<?php 
 if ( ! defined( 'ABSPATH' ) ) {
	exit;
} 
function vayu_block_wrapper_render($attributes, $content, $block){
	    $page_key            = isset( $block->context['queryId'] )
        ? 'query-' . sanitize_key( $block->context['queryId'] ) . '-page'
        : 'query-page';

	$enhanced_pagination = isset( $block->context['enhancedPagination'] ) && $block->context['enhancedPagination'];
    $page                = isset( $_GET[ $page_key ] ) ? absint( $_GET[ $page_key ] ) : 1;

	// Use global query if needed.
	$use_global_query = ( isset( $block->context['query']['inherit'] ) && $block->context['query']['inherit'] );
	if ( $use_global_query ) {
		global $wp_query;
		/*
		 * If already in the main query loop, duplicate the query instance to not tamper with the main instance.
		 * Since this is a nested query, it should start at the beginning, therefore rewind posts.
		 * Otherwise, the main query loop has not started yet and this block is responsible for doing so.
		 */
		if ( in_the_loop() ) {
			$query = clone $wp_query;
			$query->rewind_posts();
		} else {
			$query = $wp_query;
		}
	} else {
		$query_args = build_query_vars_from_query_block( $block, $page );
		$query      = new WP_Query( $query_args );
	}

	if ( ! $query->have_posts() ) {
		return '';
	}

	$classnames = '';
	if ( isset( $block->context['displayLayout'] ) && isset( $block->context['query'] ) ) {
		if ( isset( $block->context['displayLayout']['type'] ) && 'flex' === $block->context['displayLayout']['type'] ) {
			$classnames = "is-flex-container columns-{$block->context['displayLayout']['columns']}";
		}
	}
	if ( isset( $attributes['style']['elements']['link']['color']['text'] ) ) {
		$classnames .= ' has-link-color';
	}

	if ( isset( $attributes['layoutType'] ) && 'grid' === $attributes['layoutType'] && ! empty( $attributes['gridColumn'] ) ) {
		$classnames .= 'is-layout-grid';
	}

	$deviceType = isset( $_REQUEST['device_type'] ) ? $_REQUEST['device_type'] : 'desktop';
	// Ensure backwards compatibility by flagging the number of columns via classname when using grid layout.
	if ( isset( $attributes['layoutType'] ) && 'grid' === $attributes['layoutType'] ) {
    // Initialize class name variable
    $classnames .= ' ' . sanitize_html_class( 'columns-' . $attributes['gridColumn'] ); // Default class for desktop

    // Check for responsive column values based on device types
    if ( $deviceType === 'tablet' && ! empty( $attributes['gridColumnTablet'] ) ) {
        $classnames .= ' ' . sanitize_html_class( 'columns-tablet-' . $attributes['gridColumnTablet'] ); // Tablet class
    } elseif ( $deviceType === 'mobile' && ! empty( $attributes['gridColumnMobile'] ) ) {
        $classnames .= ' ' . sanitize_html_class( 'columns-mobile-' . $attributes['gridColumnMobile'] ); // Mobile class
    }
}

	$wrapper_attributes = get_block_wrapper_attributes( array( 'class' => esc_attr(trim( $classnames )) ) );

	$content = '';
	while ( $query->have_posts() ) {
		$query->the_post();

		// Get an instance of the current Post Template block.
		$block_instance = $block->parsed_block;

		// Set the block name to one that does not correspond to an existing registered block.
		// This ensures that for the inner instances of the Post Template block, we do not render any block supports.
		$block_instance['blockName'] = 'core/null';

		$post_id              = get_the_ID();
		$post_type            = get_post_type();
		$filter_block_context = static function ( $context ) use ( $post_id, $post_type ) {
			$context['postType'] = $post_type;
			$context['postId']   = $post_id;
			return $context;
		};

		// Use an early priority to so that other 'render_block_context' filters have access to the values.
		add_filter( 'render_block_context', $filter_block_context, 1 );
		// Render the inner blocks of the Post Template block with `dynamic` set to `false` to prevent calling
		// `render_callback` and ensure that no wrapper markup is included.
		$block_content = ( new WP_Block( $block_instance ) )->render( array( 'dynamic' => false ) );
		remove_filter( 'render_block_context', $filter_block_context, 1 );

		// Wrap the render inner blocks in a `li` element with the appropriate post classes.
		$post_classes = implode( ' ', get_post_class( 'wp-block-post' ) );

		$inner_block_directives = $enhanced_pagination ? ' data-wp-key="post-template-item-' . $post_id . '"' : '';

		$content .= '<li' . $inner_block_directives . ' class="' . esc_attr( $post_classes ) . '">' . $block_content . '</li>';
	
	}
   
	
	/*
	 * Use this function to restore the context of the template tags
	 * from a secondary query loop back to the main query loop.
	 * Since we use two custom loops, it's safest to always restore.
	*/
	wp_reset_postdata();

	return sprintf(
		'<ul %1$s>%2$s</ul>',
		$wrapper_attributes,
		$content
	);
}