<?php

namespace CozyAddons;

class Icons {
	public static function get_cozy_icon_collection() {
		$icons_stub = array(
			'briefcase'                           => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.9651 7.37998C20.8051 7.21998 20.6051 7.2 20.4051 7.2H16.2051V4.8C16.2051 4.36 15.8051 4 15.3651 4H8.64509C8.20509 4 7.8051 4.36 7.8051 4.8V7.2H3.6051C3.1651 7.2 2.8051 7.46 2.8051 7.9V19.2C2.8051 19.64 3.1651 20 3.6051 20H20.4051C20.8451 20 21.2051 19.64 21.2051 19.2V7.93999C21.2051 7.71999 21.1251 7.53998 20.9651 7.37998ZM9.4051 5.6H14.6051V7.2H9.4051V5.6ZM19.6051 8.8V13H14.0051V12.7C14.0051 12.36 13.6851 12.2 13.3451 12.2H10.6451C10.3051 12.2 9.9851 12.38 9.9851 12.7V13H4.3851V8.8H19.6051ZM12.8051 13.4V13.8H11.2051V13.4H12.8051ZM4.4051 18.4V14.2H10.0051V14.4C10.0051 14.74 10.3251 15 10.6651 15H13.3651C13.7051 15 14.0251 14.72 14.0251 14.4V14.2H19.6251V18.4H4.4051Z" fill="black"/>
			</svg>
			',

			'download'                            => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.6048 14.56V20C20.6048 20.56 20.1648 21 19.6048 21H4.40479C3.84479 21 3.40479 20.56 3.40479 20V14.56C3.40479 14 3.84479 13.56 4.40479 13.56C4.96479 13.56 5.40479 14 5.40479 14.56V19H18.6048V14.56C18.6048 14 19.0448 13.56 19.6048 13.56C20.1648 13.56 20.6048 14 20.6048 14.56ZM11.2848 15.8C11.4648 16 11.7248 16.1 12.0048 16.1C12.2848 16.1 12.5248 16 12.7248 15.8L16.7048 11.72C17.0848 11.32 17.0848 10.7 16.6848 10.3C16.2848 9.92 15.6648 9.92002 15.2648 10.32L12.9848 12.64V4C12.9848 3.44 12.5448 3 11.9848 3C11.4248 3 10.9848 3.44 10.9848 4V12.66L8.70479 10.34C8.32479 9.93999 7.68479 9.94002 7.28479 10.32C6.88479 10.7 6.88479 11.34 7.2648 11.74L11.2848 15.8Z" fill="black"/>
			</svg>
			',

			'upload'                              => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.6048 14.56V20C20.6048 20.56 20.1648 21 19.6048 21H4.40479C3.84479 21 3.40479 20.56 3.40479 20V14.56C3.40479 14 3.84479 13.56 4.40479 13.56C4.96479 13.56 5.40479 14 5.40479 14.56V19H18.6048V14.56C18.6048 14 19.0448 13.56 19.6048 13.56C20.1648 13.56 20.6048 14 20.6048 14.56ZM8.72478 8.77998L11.0048 6.46001V15.12C11.0048 15.68 11.4448 16.12 12.0048 16.12C12.5648 16.12 13.0048 15.68 13.0048 15.12V6.46001L15.2848 8.77998C15.4848 8.97998 15.7448 9.07998 16.0048 9.07998C16.2648 9.07998 16.5048 8.98 16.7048 8.8C17.1048 8.42 17.1048 7.77998 16.7248 7.37998L12.7448 3.3C12.5648 3.1 12.3048 3 12.0248 3C11.7648 3 11.5048 3.1 11.3048 3.3L7.32478 7.37998C6.94478 7.77998 6.94478 8.4 7.34478 8.8C7.70478 9.18 8.34478 9.15998 8.72478 8.77998Z" fill="black"/>
			</svg>
			',

			'cloud_download'                      => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M21.005 11.68C20.885 13.4 19.565 15.24 16.945 15.24C15.745 15.24 15.125 15.24 15.125 15.24C14.685 15.24 14.325 14.86 14.325 14.42C14.325 13.98 14.685 13.6 15.125 13.6C15.125 13.6 15.745 13.62 16.945 13.62C18.545 13.62 19.345 12.6 19.425 11.56C19.505 10.5 18.825 9.32001 17.165 9.08001C16.945 9.04001 16.745 8.92 16.625 8.74C16.505 8.56 16.465 8.32001 16.505 8.10001C16.725 7.20001 16.485 6.48 15.905 6.14C15.405 5.86 14.605 5.86 13.925 6.52C13.745 6.7 13.485 6.78 13.245 6.74C13.005 6.7 12.785 6.54 12.665 6.32C11.545 4.22 9.80499 4.1 8.66499 4.64C7.56499 5.16 6.68499 6.46001 7.36499 8.10001C7.44499 8.30001 7.44497 8.54 7.34497 8.74C7.24497 8.94 7.06499 9.10002 6.86499 9.16002C4.56499 9.88002 4.60499 11.42 4.66499 11.86C4.78499 12.72 5.46497 13.58 6.52497 13.58H8.96499C9.40499 13.58 9.76499 13.94 9.76499 14.38C9.76499 14.82 9.40499 15.16 8.96499 15.16H6.52497C4.80497 15.16 3.36498 13.88 3.08498 12.1C2.88498 10.72 3.44497 8.88001 5.62497 7.90001C5.12497 5.76001 6.34499 3.94001 7.96499 3.18001C9.64499 2.38001 12.005 2.60001 13.585 4.78001C14.565 4.24001 15.725 4.2 16.685 4.74C17.505 5.2 18.245 6.18 18.185 7.64C20.245 8.32 21.105 10.12 21.005 11.68ZM14.745 16.52L12.805 18.46L12.785 11.2C12.785 10.76 12.425 10.38 11.985 10.38C11.545 10.38 11.185 10.76 11.185 11.2L11.205 18.44L9.26499 16.5C8.94499 16.18 8.44497 16.18 8.12497 16.5C7.80497 16.82 7.80497 17.32 8.12497 17.64L11.425 20.96C11.585 21.12 11.785 21.2 11.985 21.2C12.205 21.2 12.405 21.12 12.545 20.96L15.845 17.66C16.165 17.34 16.165 16.84 15.845 16.52C15.565 16.22 15.065 16.22 14.745 16.52Z" fill="black"/>
			</svg>
			',

			'cloud_upload'                        => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M21.2051 13.1C21.0851 14.84 19.7251 16.74 17.0651 16.74C15.8451 16.74 15.2051 16.74 15.2051 16.74C14.7651 16.74 14.4051 16.4 14.4051 15.96C14.4051 15.52 14.7651 15.2 15.2051 15.2C15.2051 15.2 15.8451 15.16 17.0651 15.16C18.7251 15.16 19.5451 14.04 19.6251 12.98C19.7051 11.88 19.0051 10.66 17.3051 10.42C17.0851 10.38 16.8851 10.26 16.7651 10.08C16.6451 9.89999 16.6051 9.66 16.6451 9.44C16.8651 8.5 16.6251 7.76003 16.0051 7.42003C15.4851 7.12003 14.6451 7.14001 13.9651 7.80001C13.7851 7.98001 13.5251 8.06003 13.2851 8.02003C13.0451 7.98003 12.8251 7.82001 12.7051 7.60001C11.5451 5.42001 9.76511 5.31999 8.58511 5.87999C7.44511 6.41999 6.54511 7.76002 7.24511 9.46002C7.32511 9.66002 7.32511 9.90001 7.22511 10.1C7.12511 10.3 6.94511 10.46 6.74511 10.52C4.36511 11.26 4.40511 12.86 4.48511 13.32C4.62511 14.2 5.32511 15.1 6.40511 15.1L8.90511 15.12C9.34511 15.12 9.70511 15.5 9.70511 15.94C9.70511 16.38 9.34511 16.78 8.90511 16.78L6.42511 16.72C4.66511 16.72 3.20511 15.36 2.92511 13.54C2.70511 12.14 3.30511 10.26 5.54511 9.26002C5.02511 7.06002 6.26511 5.20003 7.94511 4.42003C9.66511 3.60003 12.0851 3.84002 13.6851 6.06002C14.6851 5.50002 15.8651 5.46003 16.8451 6.02003C17.6851 6.50003 18.4451 7.50001 18.3651 9.00001C20.4251 9.66001 21.3051 11.5 21.2051 13.1ZM14.8251 13.76C14.9851 13.92 15.1851 14 15.3851 14C15.5851 14 15.7851 13.92 15.9451 13.76C16.2651 13.44 16.2651 12.94 15.9451 12.62L12.5651 9.22003C12.4051 9.06003 12.2051 8.97999 12.0051 8.97999C11.7851 8.97999 11.5851 9.06003 11.4451 9.22003L8.06511 12.62C7.74511 12.94 7.74511 13.44 8.06511 13.76C8.38511 14.08 8.88511 14.08 9.20511 13.76L11.2251 11.72L11.2451 19.2C11.2451 19.64 11.6051 20 12.0451 20C12.4851 20 12.8451 19.64 12.8451 19.2L12.8251 11.74L14.8251 13.76Z" fill="black"/>
			</svg>
			',

			'facebook'                            => '<svg width="16" height="16" viewBox="0 0 14 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M12.5122 14.0625L13.2065 9.53809H8.86523V6.60205C8.86523 5.36426 9.47168 4.15771 11.416 4.15771H13.3896V0.305664C13.3896 0.305664 11.5986 0 9.88623 0C6.31104 0 3.97412 2.16699 3.97412 6.08984V9.53809H0V14.0625H3.97412V25H8.86523V14.0625H12.5122Z" fill="black"/>
            </svg>',

			'twitter'                             => '<svg width="16" height="16" viewBox="0 0 24 24" version="1.1" aria-hidden="true" focusable="false"><path d="M13.982 10.622 20.54 3h-1.554l-5.693 6.618L8.745 3H3.5l6.876 10.007L3.5 21h1.554l6.012-6.989L15.868 21h5.245l-7.131-10.378Zm-2.128 2.474-.697-.997-5.543-7.93H8l4.474 6.4.697.996 5.815 8.318h-2.387l-4.745-6.787Z"></path></svg>',

			'linkedin'                            => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M4.89648 21.8745H0.361328V7.27002H4.89648V21.8745ZM2.62646 5.27783C1.17627 5.27783 0 4.07666 0 2.62646C1.03799e-08 1.92988 0.276716 1.26183 0.769274 0.769274C1.26183 0.276716 1.92988 0 2.62646 0C3.32305 0 3.9911 0.276716 4.48366 0.769274C4.97621 1.26183 5.25293 1.92988 5.25293 2.62646C5.25293 4.07666 4.07617 5.27783 2.62646 5.27783ZM21.8701 21.8745H17.3447V14.7651C17.3447 13.0708 17.3105 10.8979 14.9868 10.8979C12.6289 10.8979 12.2676 12.7388 12.2676 14.6431V21.8745H7.73731V7.27002H12.0869V9.26221H12.1504C12.7559 8.11475 14.2349 6.90381 16.4414 6.90381C21.0312 6.90381 21.875 9.92627 21.875 13.8521V21.8745H21.8701Z" fill="black"/>
            </svg>',

			'youtube'                             => '<svg width="16" height="16" viewBox="0 0 24 17" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M23.2084 2.60777C22.9358 1.58129 22.1326 0.772873 21.1128 0.498524C19.2642 0 11.8519 0 11.8519 0C11.8519 0 4.43954 0 2.59097 0.498524C1.57114 0.772917 0.767925 1.58129 0.495312 2.60777C0 4.46832 0 8.35017 0 8.35017C0 8.35017 0 12.232 0.495312 14.0926C0.767925 15.1191 1.57114 15.8938 2.59097 16.1681C4.43954 16.6667 11.8519 16.6667 11.8519 16.6667C11.8519 16.6667 19.2642 16.6667 21.1128 16.1681C22.1326 15.8938 22.9358 15.1191 23.2084 14.0926C23.7037 12.232 23.7037 8.35017 23.7037 8.35017C23.7037 8.35017 23.7037 4.46832 23.2084 2.60777ZM9.4276 11.8746V4.82574L15.6229 8.35026L9.4276 11.8746Z" fill="black"/>
            </svg>',

			'reddit'                              => '<svg width="16" height="16" viewBox="0 0 24 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M20.5834 8.37891C19.8509 8.37891 19.2064 8.68164 18.7328 9.15527C16.9896 7.94922 14.641 7.17285 12.0384 7.08984L13.391 0.996094L17.6976 1.96289C17.6976 3.01758 18.557 3.87695 19.6117 3.87695C20.6859 3.87695 21.5502 2.99316 21.5502 1.93848C21.5502 0.883789 20.6908 0 19.6117 0C18.8597 0 18.2103 0.454102 17.888 1.07422L13.1322 0.0195312C12.8929 -0.0439453 12.6586 0.126953 12.5951 0.366211L11.1107 7.08496C8.52769 7.19238 6.20347 7.96875 4.45543 9.1748C3.9818 8.68164 3.31285 8.37891 2.58043 8.37891C-0.134415 8.37891 -1.02309 12.0215 1.46226 13.2666C1.37437 13.6523 1.33531 14.0625 1.33531 14.4727C1.33531 18.5645 5.94469 21.8799 11.6039 21.8799C17.2875 21.8799 21.8968 18.5645 21.8968 14.4727C21.8968 14.0625 21.8529 13.6328 21.7455 13.2471C24.182 11.9971 23.2836 8.37891 20.5834 8.37891ZM5.40269 13.5254C5.40269 12.4512 6.26207 11.5869 7.34117 11.5869C8.39586 11.5869 9.25523 12.4463 9.25523 13.5254C9.25523 14.5801 8.39586 15.4395 7.34117 15.4395C6.26695 15.4443 5.40269 14.5801 5.40269 13.5254ZM15.8666 18.0908C14.0892 19.8682 9.07457 19.8682 7.29723 18.0908C7.10191 17.9199 7.10191 17.6172 7.29723 17.4219C7.46812 17.251 7.77086 17.251 7.94176 17.4219C9.29918 18.8135 13.8011 18.8379 15.2171 17.4219C15.388 17.251 15.6908 17.251 15.8617 17.4219C16.0619 17.6172 16.0619 17.9199 15.8666 18.0908ZM15.8275 15.4443C14.7728 15.4443 13.9134 14.585 13.9134 13.5303C13.9134 12.4561 14.7728 11.5918 15.8275 11.5918C16.9017 11.5918 17.766 12.4512 17.766 13.5303C17.7611 14.5801 16.9017 15.4443 15.8275 15.4443Z" fill="black"/>
            </svg>',

			'whatsapp'                            => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M18.5986 3.17871C16.5527 1.12793 13.8281 0 10.9326 0C4.95605 0 0.0927734 4.86328 0.0927734 10.8398C0.0927734 12.749 0.59082 14.6143 1.53809 16.2598L0 21.875L5.74707 20.3662C7.3291 21.2305 9.11133 21.6846 10.9277 21.6846H10.9326C16.9043 21.6846 21.875 16.8213 21.875 10.8447C21.875 7.94922 20.6445 5.22949 18.5986 3.17871ZM10.9326 19.8584C9.31152 19.8584 7.72461 19.4238 6.34277 18.6035L6.01562 18.4082L2.60742 19.3018L3.51562 15.9766L3.30078 15.6348C2.39746 14.1992 1.92383 12.5439 1.92383 10.8398C1.92383 5.87402 5.9668 1.83105 10.9375 1.83105C13.3447 1.83105 15.6055 2.76855 17.3047 4.47266C19.0039 6.17676 20.0488 8.4375 20.0439 10.8447C20.0439 15.8154 15.8984 19.8584 10.9326 19.8584ZM15.874 13.1104C15.6055 12.9736 14.2725 12.3193 14.0234 12.2314C13.7744 12.1387 13.5938 12.0947 13.4131 12.3682C13.2324 12.6416 12.7148 13.2471 12.5537 13.4326C12.3975 13.6133 12.2363 13.6377 11.9678 13.501C10.376 12.7051 9.33105 12.0801 8.28125 10.2783C8.00293 9.7998 8.55957 9.83398 9.07715 8.79883C9.16504 8.61816 9.12109 8.46191 9.05273 8.3252C8.98438 8.18848 8.44238 6.85547 8.21777 6.31348C7.99805 5.78613 7.77344 5.85938 7.60742 5.84961C7.45117 5.83984 7.27051 5.83984 7.08984 5.83984C6.90918 5.83984 6.61621 5.9082 6.36719 6.17676C6.11816 6.4502 5.41992 7.10449 5.41992 8.4375C5.41992 9.77051 6.3916 11.0596 6.52344 11.2402C6.66016 11.4209 8.43262 14.1553 11.1523 15.332C12.8711 16.0742 13.5449 16.1377 14.4043 16.0107C14.9268 15.9326 16.0059 15.3564 16.2305 14.7217C16.4551 14.0869 16.4551 13.5449 16.3867 13.4326C16.3232 13.3105 16.1426 13.2422 15.874 13.1104Z" fill="black"/>
            </svg>',

			'pinterest'                           => '<svg width="16" height="16" viewBox="0 0 19 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M9.96094 0C4.95117 0 0 3.33984 0 8.74512C0 12.1826 1.93359 14.1357 3.10547 14.1357C3.58887 14.1357 3.86719 12.7881 3.86719 12.4072C3.86719 11.9531 2.70996 10.9863 2.70996 9.09668C2.70996 5.1709 5.69824 2.3877 9.56543 2.3877C12.8906 2.3877 15.3516 4.27734 15.3516 7.74902C15.3516 10.3418 14.3115 15.2051 10.9424 15.2051C9.72656 15.2051 8.68652 14.3262 8.68652 13.0664C8.68652 11.2207 9.97559 9.43359 9.97559 7.5293C9.97559 4.29688 5.39062 4.88281 5.39062 8.78906C5.39062 9.60938 5.49316 10.5176 5.85938 11.2646C5.18555 14.165 3.80859 18.4863 3.80859 21.4746C3.80859 22.3975 3.94043 23.3057 4.02832 24.2285C4.19434 24.4141 4.11133 24.3945 4.36523 24.3018C6.82617 20.9326 6.73828 20.2734 7.85156 15.8643C8.45215 17.0068 10.0049 17.6221 11.2354 17.6221C16.4209 17.6221 18.75 12.5684 18.75 8.0127C18.75 3.16406 14.5605 0 9.96094 0Z" fill="black"/>
            </svg>',

			'telegram'                            => '<svg width="16" height="16" viewBox="0 0 22 19" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M21.8107 1.66995L18.5099 17.2364C18.2609 18.335 17.6115 18.6084 16.6887 18.0908L11.6594 14.3848L9.2326 16.7188C8.96405 16.9873 8.73944 17.2119 8.22186 17.2119L8.58319 12.0899L17.9045 3.66702C18.3097 3.30569 17.8166 3.1055 17.2746 3.46683L5.75116 10.7227L0.790218 9.16995C-0.288883 8.83304 -0.308415 8.09085 1.01483 7.57327L20.4191 0.0976854C21.3176 -0.239229 22.1037 0.297881 21.8107 1.66995Z" fill="black"/>
            </svg>',

			'snapchat'                            => '<svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.9438 18.4249C24.6893 19.0185 23.6137 19.4546 21.6547 19.7588C21.5539 19.8948 21.4704 20.4759 21.337 20.9285C21.2576 21.2003 21.0624 21.3616 20.7448 21.3616L20.7303 21.3613C20.2715 21.3613 19.7926 21.1502 18.8332 21.1502C17.5382 21.1502 17.0919 21.4453 16.0864 22.1555C15.0204 22.9093 13.998 23.56 12.4718 23.4934C10.9266 23.6073 9.63858 22.6678 8.91368 22.1553C7.90225 21.4403 7.45723 21.1503 6.16753 21.1503C5.24644 21.1503 4.66675 21.3808 4.27046 21.3808C3.87627 21.3808 3.72295 21.1404 3.66392 20.9394C3.53194 20.4907 3.44888 19.9011 3.34541 19.7611C2.3357 19.6044 0.0587936 19.2072 0.000785754 18.1913C-0.00624549 18.0636 0.0341045 17.9379 0.114096 17.8381C0.194088 17.7384 0.308089 17.6717 0.434233 17.6508C3.83184 17.0915 5.36216 13.6029 5.42579 13.4548C5.4294 13.4462 5.43335 13.438 5.43736 13.4297C5.61866 13.0617 5.65923 12.7535 5.55762 12.514C5.31104 11.9332 4.24551 11.7248 3.79722 11.5474C2.63926 11.0901 2.47813 10.5646 2.54664 10.2044C2.66563 9.57769 3.60743 9.19199 4.15806 9.4499C4.59356 9.65405 4.98047 9.75737 5.30782 9.75737C5.55303 9.75737 5.70879 9.69858 5.79415 9.65137C5.69439 7.89668 5.44742 5.38916 6.07183 3.98882C7.7209 0.29165 11.2162 0.00434569 12.2475 0.00434569C12.2936 0.00434569 12.6938 0 12.7411 0C15.2874 0 17.734 1.30762 18.9288 3.98647C19.5526 5.3854 19.3071 7.88257 19.2068 9.65098C19.2841 9.69355 19.4196 9.7458 19.6267 9.75542C19.9391 9.74146 20.3013 9.63877 20.7043 9.4499C21.0014 9.31094 21.4077 9.32974 21.7043 9.45273L21.7057 9.45322C22.1684 9.61851 22.4596 9.952 22.4669 10.3258C22.4759 10.8017 22.0508 11.2127 21.2033 11.5474C21.0999 11.5881 20.9741 11.6282 20.8403 11.6707C20.362 11.8223 19.6392 12.0518 19.4431 12.514C19.3416 12.7534 19.3817 13.0614 19.5632 13.4294C19.5674 13.4376 19.5713 13.4461 19.5749 13.4545C19.6384 13.6025 21.1674 17.0903 24.5666 17.6505C24.8804 17.7022 25.1116 18.0352 24.9438 18.4249Z" fill="black"/>
            </svg>',

			'instagram'                           => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M10.946 5.33081C7.84058 5.33081 5.33569 7.83569 5.33569 10.9412C5.33569 14.0466 7.84058 16.5515 10.946 16.5515C14.0515 16.5515 16.5564 14.0466 16.5564 10.9412C16.5564 7.83569 14.0515 5.33081 10.946 5.33081ZM10.946 14.5886C8.93921 14.5886 7.29858 12.9529 7.29858 10.9412C7.29858 8.92944 8.93433 7.2937 10.946 7.2937C12.9578 7.2937 14.5935 8.92944 14.5935 10.9412C14.5935 12.9529 12.9529 14.5886 10.946 14.5886ZM18.0945 5.10132C18.0945 5.82886 17.5085 6.40991 16.7859 6.40991C16.0584 6.40991 15.4773 5.82397 15.4773 5.10132C15.4773 4.37866 16.0632 3.79272 16.7859 3.79272C17.5085 3.79272 18.0945 4.37866 18.0945 5.10132ZM21.8103 6.42944C21.7273 4.67651 21.3269 3.12378 20.0427 1.84448C18.7634 0.565185 17.2107 0.164795 15.4578 0.0769043C13.6511 -0.0256348 8.23608 -0.0256348 6.42944 0.0769043C4.6814 0.159912 3.12866 0.560303 1.84448 1.8396C0.560303 3.1189 0.164795 4.67163 0.0769043 6.42456C-0.0256348 8.2312 -0.0256348 13.6462 0.0769043 15.4529C0.159912 17.2058 0.560303 18.7585 1.84448 20.0378C3.12866 21.3171 4.67651 21.7175 6.42944 21.8054C8.23608 21.908 13.6511 21.908 15.4578 21.8054C17.2107 21.7224 18.7634 21.322 20.0427 20.0378C21.322 18.7585 21.7224 17.2058 21.8103 15.4529C21.9128 13.6462 21.9128 8.23608 21.8103 6.42944ZM19.4763 17.3914C19.0955 18.3484 18.3582 19.0857 17.3962 19.4714C15.9558 20.0427 12.5378 19.9109 10.946 19.9109C9.35425 19.9109 5.9314 20.0378 4.49585 19.4714C3.53882 19.0906 2.80151 18.3533 2.41577 17.3914C1.84448 15.9509 1.97632 12.533 1.97632 10.9412C1.97632 9.34937 1.84937 5.92651 2.41577 4.49097C2.79663 3.53394 3.53394 2.79663 4.49585 2.41089C5.93628 1.8396 9.35425 1.97144 10.946 1.97144C12.5378 1.97144 15.9607 1.84448 17.3962 2.41089C18.3533 2.79175 19.0906 3.52905 19.4763 4.49097C20.0476 5.9314 19.9158 9.34937 19.9158 10.9412C19.9158 12.533 20.0476 15.9558 19.4763 17.3914Z" fill="black"/>
            </svg>',

			'stumbleupon'                         => '<svg width="16" height="16" viewBox="0 0 25 19" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.5557 9.86328V13.2666C24.5557 16.2988 22.0996 18.7549 19.0674 18.7549C16.0498 18.7549 13.5791 16.3232 13.5791 13.3203V9.89258L15.2539 10.6738L17.749 9.93164V13.3789C17.749 14.0967 18.335 14.6729 19.0527 14.6729C19.7705 14.6729 20.3613 14.0967 20.3613 13.3789V9.86328H24.5557ZM13.584 7.02148L15.2588 7.80273L17.7539 7.06055V5.32227C17.7539 2.36816 15.2588 0 12.2803 0C9.31152 0 6.80664 2.35352 6.80664 5.2832V13.2129C6.80664 13.9404 6.2207 14.5166 5.50293 14.5166C4.78516 14.5166 4.19922 13.9404 4.19922 13.2129V9.86328H0V13.2666C0 16.2939 2.45605 18.75 5.48828 18.75C8.49609 18.75 10.9766 16.333 10.9766 13.3398V5.51269C10.9766 4.79492 11.5625 4.20898 12.2803 4.20898C12.998 4.20898 13.584 4.79492 13.584 5.51269V7.02148Z" fill="black"/>
            </svg>',

			'medium'                              => '<svg width="16" height="16" viewBox="0 0 24 19" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M2.79785 3.82324C2.82715 3.53516 2.71484 3.24707 2.5 3.05176L0.297852 0.395508V0H7.14355L12.4365 11.6064L17.0898 0H23.6182V0.395508L21.7334 2.20215C21.5723 2.32422 21.4893 2.5293 21.5234 2.72949V16.0107C21.4893 16.2109 21.5723 16.416 21.7334 16.5381L23.5742 18.3447V18.7402H14.3115V18.3447L16.2207 16.4941C16.4062 16.3086 16.4062 16.25 16.4062 15.9668V5.23438L11.0986 18.7061H10.3809L4.20898 5.23438V14.2627C4.15527 14.6436 4.28223 15.0244 4.55078 15.2979L7.03125 18.3057V18.7012H0V18.3105L2.48047 15.2979C2.74414 15.0244 2.86621 14.6387 2.79785 14.2627V3.82324Z" fill="black"/>
            </svg>',

			'tumblr'                              => '<svg width="16" height="16" viewBox="0 0 15 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M14.7412 23.4521C14.0771 24.1602 12.2998 25 9.98535 25C4.08691 25 2.80762 20.6641 2.80762 18.1348V11.1035H0.488281C0.219727 11.1035 0 10.8838 0 10.6152V7.29492C0 6.94336 0.219727 6.63086 0.551758 6.51367C3.5791 5.44922 4.53125 2.80273 4.66797 0.795898C4.70703 0.258789 4.98535 0 5.4541 0H8.91602C9.18457 0 9.4043 0.219727 9.4043 0.488281V6.11328H13.457C13.7256 6.11328 13.9453 6.32813 13.9453 6.59668V10.5859C13.9453 10.8545 13.7256 11.0742 13.457 11.0742H9.38477V17.5781C9.38477 19.248 10.542 20.1953 12.7051 19.3262C12.9395 19.2334 13.1445 19.1699 13.3252 19.2188C13.4961 19.2627 13.6084 19.3848 13.6865 19.6045L14.7607 22.7441C14.8486 22.9883 14.9219 23.2617 14.7412 23.4521Z" fill="black"/>
            </svg>',

			'behance'                             => '<svg width="16" height="16" viewBox="0 0 25 16" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M10.0694 7.02257C11.4497 6.36285 12.1701 5.36458 12.1701 3.81076C12.1701 0.746528 9.88715 0 7.2526 0H0V15.3819H7.4566C10.2517 15.3819 12.8776 14.0408 12.8776 10.9158C12.8776 8.98438 11.9618 7.55642 10.0694 7.02257ZM3.38108 2.62587H6.55382C7.77344 2.62587 8.87153 2.96875 8.87153 4.38368C8.87153 5.6901 8.01649 6.21528 6.8099 6.21528H3.38108V2.62587ZM6.99653 12.7691H3.38108V8.53299H7.06597C8.55469 8.53299 9.49653 9.15365 9.49653 10.7292C9.49653 12.283 8.3724 12.7691 6.99653 12.7691ZM22.5564 2.32205H16.3194V0.807292H22.5564V2.32205ZM25 9.97396C25 6.67969 23.0729 3.93229 19.579 3.93229C16.1849 3.93229 13.8802 6.48437 13.8802 9.82639C13.8802 13.2943 16.0634 15.6727 19.579 15.6727C22.2396 15.6727 23.9627 14.4748 24.7917 11.9271H22.092C21.8012 12.8776 20.6033 13.3811 19.6745 13.3811C17.8819 13.3811 16.9401 12.3307 16.9401 10.5469H24.974C24.987 10.3646 25 10.1693 25 9.97396ZM16.9444 8.61979C17.0443 7.15712 18.0165 6.24132 19.4835 6.24132C21.02 6.24132 21.7925 7.1441 21.9227 8.61979H16.9444Z" fill="black"/>
            </svg>',

			'blogger'                             => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M21.8053 9.30625C21.7174 8.91562 21.4733 8.55429 21.195 8.40293C21.1071 8.3541 20.5602 8.29551 19.9742 8.27109C18.9928 8.22715 18.8854 8.20761 18.5729 8.02695C18.0797 7.73886 17.9479 7.42636 17.943 6.58652C17.9381 4.97519 17.2692 3.47617 15.9459 2.12851C15.0035 1.1666 13.9489 0.517185 12.7477 0.150974C12.4596 0.0630834 11.8151 0.0337865 9.65686 0.00937241C6.26819 -0.0296901 5.51624 0.0386693 4.3639 0.497654C2.23987 1.3375 0.716435 3.12461 0.159794 5.40976C0.057255 5.83945 0.0328409 6.52793 0.00842685 10.483C-0.02087 15.4391 0.0133097 16.1666 0.320927 17.148C1.08265 19.5699 3.24573 21.3619 5.41858 21.7525C6.14124 21.8844 15.0524 21.9137 15.9655 21.7916C17.5524 21.5768 18.7975 20.9371 19.9645 19.7457C20.8092 18.8814 21.3366 17.9488 21.6832 16.7135C21.9225 15.8541 21.903 9.74082 21.8053 9.30625ZM6.07776 6.20078C6.45862 5.81504 6.56604 5.80039 8.94886 5.80039C11.0924 5.80039 11.1657 5.80527 11.4782 5.9664C11.9323 6.1959 12.1325 6.51816 12.1325 7.03574C12.1325 7.49961 11.9469 7.82676 11.5319 8.09043C11.3073 8.23203 11.1754 8.24179 9.07581 8.25156C7.78186 8.26133 6.74671 8.23203 6.59534 8.19297C5.78479 7.96347 5.48206 6.80136 6.07776 6.20078ZM15.443 15.9566L14.7155 16.0738L10.9313 16.1178C7.60608 16.1568 6.66858 16.0982 6.4928 16.0201C6.14612 15.8687 5.81897 15.4488 5.76526 15.0728C5.71155 14.7164 5.89222 14.2281 6.16565 13.9791C6.51233 13.6666 6.6637 13.6568 10.9166 13.652C15.2916 13.6471 15.2672 13.6471 15.6823 14.0328C16.2731 14.5846 16.1461 15.5562 15.443 15.9566Z" fill="black"/>
            </svg>',

			'wallet'                              => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M7.2656 4.62891C9.10153 7.58789 10.4004 10.1514 11.3818 12.5635C10.9765 14.2139 10.4638 15.8105 9.85349 17.3633C9.20896 14.8096 8.55954 12.417 7.11911 10.1123C7.43649 8.33496 7.23142 6.51855 7.2656 4.62891ZM4.94626 8.20312H0.395479C0.0780963 8.20312 -0.117216 8.56934 0.0780963 8.82324C2.13864 11.4746 3.57907 14.5752 4.55564 17.9688H9.60935C8.81833 14.5654 7.7197 11.4404 5.58103 8.52051C5.43454 8.3252 5.1904 8.20312 4.94626 8.20312ZM7.28024 3.90625C10.625 9.17969 13.6279 15.3564 14.0283 21.875H19.58C18.9941 15.1367 16.2402 8.93555 12.5879 3.90625H7.28024ZM19.5752 0.561523C19.4873 0.229492 19.1748 0 18.833 0H14.5215C14.2627 0 14.082 0.244141 14.1406 0.50293C14.7851 2.77344 15.2295 5.16602 15.4345 7.63184C17.7881 11.8408 19.3261 16.3379 19.8584 20.8545C20.6299 17.9004 21.0937 14.3359 21.0937 10.9424C21.0937 7.34863 20.5029 3.85742 19.5752 0.561523Z" fill="black"/>
            </svg>',

			'vk'                                  => '<svg width="16" height="16" viewBox="0 0 24 14" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M22.8472 0.94184C23.0078 0.399305 22.8472 0 22.0747 0H19.5182C18.8672 0 18.5677 0.342882 18.4071 0.724826C18.4071 0.724826 17.105 3.89757 15.2648 5.95486C14.6701 6.54948 14.3967 6.74045 14.0712 6.74045C13.9106 6.74045 13.6632 6.54948 13.6632 6.00694V0.94184C13.6632 0.290798 13.4809 0 12.9427 0H8.92361C8.51562 0 8.27257 0.303819 8.27257 0.585938C8.27257 1.20226 9.19271 1.34549 9.28819 3.0816V6.84896C9.28819 7.67361 9.14062 7.82552 8.8151 7.82552C7.94705 7.82552 5.83767 4.63976 4.58767 0.993924C4.33594 0.286458 4.08854 0 3.43316 0H0.876736C0.147569 0 0 0.342882 0 0.724826C0 1.40191 0.868056 4.76563 4.0408 9.21007C6.15451 12.2439 9.13194 13.8889 11.8403 13.8889C13.4679 13.8889 13.6675 13.5243 13.6675 12.895C13.6675 9.99566 13.52 9.72222 14.3359 9.72222C14.7135 9.72222 15.3646 9.91319 16.8837 11.3759C18.6198 13.112 18.9062 13.8889 19.8785 13.8889H22.4349C23.1641 13.8889 23.533 13.5243 23.3203 12.8038C22.8342 11.2891 19.5486 8.17274 19.401 7.96441C19.0234 7.4783 19.1319 7.26128 19.401 6.82726C19.4054 6.82292 22.526 2.43056 22.8472 0.94184Z" fill="black"/>
            </svg>',

			'dribble'                             => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M12.1094 0C5.43223 0 0 5.43223 0 12.1094C0 18.7865 5.43223 24.2188 12.1094 24.2188C18.7865 24.2188 24.2188 18.7865 24.2188 12.1094C24.2188 5.43223 18.7865 0 12.1094 0ZM20.1157 5.58428C21.5563 7.34434 22.4287 9.58608 22.4514 12.0274C22.1104 11.9553 18.6908 11.2617 15.2492 11.6945C14.9683 11.0089 14.7032 10.4058 14.3401 9.66255C18.1644 8.10117 19.8977 5.87925 20.1157 5.58428ZM18.9659 4.38818C18.7798 4.65317 17.2229 6.7459 13.5449 8.12446C11.85 5.0104 9.97144 2.4522 9.68555 2.06938C12.9656 1.27871 16.4222 2.1314 18.9659 4.38818ZM7.71196 2.76465C7.98467 3.13862 9.83296 5.7 11.5468 8.74653C6.70854 10.0313 2.44717 10.0128 1.98457 10.0067C2.65527 6.79712 4.81826 4.12954 7.71196 2.76465ZM1.76611 12.1251C1.76611 12.0194 1.76821 11.9141 1.77139 11.8091C2.22393 11.8184 7.23623 11.883 12.4016 10.3371C12.6977 10.9166 12.9805 11.5048 13.2401 12.0924C9.49995 13.1459 6.10176 16.1709 4.42515 19.041C2.77314 17.2073 1.76611 14.7817 1.76611 12.1251ZM5.7606 20.285C6.84102 18.0763 9.77319 15.2253 13.9432 13.8027C15.3953 17.5763 15.9958 20.7389 16.1497 21.6464C12.8239 23.063 8.82471 22.6744 5.7606 20.285ZM17.8885 20.6995C17.7825 20.0703 17.232 17.0424 15.8791 13.3248C19.1204 12.806 21.968 13.6553 22.3219 13.7669C21.8608 16.6449 20.2089 19.1304 17.8885 20.6995Z" fill="black"/>
            </svg>',

			'wordpress'                           => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M12.1094 0C5.43457 0 0 5.42969 0 12.1094C0 18.7842 5.43457 24.2188 12.1094 24.2188C18.7842 24.2188 24.2188 18.7842 24.2188 12.1094C24.2188 5.42969 18.7842 0 12.1094 0ZM1.2207 12.1094C1.2207 10.5322 1.55762 9.0332 2.16309 7.68066L7.3584 21.9092C3.72559 20.1416 1.2207 16.416 1.2207 12.1094ZM12.1094 22.998C11.04 22.998 10.0098 22.8418 9.0332 22.5537L12.2998 13.0615L15.6445 22.2314C15.6689 22.2852 15.6934 22.334 15.7227 22.3828C14.5947 22.7783 13.3789 22.998 12.1094 22.998ZM13.6084 7.00684C14.2627 6.97266 14.8535 6.9043 14.8535 6.9043C15.4395 6.83594 15.3711 5.97168 14.7852 6.00586C14.7852 6.00586 13.0225 6.14258 11.8848 6.14258C10.8154 6.14258 9.01855 6.00586 9.01855 6.00586C8.43262 5.97168 8.36426 6.87012 8.9502 6.9043C8.9502 6.9043 9.50684 6.97266 10.0928 7.00684L11.7871 11.6553L9.4043 18.7988L5.43945 7.00684C6.09375 6.97266 6.68457 6.9043 6.68457 6.9043C7.27051 6.83594 7.20215 5.97168 6.61621 6.00586C6.61621 6.00586 4.85352 6.14258 3.71582 6.14258C3.51074 6.14258 3.27148 6.1377 3.0127 6.12793C4.96094 3.17383 8.30566 1.2207 12.1094 1.2207C14.9414 1.2207 17.5244 2.30469 19.4629 4.07715C19.4141 4.07227 19.3701 4.06738 19.3213 4.06738C18.252 4.06738 17.4951 5 17.4951 6.00098C17.4951 6.89941 18.0127 7.65625 18.5645 8.55469C18.9795 9.27734 19.4629 10.21 19.4629 11.5576C19.4629 12.4902 19.1064 13.5693 18.6328 15.0781L17.5488 18.7061L13.6084 7.00684ZM17.583 21.5186L20.9082 11.9043C21.5283 10.3516 21.7383 9.11133 21.7383 8.00293C21.7383 7.60254 21.7139 7.23145 21.665 6.88477C22.5146 8.4375 22.998 10.2148 22.998 12.1094C22.998 16.1279 20.8203 19.6338 17.583 21.5186Z" fill="black"/>
            </svg>',

			'google'                              => '<svg width="16" height="16" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M23.8281 12.3926C23.8281 19.3018 19.0967 24.2188 12.1094 24.2188C5.41016 24.2188 0 18.8086 0 12.1094C0 5.41016 5.41016 0 12.1094 0C15.3711 0 18.1152 1.19629 20.2295 3.16895L16.9336 6.33789C12.6221 2.17773 4.60449 5.30273 4.60449 12.1094C4.60449 16.333 7.97852 19.7559 12.1094 19.7559C16.9043 19.7559 18.7012 16.3184 18.9844 14.5361H12.1094V10.3711H23.6377C23.75 10.9912 23.8281 11.5869 23.8281 12.3926Z" fill="black"/>
            </svg>',

			'google_play'                         => '<svg width="16" height="16" viewBox="0 0 23 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M14.6484 11.4404L3.87207 0.634766L17.583 8.50586L14.6484 11.4404ZM1.05957 0C0.424805 0.332031 0 0.9375 0 1.72363V23.2715C0 24.0576 0.424805 24.6631 1.05957 24.9951L13.5889 12.4951L1.05957 0ZM21.8213 11.0156L18.9453 9.35059L15.7373 12.5L18.9453 15.6494L21.8799 13.9844C22.7588 13.2861 22.7588 11.7139 21.8213 11.0156ZM3.87207 24.3652L17.583 16.4941L14.6484 13.5596L3.87207 24.3652Z" fill="black"/>
            </svg>',

			'rss'                                 => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M6.25395 18.748C6.25395 20.475 4.85396 21.875 3.12695 21.875C1.39995 21.875 0 20.475 0 18.748C0 17.021 1.4 15.621 3.127 15.621C4.854 15.621 6.25395 17.0211 6.25395 18.748ZM14.8311 21.0551C14.4232 13.5063 8.37676 7.45227 0.819873 7.04392C0.373828 7.01979 0 7.37819 0 7.82487V10.172C0 10.5829 0.316895 10.9275 0.726904 10.9541C6.18745 11.3098 10.5645 15.6759 10.9208 21.1481C10.9476 21.5581 11.2921 21.875 11.703 21.875H14.0501C14.4968 21.875 14.8552 21.5012 14.8311 21.0551ZM21.8745 21.0692C21.4646 9.65222 12.2786 0.412373 0.805811 0.000507366C0.364893 -0.0153129 0 0.340888 0 0.78205V3.12912C0 3.55026 0.33374 3.89304 0.754541 3.91032C10.0895 4.29309 17.582 11.7871 17.9647 21.1205C17.982 21.5413 18.3248 21.8751 18.7459 21.8751H21.093C21.5341 21.875 21.8903 21.5101 21.8745 21.0692Z" fill="black"/>
            </svg>',

			'lastfm'                              => '<svg width="16" height="16" viewBox="0 0 25 14" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M11.0254 12.3682L10.1074 9.87793C10.1074 9.87793 8.61816 11.5381 6.38672 11.5381C4.40918 11.5381 3.00781 9.81934 3.00781 7.07031C3.00781 3.5498 4.78516 2.29004 6.52832 2.29004C9.77539 2.29004 10.1807 4.89258 11.4551 8.87695C12.373 11.6553 14.0918 13.8867 19.043 13.8867C22.5928 13.8867 25 12.7979 25 9.93652C25 6.37695 21.9385 6.00098 19.3848 5.43945C18.125 5.15137 17.7539 4.63867 17.7539 3.7793C17.7539 2.80762 18.5254 2.23145 19.7852 2.23145C21.1621 2.23145 21.9043 2.74902 22.0166 3.97949L24.8779 3.6377C24.6484 1.05957 22.8711 0 19.9512 0C17.373 0 14.8535 0.971679 14.8535 4.09668C14.8535 6.04492 15.8008 7.27539 18.1738 7.84668C20.3662 8.36426 22.0703 8.52051 22.0703 10.0781C22.0703 11.1377 21.04 11.5674 19.0918 11.5674C16.2012 11.5674 14.9951 10.0488 14.3115 7.95898C12.749 3.23242 12.1826 0 6.43555 0C2.23145 0 0 2.66113 0 7.1875C0 11.5381 2.23145 13.8867 6.24512 13.8867C9.47754 13.8867 11.0254 12.3682 11.0254 12.3682Z" fill="black"/>
            </svg>',

			'yelp'                                => '<svg width="16" height="16" viewBox="0 0 19 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M2.04565 11.7341L6.90991 14.1076C7.84741 14.5666 7.70093 15.9392 6.69018 16.1931L1.44018 17.5022C1.28607 17.5409 1.12544 17.5462 0.969111 17.5177C0.812779 17.4892 0.664368 17.4275 0.533864 17.3368C0.40336 17.2461 0.29379 17.1286 0.212525 16.992C0.131261 16.8555 0.0801878 16.7031 0.0627422 16.5451C-0.0983497 15.141 0.0516864 13.7187 0.502195 12.3791C0.552735 12.2291 0.634694 12.0915 0.742601 11.9757C0.850508 11.8599 0.981882 11.7684 1.12796 11.7073C1.27403 11.6463 1.43144 11.6171 1.58969 11.6217C1.74794 11.6263 1.90339 11.6646 2.04565 11.7341ZM4.19409 23.4162C5.35791 24.2135 6.68107 24.7485 8.07202 24.9841C8.22855 25.0109 8.38901 25.004 8.54262 24.9636C8.69623 24.9233 8.83943 24.8506 8.96257 24.7503C9.08571 24.65 9.18595 24.5245 9.25654 24.3822C9.32714 24.2399 9.36644 24.0842 9.37183 23.9255L9.56225 18.5144C9.59643 17.4743 8.31714 16.9563 7.61841 17.7282L3.99487 21.7517C3.88876 21.8697 3.80911 22.0091 3.76123 22.1604C3.71336 22.3118 3.69837 22.4716 3.71728 22.6292C3.73619 22.7868 3.78856 22.9386 3.87087 23.0743C3.95319 23.21 4.06355 23.3266 4.19458 23.4162H4.19409ZM11.2908 18.049L14.1624 22.6389C14.247 22.7736 14.3594 22.8888 14.4921 22.9767C14.6247 23.0646 14.7746 23.1232 14.9317 23.1486C15.0888 23.174 15.2495 23.1657 15.4031 23.1241C15.5567 23.0825 15.6997 23.0086 15.8225 22.9074C16.9108 22.0078 17.7892 20.881 18.3962 19.6062C18.4631 19.4626 18.4989 19.3066 18.5012 19.1482C18.5035 18.9899 18.4723 18.8328 18.4097 18.6874C18.347 18.542 18.2543 18.4114 18.1376 18.3043C18.0209 18.1973 17.8829 18.1161 17.7327 18.0661L12.5852 16.3933C11.5935 16.0759 10.739 17.1647 11.2908 18.049ZM18.5334 11.5925C17.9707 10.2978 17.1304 9.14247 16.072 8.20821C15.9529 8.10384 15.813 8.02601 15.6615 7.9799C15.51 7.93379 15.3505 7.92045 15.1934 7.94078C15.0364 7.9611 14.8855 8.01462 14.7507 8.09777C14.616 8.18092 14.5005 8.2918 14.4119 8.42305L11.3845 12.9113C10.8035 13.7756 11.614 14.8942 12.615 14.6062L17.822 13.1164C17.9746 13.0715 18.116 12.9947 18.2367 12.891C18.3573 12.7874 18.4546 12.6593 18.5221 12.5152C18.5895 12.3711 18.6256 12.2143 18.6279 12.0553C18.6302 11.8962 18.5987 11.7385 18.5354 11.5925H18.5334ZM2.98364 1.47334C2.84533 1.53991 2.72223 1.63429 2.62204 1.75058C2.52186 1.86688 2.44673 2.00259 2.40137 2.14923C2.356 2.29587 2.34136 2.45029 2.35838 2.60284C2.37539 2.75539 2.42368 2.9028 2.50024 3.03584L7.58423 11.8464C8.15552 12.8327 9.66479 12.4274 9.66479 11.2897V1.1169C9.66618 0.963165 9.63552 0.810831 9.57478 0.6696C9.51404 0.528369 9.42455 0.40134 9.31201 0.296605C9.19946 0.19187 9.06634 0.111728 8.92111 0.0612835C8.77588 0.0108392 8.62174 -0.00880033 8.4685 0.00361617C6.56587 0.154814 4.70696 0.652927 2.98364 1.47334Z" fill="black"/>
            </svg>',

			'twitch'                              => '<svg width="16" height="16" viewBox="0 0 21 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M1.46973 0L0 3.75488V19.1016H5.22461V21.875H8.16406L10.9375 19.1016H15.1855L20.8984 13.3887V0H1.46973ZM18.9404 12.4072L15.6738 15.6738H10.4492L7.67578 18.4473V15.6738H3.2666V1.95801H18.9404V12.4072ZM15.6738 5.71289V11.4209H13.7158V5.71289H15.6738ZM10.4492 5.71289V11.4209H8.49121V5.71289H10.4492Z" fill="black"/>
            </svg>',

			'vimeo'                               => '<svg width="16" height="16" viewBox="0 0 22 19" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M21.8652 4.36919C21.7676 6.4981 20.2832 9.41314 17.4023 13.1143C14.4287 16.9815 11.9141 18.9151 9.85352 18.9151C8.5791 18.9151 7.5 17.7383 6.61621 15.3848C4.89746 9.07622 4.16504 5.37994 2.74414 5.37994C2.57812 5.37994 2.00684 5.72661 1.02539 6.41021L0 5.08208C2.51953 2.87017 4.92676 0.409232 6.43555 0.272514C8.13965 0.106498 9.18457 1.27349 9.58008 3.76372C10.9814 12.626 11.6016 13.9639 14.1504 9.95025C15.0635 8.50494 15.5566 7.4063 15.625 6.64947C15.8594 4.40826 13.877 4.55962 12.5342 5.13579C13.6084 1.61529 15.6641 -0.0936973 18.6963 0.00395894C20.9326 0.0625527 21.9922 1.52251 21.8652 4.36919Z" fill="black"/>
            </svg>',

			'spotify'                             => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M12.1094 0C5.42481 0 0 5.42481 0 12.1094C0 18.7939 5.42481 24.2188 12.1094 24.2188C18.7939 24.2188 24.2188 18.7939 24.2188 12.1094C24.2188 5.42481 18.7939 0 12.1094 0ZM17.0264 17.8174C16.8213 17.8174 16.6943 17.7539 16.5039 17.6416C13.457 15.8057 9.91211 15.7275 6.41113 16.4453C6.2207 16.4941 5.97168 16.5723 5.83008 16.5723C5.35645 16.5723 5.05859 16.1963 5.05859 15.8008C5.05859 15.2979 5.35645 15.0586 5.72266 14.9805C9.72168 14.0967 13.8086 14.1748 17.2949 16.2598C17.5928 16.4502 17.7686 16.6211 17.7686 17.0654C17.7686 17.5098 17.4219 17.8174 17.0264 17.8174ZM18.3398 14.6143C18.0859 14.6143 17.915 14.502 17.7393 14.4092C14.6875 12.6025 10.1367 11.875 6.08887 12.9736C5.85449 13.0371 5.72754 13.1006 5.50781 13.1006C4.98535 13.1006 4.56055 12.6758 4.56055 12.1533C4.56055 11.6309 4.81445 11.2842 5.31738 11.1426C6.6748 10.7617 8.06152 10.4785 10.0928 10.4785C13.2617 10.4785 16.3232 11.2646 18.7354 12.7002C19.1309 12.9346 19.2871 13.2373 19.2871 13.6621C19.2822 14.1895 18.8721 14.6143 18.3398 14.6143ZM19.8535 10.8936C19.5996 10.8936 19.4434 10.8301 19.2236 10.7031C15.7471 8.62793 9.53125 8.12988 5.50781 9.25293C5.33203 9.30176 5.1123 9.37988 4.87793 9.37988C4.2334 9.37988 3.74023 8.87695 3.74023 8.22754C3.74023 7.56348 4.15039 7.1875 4.58984 7.06055C6.30859 6.55762 8.23242 6.31836 10.3271 6.31836C13.8916 6.31836 17.627 7.06055 20.3564 8.65234C20.7373 8.87207 20.9863 9.1748 20.9863 9.75586C20.9863 10.4199 20.4492 10.8936 19.8535 10.8936Z" fill="black"/>
            </svg>',

			'github'                              => '<svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M8.10059 19.0137C8.10059 19.1113 7.98828 19.1895 7.84668 19.1895C7.68555 19.2041 7.57324 19.126 7.57324 19.0137C7.57324 18.916 7.68555 18.8379 7.82715 18.8379C7.97363 18.8232 8.10059 18.9014 8.10059 19.0137ZM6.58203 18.7939C6.54785 18.8916 6.64551 19.0039 6.79199 19.0332C6.91895 19.082 7.06543 19.0332 7.09473 18.9355C7.12402 18.8379 7.03125 18.7256 6.88477 18.6816C6.75781 18.6475 6.61621 18.6963 6.58203 18.7939ZM8.74023 18.7109C8.59863 18.7451 8.50098 18.8379 8.51562 18.9502C8.53027 19.0479 8.65723 19.1113 8.80371 19.0771C8.94531 19.043 9.04297 18.9502 9.02832 18.8525C9.01367 18.7598 8.88184 18.6963 8.74023 18.7109ZM11.9531 0C5.18066 0 0 5.1416 0 11.9141C0 17.3291 3.4082 21.9629 8.27637 23.5938C8.90137 23.7061 9.12109 23.3203 9.12109 23.0029C9.12109 22.7002 9.10645 21.0303 9.10645 20.0049C9.10645 20.0049 5.68848 20.7373 4.9707 18.5498C4.9707 18.5498 4.41406 17.1289 3.61328 16.7627C3.61328 16.7627 2.49512 15.9961 3.69141 16.0107C3.69141 16.0107 4.90723 16.1084 5.57617 17.2705C6.64551 19.1553 8.4375 18.6133 9.13574 18.291C9.24805 17.5098 9.56543 16.9678 9.91699 16.6455C7.1875 16.3428 4.43359 15.9473 4.43359 11.25C4.43359 9.90723 4.80469 9.2334 5.58594 8.37402C5.45898 8.05664 5.04395 6.74805 5.71289 5.05859C6.7334 4.74121 9.08203 6.37695 9.08203 6.37695C10.0586 6.10352 11.1084 5.96191 12.1484 5.96191C13.1885 5.96191 14.2383 6.10352 15.2148 6.37695C15.2148 6.37695 17.5635 4.73633 18.584 5.05859C19.2529 6.75293 18.8379 8.05664 18.7109 8.37402C19.4922 9.23828 19.9707 9.91211 19.9707 11.25C19.9707 15.9619 17.0947 16.3379 14.3652 16.6455C14.8145 17.0312 15.1953 17.7637 15.1953 18.9111C15.1953 20.5566 15.1807 22.5928 15.1807 22.9932C15.1807 23.3105 15.4053 23.6963 16.0254 23.584C20.9082 21.9629 24.2188 17.3291 24.2188 11.9141C24.2188 5.1416 18.7256 0 11.9531 0ZM4.74609 16.8408C4.68262 16.8896 4.69727 17.002 4.78027 17.0947C4.8584 17.1729 4.9707 17.207 5.03418 17.1436C5.09766 17.0947 5.08301 16.9824 5 16.8896C4.92188 16.8115 4.80957 16.7773 4.74609 16.8408ZM4.21875 16.4453C4.18457 16.5088 4.2334 16.5869 4.33105 16.6357C4.40918 16.6846 4.50684 16.6699 4.54102 16.6016C4.5752 16.5381 4.52637 16.46 4.42871 16.4111C4.33105 16.3818 4.25293 16.3965 4.21875 16.4453ZM5.80078 18.1836C5.72266 18.2471 5.75195 18.3936 5.86426 18.4863C5.97656 18.5986 6.11816 18.6133 6.18164 18.5352C6.24512 18.4717 6.21582 18.3252 6.11816 18.2324C6.01074 18.1201 5.86426 18.1055 5.80078 18.1836ZM5.24414 17.4658C5.16602 17.5146 5.16602 17.6416 5.24414 17.7539C5.32227 17.8662 5.4541 17.915 5.51758 17.8662C5.5957 17.8027 5.5957 17.6758 5.51758 17.5635C5.44922 17.4512 5.32227 17.4023 5.24414 17.4658Z" fill="black"/>
            </svg>',

			'trip_advisor'                        => '<svg width="16" height="16" viewBox="0 0 24 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M12.006 0.295C9.336 0.295 6.668 1.079 4.361 2.648H0L1.963 4.783C1.06861 5.59788 0.441617 6.66424 0.1644 7.842C-0.112816 9.01975 -0.0272945 10.2538 0.409731 11.3821C0.846756 12.5103 1.61484 13.48 2.61309 14.1637C3.61134 14.8475 4.79306 15.2132 6.003 15.213C7.51482 15.2143 8.97095 14.6426 10.078 13.613L12 15.705L13.922 13.615C15.0284 14.6435 16.4834 15.2145 17.994 15.213C19.585 15.213 21.1108 14.5811 22.2359 13.4563C23.3611 12.3316 23.9935 10.806 23.994 9.215C23.9949 8.38063 23.8213 7.55529 23.4843 6.79201C23.1472 6.02874 22.6543 5.34441 22.037 4.783L24 2.648H19.65C17.3962 1.11372 14.7325 0.29378 12.006 0.295ZM12 2.255C13.531 2.255 15.063 2.558 16.504 3.158C13.943 4.138 12 6.43 12 9.1C12 6.429 10.058 4.138 7.496 3.158C8.92314 2.56319 10.4539 2.25563 12 2.255ZM6.002 5.157C6.53504 5.157 7.06285 5.26199 7.55531 5.46597C8.04777 5.66996 8.49523 5.96894 8.87215 6.34585C9.24906 6.72277 9.54804 7.17023 9.75203 7.66269C9.95601 8.15515 10.061 8.68296 10.061 9.216C10.061 9.74903 9.95601 10.2769 9.75203 10.7693C9.54804 11.2618 9.24906 11.7092 8.87215 12.0861C8.49523 12.4631 8.04777 12.762 7.55531 12.966C7.06285 13.17 6.53504 13.275 6.002 13.275C4.92549 13.275 3.89306 12.8474 3.13185 12.0861C2.37064 11.3249 1.943 10.2925 1.943 9.216C1.943 8.13948 2.37064 7.10706 3.13185 6.34585C3.89306 5.58464 4.92549 5.157 6.002 5.157ZM17.994 5.159C18.5268 5.1588 19.0545 5.26356 19.5469 5.46728C20.0392 5.67101 20.4866 5.96972 20.8635 6.34635C21.2404 6.72299 21.5395 7.17017 21.7436 7.66238C21.9477 8.15458 22.0528 8.68216 22.053 9.215C22.0532 9.74784 21.9484 10.2755 21.7447 10.7679C21.541 11.2602 21.2423 11.7076 20.8656 12.0845C20.489 12.4614 20.0418 12.7605 19.5496 12.9646C19.0574 13.1687 18.5298 13.2738 17.997 13.274C16.9209 13.2744 15.8887 12.8473 15.1275 12.0866C14.3663 11.326 13.9384 10.2941 13.938 9.218C13.9376 8.14188 14.3647 7.10968 15.1254 6.34847C15.886 5.58726 16.9179 5.1594 17.994 5.159ZM6.002 7.089C5.43762 7.089 4.89635 7.3132 4.49728 7.71228C4.0982 8.11135 3.874 8.65262 3.874 9.217C3.874 9.78138 4.0982 10.3226 4.49728 10.7217C4.89635 11.1208 5.43762 11.345 6.002 11.345C6.56638 11.345 7.10765 11.1208 7.50672 10.7217C7.9058 10.3226 8.13 9.78138 8.13 9.217C8.13 8.65262 7.9058 8.11135 7.50672 7.71228C7.10765 7.3132 6.56638 7.089 6.002 7.089ZM17.994 7.089C17.4296 7.089 16.8884 7.3132 16.4893 7.71228C16.0902 8.11135 15.866 8.65262 15.866 9.217C15.866 9.78138 16.0902 10.3226 16.4893 10.7217C16.8884 11.1208 17.4296 11.345 17.994 11.345C18.5584 11.345 19.0996 11.1208 19.4987 10.7217C19.8978 10.3226 20.122 9.78138 20.122 9.217C20.122 8.65262 19.8978 8.11135 19.4987 7.71228C19.0996 7.3132 18.5584 7.089 17.994 7.089Z" fill="black"/>
			</svg>
			',

			'home_variant_one'                    => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.4048 12.6C20.2048 12.6 20.0048 12.52 19.8448 12.38L12.0048 4.72004L4.1648 12.38C3.8448 12.68 3.3448 12.6801 3.0248 12.3601C2.7248 12.0401 2.72481 11.54 3.04481 11.22L11.4448 3.02004C11.7648 2.72004 12.2448 2.72004 12.5648 3.02004L20.9648 11.22C21.2848 11.52 21.2848 12.0401 20.9848 12.3601C20.8248 12.5201 20.6048 12.6 20.4048 12.6ZM18.6448 20.4V12.58C18.6448 12.14 18.2848 11.78 17.8448 11.78C17.4048 11.78 17.0448 12.14 17.0448 12.58V19.6H14.5448V15.32C14.5448 14.74 14.0648 14.2601 13.4848 14.2601H10.5048C9.92481 14.2601 9.44481 14.74 9.44481 15.32V19.6H6.94481V12.58C6.94481 12.14 6.58481 11.78 6.14481 11.78C5.70481 11.78 5.34481 12.14 5.34481 12.58V20.4C5.34481 20.84 5.70481 21.2 6.14481 21.2H10.2448C10.6848 21.2 11.0448 20.84 11.0448 20.4V15.8601H12.9448V20.4C12.9448 20.84 13.3048 21.2 13.7448 21.2H17.8448C18.3048 21.2 18.6448 20.84 18.6448 20.4Z" fill="black"/>
			</svg>
			',

			'home_variant_two'                    => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M12.6667 14H3.33332C3.15651 14 2.98694 13.9298 2.86192 13.8047C2.73689 13.6797 2.66666 13.5101 2.66666 13.3333V7.33333H0.666656L7.55132 1.07466C7.67406 0.962983 7.83404 0.901093 7.99999 0.901093C8.16594 0.901093 8.32592 0.962983 8.44866 1.07466L15.3333 7.33333H13.3333V13.3333C13.3333 13.5101 13.2631 13.6797 13.1381 13.8047C13.013 13.9298 12.8435 14 12.6667 14ZM3.99999 12.6667H12V6.10466L7.99999 2.46866L3.99999 6.10466V12.6667Z" fill="black"/>
			</svg>
			',

			'home_variant_three'                  => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.6667 14H1.33334V12.6667H2.00001V2.66667C2.00001 2.48986 2.07025 2.32029 2.19527 2.19526C2.3203 2.07024 2.48987 2 2.66668 2H12C12.1768 2 12.3464 2.07024 12.4714 2.19526C12.5964 2.32029 12.6667 2.48986 12.6667 2.66667V6H14V12.6667H14.6667V14ZM11.3333 12.6667H12.6667V7.33333H8.66668V12.6667H10V8.66667H11.3333V12.6667ZM11.3333 6V3.33333H3.33334V12.6667H7.33334V6H11.3333ZM4.66668 7.33333H6.00001V8.66667H4.66668V7.33333ZM4.66668 10H6.00001V11.3333H4.66668V10ZM4.66668 4.66667H6.00001V6H4.66668V4.66667Z" fill="black"/>
			</svg>
			',

			'home_stall_variant_one'              => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14 8.828V13.3333H14.6667V14.6667H1.33332V13.3333H1.99999V8.828C1.58974 8.55389 1.25343 8.18282 1.02085 7.74768C0.788277 7.31253 0.666619 6.82674 0.666657 6.33334C0.666657 5.782 0.81599 5.25067 1.08866 4.798L2.89666 1.66667C2.95517 1.56533 3.03932 1.48117 3.14067 1.42266C3.24201 1.36414 3.35697 1.33334 3.47399 1.33334H12.5267C12.6437 1.33334 12.7586 1.36414 12.86 1.42266C12.9613 1.48117 13.0455 1.56533 13.104 1.66667L14.906 4.788C15.1847 5.25067 15.334 5.78134 15.334 6.33334C15.334 7.37334 14.804 8.29 14 8.828ZM12.6673 9.31467C12.209 9.36589 11.745 9.31073 11.3114 9.15348C10.8778 8.99623 10.4863 8.74113 10.1673 8.408C9.88729 8.70068 9.55089 8.93361 9.1784 9.09275C8.80591 9.2519 8.40505 9.33397 7.99999 9.334C7.59514 9.33405 7.19446 9.25215 6.8221 9.09324C6.44974 8.93432 6.11339 8.70169 5.83332 8.40934C5.51429 8.74235 5.12277 8.99732 4.68919 9.15445C4.25561 9.31158 3.79164 9.36664 3.33332 9.31534V13.3333H12.6667L12.6673 9.31467ZM3.85932 2.66667L2.23732 5.47534C2.11998 5.67261 2.04465 5.89199 2.01605 6.11974C1.98745 6.34749 2.00621 6.57869 2.07114 6.79885C2.13607 7.01901 2.24577 7.22338 2.39338 7.39916C2.54098 7.57494 2.72331 7.71834 2.92892 7.82036C3.13454 7.92239 3.35901 7.98084 3.58827 7.99206C3.81753 8.00328 4.04664 7.96702 4.26123 7.88556C4.47583 7.8041 4.67128 7.67919 4.83534 7.51866C4.99941 7.35813 5.12854 7.16544 5.21466 6.95267C5.43799 6.39467 6.22799 6.39467 6.45199 6.95267C6.57552 7.26228 6.78906 7.52774 7.06501 7.71474C7.34096 7.90174 7.66664 8.0017 7.99999 8.0017C8.33334 8.0017 8.65902 7.90174 8.93497 7.71474C9.21092 7.52774 9.42446 7.26228 9.54799 6.95267C9.77132 6.39467 10.5613 6.39467 10.7853 6.95267C10.8718 7.16564 11.0015 7.3584 11.1661 7.51885C11.3307 7.6793 11.5267 7.80397 11.7418 7.88502C11.9569 7.96606 12.1865 8.00173 12.416 7.98979C12.6456 7.97785 12.8702 7.91855 13.0757 7.81562C13.2813 7.71269 13.4633 7.56836 13.6104 7.39169C13.7574 7.21502 13.8664 7.00985 13.9303 6.78905C13.9943 6.56826 14.0118 6.33662 13.982 6.1087C13.9521 5.88079 13.8754 5.66151 13.7567 5.46467L12.14 2.66667H3.85932Z" fill="black"/>
			</svg>
			',

			'shopify'                             => '<svg width="16" height="16" viewBox="0 0 22 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.337 23.979L21.553 22.418C21.553 22.418 18.949 4.805 18.928 4.688C18.91 4.572 18.814 4.496 18.717 4.496C18.62 4.496 16.788 4.36 16.788 4.36C16.788 4.36 15.513 3.086 15.349 2.949C15.304 2.912 15.274 2.892 15.228 2.875L14.314 23.979H14.337ZM10.71 11.305C10.71 11.305 9.9 10.881 8.936 10.881C7.489 10.881 7.432 11.787 7.432 12.022C7.432 13.254 10.672 13.737 10.672 16.651C10.672 18.946 9.232 20.411 7.266 20.411C4.912 20.411 3.726 18.946 3.726 18.946L4.372 16.86C4.372 16.86 5.617 17.926 6.652 17.926C7.327 17.926 7.627 17.381 7.627 16.994C7.627 15.375 4.973 15.3 4.973 12.635C4.939 10.398 6.544 8.219 9.8 8.219C11.057 8.219 11.675 8.58 11.675 8.58L10.73 11.295L10.71 11.305ZM10.17 0.83C10.306 0.83 10.441 0.868 10.575 0.965C9.591 1.43 8.511 2.604 8.067 4.957C7.411 5.17 6.774 5.362 6.178 5.535C6.697 3.75 7.951 0.84 10.17 0.84V0.83ZM11.405 3.779V3.914C10.651 4.146 9.822 4.398 9.011 4.65C9.477 2.873 10.344 2.005 11.096 1.679C11.289 2.18 11.405 2.855 11.405 3.779ZM11.944 1.545C12.638 1.619 13.085 2.412 13.373 3.3C13.024 3.414 12.638 3.531 12.215 3.666V3.414C12.215 2.662 12.119 2.043 11.944 1.543V1.545ZM14.936 2.834C14.916 2.834 14.876 2.855 14.858 2.855C14.84 2.855 14.569 2.93 14.144 3.065C13.721 1.832 12.968 0.695 11.636 0.695H11.521C11.135 0.209 10.669 0 10.265 0C7.159 0 5.675 3.877 5.21 5.846C4.016 6.211 3.147 6.482 3.05 6.52C2.375 6.733 2.356 6.752 2.278 7.39C2.203 7.852 0.447998 21.453 0.447998 21.453L14.009 24L14.936 2.834Z" fill="black"/>
			</svg>',

			'trust_pilot'                         => '<svg width="16" height="16" viewBox="0 0 24 23" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.227 16.081L19.417 22.823L12.004 17.435L17.227 16.081ZM24 8.721H14.835L12.005 0L9.165 8.723L0 8.711L7.422 14.108L4.582 22.822L12.004 17.435L16.587 14.108L24 8.721Z" fill="black"/>
			</svg>
			',

			'angellist'                           => '<svg width="16" height="16" viewBox="0 0 18 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M14.6973 10.5176C15.2686 8.92578 16.9141 4.32129 16.9141 2.84668C16.9141 1.54785 16.1475 0.458984 14.7803 0.458984C12.6025 0.458984 10.6494 6.88965 10.0391 8.42285C9.56544 7.03125 7.34864 0 5.39551 0C3.87696 0 3.16407 1.11816 3.16407 2.52441C3.16407 4.24805 4.83399 8.71582 5.43946 10.4346C5.13184 10.3223 4.79981 10.2246 4.4629 10.2246C3.32032 10.2246 2.1045 11.6455 2.1045 12.793C2.1045 13.2275 2.34376 13.8379 2.49512 14.2432C0.693365 14.7314 5.34692e-06 15.9326 5.34692e-06 17.7441C-0.00487747 21.2695 3.33497 25 8.03223 25C13.794 25 17.3779 20.6738 17.3779 15.0928C17.3779 12.9883 17.041 11.0889 14.6973 10.5176ZM12.9688 5.27344C13.1641 4.67285 13.999 2.13379 14.7803 2.13379C15.2002 2.13379 15.3125 2.56836 15.3125 2.91504C15.3125 3.84766 13.4277 8.99902 13.0127 10.1416L11.3525 9.84863L12.9688 5.27344ZM4.69727 2.3584C4.69727 1.77734 5.40528 0.126953 6.95801 4.6582L8.64747 9.55566C7.88575 9.49219 7.29493 9.40918 6.91895 9.62402C6.38672 8.21777 4.69727 3.7793 4.69727 2.3584ZM4.58497 11.9141C6.01563 11.9141 7.86133 16.5332 7.86133 17.1582C7.86133 17.4072 7.62208 17.7148 7.34376 17.7148C6.32325 17.7148 3.58887 13.96 3.58887 12.9443C3.59376 12.5684 4.20899 11.9141 4.58497 11.9141ZM13.584 21.0107C12.1631 22.5732 10.3467 23.3838 8.22754 23.3838C5.32715 23.3838 3.03711 21.792 1.9336 19.0723C1.09864 16.9531 2.11915 15.7373 2.93946 15.7373C3.4961 15.7373 5.59083 18.6816 5.59083 19.3066C5.59083 19.5459 5.21485 19.7119 5.01954 19.7119C4.2334 19.7119 3.92579 18.9551 2.52442 17.2021C1.07422 18.6523 3.5254 21.4453 5.3711 21.4453C6.64551 21.4453 7.47559 20.2637 7.22657 19.3945C7.40723 19.3945 7.63184 19.4092 7.79786 19.3652C7.85157 20.6885 8.24219 22.2656 9.83399 22.3779C9.83399 22.334 9.93165 22.0312 9.93165 22.0166C9.93165 21.167 9.41407 20.4248 9.41407 19.5605C9.41407 18.1787 10.4736 16.8408 11.5479 16.0596C11.9385 15.7666 12.4121 15.5859 12.8711 15.4199C13.3447 15.2393 13.8477 15.0293 14.209 14.668C14.1553 14.1211 13.9307 13.6377 13.3838 13.6377C12.0313 13.6377 7.49512 13.833 7.49512 11.6992C7.49512 11.3721 7.50001 11.0596 8.34473 11.0596C9.92188 11.0596 13.9258 11.4502 15.0977 12.4805C15.9815 13.2666 16.2842 18.0078 13.584 21.0107ZM8.76954 14.8584C9.24317 15.0098 9.73145 15.0537 10.2197 15.1514C9.8584 15.415 9.53614 15.7373 9.22852 16.084C9.0918 15.6689 8.92579 15.2637 8.76954 14.8584Z" fill="black"/>
            </svg>',

			'amazon'                              => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M12.2154 6.38184C9.83746 6.46973 3.93902 7.13867 3.93902 12.1191C3.93902 17.4658 10.6919 17.6855 12.899 14.2285C13.2164 14.7266 14.6275 16.0596 15.1109 16.5137L17.8843 13.7793C17.8843 13.7793 16.3072 12.5439 16.3072 11.2012V4.01855C16.3072 2.7832 15.1109 0 10.8238 0C6.52691 0 4.24663 2.68555 4.24663 5.09277L7.8355 5.42481C8.6314 3.00781 10.482 3.00781 10.482 3.00781C12.4693 3.00293 12.2154 4.46289 12.2154 6.38184ZM12.2154 10.6201C12.2154 14.5264 8.10406 13.9404 8.10406 11.46C8.10406 9.15527 10.5699 8.69141 12.2154 8.6377V10.6201ZM18.856 18.6035C18.48 19.0918 15.438 21.875 10.3355 21.875C5.23296 21.875 1.32671 18.3838 0.130424 16.9434C-0.201607 16.5674 0.179252 16.3916 0.398979 16.5381C3.97808 18.7109 9.5689 22.29 18.5875 18.0176C18.9537 17.8369 19.2369 18.1152 18.856 18.6035ZM20.7994 18.7109C20.482 19.4824 20.0181 20.0195 19.7642 20.2246C19.4957 20.4443 19.3003 20.3564 19.4468 20.0391C19.5933 19.7217 20.3892 17.7686 20.0669 17.3535C19.7496 16.9482 18.2603 17.1436 17.7232 17.1973C17.1959 17.2461 17.0884 17.2949 17.0396 17.1826C16.9273 16.9043 18.0992 16.4258 18.8707 16.3281C19.6373 16.2402 20.8726 16.2891 21.1168 16.6064C21.2974 16.8555 21.1168 17.9297 20.7994 18.7109Z" fill="black"/>
            </svg>',

			'home_advisor'                        => '<svg width="16" height="16" viewBox="0 0 24 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M15.98 0.442001H8.02L0 8.46H2.275L9.157 1.58L16.038 8.461H24L15.98 0.443002M15.488 9.791L9.157 3.459L4.01 8.605V13.592C4.01027 13.9444 4.15037 14.2823 4.39955 14.5315C4.64873 14.7806 4.98661 14.9207 5.339 14.921H11.416L16.053 19.558V14.921H18.651C19.0037 14.921 19.342 14.7809 19.5915 14.5315C19.8409 14.282 19.981 13.9437 19.981 13.591V9.79H15.487L15.488 9.791Z" fill="black"/>
			</svg>
			',

			'viber'                               => '<svg width="16" height="16" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M21.0357 2.43468C20.4155 1.86339 17.9058 0.0421041 12.3101 0.01769C12.3101 0.01769 5.7134 -0.377818 2.50051 2.5714C0.713398 4.35851 0.0835148 6.98058 0.0151554 10.2277C-0.053204 13.4747 -0.136212 19.5587 5.72805 21.2091H5.73293L5.72805 23.7286C5.72805 23.7286 5.68898 24.7491 6.36281 24.9542C7.17336 25.2081 7.65187 24.4318 8.42824 23.5968C8.85305 23.1378 9.43898 22.464 9.88332 21.9513C13.897 22.2882 16.978 21.5167 17.3296 21.4044C18.1402 21.1407 22.7251 20.5548 23.4673 14.4708C24.2388 8.19152 23.0962 4.22667 21.0357 2.43468ZM21.7144 14.0118C21.0845 19.09 17.3687 19.4122 16.6851 19.6319C16.3921 19.7247 13.6821 20.3985 10.2788 20.1788C10.2788 20.1788 7.73976 23.2403 6.94875 24.0362C6.68996 24.295 6.40676 24.2706 6.41164 23.7579C6.41164 23.421 6.43117 19.5734 6.43117 19.5734C6.42629 19.5734 6.42629 19.5734 6.43117 19.5734C1.46047 18.1964 1.75344 13.0157 1.80715 10.3058C1.86086 7.59582 2.37355 5.37414 3.88723 3.87999C6.60695 1.41417 12.2075 1.78039 12.2075 1.78039C16.939 1.79992 19.2046 3.2257 19.732 3.70421C21.4751 5.19835 22.3638 8.77257 21.7144 14.0118ZM14.9273 10.0665C14.9468 10.4864 14.3169 10.5157 14.2974 10.0958C14.2437 9.0216 13.7407 8.49914 12.7056 8.44054C12.2857 8.41613 12.3247 7.78624 12.7398 7.81066C14.1021 7.8839 14.8589 8.66515 14.9273 10.0665ZM15.9185 10.6183C15.9673 8.54796 14.6734 6.92687 12.2173 6.74621C11.8023 6.71691 11.8462 6.08703 12.2612 6.11632C15.0933 6.3214 16.6021 8.26964 16.5484 10.6329C16.5435 11.0528 15.9087 11.0333 15.9185 10.6183ZM18.2134 11.2726C18.2183 11.6925 17.5835 11.6974 17.5835 11.2775C17.5542 7.29796 14.9029 5.12999 11.6851 5.10558C11.27 5.1007 11.27 4.4757 11.6851 4.4757C15.2837 4.50011 18.1792 6.98546 18.2134 11.2726ZM17.6616 16.0626V16.0724C17.1343 17.0001 16.148 18.0255 15.1323 17.6984L15.1226 17.6837C14.0923 17.3956 11.6655 16.1456 10.1323 14.9249C9.34133 14.2999 8.61867 13.5626 8.06203 12.8546C7.5591 12.2247 7.05129 11.4777 6.55812 10.5792C5.51809 8.69933 5.28859 7.85949 5.28859 7.85949C4.96144 6.84386 5.98195 5.85753 6.91457 5.33019H6.92434C7.37355 5.09581 7.80324 5.17394 8.09133 5.52062C8.09133 5.52062 8.6968 6.24328 8.95559 6.59972C9.19973 6.93175 9.52687 7.46398 9.69777 7.76183C9.99562 8.29406 9.81008 8.83605 9.51711 9.06066L8.93117 9.52941C8.63332 9.76867 8.67238 10.213 8.67238 10.213C8.67238 10.213 9.54152 13.4991 12.7886 14.3292C12.7886 14.3292 13.2329 14.3683 13.4722 14.0704L13.9409 13.4845C14.1655 13.1915 14.7075 13.006 15.2398 13.3038C15.9575 13.7091 16.8706 14.339 17.4761 14.9103C17.8179 15.1886 17.896 15.6134 17.6616 16.0626Z" fill="black"/>
            </svg>',

			'android'                             => '<svg width="16" height="16" viewBox="0 0 19 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M2.8125 8.42631V14.0806C2.8125 14.8326 2.22168 15.4331 1.46973 15.4331C0.722656 15.4331 0 14.8277 0 14.0806V8.42631C0 7.689 0.722656 7.08353 1.46973 7.08353C2.20703 7.08353 2.8125 7.689 2.8125 8.42631ZM3.33984 16.0923C3.33984 16.8931 3.98438 17.5376 4.78516 17.5376H5.75684L5.77148 20.521C5.77148 22.3228 8.4668 22.3081 8.4668 20.521V17.5376H10.2832V20.521C10.2832 22.313 12.9932 22.3179 12.9932 20.521V17.5376H13.9795C14.7705 17.5376 15.415 16.8931 15.415 16.0923V7.33256H3.33984V16.0923ZM15.4492 6.85892H3.28613C3.28613 4.76908 4.53613 2.95268 6.3916 2.00541L5.45898 0.281777C5.32227 0.0425192 5.66895 -0.108848 5.78613 0.0962301L6.7334 1.83451C8.4375 1.07768 10.3955 1.11674 12.0215 1.83451L12.9639 0.101113C13.0859 -0.108848 13.4277 0.0474019 13.291 0.28666L12.3584 2.00541C14.1992 2.95268 15.4492 4.76908 15.4492 6.85892ZM7.11426 4.14896C7.11426 3.87064 6.88965 3.63627 6.60156 3.63627C6.32324 3.63627 6.10352 3.87064 6.10352 4.14896C6.10352 4.42728 6.32812 4.66166 6.60156 4.66166C6.88965 4.66166 7.11426 4.42728 7.11426 4.14896ZM12.6514 4.14896C12.6514 3.87064 12.4268 3.63627 12.1533 3.63627C11.8652 3.63627 11.6406 3.87064 11.6406 4.14896C11.6406 4.42728 11.8652 4.66166 12.1533 4.66166C12.4268 4.66166 12.6514 4.42728 12.6514 4.14896ZM17.2803 7.08353C16.543 7.08353 15.9375 7.67435 15.9375 8.42631V14.0806C15.9375 14.8326 16.543 15.4331 17.2803 15.4331C18.0322 15.4331 18.75 14.8277 18.75 14.0806V8.42631C18.75 7.67435 18.0273 7.08353 17.2803 7.08353Z" fill="black"/>
            </svg>',

			'quora'                               => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M21.1523 17.3193H19.7217C19.6484 17.9785 19.209 18.8232 18.1104 18.8232C17.1094 18.8232 16.3867 18.1299 15.6934 17.0752C17.8516 15.4053 19.3408 12.8027 19.3408 9.60449C19.3457 3.86719 14.624 0 9.65332 0C4.78516 0 0 3.8916 0 9.60449C0 16.1523 6.41113 20.4248 12.1582 18.833C13.1201 20.4736 14.3896 21.875 16.8066 21.875C20.8008 21.875 21.2402 18.1982 21.1523 17.3193ZM14.1455 14.5117C13.1934 13.0859 12.0117 11.9629 9.67773 11.9629C8.18848 11.9629 7.02637 12.4512 6.30859 13.0762L6.9043 14.2627C7.20703 14.1162 7.53906 14.0674 7.87109 14.0674C9.60449 14.0674 10.4932 15.5713 11.25 17.0605C10.7617 17.207 10.2393 17.2656 9.65332 17.2656C5.99121 17.2656 4.4043 14.6777 4.4043 9.61426C4.4043 4.5166 5.99121 1.9043 9.65332 1.9043C13.374 1.9043 14.9609 4.5166 14.9609 9.60449C14.9658 11.6455 14.6973 13.2959 14.1455 14.5117Z" fill="black"/>
            </svg>',

			'academy_graduation'                  => '<svg width="16" height="16" viewBox="0 0 25 15" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.31 3.48447L13.4139 0.136816C12.8201 -0.0456055 12.1795 -0.0456055 11.5861 0.136816L0.689648 3.48447C-0.229883 3.76689 -0.229883 4.98291 0.689648 5.26533L2.58926 5.84893C2.17246 6.36416 1.91621 6.99268 1.89082 7.68096C1.51465 7.89658 1.2498 8.28564 1.2498 8.7501C1.2498 9.17119 1.47168 9.52549 1.79121 9.75205L0.793945 14.2396C0.707227 14.6298 1.0041 15.0001 1.40371 15.0001H3.59551C3.99551 15.0001 4.29238 14.6298 4.20566 14.2396L3.2084 9.75205C3.52793 9.52549 3.7498 9.17119 3.7498 8.7501C3.7498 8.29814 3.49707 7.92002 3.13809 7.70049C3.16777 7.11377 3.46777 6.59502 3.94629 6.26611L11.5857 8.61338C11.9396 8.72197 12.6186 8.85752 13.4135 8.61338L24.31 5.26572C25.2299 4.98291 25.2299 3.76729 24.31 3.48447ZM13.7807 9.8083C12.6662 10.1505 11.7166 9.96143 11.2186 9.8083L5.55371 8.06807L4.9998 12.5001C4.9998 13.881 8.35762 15.0001 12.4998 15.0001C16.642 15.0001 19.9998 13.881 19.9998 12.5001L19.4459 8.06768L13.7807 9.8083Z" fill="black"/>
            </svg>',

			'shapes'                              => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.74066 23.7307C9.11926 23.7307 8.58731 23.5095 8.14481 23.067C7.70231 22.6245 7.48106 22.0925 7.48106 21.4711V20.4375C7.48106 20.1719 7.57094 19.9492 7.75069 19.7695C7.93046 19.5898 8.15321 19.5 8.41894 19.5C8.68469 19.5 8.9073 19.5898 9.08678 19.7695C9.26626 19.9492 9.356 20.1719 9.356 20.4375V21.4711C9.356 21.5833 9.39206 21.6755 9.46419 21.7476C9.53631 21.8197 9.62847 21.8558 9.74066 21.8558H21.4714C21.5836 21.8558 21.6757 21.8197 21.7478 21.7476C21.8199 21.6755 21.856 21.5833 21.856 21.4711V9.74041C21.856 9.62822 21.8199 9.53607 21.7478 9.46394C21.6757 9.39182 21.5836 9.35575 21.4714 9.35575H20.4377C20.1721 9.35575 19.9495 9.26588 19.7698 9.08613C19.5901 8.90636 19.5002 8.68361 19.5002 8.41788C19.5002 8.15213 19.5901 7.92952 19.7698 7.75004C19.9495 7.57056 20.1721 7.48082 20.4377 7.48082H21.4714C22.0928 7.48082 22.6247 7.70207 23.0672 8.14457C23.5097 8.58707 23.731 9.11902 23.731 9.74041V21.4711C23.731 22.0925 23.5097 22.6245 23.0672 23.067C22.6247 23.5095 22.0928 23.7307 21.4714 23.7307H9.74066ZM8.39678 16.5192C6.13405 16.5192 4.21383 15.7311 2.63613 14.1549C1.0584 12.5788 0.269531 10.6593 0.269531 8.39654C0.269531 6.13381 1.05763 4.21359 2.63381 2.63588C4.21 1.05815 6.12946 0.269287 8.39219 0.269287C10.6549 0.269287 12.5752 1.05738 14.1529 2.63357C15.7306 4.20976 16.5194 6.12921 16.5194 8.39194C16.5194 10.6547 15.7314 12.5749 14.1552 14.1526C12.579 15.7303 10.6595 16.5192 8.39678 16.5192ZM8.3945 14.6443C10.1237 14.6443 11.5976 14.0349 12.8164 12.8161C14.0351 11.5974 14.6445 10.1234 14.6445 8.39426C14.6445 6.66509 14.0351 5.19113 12.8164 3.97238C11.5976 2.75363 10.1237 2.14426 8.3945 2.14426C6.66533 2.14426 5.19138 2.75363 3.97263 3.97238C2.75388 5.19113 2.1445 6.66509 2.1445 8.39426C2.1445 10.1234 2.75388 11.5974 3.97263 12.8161C5.19138 14.0349 6.66533 14.6443 8.3945 14.6443Z" fill="black"/>
			</svg>
			',

			'crown_pro_king'                      => '<svg width="16" height="16" viewBox="0 0 15 11" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M3.67847 4.22704L1.09368 2.76174C0.700191 2.53868 0.236327 2.91114 0.369137 3.34352L2.61241 10.6468C2.67689 10.8567 2.87078 11 3.09037 11H12.3804C12.6049 11 12.8018 10.8505 12.8621 10.6343L14.9054 3.3083C15.0252 2.87869 14.5652 2.51905 14.1772 2.739L11.5491 4.22886C11.3365 4.34937 11.0679 4.29856 10.9141 4.10871L7.97597 0.483505C7.77476 0.235235 7.39548 0.236859 7.1964 0.486844L4.31618 4.10355C4.16293 4.29598 3.89247 4.34835 3.67847 4.22704Z" fill="black"/>
			</svg>
			',

			'graduation_cap'                      => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.7251 9.10002L12.3251 5.32001C12.1051 5.22001 11.8651 5.22001 11.6651 5.32001L3.2651 9.10002C2.9851 9.22002 2.8051 9.50002 2.8051 9.80002C2.8051 10.1 3.0051 10.38 3.2851 10.52L4.0051 10.86V13.66C4.0051 13.94 4.2251 14.16 4.5051 14.16C4.7851 14.16 5.0051 13.94 5.0051 13.66V11.4L6.2051 12.04V15.44C6.2051 15.58 6.2451 15.7 6.3251 15.82C6.4051 15.94 8.2251 18.66 11.9051 18.66C15.6851 18.66 17.4251 15.92 17.5051 15.82C17.5651 15.72 17.6251 15.58 17.6251 15.46V12.18L20.8051 10.56C21.0851 10.42 21.2451 10.14 21.2451 9.84001C21.2051 9.50001 21.0051 9.24002 20.7251 9.10002ZM16.2051 15.22C15.8051 15.7 14.4451 17.26 11.9051 17.26C9.4251 17.26 8.0051 15.72 7.6051 15.22V12.76L11.6451 14.82C11.7651 14.88 11.8851 14.9 12.0051 14.9C12.1251 14.9 12.2651 14.88 12.3851 14.82L16.2051 12.88V15.22ZM12.0051 13.2L5.4451 9.88002L12.0051 6.92001L18.5651 9.88002L12.0051 13.2ZM5.0051 14.86C5.1451 15 5.2451 15.22 5.2451 15.42C5.2451 15.62 5.1651 15.84 5.0051 15.98C4.8651 16.12 4.6451 16.22 4.4451 16.22C4.2451 16.22 4.0251 16.14 3.8851 15.98C3.7451 15.84 3.6451 15.62 3.6451 15.42C3.6451 15.22 3.7251 15 3.8851 14.86C4.0251 14.72 4.2451 14.62 4.4451 14.62C4.6451 14.62 4.8451 14.7 5.0051 14.86Z" fill="black"/>
			</svg>
			',

			'discount_light'                      => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.70267 1.396C7.06456 1.08756 7.5245 0.918144 8 0.918144C8.4755 0.918144 8.93545 1.08756 9.29734 1.396L10.196 2.162C10.3029 2.25318 10.4359 2.30825 10.576 2.31933L11.7527 2.41267C12.2267 2.45047 12.6717 2.6559 13.0079 2.99212C13.3441 3.32834 13.5495 3.77335 13.5873 4.24733L13.6807 5.42467C13.6919 5.56452 13.7469 5.69726 13.838 5.804L14.604 6.70267C14.9124 7.06456 15.0819 7.5245 15.0819 8C15.0819 8.4755 14.9124 8.93544 14.604 9.29733L13.838 10.196C13.7469 10.3027 13.6919 10.4355 13.6807 10.5753L13.5873 11.752C13.5495 12.226 13.3441 12.671 13.0079 13.0072C12.6717 13.3434 12.2267 13.5489 11.7527 13.5867L10.5753 13.68C10.4354 13.6914 10.3027 13.7467 10.196 13.838L9.29734 14.6033C8.93545 14.9118 8.4755 15.0812 8 15.0812C7.5245 15.0812 7.06456 14.9118 6.70267 14.6033L5.804 13.838C5.69726 13.7469 5.56452 13.6919 5.42467 13.6807L4.248 13.5867C3.77402 13.5489 3.32901 13.3434 2.99279 13.0072C2.65657 12.671 2.45114 12.226 2.41334 11.752L2.32 10.5753C2.30873 10.4352 2.25343 10.3022 2.162 10.1953L1.39667 9.29667C1.0884 8.93482 0.919098 8.47501 0.919098 7.99967C0.919098 7.52432 1.0884 7.06451 1.39667 6.70267L2.162 5.804C2.25318 5.69708 2.30825 5.56408 2.31934 5.424L2.41334 4.24733C2.45129 3.77347 2.65679 3.32862 2.99299 2.99254C3.3292 2.65645 3.77413 2.45111 4.248 2.41333L5.42467 2.32C5.56475 2.30891 5.69775 2.25385 5.80467 2.16267L6.70267 1.396ZM8.43267 2.41067C8.31205 2.30791 8.15878 2.25148 8.00034 2.25148C7.84189 2.25148 7.68862 2.30791 7.568 2.41067L6.66934 3.17733C6.34877 3.45014 5.9503 3.61485 5.53067 3.648L4.354 3.742C4.19608 3.75464 4.04783 3.82311 3.9358 3.93513C3.82378 4.04716 3.75531 4.19541 3.74267 4.35333L3.64867 5.53067C3.61519 5.95014 3.45025 6.34836 3.17734 6.66867L2.41067 7.56733C2.30791 7.68795 2.25148 7.84122 2.25148 7.99967C2.25148 8.15812 2.30791 8.31138 2.41067 8.432L3.17734 9.33067C3.45025 9.65097 3.61519 10.0492 3.64867 10.4687L3.742 11.646C3.75467 11.804 3.82323 11.9524 3.93539 12.0644C4.04755 12.1764 4.19596 12.2448 4.354 12.2573L5.53067 12.3513C5.95037 12.3847 6.34885 12.5496 6.66934 12.8227L7.568 13.5893C7.68862 13.6921 7.84189 13.7485 8.00034 13.7485C8.15878 13.7485 8.31205 13.6921 8.43267 13.5893L9.33134 12.8227C9.65164 12.5497 10.0499 12.3848 10.4693 12.3513L11.646 12.258C11.8041 12.2455 11.9526 12.177 12.0648 12.0648C12.177 11.9526 12.2455 11.8041 12.258 11.646L12.3513 10.4687C12.3847 10.0493 12.55 9.65133 12.8233 9.33067L13.5893 8.432C13.6921 8.31138 13.7485 8.15812 13.7485 7.99967C13.7485 7.84122 13.6921 7.68795 13.5893 7.56733L12.8227 6.66867C12.55 6.34828 12.3853 5.95006 12.352 5.53067L12.258 4.35333C12.2453 4.19531 12.1768 4.04697 12.0646 3.93493C11.9525 3.82289 11.804 3.75449 11.646 3.742L10.4693 3.64867C10.0498 3.615 9.65155 3.44982 9.33134 3.17667L8.43267 2.41067ZM9.886 5.17133L10.8287 6.114L6.11467 10.8287L5.17134 9.88533L9.886 5.17133ZM6.82134 6.82133C6.72909 6.91684 6.61874 6.99302 6.49674 7.04543C6.37474 7.09784 6.24352 7.12543 6.11074 7.12658C5.97796 7.12774 5.84628 7.10243 5.72338 7.05215C5.60048 7.00187 5.48883 6.92762 5.39494 6.83373C5.30105 6.73983 5.22679 6.62818 5.17651 6.50529C5.12623 6.38239 5.10093 6.25071 5.10208 6.11793C5.10324 5.98515 5.13083 5.85393 5.18323 5.73193C5.23564 5.60992 5.31183 5.49958 5.40734 5.40733C5.59594 5.22517 5.84854 5.12438 6.11074 5.12666C6.37293 5.12894 6.62375 5.23411 6.80915 5.41951C6.99456 5.60492 7.09973 5.85573 7.10201 6.11793C7.10429 6.38013 7.00349 6.63273 6.82134 6.82133ZM9.17867 10.5927C9.27092 10.6882 9.38126 10.7644 9.50326 10.8168C9.62527 10.8692 9.75649 10.8968 9.88927 10.8979C10.022 10.8991 10.1537 10.8738 10.2766 10.8235C10.3995 10.7732 10.5112 10.699 10.6051 10.6051C10.699 10.5112 10.7732 10.3995 10.8235 10.2766C10.8738 10.1537 10.8991 10.022 10.8979 9.88926C10.8968 9.75649 10.8692 9.62527 10.8168 9.50326C10.7644 9.38126 10.6882 9.27091 10.5927 9.17867C10.4035 8.99968 10.152 8.90153 9.89166 8.90509C9.63128 8.90865 9.38256 9.01364 9.19839 9.19773C9.01421 9.38181 8.90911 9.63048 8.90543 9.89086C8.90174 10.1512 8.99977 10.4028 9.17867 10.592" fill="black"/>
			</svg>
			',

			'discount_fill'                       => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.29734 1.396C8.93545 1.08756 8.4755 0.918144 8 0.918144C7.5245 0.918144 7.06456 1.08756 6.70267 1.396L5.804 2.162C5.69726 2.25305 5.56452 2.30811 5.42467 2.31933L4.248 2.41267C3.77402 2.45047 3.32901 2.6559 2.99279 2.99212C2.65657 3.32834 2.45114 3.77335 2.41334 4.24733L2.32 5.42467C2.30859 5.56459 2.2533 5.69735 2.162 5.804L1.39667 6.70267C1.0884 7.06451 0.919098 7.52432 0.919098 7.99967C0.919098 8.47501 1.0884 8.93482 1.39667 9.29667L2.162 10.196C2.25306 10.3027 2.30811 10.4355 2.31934 10.5753L2.41334 11.752C2.45114 12.226 2.65657 12.671 2.99279 13.0072C3.32901 13.3434 3.77402 13.5489 4.248 13.5867L5.42467 13.68C5.56483 13.6913 5.69783 13.7466 5.80467 13.838L6.70267 14.6033C7.06456 14.9118 7.5245 15.0812 8 15.0812C8.4755 15.0812 8.93545 14.9118 9.29734 14.6033L10.196 13.838C10.3029 13.7468 10.4359 13.6918 10.576 13.6807L11.7527 13.5867C12.2267 13.5489 12.6717 13.3434 13.0079 13.0072C13.3441 12.671 13.5495 12.226 13.5873 11.752L13.6807 10.5753C13.6918 10.4352 13.7468 10.3023 13.838 10.1953L14.604 9.29733C14.9124 8.93544 15.0819 8.4755 15.0819 8C15.0819 7.5245 14.9124 7.06456 14.604 6.70267L13.838 5.804C13.7468 5.69708 13.6918 5.56408 13.6807 5.424L13.5873 4.24733C13.5495 3.77335 13.3441 3.32834 13.0079 2.99212C12.6717 2.6559 12.2267 2.45047 11.7527 2.41267L10.5753 2.31933C10.4355 2.30811 10.3027 2.25305 10.196 2.162L9.29734 1.396ZM9.88534 5.17133L10.8287 6.114L6.11467 10.8287L5.17134 9.88533L9.88534 5.17133ZM6.82134 6.82133C6.72909 6.91684 6.61874 6.99302 6.49674 7.04543C6.37474 7.09784 6.24352 7.12543 6.11074 7.12658C5.97796 7.12774 5.84628 7.10243 5.72338 7.05215C5.60048 7.00187 5.48883 6.92762 5.39494 6.83373C5.30105 6.73983 5.22679 6.62818 5.17651 6.50529C5.12623 6.38239 5.10093 6.25071 5.10208 6.11793C5.10324 5.98515 5.13083 5.85393 5.18323 5.73193C5.23564 5.60992 5.31183 5.49958 5.40734 5.40733C5.59594 5.22517 5.84854 5.12438 6.11074 5.12666C6.37293 5.12894 6.62375 5.23411 6.80915 5.41951C6.99456 5.60492 7.09973 5.85573 7.10201 6.11793C7.10429 6.38013 7.00349 6.63273 6.82134 6.82133ZM9.17867 10.5927C9.08154 10.5008 9.00381 10.3905 8.95007 10.2681C8.89632 10.1457 8.86766 10.0138 8.86577 9.88015C8.86388 9.7465 8.8888 9.61383 8.93906 9.48998C8.98932 9.36612 9.0639 9.2536 9.15839 9.15907C9.25289 9.06453 9.36537 8.9899 9.4892 8.93958C9.61303 8.88926 9.74569 8.86427 9.87934 8.8661C10.013 8.86793 10.1449 8.89653 10.2673 8.95022C10.3897 9.0039 10.5001 9.08158 10.592 9.17867C10.7686 9.36823 10.8648 9.61896 10.8602 9.87803C10.8557 10.1371 10.7507 10.3843 10.5675 10.5675C10.3843 10.7507 10.1371 10.8557 9.87803 10.8602C9.61896 10.8648 9.36824 10.7686 9.17867 10.592" fill="black"/>
			</svg>
			',

			'hash'                                => '<svg width="16" height="16" viewBox="0 0 11 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.52267 7.33333L2.80267 4.66667H0V3.33333H2.94333L3.29333 0H4.634L4.284 3.33333H6.94333L7.29333 0H8.634L8.284 3.33333H10.6667V4.66667H8.144L7.864 7.33333H10.6667V8.66667H7.72333L7.37333 12H6.03267L6.38267 8.66667H3.72333L3.37333 12H2.03267L2.38267 8.66667H0V7.33333H2.52267ZM3.86333 7.33333H6.52333L6.80333 4.66667H4.14333L3.86333 7.33333Z" fill="black"/>
			</svg>
			',

			'track_changes'                       => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M12.5 25C10.7708 25 9.14583 24.6719 7.625 24.0156C6.10417 23.3594 4.78125 22.4688 3.65625 21.3438C2.53125 20.2188 1.64063 18.8958 0.984375 17.375C0.328125 15.8542 0 14.2292 0 12.5C0 10.7708 0.328125 9.14583 0.984375 7.625C1.64063 6.10417 2.53125 4.78125 3.65625 3.65625C4.78125 2.53125 6.10417 1.64063 7.625 0.984375C9.14583 0.328125 10.7708 0 12.5 0H13.75V10.3438C14.125 10.5729 14.4271 10.8698 14.6562 11.2344C14.8854 11.599 15 12.0208 15 12.5C15 13.1875 14.7552 13.776 14.2656 14.2656C13.776 14.7552 13.1875 15 12.5 15C11.8125 15 11.224 14.7552 10.7344 14.2656C10.2448 13.776 10 13.1875 10 12.5C10 12.0208 10.1146 11.5938 10.3438 11.2188C10.5729 10.8438 10.875 10.5521 11.25 10.3438V7.65625C10.1667 7.94792 9.27083 8.53646 8.5625 9.42188C7.85417 10.3073 7.5 11.3333 7.5 12.5C7.5 13.875 7.98958 15.0521 8.96875 16.0312C9.94792 17.0104 11.125 17.5 12.5 17.5C13.875 17.5 15.0521 17.0104 16.0312 16.0312C17.0104 15.0521 17.5 13.875 17.5 12.5C17.5 11.75 17.349 11.0573 17.0469 10.4219C16.7448 9.78646 16.3333 9.22917 15.8125 8.75L17.5938 6.96875C18.3229 7.65625 18.9062 8.47396 19.3438 9.42188C19.7812 10.3698 20 11.3958 20 12.5C20 14.5833 19.2708 16.3542 17.8125 17.8125C16.3542 19.2708 14.5833 20 12.5 20C10.4167 20 8.64583 19.2708 7.1875 17.8125C5.72917 16.3542 5 14.5833 5 12.5C5 10.625 5.59375 8.99479 6.78125 7.60938C7.96875 6.22396 9.45833 5.38542 11.25 5.09375V2.5625C8.77083 2.875 6.69271 3.96875 5.01563 5.84375C3.33854 7.71875 2.5 9.9375 2.5 12.5C2.5 15.2917 3.46875 17.6562 5.40625 19.5938C7.34375 21.5312 9.70833 22.5 12.5 22.5C15.2917 22.5 17.6562 21.5312 19.5938 19.5938C21.5312 17.6562 22.5 15.2917 22.5 12.5C22.5 11.0625 22.2188 9.71875 21.6562 8.46875C21.0938 7.21875 20.3229 6.13542 19.3438 5.21875L21.125 3.4375C22.3125 4.58333 23.2552 5.93229 23.9531 7.48438C24.651 9.03646 25 10.7083 25 12.5C25 14.2292 24.6719 15.8542 24.0156 17.375C23.3594 18.8958 22.4688 20.2188 21.3438 21.3438C20.2188 22.4688 18.8958 23.3594 17.375 24.0156C15.8542 24.6719 14.2292 25 12.5 25Z" fill="black"/>
			</svg>
			',

			'linked_changes'                      => '<svg width="16" height="16" viewBox="0 0 29 29" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M23.25 10.75C22.0625 10.75 21.0312 10.3958 20.1562 9.6875C19.2812 8.97917 18.6979 8.08333 18.4062 7H10.5625C10.3333 7.875 9.90104 8.63021 9.26562 9.26562C8.63021 9.90104 7.875 10.3333 7 10.5625V18.4062C8.08333 18.6979 8.97917 19.2812 9.6875 20.1562C10.3958 21.0312 10.75 22.0625 10.75 23.25C10.75 24.625 10.2604 25.8021 9.28125 26.7812C8.30208 27.7604 7.125 28.25 5.75 28.25C4.375 28.25 3.19792 27.7604 2.21875 26.7812C1.23958 25.8021 0.75 24.625 0.75 23.25C0.75 22.0625 1.10417 21.0312 1.8125 20.1562C2.52083 19.2812 3.41667 18.6979 4.5 18.4062V10.5625C3.41667 10.2708 2.52083 9.6875 1.8125 8.8125C1.10417 7.9375 0.75 6.91667 0.75 5.75C0.75 4.375 1.23958 3.19792 2.21875 2.21875C3.19792 1.23958 4.375 0.75 5.75 0.75C6.91667 0.75 7.9375 1.10417 8.8125 1.8125C9.6875 2.52083 10.2708 3.41667 10.5625 4.5H18.4062C18.6979 3.41667 19.2812 2.52083 20.1562 1.8125C21.0312 1.10417 22.0625 0.75 23.25 0.75C24.625 0.75 25.8021 1.23958 26.7812 2.21875C27.7604 3.19792 28.25 4.375 28.25 5.75C28.25 7.125 27.7604 8.30208 26.7812 9.28125C25.8021 10.2604 24.625 10.75 23.25 10.75ZM5.75 25.75C6.4375 25.75 7.02604 25.5 7.51562 25C8.00521 24.5 8.25 23.9167 8.25 23.25C8.25 22.5625 8.00521 21.974 7.51562 21.4844C7.02604 20.9948 6.4375 20.75 5.75 20.75C5.08333 20.75 4.5 20.9948 4 21.4844C3.5 21.974 3.25 22.5625 3.25 23.25C3.25 23.9167 3.5 24.5 4 25C4.5 25.5 5.08333 25.75 5.75 25.75ZM5.75 8.25C6.4375 8.25 7.02604 8.00521 7.51562 7.51562C8.00521 7.02604 8.25 6.4375 8.25 5.75C8.25 5.0625 8.00521 4.47396 7.51562 3.98438C7.02604 3.49479 6.4375 3.25 5.75 3.25C5.08333 3.25 4.5 3.49479 4 3.98438C3.5 4.47396 3.25 5.0625 3.25 5.75C3.25 6.4375 3.5 7.02604 4 7.51562C4.5 8.00521 5.08333 8.25 5.75 8.25ZM23.25 28.25C21.875 28.25 20.6979 27.7604 19.7188 26.7812C18.7396 25.8021 18.25 24.625 18.25 23.25C18.25 21.875 18.7396 20.6979 19.7188 19.7188C20.6979 18.7396 21.875 18.25 23.25 18.25C24.625 18.25 25.8021 18.7396 26.7812 19.7188C27.7604 20.6979 28.25 21.875 28.25 23.25C28.25 24.625 27.7604 25.8021 26.7812 26.7812C25.8021 27.7604 24.625 28.25 23.25 28.25ZM23.25 25.75C23.9375 25.75 24.526 25.5 25.0156 25C25.5052 24.5 25.75 23.9167 25.75 23.25C25.75 22.5625 25.5052 21.974 25.0156 21.4844C24.526 20.9948 23.9375 20.75 23.25 20.75C22.5625 20.75 21.974 20.9948 21.4844 21.4844C20.9948 21.974 20.75 22.5625 20.75 23.25C20.75 23.9167 20.9948 24.5 21.4844 25C21.974 25.5 22.5625 25.75 23.25 25.75ZM23.25 8.25C23.9375 8.25 24.526 8.00521 25.0156 7.51562C25.5052 7.02604 25.75 6.4375 25.75 5.75C25.75 5.0625 25.5052 4.47396 25.0156 3.98438C24.526 3.49479 23.9375 3.25 23.25 3.25C22.5625 3.25 21.974 3.49479 21.4844 3.98438C20.9948 4.47396 20.75 5.0625 20.75 5.75C20.75 6.4375 20.9948 7.02604 21.4844 7.51562C21.974 8.00521 22.5625 8.25 23.25 8.25Z" fill="black"/>
			</svg>
			',

			'add_photo_image'                     => '<svg width="16" height="16" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M4.41667 37.75C3.27083 37.75 2.28993 37.342 1.47396 36.526C0.657986 35.7101 0.25 34.7292 0.25 33.5833V4.41667C0.25 3.27083 0.657986 2.28993 1.47396 1.47396C2.28993 0.657986 3.27083 0.25 4.41667 0.25H23.1667V4.41667H4.41667V33.5833H33.5833V14.8333H37.75V33.5833C37.75 34.7292 37.342 35.7101 36.526 36.526C35.7101 37.342 34.7292 37.75 33.5833 37.75H4.41667ZM29.4167 12.75V8.58333H25.25V4.41667H29.4167V0.25H33.5833V4.41667H37.75V8.58333H33.5833V12.75H29.4167ZM6.5 29.4167H31.5L23.6875 19L17.4375 27.3333L12.75 21.0833L6.5 29.4167Z" fill="black"/>
			</svg>
			',

			'monitor_bar'                         => '<svg width="16" height="16" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0.25 37.75V33.5833L4.41667 29.4167V37.75H0.25ZM8.58333 37.75V25.25L12.75 21.0833V37.75H8.58333ZM16.9167 37.75V21.0833L21.0833 25.3021V37.75H16.9167ZM25.25 37.75V25.3021L29.4167 21.1354V37.75H25.25ZM33.5833 37.75V16.9167L37.75 12.75V37.75H33.5833ZM0.25 26.9687V21.0833L14.8333 6.5L23.1667 14.8333L37.75 0.25V6.13542L23.1667 20.7187L14.8333 12.3854L0.25 26.9687Z" fill="black"/>
			</svg>
			',

			'text_align_bar'                      => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M19.2051 6.4H4.8051C4.3651 6.4 4.0051 6.04 4.0051 5.6C4.0051 5.16 4.3651 4.8 4.8051 4.8H19.2051C19.6451 4.8 20.0051 5.16 20.0051 5.6C20.0051 6.04 19.6451 6.4 19.2051 6.4ZM13.8851 9.88C13.8851 9.44 13.5251 9.08 13.0851 9.08H4.8051C4.3651 9.08 4.0051 9.44 4.0051 9.88C4.0051 10.32 4.3651 10.68 4.8051 10.68H13.0851C13.5251 10.68 13.8851 10.32 13.8851 9.88ZM16.3251 14.14C16.3251 13.7 15.9651 13.34 15.5251 13.34H4.8051C4.3651 13.34 4.0051 13.7 4.0051 14.14C4.0051 14.58 4.3651 14.94 4.8051 14.94H15.5251C15.9651 14.94 16.3251 14.58 16.3251 14.14ZM19.2851 18.4C19.2851 17.96 18.9251 17.6 18.4851 17.6H4.86509C4.42509 17.6 4.06509 17.96 4.06509 18.4C4.06509 18.84 4.42509 19.2 4.86509 19.2H18.4851C18.9251 19.2 19.2851 18.84 19.2851 18.4Z" fill="black"/>
			</svg>
			',

			'bar_chart'                           => '<svg width="16" height="16" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M15 20V11.25H20V20H15ZM7.5 20V0H12.5V20H7.5ZM0 20V6.25H5V20H0Z" fill="black"/>
			</svg>
			',

			'finance_bar'                         => '<svg width="16" height="16" viewBox="0 0 23 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.75 23.25C2.0625 23.25 1.47396 23.0052 0.984375 22.5156C0.494792 22.026 0.25 21.4375 0.25 20.75V0.75H2.75V20.75H22.75V23.25H2.75ZM4 19.5V8.25H9V19.5H4ZM10.25 19.5V2H15.25V19.5H10.25ZM16.5 19.5V13.25H21.5V19.5H16.5Z" fill="black"/>
			</svg>
			',

			'candlestick_chart'                   => '<svg width="16" height="16" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M3.25 20V17.5H0.75V2.5H3.25V0H5.75V2.5H8.25V17.5H5.75V20H3.25ZM3.25 15H5.75V5H3.25V15ZM13.25 20V13.75H10.75V5H13.25V0H15.75V5H18.25V13.75H15.75V20H13.25ZM13.25 11.25H15.75V7.5H13.25V11.25Z" fill="black"/>
			</svg>
			',

			'social_share'                        => '<svg width="16" height="16" viewBox="0 0 22 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M17.1875 15.625C16.0836 15.625 15.069 16.0068 14.2681 16.6453L9.26387 13.5176C9.41206 12.8473 9.41206 12.1527 9.26387 11.4823L14.2681 8.35469C15.069 8.99321 16.0836 9.375 17.1875 9.375C19.7763 9.375 21.875 7.27632 21.875 4.6875C21.875 2.09868 19.7763 0 17.1875 0C14.5987 0 12.5 2.09868 12.5 4.6875C12.5 5.03701 12.5386 5.37744 12.6111 5.70513L7.60693 8.83276C6.80601 8.19429 5.79141 7.8125 4.6875 7.8125C2.09868 7.8125 0 9.91118 0 12.5C0 15.0888 2.09868 17.1875 4.6875 17.1875C5.79141 17.1875 6.80601 16.8057 7.60693 16.1672L12.6111 19.2949C12.5372 19.629 12.4999 19.9703 12.5 20.3125C12.5 22.9013 14.5987 25 17.1875 25C19.7763 25 21.875 22.9013 21.875 20.3125C21.875 17.7237 19.7763 15.625 17.1875 15.625Z" fill="black"/>
            </svg>',

			'share'                               => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.4051 18.1V19.1C17.4051 19.54 17.0251 19.8 16.5851 19.8H3.52509C3.08509 19.8 2.8051 19.56 2.8051 19.1V9.2C2.8051 8.76 3.08509 8.35999 3.52509 8.35999H5.8651C6.3051 8.35999 6.6651 8.71999 6.6651 9.15999C6.6651 9.59999 6.3051 9.95999 5.8651 9.95999H4.4051V18.2H15.8051V18.1C15.8051 17.66 16.1651 17.3 16.6051 17.3C17.0651 17.28 17.4051 17.66 17.4051 18.1ZM20.9651 10.64L16.0051 15.7C15.7651 15.94 15.4251 16 15.1251 15.88C14.8251 15.76 14.6251 15.46 14.6251 15.14V12.96C13.0251 12.92 9.1851 13.08 7.7851 15.54C7.6451 15.8 7.3651 15.96 7.0851 15.96C7.0251 15.96 6.9451 15.96 6.8851 15.94C6.5251 15.84 6.2851 15.52 6.2851 15.16C6.2851 15.02 6.2851 11.94 8.6051 9.64C10.0651 8.16 12.0251 7.35999 14.6251 7.21999V5C14.6251 4.68 14.8251 4.37999 15.1251 4.25999C15.4251 4.13999 15.7851 4.2 16.0051 4.44L20.9851 9.5C21.2851 9.82 21.2851 10.32 20.9651 10.64ZM19.2451 10.06L16.2051 6.98V7.95999C16.2051 8.39999 15.8651 8.75999 15.4051 8.75999C12.9251 8.75999 11.0251 9.42 9.72509 10.74C9.12509 11.34 8.7251 12 8.4651 12.64C10.3451 11.52 12.7251 11.32 14.1851 11.32C14.9451 11.32 15.4451 11.38 15.5051 11.38C15.9051 11.42 16.2051 11.78 16.2051 12.18V13.16L19.2451 10.06Z" fill="black"/>
			</svg>
			',

			'quote'                               => '<svg width="16" height="16" viewBox="0 0 17 30" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M16.8906 21.122C17.0466 16.2762 14.1432 9.31223 3.62016 0.922485C5.99159 3.97315 9.05055 8.71358 10.7855 13.3194C10.0432 13.1061 9.25888 12.9919 8.44791 12.9919C3.78189 12.9919 -0.00066185 16.7744 -0.00066185 21.4404C-0.00066185 26.1065 3.78189 29.889 8.44791 29.889C13.1139 29.889 16.8965 26.1065 16.8965 21.4404C16.8965 21.3338 16.8945 21.2276 16.8906 21.122Z" fill="black"/>
			</svg>
			',

			'code'                                => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.6051 17.8C14.3851 17.8 14.1851 17.72 14.0251 17.56C13.7251 17.24 13.7251 16.74 14.0451 16.42L18.6451 12L14.0451 7.58C13.7251 7.28 13.7251 6.76 14.0251 6.44C14.3251 6.12 14.8451 6.11999 15.1651 6.41999L20.3651 11.42C20.5251 11.58 20.6051 11.78 20.6051 12C20.6051 12.22 20.5251 12.42 20.3651 12.58L15.1651 17.58C15.0051 17.72 14.8051 17.8 14.6051 17.8ZM9.98509 17.56C10.2851 17.24 10.2851 16.74 9.96509 16.42L5.36509 12L9.96509 7.58C10.2851 7.28 10.2851 6.76 9.98509 6.44C9.68509 6.12 9.16509 6.11999 8.84509 6.41999L3.64509 11.42C3.48509 11.58 3.40509 11.78 3.40509 12C3.40509 12.22 3.48509 12.42 3.64509 12.58L8.84509 17.58C9.00509 17.72 9.20509 17.8 9.40509 17.8C9.62509 17.8 9.82509 17.72 9.98509 17.56Z" fill="black"/>
			</svg>
			',

			'hamburger'                           => '<svg width="16" height="16" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0.78125 3.51562H21.0938C21.5252 3.51562 21.875 3.16587 21.875 2.73438V0.78125C21.875 0.349756 21.5252 0 21.0938 0H0.78125C0.349756 0 0 0.349756 0 0.78125V2.73438C0 3.16587 0.349756 3.51562 0.78125 3.51562ZM0.78125 11.3281H21.0938C21.5252 11.3281 21.875 10.9784 21.875 10.5469V8.59375C21.875 8.16226 21.5252 7.8125 21.0938 7.8125H0.78125C0.349756 7.8125 0 8.16226 0 8.59375V10.5469C0 10.9784 0.349756 11.3281 0.78125 11.3281ZM0.78125 19.1406H21.0938C21.5252 19.1406 21.875 18.7909 21.875 18.3594V16.4062C21.875 15.9748 21.5252 15.625 21.0938 15.625H0.78125C0.349756 15.625 0 15.9748 0 16.4062V18.3594C0 18.7909 0.349756 19.1406 0.78125 19.1406Z" fill="black"/>
		  	</svg>',

			'menu_hamburger'                      => '<svg width="16" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0 0H18V2H0V0ZM0 7H18V9H0V7ZM0 14H18V16H0V14Z" fill="black"/>
			</svg>',

			'menu_hamburger_2'                    => '<svg width="16" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0 0H18V2H0V0ZM0 7H12V9H0V7ZM0 14H18V16H0V14Z" fill="black"/>
			</svg>',

			'menu_hamburger_3'                    => '<svg width="16" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0 0H18V2H0V0ZM6 7H18V9H6V7ZM0 14H18V16H0V14Z" fill="black"/>
			</svg>
			',

			'apple_pay'                           => '<svg width="16" height="16" viewBox="0 0 25 11" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M4.56846 1.32031C4.27549 1.66797 3.80674 1.94141 3.33799 1.90234C3.2794 1.43359 3.50987 0.933594 3.7794 0.628906C4.07237 0.273438 4.58409 0.0195312 5.00206 0C5.04893 0.484375 4.85752 0.964844 4.56846 1.32031ZM4.99424 1.99219C4.31456 1.95312 3.73252 2.37891 3.41221 2.37891C3.08409 2.37891 2.5919 2.01172 2.05284 2.02344C1.35362 2.03516 0.705181 2.42969 0.349712 3.05859C-0.384663 4.32031 0.158306 6.18359 0.869244 7.21094C1.2169 7.71875 1.63096 8.27734 2.17784 8.25781C2.69737 8.23828 2.90049 7.92188 3.52549 7.92188C4.1544 7.92188 4.33799 8.25781 4.88487 8.25C5.45127 8.23828 5.80674 7.74219 6.1544 7.23438C6.54893 6.65625 6.71299 6.09766 6.72081 6.06641C6.70909 6.05469 5.62706 5.64063 5.61534 4.39063C5.60362 3.34375 6.47081 2.84766 6.50987 2.81641C6.02159 2.08984 5.25987 2.01172 4.99424 1.99219ZM8.91612 0.578125V8.19141H10.0997V5.58984H11.7364C13.2325 5.58984 14.2794 4.5625 14.2794 3.07812C14.2794 1.59375 13.2481 0.578125 11.7755 0.578125H8.91612ZM10.0997 1.57422H11.463C12.4903 1.57422 13.0763 2.12109 13.0763 3.08203C13.0763 4.04297 12.4903 4.59766 11.4591 4.59766H10.0997V1.57422ZM16.4356 8.25C17.1778 8.25 17.8653 7.875 18.1778 7.27734H18.2013V8.19141H19.295V4.40234C19.295 3.30469 18.4161 2.59375 17.0646 2.59375C15.8106 2.59375 14.881 3.3125 14.8458 4.29688H15.9122C16.0021 3.82812 16.4356 3.51953 17.0294 3.51953C17.7521 3.51953 18.1583 3.85547 18.1583 4.47656V4.89844L16.6817 4.98828C15.3106 5.07031 14.5685 5.63281 14.5685 6.60938C14.5724 7.59375 15.338 8.25 16.4356 8.25ZM16.756 7.34766C16.1271 7.34766 15.7247 7.04297 15.7247 6.58203C15.7247 6.10156 16.1114 5.82422 16.8497 5.78125L18.1622 5.69922V6.12891C18.1622 6.83984 17.5567 7.34766 16.756 7.34766ZM20.7599 10.2617C21.9122 10.2617 22.4552 9.82031 22.9278 8.48828L25.0021 2.66797H23.7989L22.4083 7.16406H22.3849L20.9942 2.66797H19.7599L21.7599 8.21094L21.6505 8.54688C21.4708 9.11719 21.1778 9.33984 20.6544 9.33984C20.5606 9.33984 20.381 9.32812 20.3067 9.32031V10.2344C20.3771 10.25 20.67 10.2617 20.7599 10.2617Z" fill="black"/>
            </svg>',

			'add_photo_cam'                       => '<svg width="16" height="16" viewBox="0 0 29 26" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M3.24512 25.2506C2.55762 25.2506 1.96908 25.0058 1.47949 24.5162C0.989909 24.0267 0.745117 23.4381 0.745117 22.7506V7.75061C0.745117 7.06311 0.989909 6.47457 1.47949 5.98499C1.96908 5.4954 2.55762 5.25061 3.24512 5.25061H7.18262L9.49512 2.75061H16.9951V5.25061H10.5889L8.30762 7.75061H3.24512V22.7506H23.2451V11.5006H25.7451V22.7506C25.7451 23.4381 25.5003 24.0267 25.0107 24.5162C24.5212 25.0058 23.9326 25.2506 23.2451 25.2506H3.24512ZM23.2451 7.75061V5.25061H20.7451V2.75061H23.2451V0.25061H25.7451V2.75061H28.2451V5.25061H25.7451V7.75061H23.2451ZM13.2451 20.8756C14.8076 20.8756 16.1357 20.3287 17.2295 19.235C18.3232 18.1412 18.8701 16.8131 18.8701 15.2506C18.8701 13.6881 18.3232 12.36 17.2295 11.2662C16.1357 10.1725 14.8076 9.62561 13.2451 9.62561C11.6826 9.62561 10.3545 10.1725 9.26074 11.2662C8.16699 12.36 7.62012 13.6881 7.62012 15.2506C7.62012 16.8131 8.16699 18.1412 9.26074 19.235C10.3545 20.3287 11.6826 20.8756 13.2451 20.8756ZM13.2451 18.3756C12.3701 18.3756 11.6305 18.0735 11.0264 17.4694C10.4222 16.8652 10.1201 16.1256 10.1201 15.2506C10.1201 14.3756 10.4222 13.636 11.0264 13.0319C11.6305 12.4277 12.3701 12.1256 13.2451 12.1256C14.1201 12.1256 14.8597 12.4277 15.4639 13.0319C16.068 13.636 16.3701 14.3756 16.3701 15.2506C16.3701 16.1256 16.068 16.8652 15.4639 17.4694C14.8597 18.0735 14.1201 18.3756 13.2451 18.3756Z" fill="black"/>
			</svg>
			',

			'toll'                                => '<svg width="16" height="16" viewBox="0 0 28 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.75 20C14.9583 20 12.5938 19.0312 10.6562 17.0938C8.71875 15.1562 7.75 12.7917 7.75 10C7.75 7.20833 8.71875 4.84375 10.6562 2.90625C12.5938 0.96875 14.9583 0 17.75 0C20.5417 0 22.9063 0.96875 24.8438 2.90625C26.7813 4.84375 27.75 7.20833 27.75 10C27.75 12.7917 26.7813 15.1562 24.8438 17.0938C22.9063 19.0312 20.5417 20 17.75 20ZM7.75 19.6875C5.54167 19.1042 3.73958 17.9167 2.34375 16.125C0.947917 14.3333 0.25 12.2917 0.25 10C0.25 7.70833 0.947917 5.66667 2.34375 3.875C3.73958 2.08333 5.54167 0.895833 7.75 0.3125V2.9375C6.25 3.45833 5.04167 4.36458 4.125 5.65625C3.20833 6.94792 2.75 8.39583 2.75 10C2.75 11.6042 3.20833 13.0521 4.125 14.3438C5.04167 15.6354 6.25 16.5417 7.75 17.0625V19.6875ZM17.75 17.5C19.8333 17.5 21.6042 16.7708 23.0625 15.3125C24.5208 13.8542 25.25 12.0833 25.25 10C25.25 7.91667 24.5208 6.14583 23.0625 4.6875C21.6042 3.22917 19.8333 2.5 17.75 2.5C15.6667 2.5 13.8958 3.22917 12.4375 4.6875C10.9792 6.14583 10.25 7.91667 10.25 10C10.25 12.0833 10.9792 13.8542 12.4375 15.3125C13.8958 16.7708 15.6667 17.5 17.75 17.5Z" fill="black"/>
			</svg>
			',

			'heart'                               => '<svg width="16" height="16" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M22.5738 1.49576C19.8981 -0.784512 15.9186 -0.374356 13.4625 2.15982L12.5006 3.15104L11.5387 2.15982C9.08751 -0.374356 5.10314 -0.784512 2.42736 1.49576C-0.639049 4.11295 -0.800182 8.81021 1.94396 11.6471L11.3922 21.403C12.0026 22.0329 12.9938 22.0329 13.6041 21.403L23.0524 11.6471C25.8014 8.81021 25.6402 4.11295 22.5738 1.49576Z" fill="black"/>
            </svg>',

			'heart_light'                         => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M8.00068 3.01933C8.76254 2.33777 9.75642 1.97375 10.7783 2.00201C11.8001 2.03028 12.7723 2.44869 13.4953 3.17133C14.2176 3.89346 14.6362 4.86449 14.6655 5.88539C14.6947 6.90628 14.3324 7.8997 13.6527 8.662L7.99935 14.3233L2.34735 8.662C1.66685 7.8993 1.30415 6.90503 1.33371 5.88332C1.36326 4.8616 1.78283 3.88996 2.50628 3.16788C3.22972 2.4458 4.20215 2.02807 5.22392 2.00044C6.24569 1.97281 7.23927 2.33739 8.00068 3.01933ZM12.5513 4.11333C12.0696 3.63237 11.4221 3.35388 10.7416 3.33492C10.0611 3.31595 9.39916 3.55795 8.89135 4.01133L8.00135 4.81L7.11068 4.012C6.60513 3.55992 5.94632 3.31746 5.26833 3.33394C4.59033 3.35043 3.94408 3.62462 3.4611 4.10073C2.97811 4.57683 2.69467 5.21908 2.66846 5.89677C2.64226 6.57446 2.87524 7.23668 3.32002 7.74866L8.00002 12.436L12.68 7.74933C13.1229 7.2396 13.3559 6.58082 13.3321 5.90598C13.3082 5.23113 13.0292 4.59048 12.5513 4.11333Z" fill="#000"/>
			</svg>
			',

			'heart_plus'                          => '<svg width="16" height="16" viewBox="0 0 14 13" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.6667 7.33334V9.33335H13.6667V10.6667H11.6667V12.6667H10.3333V10.6667H8.33335V9.33335H10.3333V7.33334H11.6667ZM12.4953 1.17134C13.1832 1.85898 13.5969 2.77366 13.6591 3.74425C13.7213 4.71485 13.4277 5.67486 12.8333 6.44468C12.0771 6.05458 11.2161 5.91583 10.3756 6.04859C9.53504 6.18135 8.75875 6.57871 8.15953 7.18291C7.56031 7.78711 7.1694 8.56667 7.0436 9.40827C6.9178 10.2499 7.06367 11.1097 7.46002 11.8627L7.00002 12.3233L1.34735 6.66201C0.666852 5.89932 0.30415 4.90505 0.333705 3.88333C0.363261 2.86162 0.782831 1.88998 1.50628 1.1679C2.22972 0.445816 3.20215 0.0280814 4.22392 0.000455617C5.24569 -0.0271702 6.23927 0.337409 7.00068 1.01934C7.76254 0.337782 8.75642 -0.0262383 9.77826 0.00202902C10.8001 0.0302963 11.7723 0.448706 12.4953 1.17134Z" fill="black"/>
			</svg>
			',

			'heart_plus_light'                    => '<svg width="16" height="16" viewBox="0 0 14 13" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.6667 7.33334V9.33335H13.6667V10.6667H11.6667V12.6667H10.3333V10.6667H8.33334V9.33335H10.3333V7.33334H11.6667ZM12.4953 1.17134C13.2175 1.89335 13.6361 2.8642 13.6655 3.88494C13.6949 4.90568 13.3328 5.899 12.6533 6.66134L11.7067 5.71601C12.5933 4.70001 12.5467 3.10668 11.5513 2.11334C11.0696 1.63239 10.4221 1.3539 9.74162 1.33493C9.06113 1.31597 8.39915 1.55797 7.89134 2.01134L7.00134 2.81001L6.11068 2.01201C5.60512 1.55994 4.94632 1.31747 4.26832 1.33396C3.59032 1.35044 2.94408 1.62464 2.46109 2.10074C1.97811 2.57685 1.69467 3.21909 1.66846 3.89678C1.64225 4.57447 1.87524 5.23669 2.32001 5.74868L7.94134 11.3793L7.00001 12.3233L1.34668 6.66201C0.666181 5.89932 0.303479 4.90505 0.333034 3.88333C0.362589 2.86162 0.78216 1.88998 1.50561 1.1679C2.22905 0.445816 3.20148 0.0280814 4.22325 0.000455617C5.24502 -0.0271702 6.2386 0.337409 7.00001 1.01934C7.76187 0.337782 8.75575 -0.0262383 9.77759 0.00202902C10.7994 0.0302963 11.7723 0.448706 12.4953 1.17134Z" fill="black"/>
			</svg>
			',

			'heart_like'                          => '
			<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.1451 7.2C19.3251 5.38 17.6051 4.2 15.7451 4.2C13.8851 4.2 12.6851 5.02 11.9851 5.9C11.2851 5.02 10.0851 4.2 8.2251 4.2C6.3651 4.2 4.6451 5.38 3.8251 7.2C2.9851 9.1 3.3451 11.2 4.8051 12.84C8.3051 16.78 11.4051 19.56 11.4451 19.58C11.6051 19.72 11.7851 19.78 11.9851 19.78C12.1851 19.78 12.3651 19.72 12.5251 19.58C12.5651 19.56 15.6451 16.76 19.1651 12.84C20.6451 11.2 21.0051 9.1 20.1451 7.2ZM17.9851 11.78C15.3851 14.68 13.0251 16.96 12.0051 17.9C10.9851 16.94 8.6251 14.68 6.0251 11.76C4.9851 10.58 4.7251 9.15999 5.3051 7.81999C5.8451 6.59999 7.0251 5.76001 8.2451 5.76001C10.6251 5.76001 11.1651 7.54001 11.2251 7.76001C11.3051 8.12001 11.6251 8.36001 11.9851 8.36001C12.3451 8.36001 12.6651 8.10001 12.7651 7.76001C12.8251 7.56001 13.3651 5.76001 15.7451 5.76001C16.9451 5.76001 18.1251 6.57999 18.6851 7.81999C19.2851 9.17999 19.0251 10.6 17.9851 11.78ZM17.7851 9.46001C17.8051 9.84001 17.5251 10.18 17.1251 10.2C17.1051 10.2 17.0851 10.2 17.0851 10.2C16.7251 10.2 16.4051 9.91999 16.3851 9.53999C16.3051 8.39999 15.5651 8.22 15.4251 8.2C15.0451 8.14 14.7851 7.79999 14.8251 7.41999C14.8851 7.03999 15.2451 6.77999 15.6251 6.81999C16.3251 6.91999 17.6651 7.60001 17.7851 9.46001ZM16.8251 10.62C16.9851 10.78 17.0651 10.98 17.0651 11.18C17.0651 11.4 16.9851 11.6 16.8251 11.74C16.6851 11.9 16.4651 11.98 16.2651 11.98C16.0651 11.98 15.8451 11.9 15.7051 11.74C15.5451 11.6 15.4651 11.38 15.4651 11.18C15.4651 10.98 15.5451 10.76 15.7051 10.62C15.8451 10.48 16.0651 10.38 16.2651 10.38C16.4651 10.4 16.6651 10.48 16.8251 10.62Z" fill="black"/>
			</svg>
			',

			'dashboard_customize'                 => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1.19228 9.43744C0.872177 9.43744 0.603854 9.32917 0.387312 9.11263C0.170771 8.89608 0.0625 8.62776 0.0625 8.30766V1.19228C0.0625 0.872178 0.170771 0.603855 0.387312 0.387314C0.603854 0.170772 0.872177 0.0625 1.19228 0.0625H8.30766C8.62776 0.0625 8.89608 0.170772 9.11263 0.387314C9.32917 0.603855 9.43744 0.872178 9.43744 1.19228V8.30766C9.43744 8.62776 9.32917 8.89608 9.11263 9.11263C8.89608 9.32917 8.62776 9.43744 8.30766 9.43744H1.19228ZM13.6923 9.43744C13.3722 9.43744 13.1039 9.32917 12.8873 9.11263C12.6708 8.89608 12.5625 8.62776 12.5625 8.30766V1.19228C12.5625 0.872178 12.6708 0.603855 12.8873 0.387314C13.1039 0.170772 13.3722 0.0625 13.6923 0.0625H20.8077C21.1278 0.0625 21.3961 0.170772 21.6126 0.387314C21.8292 0.603855 21.9374 0.872178 21.9374 1.19228V8.30766C21.9374 8.62776 21.8292 8.89608 21.6126 9.11263C21.3961 9.32917 21.1278 9.43744 20.8077 9.43744H13.6923ZM1.19228 21.9374C0.872177 21.9374 0.603854 21.8292 0.387312 21.6126C0.170771 21.3961 0.0625 21.1278 0.0625 20.8077V13.6923C0.0625 13.3722 0.170771 13.1039 0.387312 12.8873C0.603854 12.6708 0.872177 12.5625 1.19228 12.5625H8.30766C8.62776 12.5625 8.89608 12.6708 9.11263 12.8873C9.32917 13.1039 9.43744 13.3722 9.43744 13.6923V20.8077C9.43744 21.1278 9.32917 21.3961 9.11263 21.6126C8.89608 21.8292 8.62776 21.9374 8.30766 21.9374H1.19228ZM17.2496 21.9374C16.9838 21.9374 16.7612 21.8476 16.5817 21.6679C16.4022 21.4882 16.3125 21.2656 16.3125 21V18.1874H13.4687C13.2107 18.1874 12.9952 18.0976 12.8221 17.9178C12.649 17.738 12.5625 17.5153 12.5625 17.2496C12.5625 16.9838 12.6523 16.7612 12.832 16.5817C13.0117 16.4022 13.2343 16.3125 13.5 16.3125H16.3125V13.4687C16.3125 13.2107 16.4024 12.9952 16.5821 12.8221C16.7619 12.649 16.9846 12.5625 17.2504 12.5625C17.5161 12.5625 17.7387 12.6523 17.9182 12.832C18.0977 13.0117 18.1874 13.2343 18.1874 13.5V16.3125H21.0312C21.2892 16.3125 21.5048 16.4024 21.6778 16.5821C21.8509 16.7619 21.9374 16.9846 21.9374 17.2504C21.9374 17.5161 21.8476 17.7387 21.6679 17.9182C21.4882 18.0977 21.2656 18.1874 21 18.1874H18.1874V21.0312C18.1874 21.2892 18.0976 21.5048 17.9178 21.6778C17.738 21.8509 17.5153 21.9374 17.2496 21.9374ZM14.4374 1.93744V7.5625H20.0625V1.93744H14.4374ZM1.93744 1.93744V7.5625H7.5625V1.93744H1.93744ZM1.93744 14.4374V20.0625H7.5625V14.4374H1.93744Z" fill="black"/>
			</svg>
			',

			'codepen'                             => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.5256 7.79801L13.0999 0.180818C12.7099 -0.0591726 12.2937 -0.0613699 11.9001 0.180818L0.474316 7.79801C0.181348 7.99327 0 8.3421 0 8.69083V16.308C0 16.6567 0.181348 17.0055 0.474365 17.2008L11.9001 24.8191C12.2901 25.0591 12.7063 25.0613 13.0999 24.8191L24.5257 17.2008C24.8187 17.0056 25 16.6567 25 16.308V8.69083C25 8.3421 24.8187 7.99327 24.5256 7.79801ZM13.5742 3.08253L21.9866 8.69083L18.2338 11.202L13.5742 8.09093V3.08253ZM11.4258 3.08253V8.09093L6.76616 11.202L3.01338 8.69083L11.4258 3.08253ZM2.14844 10.6998L4.84097 12.4994L2.14844 14.2991V10.6998ZM11.4258 21.9163L3.01338 16.308L6.76616 13.7968L11.4258 16.9079V21.9163ZM12.5 15.0385L8.70532 12.4994L12.5 9.96036L16.2947 12.4994L12.5 15.0385ZM13.5742 21.9163V16.9079L18.2338 13.7968L21.9866 16.308L13.5742 21.9163ZM22.8516 14.2991L20.159 12.4994L22.8516 10.6998V14.2991Z" fill="black"/>
            </svg>',

			'deviantart'                          => '<svg width="16" height="16" viewBox="0 0 16 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M15.625 4.5459L10.8301 13.291L11.1914 13.7549H15.625V19.9902H7.76856L7.10938 20.4395L4.97559 24.541C4.96094 24.541 4.55566 24.9609 4.52637 24.9902H0V20.4395L4.55078 11.6797L4.18945 11.2305H0V5H7.61719L8.27637 4.55078L10.4102 0.449219C10.4248 0.449219 10.8301 0.0292969 10.8594 0H15.625V4.5459Z" fill="black"/>
            </svg>',

			'cog'                                 => '<svg width="16" height="16" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M22.8885 15.0196L20.8084 13.8184C21.0184 12.6856 21.0184 11.5235 20.8084 10.3907L22.8885 9.1895C23.1277 9.05278 23.2352 8.76958 23.157 8.50591C22.615 6.76762 21.6922 5.19536 20.4861 3.88676C20.3006 3.68657 19.9979 3.63774 19.7635 3.77446L17.6834 4.97563C16.8094 4.22368 15.8035 3.64262 14.7147 3.26176V0.864303C14.7147 0.590866 14.5242 0.351608 14.2557 0.293014C12.4637 -0.107376 10.6277 -0.0878449 8.92364 0.293014C8.65508 0.351608 8.46465 0.590866 8.46465 0.864303V3.26665C7.38067 3.65239 6.37481 4.23344 5.4959 4.98051L3.42071 3.77934C3.18145 3.64262 2.8836 3.68657 2.69805 3.89165C1.492 5.19536 0.569146 6.76762 0.0271543 8.51079C-0.0558535 8.77446 0.0564511 9.05766 0.295709 9.19438L2.37579 10.3956C2.16583 11.5284 2.16583 12.6905 2.37579 13.8233L0.295709 15.0245C0.0564511 15.1612 -0.0509707 15.4444 0.0271543 15.7081C0.569146 17.4463 1.492 19.0186 2.69805 20.3272C2.8836 20.5274 3.18633 20.5762 3.42071 20.4395L5.50079 19.2383C6.37481 19.9903 7.38067 20.5713 8.46954 20.9522V23.3545C8.46954 23.628 8.65997 23.8672 8.92852 23.9258C10.7205 24.3262 12.5565 24.3067 14.2606 23.9258C14.5291 23.8672 14.7195 23.628 14.7195 23.3545V20.9522C15.8035 20.5665 16.8094 19.9854 17.6883 19.2383L19.7684 20.4395C20.0076 20.5762 20.3055 20.5323 20.491 20.3272C21.6971 19.0235 22.6199 17.4512 23.1619 15.7081C23.2352 15.4395 23.1277 15.1563 22.8885 15.0196ZM11.5897 16.0108C9.43633 16.0108 7.6834 14.2579 7.6834 12.1045C7.6834 9.95122 9.43633 8.19829 11.5897 8.19829C13.743 8.19829 15.4959 9.95122 15.4959 12.1045C15.4959 14.2579 13.743 16.0108 11.5897 16.0108Z" fill="black"/>
            </svg>',

			'equalizer_setting'                   => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M19.605 12.56V20.4C19.605 20.84 19.245 21.2 18.805 21.2C18.365 21.2 18.005 20.84 18.005 20.4V12.56C18.005 12.12 18.365 11.76 18.805 11.76C19.245 11.76 19.605 12.12 19.605 12.56ZM18.805 5.07997C19.245 5.07997 19.605 4.71997 19.605 4.27997V3.59999C19.605 3.15999 19.245 2.79999 18.805 2.79999C18.365 2.79999 18.005 3.15999 18.005 3.59999V4.27997C18.005 4.71997 18.365 5.07997 18.805 5.07997ZM7.585 12C7.585 13.32 6.505 14.4 5.205 14.4C3.905 14.4 2.82499 13.32 2.82499 12C2.82499 10.68 3.905 9.59999 5.205 9.59999C6.505 9.59999 7.585 10.68 7.585 12ZM5.985 12C5.985 11.56 5.625 11.2 5.205 11.2C4.785 11.2 4.42499 11.56 4.42499 12C4.42499 12.44 4.785 12.8 5.205 12.8C5.625 12.8 5.985 12.44 5.985 12ZM14.385 15.94C14.385 17.26 13.305 18.34 12.005 18.34C10.705 18.34 9.62499 17.26 9.62499 15.94C9.62499 14.62 10.705 13.54 12.005 13.54C13.305 13.54 14.385 14.6 14.385 15.94ZM12.785 15.94C12.785 15.5 12.425 15.14 12.005 15.14C11.585 15.14 11.225 15.5 11.225 15.94C11.225 16.38 11.585 16.74 12.005 16.74C12.425 16.74 12.785 16.38 12.785 15.94ZM21.205 8.52001C21.205 9.84001 20.125 10.92 18.825 10.92C17.525 10.92 16.445 9.84001 16.445 8.52001C16.445 7.20001 17.525 6.12001 18.825 6.12001C20.125 6.12001 21.205 7.20001 21.205 8.52001ZM19.605 8.52001C19.605 8.08001 19.245 7.72001 18.825 7.72001C18.405 7.72001 18.045 8.08001 18.045 8.52001C18.045 8.96001 18.405 9.32001 18.825 9.32001C19.245 9.32001 19.605 8.98001 19.605 8.52001ZM12.005 19.14C11.565 19.14 11.205 19.5 11.205 19.94V20.4C11.205 20.84 11.565 21.2 12.005 21.2C12.445 21.2 12.805 20.84 12.805 20.4V19.94C12.805 19.5 12.445 19.14 12.005 19.14ZM12.005 12.54C12.445 12.54 12.805 12.18 12.805 11.74V3.59999C12.805 3.15999 12.445 2.79999 12.005 2.79999C11.565 2.79999 11.205 3.15999 11.205 3.59999V11.74C11.205 12.18 11.565 12.54 12.005 12.54ZM5.205 15.46C4.765 15.46 4.405 15.82 4.405 16.26V20.4C4.405 20.84 4.765 21.2 5.205 21.2C5.645 21.2 6.005 20.84 6.005 20.4V16.26C6.005 15.82 5.645 15.46 5.205 15.46ZM5.205 8.57997C5.645 8.57997 6.005 8.21997 6.005 7.77997V3.59999C6.005 3.15999 5.645 2.79999 5.205 2.79999C4.765 2.79999 4.405 3.15999 4.405 3.59999V7.77997C4.405 8.21997 4.765 8.57997 5.205 8.57997Z" fill="black"/>
			</svg>
			',

			'equalizer_setting_two'               => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M12.2451 15.4C12.2451 15.84 11.8851 16.2 11.4451 16.2H3.6051C3.1651 16.2 2.8051 15.84 2.8051 15.4C2.8051 14.96 3.1651 14.6 3.6051 14.6H11.4451C11.8851 14.6 12.2451 14.96 12.2451 15.4ZM20.4051 14.6H19.7251C19.2851 14.6 18.9251 14.96 18.9251 15.4C18.9251 15.84 19.2851 16.2 19.7251 16.2H20.4051C20.8451 16.2 21.2051 15.84 21.2051 15.4C21.2051 14.96 20.8451 14.6 20.4051 14.6ZM5.66511 8.57999C5.66511 7.25999 6.74511 6.20001 8.06511 6.20001C9.38511 6.20001 10.4651 7.27999 10.4651 8.57999C10.4651 9.87999 9.38511 10.96 8.06511 10.96C6.74511 10.96 5.66511 9.89999 5.66511 8.57999ZM7.26511 8.57999C7.26511 9.01999 7.62511 9.36002 8.06511 9.36002C8.50511 9.36002 8.86511 8.99999 8.86511 8.57999C8.86511 8.15999 8.50511 7.80001 8.06511 7.80001C7.62511 7.80001 7.26511 8.15999 7.26511 8.57999ZM17.8851 15.42C17.8851 16.74 16.8051 17.8 15.4851 17.8C14.1651 17.8 13.0851 16.72 13.0851 15.42C13.0851 14.12 14.1651 13.04 15.4851 13.04C16.8051 13.02 17.8851 14.1 17.8851 15.42ZM16.2851 15.42C16.2851 14.98 15.9251 14.64 15.4851 14.64C15.0451 14.64 14.6851 15 14.6851 15.42C14.6851 15.84 15.0451 16.2 15.4851 16.2C15.9251 16.2 16.2851 15.84 16.2851 15.42ZM3.6051 9.40001H4.06511C4.50511 9.40001 4.86511 9.04001 4.86511 8.60001C4.86511 8.16001 4.50511 7.80001 4.06511 7.80001H3.6051C3.1651 7.80001 2.8051 8.16001 2.8051 8.60001C2.8051 9.04001 3.1651 9.40001 3.6051 9.40001ZM21.2051 8.60001C21.2051 8.16001 20.8451 7.80001 20.4051 7.80001H12.2651C11.8251 7.80001 11.4651 8.16001 11.4651 8.60001C11.4651 9.04001 11.8251 9.40001 12.2651 9.40001H20.4051C20.8451 9.40001 21.2051 9.04001 21.2051 8.60001Z" fill="black"/>
			</svg>
			',

			'laptop'                              => '<svg width="16" height="16" viewBox="0 0 25 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.375 16.25H14.9039C14.875 17.0238 14.3293 17.5 13.625 17.5H11.25C10.5199 17.5 9.96016 16.8176 9.96992 16.25H0.625C0.28125 16.25 0 16.5312 0 16.875V17.5C0 18.875 1.125 20 2.5 20H22.5C23.875 20 25 18.875 25 17.5V16.875C25 16.5312 24.7188 16.25 24.375 16.25ZM22.5 1.875C22.5 0.84375 21.6562 0 20.625 0H4.375C3.34375 0 2.5 0.84375 2.5 1.875V15H22.5V1.875ZM20 12.5H5V2.5H20V12.5Z" fill="black"/>
            </svg>',

			'laptop_code'                         => '<svg width="16" height="16" viewBox="0 0 25 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M9.96211 10.2207C10.2063 10.4648 10.602 10.4648 10.8461 10.2207L11.2879 9.77891C11.532 9.53477 11.532 9.13906 11.2879 8.89492L9.89258 7.5L11.2875 6.10469C11.5316 5.86055 11.5316 5.46484 11.2875 5.2207L10.8457 4.77891C10.6016 4.53477 10.2059 4.53477 9.96172 4.77891L7.68281 7.05781C7.43867 7.30195 7.43867 7.69766 7.68281 7.9418L9.96211 10.2207ZM13.7125 9.7793L14.1543 10.2211C14.3984 10.4652 14.7941 10.4652 15.0383 10.2211L17.3172 7.94219C17.5613 7.69805 17.5613 7.30234 17.3172 7.0582L15.0383 4.7793C14.7941 4.53516 14.3984 4.53516 14.1543 4.7793L13.7125 5.22109C13.4684 5.46523 13.4684 5.86094 13.7125 6.10508L15.1074 7.5L13.7125 8.89531C13.4684 9.13945 13.4684 9.53516 13.7125 9.7793ZM24.375 16.25H14.9039C14.875 17.0238 14.3293 17.5 13.625 17.5H11.25C10.5199 17.5 9.96016 16.8176 9.96992 16.25H0.625C0.28125 16.25 0 16.5312 0 16.875V17.5C0 18.875 1.125 20 2.5 20H22.5C23.875 20 25 18.875 25 17.5V16.875C25 16.5312 24.7188 16.25 24.375 16.25ZM22.5 1.875C22.5 0.84375 21.6562 0 20.625 0H4.375C3.34375 0 2.5 0.84375 2.5 1.875V15H22.5V1.875ZM20 12.5H5V2.5H20V12.5Z" fill="black"/>
            </svg>',

			'trending'                            => '<svg width="16" height="16" viewBox="0 0 25 15" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M1.75 15L0 13.25L9.25 3.9375L14.25 8.9375L20.75 2.5H17.5V0H25V7.5H22.5V4.25L14.25 12.5L9.25 7.5L1.75 15Z" fill="black"/>
            </svg>',

			'trending_line_chart'                 => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M4.0051 19.2C3.8251 19.2 3.6451 19.16 3.4851 19.06C3.0051 18.78 2.86509 18.16 3.14509 17.68L5.5851 13.58C5.7651 13.3 6.0651 13.1 6.4051 13.1C6.7451 13.08 7.06511 13.24 7.26511 13.52L8.3051 14.96L10.5051 11.2C10.6651 10.92 10.9851 10.72 11.3051 10.7C11.6451 10.68 11.9651 10.84 12.1651 11.1L14.0851 13.68L19.1451 5.27999C19.4251 4.79999 20.0451 4.65998 20.5251 4.93998C21.0051 5.21998 21.1451 5.83998 20.8651 6.31998L15.0451 16C14.8651 16.28 14.5651 16.46 14.2451 16.48C13.9051 16.5 13.5851 16.34 13.3851 16.08L11.4651 13.52L9.24509 17.3C9.06509 17.6 8.76509 17.78 8.42509 17.8C8.08509 17.82 7.76511 17.66 7.56511 17.38L6.52509 15.94L4.86511 18.72C4.68511 19.02 4.3451 19.2 4.0051 19.2Z" fill="black"/>
			</svg>
			',

			'star'                                => '<svg width="16" height="16" viewBox="0 0 24 23" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M10.3646 0.77312L7.5304 6.51965L1.18926 7.44413C0.052104 7.60906 -0.403625 9.01097 0.421028 9.81392L5.0087 14.2844L3.92363 20.5995C3.72832 21.741 4.93058 22.596 5.93752 22.0622L11.6103 19.0804L17.283 22.0622C18.29 22.5917 19.4922 21.741 19.2969 20.5995L18.2118 14.2844L22.7995 9.81392C23.6242 9.01097 23.1684 7.60906 22.0313 7.44413L15.6901 6.51965L12.8559 0.77312C12.3481 -0.251186 10.8768 -0.264207 10.3646 0.77312Z" fill="black"/>
            </svg>',

			'award'                               => '<svg width="16" height="16" viewBox="0 0 19 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M4.74228 17.7069C4.31797 17.2826 4.53916 17.4022 3.51572 17.1283C3.05137 17.0038 2.64316 16.7646 2.27402 16.4779L0.0586902 21.9096C-0.155665 22.4355 0.244725 23.0067 0.812108 22.9853L3.38486 22.8871L5.15439 24.7563C5.54502 25.1684 6.23057 25.0399 6.44492 24.5141L8.98642 18.2826C8.45713 18.5775 7.86972 18.7504 7.2623 18.7504C6.31015 18.7504 5.41562 18.3798 4.74228 17.7069ZM18.6915 21.9096L16.4762 16.4779C16.107 16.765 15.6988 17.0038 15.2345 17.1283C14.2057 17.4037 14.4312 17.2836 14.0079 17.7069C13.3346 18.3798 12.4395 18.7504 11.4874 18.7504C10.88 18.7504 10.2926 18.5771 9.76328 18.2826L12.3048 24.5141C12.5191 25.0399 13.2052 25.1684 13.5953 24.7563L15.3653 22.8871L17.9381 22.9853C18.5055 23.0067 18.9059 22.435 18.6915 21.9096ZM12.8419 16.602C13.588 15.8427 13.6734 15.9081 14.7359 15.6186C15.4142 15.4335 15.9444 14.8939 16.1261 14.2035C16.4913 12.8168 16.3966 12.9843 17.3932 11.9696C17.8897 11.4643 18.0836 10.7274 17.902 10.037C17.5372 8.65127 17.5367 8.84463 17.902 7.45742C18.0836 6.76699 17.8897 6.03018 17.3932 5.52481C16.3966 4.51016 16.4913 4.67715 16.1261 3.29092C15.9444 2.60049 15.4142 2.06094 14.7359 1.87588C13.3746 1.5043 13.5387 1.60147 12.5411 0.586331C12.0445 0.0809601 11.3204 -0.116794 10.6422 0.0682648C9.28135 0.439359 9.47129 0.439847 8.10801 0.0682648C7.42978 -0.116794 6.70566 0.0804719 6.20908 0.586331C5.2125 1.60098 5.37656 1.5043 4.01474 1.87588C3.33652 2.06094 2.80625 2.60049 2.62461 3.29092C2.25986 4.67715 2.3541 4.51016 1.35752 5.52481C0.860936 6.03018 0.6666 6.76699 0.848729 7.45742C1.21348 8.84219 1.21396 8.64883 0.848729 10.0365C0.667089 10.727 0.860936 11.4638 1.35752 11.9696C2.3541 12.9843 2.25937 12.8168 2.62461 14.2035C2.80625 14.8939 3.33652 15.4335 4.01474 15.6186C5.10752 15.9164 5.18906 15.8695 5.9083 16.602C6.5543 17.2597 7.56064 17.3773 8.33701 16.8861C8.64747 16.689 9.00761 16.5844 9.37534 16.5844C9.74308 16.5844 10.1032 16.689 10.4137 16.8861C11.1895 17.3773 12.1959 17.2597 12.8419 16.602ZM4.76865 8.59219C4.76865 6.00284 6.83115 3.90371 9.3751 3.90371C11.919 3.90371 13.9815 6.00284 13.9815 8.59219C13.9815 11.1815 11.919 13.2807 9.3751 13.2807C6.83115 13.2807 4.76865 11.1815 4.76865 8.59219Z" fill="black"/>
            </svg>',

			'rocket'                              => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.6578 0.932617C24.6264 0.786498 24.5535 0.65255 24.4479 0.546873C24.3422 0.441197 24.2082 0.368289 24.0621 0.336914C22.4899 0 21.2599 0 20.0343 0C14.9952 0 11.9728 2.69531 9.71739 6.25H4.6295C4.19498 6.25037 3.76912 6.37152 3.39948 6.59993C3.02983 6.82834 2.73096 7.15501 2.53624 7.54346L0.123155 12.3677C0.0340395 12.5464 -0.0079282 12.7449 0.00123432 12.9444C0.0103968 13.1439 0.0703856 13.3377 0.175507 13.5075C0.280629 13.6773 0.427396 13.8174 0.60188 13.9145C0.776363 14.0117 0.972774 14.0626 1.17247 14.0625H6.23937L5.1422 15.1597C4.84924 15.4527 4.68467 15.8501 4.68467 16.2644C4.68467 16.6787 4.84924 17.0761 5.1422 17.3691L7.62755 19.855C7.77264 20.0001 7.94491 20.1152 8.1345 20.1938C8.3241 20.2723 8.52731 20.3128 8.73253 20.3128C8.93775 20.3128 9.14096 20.2723 9.33055 20.1938C9.52015 20.1152 9.69241 20.0001 9.83751 19.855L10.9347 18.7578V23.8281C10.9346 24.0278 10.9856 24.2241 11.0827 24.3985C11.1798 24.5729 11.3198 24.7197 11.4895 24.8248C11.6593 24.9299 11.853 24.9899 12.0524 24.9991C12.2519 25.0083 12.4503 24.9664 12.629 24.8774L17.4483 22.4658C17.8374 22.2715 18.1646 21.9725 18.3932 21.6025C18.6218 21.2324 18.7427 20.806 18.7423 20.3711V15.2729C22.2867 13.0122 24.9923 9.97998 24.9923 4.96582C24.9972 3.73535 24.9972 2.50488 24.6578 0.932617ZM18.7472 8.20312C18.3609 8.20312 17.9833 8.08858 17.6621 7.87396C17.3409 7.65935 17.0906 7.35432 16.9427 6.99743C16.7949 6.64054 16.7562 6.24783 16.8316 5.86896C16.9069 5.4901 17.093 5.14208 17.3661 4.86893C17.6393 4.59578 17.9873 4.40977 18.3661 4.3344C18.745 4.25904 19.1377 4.29772 19.4946 4.44555C19.8515 4.59338 20.1565 4.84371 20.3711 5.1649C20.5858 5.48609 20.7003 5.86371 20.7003 6.25C20.7003 6.768 20.4945 7.26479 20.1282 7.63107C19.762 7.99735 19.2652 8.20312 18.7472 8.20312Z" fill="black"/>
            </svg>',

			'promotion'                           => '<svg width="16" height="16" viewBox="0 0 25 23" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M25 10.4167C25 9.39106 24.4379 8.50521 23.6111 8.02431V1.38932C23.6111 1.00955 23.3082 0 22.2222 0C21.9132 0 21.6063 0.103299 21.355 0.304688L17.6645 3.25738C15.8108 4.73915 13.4835 5.55556 11.1111 5.55556H2.77778C1.24349 5.55556 0 6.79905 0 8.33333V12.5C0 14.0343 1.24349 15.2778 2.77778 15.2778H4.24045C4.18012 15.7326 4.14583 16.1953 4.14583 16.6667C4.14583 18.3928 4.54774 20.0239 5.25521 21.4818C5.48047 21.9457 5.97222 22.2222 6.48785 22.2222H9.71181C10.8424 22.2222 11.5213 20.9271 10.8359 20.0278C10.1241 19.0938 9.70095 17.9288 9.70095 16.6667C9.70095 16.1845 9.77127 15.7209 9.89236 15.2778H11.1111C13.4835 15.2778 15.8108 16.0942 17.6641 17.576L21.3546 20.5286C21.6007 20.7256 21.9065 20.8331 22.2218 20.8333C23.3034 20.8333 23.6107 19.8446 23.6107 19.4444V12.8095C24.4379 12.3281 25 11.4423 25 10.4167ZM20.8333 16.5547L19.3989 15.4071C17.0551 13.5321 14.1111 12.5 11.1111 12.5V8.33333C14.1111 8.33333 17.0551 7.30121 19.3989 5.42621L20.8333 4.27865V16.5547Z" fill="black"/>
            </svg>',

			'wifi'                                => '<svg width="16" height="16" viewBox="0 0 25 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.8011 4.8C17.8804 -1.60117 7.11676 -1.59883 0.198795 4.8C-0.0613614 5.04063 -0.0664395 5.44805 0.185123 5.69766L1.52262 7.02461C1.76247 7.26289 2.1484 7.26797 2.39762 7.03945C8.09762 1.81758 16.9015 1.81641 22.6027 7.03945C22.8519 7.26797 23.2379 7.2625 23.4777 7.02461L24.8152 5.69766C25.0664 5.44805 25.0613 5.04063 24.8011 4.8ZM12.5 12.5C11.1191 12.5 9.99997 13.6191 9.99997 15C9.99997 16.3809 11.1191 17.5 12.5 17.5C13.8808 17.5 15 16.3809 15 15C15 13.6191 13.8808 12.5 12.5 12.5ZM20.4168 9.23477C15.9144 5.25313 9.08044 5.25742 4.58317 9.23477C4.31364 9.47305 4.30504 9.88672 4.5609 10.1391L5.90622 11.4668C6.14059 11.698 6.51794 11.7137 6.76754 11.498C10.0468 8.66328 14.9605 8.66953 18.232 11.498C18.4816 11.7137 18.859 11.6984 19.0933 11.4668L20.4386 10.1391C20.6949 9.88672 20.6859 9.47266 20.4168 9.23477Z" fill="black"/>
            </svg>',

			'stack'                               => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M0.606079 7.2279L11.9801 12.3876C12.3121 12.5385 12.6876 12.5385 13.0197 12.3876L24.3937 7.2279C25.2018 6.8612 25.2018 5.64001 24.3937 5.27331L13.0201 0.113157C12.857 0.0385924 12.6797 0 12.5004 0C12.321 0 12.1437 0.0385924 11.9806 0.113157L0.606079 5.27283C-0.202026 5.63952 -0.202026 6.8612 0.606079 7.2279ZM24.3942 11.5385L21.5577 10.2528L13.6652 13.8304C13.296 13.9979 12.9039 14.0829 12.5001 14.0829C12.0963 14.0829 11.7047 13.9979 11.3351 13.8304L3.44299 10.2528L0.606079 11.5385C-0.202026 11.9047 -0.202026 13.1254 0.606079 13.4916L11.9801 18.6473C12.3121 18.7977 12.6876 18.7977 13.0197 18.6473L24.3942 13.4916C25.2023 13.1254 25.2023 11.9047 24.3942 11.5385ZM24.3942 17.7787L21.5685 16.4979L13.6652 20.0804C13.296 20.2479 12.9039 20.3329 12.5001 20.3329C12.0963 20.3329 11.7047 20.2479 11.3351 20.0804L3.43225 16.4979L0.606079 17.7787C-0.202026 18.1449 -0.202026 19.3656 0.606079 19.7318L11.9801 24.8876C12.3121 25.038 12.6876 25.038 13.0197 24.8876L24.3942 19.7318C25.2023 19.3656 25.2023 18.1449 24.3942 17.7787Z" fill="black"/>
            </svg>',

			'paypal'                              => '<svg width="16" height="16" viewBox="0 0 19 23" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M5.43542 13.0176C5.26452 13.9551 4.58581 18.3252 4.38562 19.5606C4.37097 19.6484 4.33679 19.6826 4.23913 19.6826H0.596556C0.225462 19.6826 -0.0430923 19.3604 0.00573583 19.0039L2.86706 0.844737C2.94031 0.375987 3.36023 0.0195421 3.84363 0.0195421C11.2801 0.0195421 11.9051 -0.161122 13.8046 0.576183C16.7391 1.71388 17.0077 4.45802 15.953 7.42677C14.9032 10.4834 12.413 11.7969 9.11218 11.8359C6.99304 11.8701 5.71863 11.4942 5.43542 13.0176ZM17.4325 5.99122C17.3446 5.92774 17.3104 5.90333 17.286 6.0547C17.1884 6.61134 17.037 7.15333 16.8563 7.69532C14.9081 13.252 9.50769 12.7686 6.87097 12.7686C6.57312 12.7686 6.37781 12.9297 6.33874 13.2275C5.23523 20.083 5.0155 21.5137 5.0155 21.5137C4.96667 21.8604 5.1864 22.1436 5.53308 22.1436H8.63366C9.05359 22.1436 9.40027 21.8359 9.48327 21.416C9.51745 21.1524 9.42956 21.7139 10.1864 16.958C10.411 15.8838 10.8846 15.9961 11.6171 15.9961C15.0839 15.9961 17.7889 14.5899 18.5946 10.5127C18.912 8.81349 18.8192 7.02638 17.4325 5.99122Z" fill="black"/>
            </svg>',

			'apple'                               => '<svg width="16" height="16" viewBox="0 0 19 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M15.3662 11.5576C15.3564 9.76563 16.167 8.41309 17.8076 7.41699C16.8896 6.10352 15.5029 5.38086 13.6719 5.23926C11.9385 5.10254 10.0439 6.25 9.35059 6.25C8.61816 6.25 6.93848 5.28809 5.62012 5.28809C2.89551 5.33203 0 7.46094 0 11.792C0 13.0713 0.234375 14.3929 0.703125 15.7568C1.32812 17.5488 3.58398 21.9434 5.9375 21.8701C7.16797 21.8408 8.03711 20.9961 9.63867 20.9961C11.1914 20.9961 11.9971 21.8701 13.3691 21.8701C15.7422 21.8359 17.7832 17.8418 18.3789 16.0449C15.1953 14.5459 15.3662 11.6504 15.3662 11.5576ZM12.6025 3.54004C13.9355 1.95801 13.8135 0.517578 13.7744 0C12.5977 0.0683594 11.2354 0.800781 10.459 1.7041C9.60449 2.6709 9.10156 3.86719 9.20898 5.21484C10.4834 5.3125 11.6455 4.6582 12.6025 3.54004Z" fill="black"/>
            </svg>',

			'tower'                               => '<svg width="16" height="16" viewBox="0 0 25 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M5.89609 7.5H7.21367C7.64375 7.5 7.94063 7.07695 7.79414 6.67266C7.60156 6.14219 7.49922 5.57969 7.49922 5C7.49922 4.42031 7.60156 3.85781 7.79414 3.32734C7.94102 2.92305 7.64375 2.5 7.21367 2.5H5.89609C5.62227 2.5 5.37031 2.67539 5.29414 2.93867C5.10313 3.60195 5 4.29219 5 5C5 5.70781 5.10312 6.39805 5.29453 7.06094C5.37031 7.32422 5.62227 7.5 5.89609 7.5ZM3.5125 0.911719C3.73281 0.496875 3.43633 0 2.96719 0H1.58711C1.34219 0 1.11289 0.140234 1.01133 0.363672C0.367188 1.77891 0 3.3457 0 5C0 5.9668 0.121875 7.66914 1.04258 9.64297C1.14492 9.86289 1.37148 10 1.61328 10H2.97422C3.44375 10 3.74023 9.50234 3.51914 9.08711C1.57461 5.4418 2.86641 2.12812 3.5125 0.911719ZM23.9867 0.362891C23.8852 0.139844 23.6562 0 23.4113 0H22.0277C21.5598 0 21.2598 0.494531 21.4801 0.908203C22.1938 2.24766 23.3715 5.57305 21.491 9.08125C21.2676 9.49844 21.5613 10 22.0344 10H23.4105C23.6555 10 23.8844 9.86016 23.9859 9.63711C24.6316 8.22188 25 6.65469 25 5C25 3.34531 24.632 1.77812 23.9867 0.362891ZM19.1039 2.5H17.7863C17.3562 2.5 17.0594 2.92305 17.2059 3.32734C17.3984 3.85781 17.5008 4.42031 17.5008 5C17.5008 5.57969 17.3984 6.14219 17.2059 6.67266C17.059 7.07695 17.3562 7.5 17.7863 7.5H19.1039C19.3781 7.5 19.6297 7.32461 19.7059 7.06094C19.8973 6.39805 20 5.70781 20 5C20 4.29219 19.8969 3.60195 19.7055 2.93906C19.6297 2.67539 19.3777 2.5 19.1039 2.5ZM14.5609 6.41094C14.8363 6.00898 14.9984 5.52383 14.9984 5C14.9984 3.61914 13.8801 2.5 12.5 2.5C11.1203 2.5 10.0016 3.61914 10.0016 5C10.0016 5.52383 10.1637 6.00898 10.4391 6.41094L5.34141 18.6535C5.20859 18.9719 5.35938 19.3379 5.67773 19.4707L6.83047 19.9516C7.14883 20.0844 7.51484 19.9336 7.64727 19.6152L9.56875 15H15.4309L17.3527 19.6152C17.4855 19.934 17.8512 20.0844 18.1695 19.9516L19.3223 19.4707C19.6406 19.3379 19.791 18.9719 19.6586 18.6535L14.5609 6.41094ZM10.6102 12.5L12.5 7.96133L14.3898 12.5H10.6102Z" fill="black"/>
            </svg>',

			'padlock_locked'                      => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.4051 9.4H16.8051V8.02002C16.8051 5.06002 14.8051 3 12.0051 3C9.2051 3 7.2051 5.06002 7.2051 8.02002V9.4H6.6051C6.1651 9.4 5.8051 9.76 5.8051 10.2V20.2C5.8051 20.64 6.1651 21 6.6051 21H17.4051C17.8451 21 18.2051 20.64 18.2051 20.2V10.2C18.2051 9.76 17.8451 9.4 17.4051 9.4ZM8.8051 8.02002C8.8051 5.98002 10.1251 4.6 12.0051 4.6C13.8851 4.6 15.2051 5.98002 15.2051 8.02002V9.4H8.8051V8.02002ZM16.6051 19.4H7.4051V11H16.6051V19.4Z" fill="black"/>
			</svg>
			',

			'padlock_open'                        => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.405 9.39998H8.805V8.02C8.805 5.98 10.105 4.59998 11.965 4.59998C13.325 4.59998 14.405 5.29997 14.865 6.53997C15.025 6.95997 15.485 7.15998 15.905 6.99998C16.325 6.83998 16.525 6.37999 16.365 5.95999C15.665 4.09999 13.985 2.97996 11.945 2.97996C9.14501 2.97996 7.18501 5.03998 7.18501 7.99998V9.37996H6.58501C6.14501 9.37996 5.78501 9.73996 5.78501 10.18V20.18C5.78501 20.62 6.14501 20.98 6.58501 20.98H17.385C17.825 20.98 18.185 20.62 18.185 20.18V10.18C18.205 9.75996 17.845 9.39998 17.405 9.39998ZM16.605 19.4H7.405V11H16.605V19.4Z" fill="black"/>
			</svg>
			',

			'comment'                             => '<svg width="16" height="16" viewBox="0 0 25 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M12.5 0C5.5957 0 0 4.5459 0 10.1562C0 12.5781 1.04492 14.7949 2.7832 16.5381C2.17285 18.999 0.131836 21.1914 0.107422 21.2158C0 21.3281 -0.0292969 21.4941 0.0341797 21.6406C0.0976562 21.7871 0.234375 21.875 0.390625 21.875C3.62793 21.875 6.05469 20.3223 7.25586 19.3652C8.85254 19.9658 10.625 20.3125 12.5 20.3125C19.4043 20.3125 25 15.7666 25 10.1562C25 4.5459 19.4043 0 12.5 0Z" fill="black"/>
            </svg>',

			'comments'                            => '<svg width="16" height="16" viewBox="0 0 25 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M18.0556 6.94444C18.0556 3.10764 14.0148 0 9.02778 0C4.0408 0 0 3.10764 0 6.94444C0 8.43316 0.611979 9.80469 1.64931 10.9375C1.06771 12.2483 0.108507 13.2899 0.0954861 13.3029C0 13.4028 -0.0260417 13.5503 0.0303819 13.6806C0.0868056 13.8108 0.208333 13.8889 0.347222 13.8889C1.93576 13.8889 3.25087 13.355 4.19705 12.8038C5.59462 13.4852 7.24826 13.8889 9.02778 13.8889C14.0148 13.8889 18.0556 10.7812 18.0556 6.94444ZM23.3507 16.4931C24.388 15.3646 25 13.9887 25 12.5C25 9.59635 22.678 7.10937 19.388 6.07205C19.4271 6.35851 19.4444 6.6493 19.4444 6.94444C19.4444 11.5408 14.77 15.2778 9.02778 15.2778C8.55903 15.2778 8.1033 15.2431 7.65191 15.1953C9.0191 17.691 12.2309 19.4444 15.9722 19.4444C17.7517 19.4444 19.4054 19.0451 20.8029 18.3594C21.7491 18.9106 23.0642 19.4444 24.6528 19.4444C24.7917 19.4444 24.9175 19.362 24.9696 19.2361C25.026 19.1102 25 18.9627 24.9045 18.8585C24.8915 18.8455 23.9323 17.8082 23.3507 16.4931Z" fill="black"/>
            </svg>',

			'funnel_filter'                       => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.7249 3.62C20.5849 3.36 20.3049 3.2 20.0249 3.2H4.00492C3.70492 3.2 3.44492 3.36 3.30492 3.62C3.16492 3.88 3.22492 4.19999 3.38492 4.43999L9.62491 13.6V19.66C9.62491 20.28 10.0449 20.8 10.6849 20.8H13.3649C13.9849 20.8 14.4249 20.3 14.4249 19.66V13.6L20.6649 4.43999C20.8049 4.19999 20.8649 3.88 20.7249 3.62ZM12.9849 12.92C12.9049 13.06 12.8049 13.2 12.8049 13.36V19.2H11.2049V13.36C11.2049 13.2 11.1249 13.04 11.0249 12.92L9.12491 10.14C9.52491 10.02 10.0049 9.9 10.5249 9.92C11.1449 9.92 11.5649 10.04 12.0249 10.16C12.5049 10.28 12.9849 10.4 13.6649 10.42C14.0649 10.42 14.4249 10.4 14.7449 10.36L12.9849 12.92ZM15.9049 8.63999C15.8849 8.63999 15.0449 9.02 13.6649 9C13.1649 9 12.7849 8.90001 12.3649 8.78001C11.8849 8.66001 11.3249 8.52 10.5249 8.5C9.62491 8.5 8.82492 8.72 8.28492 8.92L5.48492 4.78001H18.5049L15.9049 8.63999ZM14.2649 7.32C14.1249 7.18 14.0249 6.96001 14.0249 6.76001C14.0249 6.54001 14.1049 6.34 14.2649 6.2C14.4049 6.06 14.6249 5.96001 14.8249 5.96001C15.0449 5.96001 15.2449 6.04 15.3849 6.2C15.5249 6.36 15.6249 6.56001 15.6249 6.76001C15.6249 6.98001 15.5449 7.18 15.3849 7.32C15.2249 7.46 15.0249 7.56001 14.8249 7.56001C14.6249 7.56001 14.4049 7.46 14.2649 7.32Z" fill="black"/>
			</svg>
			',

			'link_variation_one'                  => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M7.70665 4.40733L8.64999 5.35C9.08338 5.78335 9.42717 6.29782 9.66172 6.86403C9.89627 7.43025 10.017 8.03713 10.017 8.65C10.017 9.26288 9.89627 9.86975 9.66172 10.436C9.42717 11.0022 9.08338 11.5167 8.64999 11.95L8.41399 12.1853C7.98063 12.6187 7.46615 12.9625 6.89993 13.197C6.33372 13.4315 5.72685 13.5522 5.11399 13.5522C4.50112 13.5522 3.89426 13.4315 3.32804 13.197C2.76183 12.9625 2.24735 12.6187 1.81399 12.1853C1.38062 11.752 1.03686 11.2375 0.802329 10.6713C0.567795 10.1051 0.447083 9.4982 0.447083 8.88533C0.447083 8.27247 0.567795 7.6656 0.802329 7.09939C1.03686 6.53317 1.38063 6.0187 1.81399 5.58533L2.75732 6.52867C2.44557 6.8377 2.19792 7.20527 2.02861 7.61027C1.85929 8.01527 1.77163 8.44972 1.77067 8.88869C1.76971 9.32766 1.85546 9.76249 2.023 10.1682C2.19055 10.574 2.43658 10.9426 2.74698 11.253C3.05737 11.5634 3.42602 11.8094 3.83176 11.977C4.2375 12.1445 4.67233 12.2303 5.1113 12.2293C5.55026 12.2284 5.98472 12.1407 6.38972 11.9714C6.79472 11.8021 7.16229 11.5544 7.47132 11.2427L7.70732 11.0067C8.33222 10.3816 8.68328 9.53388 8.68328 8.65C8.68328 7.76612 8.33222 6.91842 7.70732 6.29333L6.76399 5.35L7.70665 4.40733ZM12.1853 8.414L11.2427 7.47133C11.8547 6.84354 12.1947 5.9999 12.1891 5.12318C12.1834 4.24646 11.8326 3.40725 11.2126 2.78735C10.5927 2.16744 9.75339 1.81676 8.87667 1.81127C7.99995 1.80578 7.15637 2.14591 6.52865 2.758L6.29265 2.99333C5.66775 3.61843 5.3167 4.46612 5.3167 5.35C5.3167 6.23388 5.66775 7.08157 6.29265 7.70667L7.23599 8.65L6.29265 9.59267L5.34999 8.65C4.9166 8.21665 4.57281 7.70218 4.33826 7.13597C4.10371 6.56975 3.98298 5.96288 3.98298 5.35C3.98298 4.73712 4.10371 4.13025 4.33826 3.56403C4.57281 2.99782 4.9166 2.48335 5.34999 2.05L5.58599 1.81467C6.01935 1.3813 6.53383 1.03754 7.10004 0.803009C7.66626 0.568475 8.27312 0.447762 8.88599 0.447762C9.49885 0.447762 10.1057 0.568475 10.6719 0.803009C11.2382 1.03754 11.7526 1.3813 12.186 1.81467C12.6193 2.24803 12.9631 2.7625 13.1976 3.32872C13.4322 3.89493 13.5529 4.5018 13.5529 5.11467C13.5529 5.72753 13.4322 6.3344 13.1976 6.90061C12.9631 7.46683 12.6193 7.9813 12.186 8.41467" fill="black"/>
			</svg>
			',

			'link_variation_two'                  => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.2427 9.35733L10.3 8.41333L11.2427 7.47067C11.8633 6.84461 12.2106 5.99821 12.2087 5.11669C12.2067 4.23517 11.8557 3.3903 11.2324 2.76697C10.609 2.14363 9.76415 1.79259 8.88263 1.79066C8.00111 1.78873 7.15471 2.13607 6.52865 2.75667L5.58532 3.7L4.64265 2.75733L5.58532 1.81467C6.46054 0.939452 7.64758 0.447762 8.88532 0.447762C10.1231 0.447762 11.3101 0.939452 12.1853 1.81467C13.0605 2.68988 13.5522 3.87693 13.5522 5.11467C13.5522 6.35241 13.0605 7.53945 12.1853 8.41467L11.2427 9.35733ZM9.35665 11.2427L8.41399 12.1853C7.53877 13.0605 6.35173 13.5522 5.11399 13.5522C3.87625 13.5522 2.6892 13.0605 1.81399 12.1853C0.938773 11.3101 0.447083 10.1231 0.447083 8.88533C0.447083 7.64759 0.938773 6.46055 1.81399 5.58533L2.75732 4.64267L3.69999 5.58667L2.75732 6.52933C2.14523 7.15704 1.8051 8.00063 1.81059 8.87735C1.81608 9.75407 2.16677 10.5933 2.78667 11.2133C3.40657 11.8333 4.24578 12.1841 5.1225 12.1897C5.99922 12.1953 6.84286 11.8553 7.47065 11.2433L8.41399 10.3007L9.35665 11.2427ZM8.88532 4.17133L9.82865 5.11467L5.11399 9.828L4.17132 8.88533L8.88532 4.17133Z" fill="black"/>
			</svg>
			',

			'link_variation_three'                => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M10.3333 10.3333H13.6667V11.6667H11.6667V13.6667H10.3333V10.3333ZM3.66668 3.66667H0.333344V2.33334H2.33334V0.333336H3.66668V3.66667ZM11.2427 9.35734L10.3 8.41334L11.2427 7.47067C11.8633 6.84461 12.2106 5.99822 12.2087 5.11669C12.2067 4.23517 11.8557 3.3903 11.2324 2.76697C10.609 2.14364 9.76418 1.7926 8.88265 1.79067C8.00113 1.78874 7.15473 2.13607 6.52868 2.75667L5.58601 3.7L4.64268 2.75734L5.58668 1.81467C6.46189 0.939455 7.64894 0.447764 8.88668 0.447764C10.1244 0.447764 11.3115 0.939455 12.1867 1.81467C13.0619 2.68988 13.5536 3.87693 13.5536 5.11467C13.5536 6.35241 13.0619 7.53945 12.1867 8.41467L11.2427 9.35734ZM9.35734 11.2427L8.41401 12.1853C7.5388 13.0606 6.35175 13.5522 5.11401 13.5522C3.87627 13.5522 2.68922 13.0606 1.81401 12.1853C0.938796 11.3101 0.447105 10.1231 0.447105 8.88534C0.447105 7.6476 0.938796 6.46055 1.81401 5.58534L2.75734 4.64267L3.70001 5.58667L2.75734 6.52934C2.13675 7.15539 1.78941 8.00179 1.79134 8.88331C1.79327 9.76484 2.14431 10.6097 2.76764 11.233C3.39098 11.8564 4.23584 12.2074 5.11737 12.2093C5.99889 12.2113 6.84529 11.8639 7.47134 11.2433L8.41401 10.3007L9.35734 11.2427ZM8.88534 4.17134L9.82868 5.11467L5.11468 9.828L4.17134 8.88534L8.88534 4.17134Z" fill="black"/>
			</svg>
			',

			'jump_arr_left'                       => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.1449 11.54C15.7049 10.08 13.6049 9.27995 11.2049 9.13995V6.99995C11.2049 6.67995 10.9649 6.37995 10.6649 6.25995C10.3649 6.13995 10.0049 6.19995 9.76486 6.43995L4.84486 11.44C4.54486 11.76 4.52486 12.2599 4.84486 12.5599L9.76486 17.5599C9.98486 17.7999 10.3649 17.86 10.6649 17.74C10.9649 17.62 11.2049 17.32 11.2049 17V14.84C12.8049 14.8 16.5649 14.96 17.9449 17.4C18.0849 17.66 18.3449 17.8 18.6249 17.8C18.6849 17.8 18.7449 17.8 18.8249 17.78C19.1849 17.68 19.4449 17.38 19.4449 17C19.4249 16.88 19.4249 13.82 17.1449 11.54ZM10.2849 13.28C9.88486 13.32 9.60487 13.66 9.60487 14.08V15.04L6.60487 12L9.60487 8.95995V9.91995C9.60487 10.3599 9.92486 10.7199 10.3649 10.7199C14.6649 10.7199 16.4849 12.78 17.2649 14.54C14.4449 12.86 10.4849 13.26 10.2849 13.28Z" fill="black"/>
			</svg>
			',

			'jump_arr_right'                      => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M5.40498 17.8C5.34498 17.8 5.26498 17.8 5.20498 17.78C4.84498 17.68 4.60498 17.38 4.60498 17C4.60498 16.88 4.62498 13.82 6.90498 11.54C8.36498 10.08 10.365 9.27995 12.885 9.13995V6.99995C12.885 6.67995 13.085 6.37995 13.385 6.25995C13.685 6.13995 14.025 6.19995 14.265 6.43995L19.185 11.44C19.485 11.76 19.485 12.2599 19.185 12.5599L14.265 17.5599C14.045 17.7999 13.685 17.86 13.385 17.74C13.085 17.62 12.885 17.32 12.885 17V14.84C11.285 14.8 7.48498 14.96 6.10498 17.4C5.96498 17.64 5.68498 17.8 5.40498 17.8ZM12.445 13.2199C13.185 13.2199 13.705 13.28 13.765 13.28C14.165 13.32 14.485 13.66 14.485 14.08V15.04L17.485 12L14.485 8.95995V9.91995C14.485 10.3599 14.125 10.7199 13.685 10.7199C11.225 10.7199 9.32498 11.38 8.04498 12.68C7.46498 13.26 7.06498 13.92 6.78498 14.54C8.64498 13.42 11.005 13.2199 12.445 13.2199Z" fill="black"/>
			</svg>
			',

			'arrow_medium'                        => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2 12.5V11.5C2 11.2239 2.22386 11 2.5 11H18.67L14.22 6.56C14.1253 6.46611 14.0721 6.33832 14.0721 6.205C14.0721 6.07168 14.1253 5.94388 14.22 5.85L14.93 5.15C15.0239 5.05534 15.1517 5.0021 15.285 5.0021C15.4183 5.0021 15.5461 5.05534 15.64 5.15L21.78 11.28C21.9207 11.4205 21.9998 11.6112 22 11.81V12.19C21.9977 12.3884 21.9189 12.5783 21.78 12.72L15.64 18.85C15.5461 18.9447 15.4183 18.9979 15.285 18.9979C15.1517 18.9979 15.0239 18.9447 14.93 18.85L14.22 18.14C14.1259 18.0478 14.0729 17.9217 14.0729 17.79C14.0729 17.6583 14.1259 17.5322 14.22 17.44L18.67 13H2.5C2.22386 13 2 12.7761 2 12.5Z" fill="black"/>
			</svg>
			',

			'arrow_circle' => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill="black" fill-rule="evenodd" clip-rule="evenodd" d="M12 0C18.627 0 24 5.373 24 12C24 18.627 18.627 24 12 24C5.373 24 0 18.627 0 12C0 5.373 5.373 0 12 0ZM12 1C5.925 1 1 5.925 1 12C1 18.075 5.925 23 12 23C18.075 23 23 18.075 23 12C23 5.925 18.075 1 12 1ZM14.123 7.385C14.209 7.385 14.291 7.42 14.352 7.482L18.319 11.525C18.41 11.618 18.462 11.744 18.462 11.875V12.125C18.46 12.256 18.409 12.381 18.319 12.475L14.352 16.518C14.291 16.58 14.209 16.615 14.123 16.615C14.037 16.615 13.954 16.58 13.894 16.518L13.435 16.05C13.374 15.989 13.34 15.905 13.34 15.818C13.34 15.732 13.374 15.649 13.435 15.588L16.31 12.659H5.861C5.683 12.659 5.538 12.512 5.538 12.33V11.67C5.538 11.488 5.683 11.341 5.861 11.341H16.31L13.435 8.412C13.373 8.35 13.339 8.266 13.339 8.178C13.339 8.09 13.373 8.005 13.435 7.943L13.894 7.482C13.954 7.42 14.037 7.385 14.123 7.385Z" fill="black"/>
			</svg>
			', 

			'clock'                               => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M12.1094 0C5.41992 0 0 5.41992 0 12.1094C0 18.7988 5.41992 24.2188 12.1094 24.2188C18.7988 24.2188 24.2188 18.7988 24.2188 12.1094C24.2188 5.41992 18.7988 0 12.1094 0ZM14.8975 17.0947L10.5908 13.9648C10.4395 13.8525 10.3516 13.6768 10.3516 13.4912V5.27344C10.3516 4.95117 10.6152 4.6875 10.9375 4.6875H13.2812C13.6035 4.6875 13.8672 4.95117 13.8672 5.27344V11.9971L16.9678 14.2529C17.2314 14.4434 17.2852 14.8096 17.0947 15.0732L15.7178 16.9678C15.5273 17.2266 15.1611 17.2852 14.8975 17.0947Z" fill="black"/>
            </svg>',

			'clock_light'                         => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.1987 10.1335L10.132 9.20016L7.66536 6.7335V3.66683H6.33203V7.26683L9.1987 10.1335ZM6.9987 13.6668C6.07648 13.6668 5.20981 13.4918 4.3987 13.1418C3.58759 12.7918 2.88203 12.3168 2.28203 11.7168C1.68203 11.1168 1.20703 10.4113 0.857031 9.60016C0.507031 8.78905 0.332031 7.92239 0.332031 7.00016C0.332031 6.07794 0.507031 5.21127 0.857031 4.40016C1.20703 3.58905 1.68203 2.8835 2.28203 2.2835C2.88203 1.6835 3.58759 1.2085 4.3987 0.858496C5.20981 0.508496 6.07648 0.333496 6.9987 0.333496C7.92092 0.333496 8.78759 0.508496 9.5987 0.858496C10.4098 1.2085 11.1154 1.6835 11.7154 2.2835C12.3154 2.8835 12.7904 3.58905 13.1404 4.40016C13.4904 5.21127 13.6654 6.07794 13.6654 7.00016C13.6654 7.92239 13.4904 8.78905 13.1404 9.60016C12.7904 10.4113 12.3154 11.1168 11.7154 11.7168C11.1154 12.3168 10.4098 12.7918 9.5987 13.1418C8.78759 13.4918 7.92092 13.6668 6.9987 13.6668ZM6.9987 12.3335C8.47648 12.3335 9.73481 11.8141 10.7737 10.7752C11.8126 9.73627 12.332 8.47794 12.332 7.00016C12.332 5.52239 11.8126 4.26405 10.7737 3.22516C9.73481 2.18627 8.47648 1.66683 6.9987 1.66683C5.52092 1.66683 4.26259 2.18627 3.2237 3.22516C2.18481 4.26405 1.66536 5.52239 1.66536 7.00016C1.66536 8.47794 2.18481 9.73627 3.2237 10.7752C4.26259 11.8141 5.52092 12.3335 6.9987 12.3335Z" fill="black"/>
			</svg>
			',

			'clipboard'                           => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M18.205 4.59999H16.605H16.405H15.225L14.905 3.76C14.685 3.18 14.125 2.79999 13.505 2.79999H10.665C10.045 2.79999 9.48503 3.18 9.26503 3.76L8.94501 4.59999H7.58502H7.38502H5.78502C5.34502 4.59999 4.98502 4.99998 4.98502 5.43998V20.4C4.98502 20.84 5.34502 21.2 5.78502 21.2H18.185C18.625 21.2 18.985 20.84 18.985 20.4V5.43998C19.005 4.99998 18.645 4.59999 18.205 4.59999ZM9.52501 6.19999C9.86501 6.19999 10.165 5.99999 10.285 5.69999L10.765 4.39999H13.445L13.925 5.69999C14.045 6.01999 14.345 6.19999 14.685 6.19999H15.325L14.745 7.33998C14.645 7.49998 14.465 7.59999 14.265 7.59999H9.92501C9.74501 7.59999 9.56503 7.52 9.46503 7.36L8.80502 6.19999H9.52501ZM17.405 19.6H6.60502V6.19999H6.94501L8.06503 8.19999C8.06503 8.21999 8.08502 8.20001 8.08502 8.22001C8.48502 8.84001 9.16502 9.19999 9.90502 9.19999H14.245C15.005 9.19999 15.725 8.81998 16.105 8.13998C16.105 8.11998 16.125 8.09999 16.125 8.09999L17.085 6.19999H17.385V19.6H17.405Z" fill="black"/>
			</svg>
			',

			'cup'                                 => '<svg width="16" height="16" viewBox="0 0 25 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M7.50218 13.75H15.0022C17.0725 13.75 18.7522 12.0703 18.7522 10H20.0022C22.76 10 25.0022 7.75781 25.0022 5C25.0022 2.24219 22.76 0 20.0022 0H4.68968C4.17015 0 3.75218 0.417969 3.75218 0.9375V10C3.75218 12.0703 5.43187 13.75 7.50218 13.75ZM20.0022 2.5C21.3811 2.5 22.5022 3.62109 22.5022 5C22.5022 6.37891 21.3811 7.5 20.0022 7.5H18.7522V2.5H20.0022ZM21.8655 17.5H1.8889C0.029528 17.5 -0.49391 15 0.482653 15H23.2678C24.2444 15 23.7287 17.5 21.8655 17.5Z" fill="black"/>
            </svg>',

			'internal_link_open'                  => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.6051 5.40001V18.6C20.6051 19.04 20.2451 19.4 19.8051 19.4H9.38509C8.94509 19.4 8.60509 19.04 8.60509 18.6V14.94C8.60509 14.5 8.96509 14.14 9.40509 14.14C9.84509 14.14 10.2051 14.5 10.2051 14.94V17.8H19.0051V6.20001H10.2051V9.06002C10.2051 9.50002 9.84509 9.86002 9.40509 9.86002C8.96509 9.86002 8.60509 9.50002 8.60509 9.06002V5.40001C8.60509 4.96001 8.94509 4.60001 9.38509 4.60001H19.8051C20.2451 4.60001 20.6051 4.96001 20.6051 5.40001ZM12.1051 14.58C11.7851 14.9 11.8051 15.4 12.1051 15.72C12.2651 15.88 12.4651 15.96 12.6651 15.96C12.8651 15.96 13.0851 15.88 13.2251 15.72L16.3651 12.56C16.6651 12.24 16.6651 11.74 16.3651 11.44L13.2251 8.27999C12.9051 7.95999 12.4051 7.95999 12.0851 8.27999C11.7651 8.59999 11.7651 9.10003 12.0851 9.42003L13.8651 11.22L4.20509 11.2C3.76509 11.2 3.40509 11.56 3.40509 12C3.40509 12.44 3.76509 12.8 4.20509 12.8L13.8851 12.78L12.1051 14.58Z" fill="black"/>
			</svg>
			',

			'external_link_open'                  => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.805 14.94V18.6C14.805 19.04 14.485 19.4 14.045 19.4H3.60498C3.16498 19.4 2.80498 19.04 2.80498 18.6V5.40001C2.80498 4.96001 3.16498 4.60001 3.60498 4.60001H14.045C14.485 4.60001 14.805 4.96001 14.805 5.40001V9.06002C14.805 9.50002 14.445 9.86002 14.005 9.86002C13.565 9.86002 13.205 9.50002 13.205 9.06002V6.20001H4.40498V17.8H13.205V14.94C13.205 14.5 13.565 14.14 14.005 14.14C14.445 14.14 14.805 14.5 14.805 14.94ZM20.965 11.4L17.825 8.24C17.505 7.92 17.005 7.92 16.685 8.24C16.365 8.56 16.365 9.05999 16.685 9.37999L18.465 11.18L8.76499 11.2C8.32499 11.2 7.96499 11.56 7.96499 12C7.96499 12.44 8.32499 12.8 8.76499 12.8L18.465 12.78L16.685 14.58C16.365 14.9 16.385 15.4 16.685 15.72C16.845 15.88 17.045 15.96 17.245 15.96C17.445 15.96 17.665 15.88 17.805 15.72L20.945 12.56C21.285 12.22 21.285 11.72 20.965 11.4Z" fill="black"/>
			</svg>
			',

			'folder'                              => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M18.8051 7.40001H11.9051L11.0251 5.97999C10.8851 5.73999 10.6251 5.60001 10.3451 5.60001H5.20509C4.76509 5.60001 4.40509 5.96001 4.40509 6.40001V17.6C4.40509 18.04 4.76509 18.4 5.20509 18.4H18.8051C19.2451 18.4 19.6051 18.04 19.6051 17.6V8.22003C19.6051 7.78003 19.2451 7.40001 18.8051 7.40001ZM18.0051 16.8H6.00509V7.20001H9.88509L10.7651 8.62003C10.9051 8.86003 11.1651 9.00001 11.4451 9.00001H18.0051V16.8Z" fill="black"/>
			</svg>
			',

			'folder_open'                         => '<svg width="16" height="16" viewBox="0 0 25 17" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.8565 9.89987L21.7131 15.2885C21.4685 15.7079 21.1182 16.0558 20.6972 16.2976C20.2763 16.5394 19.7992 16.6667 19.3138 16.6667H1.95421C1.15026 16.6667 0.649349 15.7946 1.05443 15.1001L4.19783 9.71146C4.44246 9.2921 4.79272 8.94418 5.21372 8.70238C5.63471 8.46057 6.11173 8.33333 6.59722 8.33333H23.9568C24.7607 8.33333 25.2616 9.20542 24.8565 9.89987ZM6.59722 6.94444H20.8333V4.86111C20.8333 3.7105 19.9006 2.77778 18.75 2.77778H11.8056L9.02778 0H2.08333C0.932726 0 0 0.932726 0 2.08333V14.1513L2.99813 9.01163C3.74193 7.73654 5.12105 6.94444 6.59722 6.94444Z" fill="black"/>
            </svg>',

			'folder_open_light'                   => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M21.045 10.32C20.885 10.12 20.665 9.99999 20.425 9.99999H19.425V7.82001C19.425 7.44001 19.145 7.19999 18.765 7.19999H11.785L10.885 5.72001C10.765 5.52001 10.525 5.39999 10.285 5.39999H5.12502C4.74502 5.39999 4.44502 5.61999 4.44502 5.99999V9.99999H3.64502C3.40502 9.99999 3.16502 10.12 3.02502 10.3C2.86502 10.48 2.80502 10.74 2.86502 10.98L4.34502 17.76C4.42502 18.12 4.74502 18.4 5.12502 18.4H18.785C19.145 18.4 19.465 18.14 19.565 17.8L21.225 11.02C21.245 10.76 21.185 10.52 21.045 10.32ZM5.80502 6.79999H9.84502L10.745 8.27997C10.865 8.47997 11.105 8.59999 11.345 8.59999H18.005V9.99999H5.80502V6.79999ZM18.105 16.8H5.72502L4.58502 11.6H19.365L18.105 16.8Z" fill="black"/>
			</svg>
			',

			'percentage_light'                    => '<svg width="16" height="16" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.66667 12C9.04783 12 8.45434 11.7542 8.01675 11.3166C7.57917 10.879 7.33333 10.2855 7.33333 9.66667C7.33333 9.04783 7.57917 8.45434 8.01675 8.01675C8.45434 7.57917 9.04783 7.33333 9.66667 7.33333C10.2855 7.33333 10.879 7.57917 11.3166 8.01675C11.7542 8.45434 12 9.04783 12 9.66667C12 10.2855 11.7542 10.879 11.3166 11.3166C10.879 11.7542 10.2855 12 9.66667 12ZM9.66667 10.6667C9.93188 10.6667 10.1862 10.5613 10.3738 10.3738C10.5613 10.1862 10.6667 9.93188 10.6667 9.66667C10.6667 9.40145 10.5613 9.1471 10.3738 8.95956C10.1862 8.77202 9.93188 8.66667 9.66667 8.66667C9.40145 8.66667 9.1471 8.77202 8.95956 8.95956C8.77202 9.1471 8.66667 9.40145 8.66667 9.66667C8.66667 9.93188 8.77202 10.1862 8.95956 10.3738C9.1471 10.5613 9.40145 10.6667 9.66667 10.6667ZM2.33333 4.66667C2.02692 4.66667 1.7235 4.60631 1.44041 4.48905C1.15731 4.37179 0.900088 4.19992 0.683417 3.98325C0.466747 3.76658 0.294876 3.50935 0.177615 3.22626C0.0603535 2.94317 0 2.63975 0 2.33333C0 2.02692 0.0603535 1.7235 0.177615 1.44041C0.294876 1.15731 0.466747 0.900088 0.683417 0.683417C0.900088 0.466747 1.15731 0.294875 1.44041 0.177614C1.7235 0.0603534 2.02692 -6.45727e-09 2.33333 0C2.95217 1.3041e-08 3.54566 0.245833 3.98325 0.683417C4.42083 1.121 4.66667 1.71449 4.66667 2.33333C4.66667 2.95217 4.42083 3.54566 3.98325 3.98325C3.54566 4.42083 2.95217 4.66667 2.33333 4.66667ZM2.33333 3.33333C2.46466 3.33333 2.59469 3.30747 2.71602 3.25721C2.83734 3.20696 2.94758 3.1333 3.04044 3.04044C3.1333 2.94758 3.20696 2.83734 3.25721 2.71602C3.30747 2.59469 3.33333 2.46466 3.33333 2.33333C3.33333 2.20201 3.30747 2.07198 3.25721 1.95065C3.20696 1.82932 3.1333 1.71909 3.04044 1.62623C2.94758 1.53337 2.83734 1.45971 2.71602 1.40945C2.59469 1.3592 2.46466 1.33333 2.33333 1.33333C2.06812 1.33333 1.81376 1.43869 1.62623 1.62623C1.43869 1.81376 1.33333 2.06812 1.33333 2.33333C1.33333 2.59855 1.43869 2.8529 1.62623 3.04044C1.81376 3.22798 2.06812 3.33333 2.33333 3.33333ZM10.714 0.342667L11.6567 1.286L1.286 11.6567L0.343333 10.714L10.714 0.342667Z" fill="black"/>
			</svg>
			',

			'percentage_dark'                     => '<svg width="16" height="16" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.66667 12C9.04783 12 8.45434 11.7542 8.01675 11.3166C7.57917 10.879 7.33333 10.2855 7.33333 9.66667C7.33333 9.04783 7.57917 8.45434 8.01675 8.01675C8.45434 7.57917 9.04783 7.33333 9.66667 7.33333C10.2855 7.33333 10.879 7.57917 11.3166 8.01675C11.7542 8.45434 12 9.04783 12 9.66667C12 10.2855 11.7542 10.879 11.3166 11.3166C10.879 11.7542 10.2855 12 9.66667 12ZM2.33333 4.66667C2.02692 4.66667 1.7235 4.60631 1.44041 4.48905C1.15731 4.37179 0.900088 4.19992 0.683417 3.98325C0.466747 3.76658 0.294876 3.50935 0.177615 3.22626C0.0603535 2.94317 0 2.63975 0 2.33333C0 2.02692 0.0603535 1.7235 0.177615 1.44041C0.294876 1.15731 0.466747 0.900088 0.683417 0.683417C0.900088 0.466747 1.15731 0.294875 1.44041 0.177614C1.7235 0.0603534 2.02692 -6.45727e-09 2.33333 0C2.95217 1.3041e-08 3.54566 0.245833 3.98325 0.683417C4.42083 1.121 4.66667 1.71449 4.66667 2.33333C4.66667 2.95217 4.42083 3.54566 3.98325 3.98325C3.54566 4.42083 2.95217 4.66667 2.33333 4.66667ZM10.714 0.342667L11.6567 1.286L1.286 11.6567L0.343333 10.714L10.714 0.342667Z" fill="black"/>
			</svg>
			',

			'emoji_happy_light'                   => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667ZM6.96391 12.3333C8.3784 12.3333 9.73495 11.7714 10.7351 10.7712C11.7353 9.77104 12.2972 8.41449 12.2972 7C12.2972 5.58551 11.7353 4.22896 10.7351 3.22876C9.73495 2.22857 8.3784 1.66667 6.96391 1.66667C5.54942 1.66667 4.19287 2.22857 3.19267 3.22876C2.19248 4.22896 1.63057 5.58551 1.63057 7C1.63057 8.41449 2.19248 9.77104 3.19267 10.7712C4.19287 11.7714 5.54942 12.3333 6.96391 12.3333ZM3.63057 7.66667H4.96391C4.96391 8.1971 5.17462 8.70581 5.54969 9.08088C5.92477 9.45595 6.43348 9.66667 6.96391 9.66667C7.49434 9.66667 8.00305 9.45595 8.37812 9.08088C8.75319 8.70581 8.96391 8.1971 8.96391 7.66667H10.2972C10.2972 8.55072 9.94605 9.39857 9.32093 10.0237C8.69581 10.6488 7.84796 11 6.96391 11C6.07985 11 5.23201 10.6488 4.60689 10.0237C3.98176 9.39857 3.63057 8.55072 3.63057 7.66667ZM4.29724 6.33333C4.03202 6.33333 3.77767 6.22798 3.59013 6.04044C3.4026 5.8529 3.29724 5.59855 3.29724 5.33333C3.29724 5.06812 3.4026 4.81376 3.59013 4.62623C3.77767 4.43869 4.03202 4.33333 4.29724 4.33333C4.56246 4.33333 4.81681 4.43869 5.00435 4.62623C5.19188 4.81376 5.29724 5.06812 5.29724 5.33333C5.29724 5.59855 5.19188 5.8529 5.00435 6.04044C4.81681 6.22798 4.56246 6.33333 4.29724 6.33333ZM9.63057 6.33333C9.36536 6.33333 9.111 6.22798 8.92347 6.04044C8.73593 5.8529 8.63057 5.59855 8.63057 5.33333C8.63057 5.06812 8.73593 4.81376 8.92347 4.62623C9.111 4.43869 9.36536 4.33333 9.63057 4.33333C9.89579 4.33333 10.1501 4.43869 10.3377 4.62623C10.5252 4.81376 10.6306 5.06812 10.6306 5.33333C10.6306 5.59855 10.5252 5.8529 10.3377 6.04044C10.1501 6.22798 9.89579 6.33333 9.63057 6.33333Z" fill="black"/>
			</svg>
			',

			'emoji_happy_fill'                    => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667ZM3.63057 7.66667C3.63057 8.55072 3.98176 9.39857 4.60689 10.0237C5.23201 10.6488 6.07985 11 6.96391 11C7.84796 11 8.69581 10.6488 9.32093 10.0237C9.94605 9.39857 10.2972 8.55072 10.2972 7.66667H8.96391C8.96391 8.1971 8.75319 8.70581 8.37812 9.08088C8.00305 9.45595 7.49434 9.66667 6.96391 9.66667C6.43348 9.66667 5.92477 9.45595 5.54969 9.08088C5.17462 8.70581 4.96391 8.1971 4.96391 7.66667H3.63057ZM4.29724 6.33333C4.56246 6.33333 4.81681 6.22798 5.00435 6.04044C5.19188 5.8529 5.29724 5.59855 5.29724 5.33333C5.29724 5.06812 5.19188 4.81376 5.00435 4.62623C4.81681 4.43869 4.56246 4.33333 4.29724 4.33333C4.03202 4.33333 3.77767 4.43869 3.59013 4.62623C3.4026 4.81376 3.29724 5.06812 3.29724 5.33333C3.29724 5.59855 3.4026 5.8529 3.59013 6.04044C3.77767 6.22798 4.03202 6.33333 4.29724 6.33333ZM9.63057 6.33333C9.89579 6.33333 10.1501 6.22798 10.3377 6.04044C10.5252 5.8529 10.6306 5.59855 10.6306 5.33333C10.6306 5.06812 10.5252 4.81376 10.3377 4.62623C10.1501 4.43869 9.89579 4.33333 9.63057 4.33333C9.36536 4.33333 9.111 4.43869 8.92347 4.62623C8.73593 4.81376 8.63057 5.06812 8.63057 5.33333C8.63057 5.59855 8.73593 5.8529 8.92347 6.04044C9.111 6.22798 9.36536 6.33333 9.63057 6.33333Z" fill="black"/>
			</svg>
			',

			'emoji_sad_light'                     => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667ZM6.96391 12.3333C8.3784 12.3333 9.73495 11.7714 10.7351 10.7712C11.7353 9.77104 12.2972 8.41449 12.2972 7C12.2972 5.58551 11.7353 4.22896 10.7351 3.22876C9.73495 2.22857 8.3784 1.66667 6.96391 1.66667C5.54942 1.66667 4.19287 2.22857 3.19267 3.22876C2.19248 4.22896 1.63057 5.58551 1.63057 7C1.63057 8.41449 2.19248 9.77104 3.19267 10.7712C4.19287 11.7714 5.54942 12.3333 6.96391 12.3333ZM3.63057 10.3333C3.63057 9.44928 3.98176 8.60143 4.60689 7.97631C5.23201 7.35119 6.07985 7 6.96391 7C7.84796 7 8.69581 7.35119 9.32093 7.97631C9.94605 8.60143 10.2972 9.44928 10.2972 10.3333H8.96391C8.96391 9.8029 8.75319 9.29419 8.37812 8.91912C8.00305 8.54405 7.49434 8.33333 6.96391 8.33333C6.43348 8.33333 5.92477 8.54405 5.54969 8.91912C5.17462 9.29419 4.96391 9.8029 4.96391 10.3333H3.63057ZM4.29724 6.33333C4.03202 6.33333 3.77767 6.22798 3.59013 6.04044C3.4026 5.8529 3.29724 5.59855 3.29724 5.33333C3.29724 5.06812 3.4026 4.81376 3.59013 4.62623C3.77767 4.43869 4.03202 4.33333 4.29724 4.33333C4.56246 4.33333 4.81681 4.43869 5.00435 4.62623C5.19188 4.81376 5.29724 5.06812 5.29724 5.33333C5.29724 5.59855 5.19188 5.8529 5.00435 6.04044C4.81681 6.22798 4.56246 6.33333 4.29724 6.33333ZM9.63057 6.33333C9.36536 6.33333 9.111 6.22798 8.92347 6.04044C8.73593 5.8529 8.63057 5.59855 8.63057 5.33333C8.63057 5.06812 8.73593 4.81376 8.92347 4.62623C9.111 4.43869 9.36536 4.33333 9.63057 4.33333C9.89579 4.33333 10.1501 4.43869 10.3377 4.62623C10.5252 4.81376 10.6306 5.06812 10.6306 5.33333C10.6306 5.59855 10.5252 5.8529 10.3377 6.04044C10.1501 6.22798 9.89579 6.33333 9.63057 6.33333Z" fill="black"/>
			</svg>
			',

			'emoji_sad_fill'                      => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667ZM3.63057 10.3333H4.96391C4.96391 9.8029 5.17462 9.29419 5.54969 8.91912C5.92477 8.54405 6.43348 8.33333 6.96391 8.33333C7.49434 8.33333 8.00305 8.54405 8.37812 8.91912C8.75319 9.29419 8.96391 9.8029 8.96391 10.3333H10.2972C10.2972 9.44928 9.94605 8.60143 9.32093 7.97631C8.69581 7.35119 7.84796 7 6.96391 7C6.07985 7 5.23201 7.35119 4.60689 7.97631C3.98176 8.60143 3.63057 9.44928 3.63057 10.3333ZM4.29724 6.33333C4.56246 6.33333 4.81681 6.22798 5.00435 6.04044C5.19188 5.8529 5.29724 5.59855 5.29724 5.33333C5.29724 5.06812 5.19188 4.81376 5.00435 4.62623C4.81681 4.43869 4.56246 4.33333 4.29724 4.33333C4.03202 4.33333 3.77767 4.43869 3.59013 4.62623C3.4026 4.81376 3.29724 5.06812 3.29724 5.33333C3.29724 5.59855 3.4026 5.8529 3.59013 6.04044C3.77767 6.22798 4.03202 6.33333 4.29724 6.33333ZM9.63057 6.33333C9.89579 6.33333 10.1501 6.22798 10.3377 6.04044C10.5252 5.8529 10.6306 5.59855 10.6306 5.33333C10.6306 5.06812 10.5252 4.81376 10.3377 4.62623C10.1501 4.43869 9.89579 4.33333 9.63057 4.33333C9.36536 4.33333 9.111 4.43869 8.92347 4.62623C8.73593 4.81376 8.63057 5.06812 8.63057 5.33333C8.63057 5.59855 8.73593 5.8529 8.92347 6.04044C9.111 6.22798 9.36536 6.33333 9.63057 6.33333Z" fill="black"/>
			</svg>
			',

			'emoji_laugh_light'                   => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333ZM6.96391 1.66667C5.54942 1.66667 4.19287 2.22857 3.19267 3.22876C2.19248 4.22896 1.63057 5.58551 1.63057 7C1.63057 8.41449 2.19248 9.77104 3.19267 10.7712C4.19287 11.7714 5.54942 12.3333 6.96391 12.3333C8.3784 12.3333 9.73495 11.7714 10.7351 10.7712C11.7353 9.77104 12.2972 8.41449 12.2972 7C12.2972 5.58551 11.7353 4.22896 10.7351 3.22876C9.73495 2.22857 8.3784 1.66667 6.96391 1.66667ZM6.96391 6.33333C8.29724 6.33333 9.40835 6.55556 10.2972 7C10.2972 7.88406 9.94605 8.7319 9.32093 9.35702C8.69581 9.98214 7.84796 10.3333 6.96391 10.3333C6.07985 10.3333 5.23201 9.98214 4.60689 9.35702C3.98176 8.7319 3.63057 7.88406 3.63057 7C4.51946 6.55556 5.63057 6.33333 6.96391 6.33333ZM4.63057 3.66667C5.01479 3.66659 5.38724 3.79926 5.68488 4.04223C5.98251 4.2852 6.18706 4.62355 6.26391 5H2.99724C3.07408 4.62355 3.27864 4.2852 3.57627 4.04223C3.87391 3.79926 4.24636 3.66659 4.63057 3.66667ZM9.29724 3.66667C9.68146 3.66659 10.0539 3.79926 10.3515 4.04223C10.6492 4.2852 10.8537 4.62355 10.9306 5H7.66391C7.74075 4.62355 7.9453 4.2852 8.24294 4.04223C8.54058 3.79926 8.91302 3.66659 9.29724 3.66667Z" fill="black"/>
			</svg>
			',

			'emoji_laugh_fill'                    => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333ZM6.96391 6.33333C5.63057 6.33333 4.51946 6.55556 3.63057 7C3.63057 7.88406 3.98176 8.7319 4.60689 9.35702C5.23201 9.98214 6.07985 10.3333 6.96391 10.3333C7.84796 10.3333 8.69581 9.98214 9.32093 9.35702C9.94605 8.7319 10.2972 7.88406 10.2972 7C9.40835 6.55556 8.29724 6.33333 6.96391 6.33333ZM4.63057 3.66667C3.86257 3.66667 3.21591 4.18667 3.02257 4.89333L2.99724 5H6.26391C6.18706 4.62355 5.98251 4.2852 5.68488 4.04223C5.38724 3.79926 5.01479 3.66659 4.63057 3.66667ZM9.29724 3.66667C8.52924 3.66667 7.88257 4.18667 7.68924 4.89333L7.66391 5H10.9306C10.8537 4.62355 10.6492 4.2852 10.3515 4.04223C10.0539 3.79926 9.68146 3.66659 9.29724 3.66667Z" fill="black"/>
			</svg>
			',

			'graph'                               => '<svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.2552 13.2351H13.3503L20.6127 20.4975C20.8903 20.7751 21.3471 20.7976 21.6325 20.5288C23.4109 18.8532 24.6343 16.5945 24.9932 14.0554C25.0548 13.6207 24.694 13.2351 24.2552 13.2351ZM23.5277 10.2572C23.149 4.76729 18.762 0.380338 13.2722 0.00166177C12.853 -0.0272904 12.5001 0.32611 12.5001 0.746147V11.0292H22.7836C23.2037 11.0292 23.5566 10.6763 23.5277 10.2572ZM10.2942 13.2351V2.33025C10.2942 1.89137 9.90865 1.53061 9.47437 1.59219C3.9978 2.36609 -0.188319 7.15056 0.00653426 12.8845C0.206902 18.7733 5.27721 23.6023 11.1688 23.5283C13.4849 23.4994 15.6251 22.753 17.3848 21.5049C17.7478 21.2475 17.7717 20.7131 17.4569 20.3983L10.2942 13.2351Z" fill="black"/>
            </svg>',

			'search'                              => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M24.6582 21.6162L19.79 16.748C19.5703 16.5283 19.2725 16.4062 18.96 16.4062H18.1641C19.5117 14.6826 20.3125 12.5146 20.3125 10.1562C20.3125 4.5459 15.7666 0 10.1562 0C4.5459 0 0 4.5459 0 10.1562C0 15.7666 4.5459 20.3125 10.1562 20.3125C12.5146 20.3125 14.6826 19.5117 16.4062 18.1641V18.96C16.4062 19.2725 16.5283 19.5703 16.748 19.79L21.6162 24.6582C22.0752 25.1172 22.8174 25.1172 23.2715 24.6582L24.6533 23.2764C25.1123 22.8174 25.1123 22.0752 24.6582 21.6162ZM10.1562 16.4062C6.7041 16.4062 3.90625 13.6133 3.90625 10.1562C3.90625 6.7041 6.69922 3.90625 10.1562 3.90625C13.6084 3.90625 16.4062 6.69922 16.4062 10.1562C16.4062 13.6084 13.6133 16.4062 10.1562 16.4062Z" fill="black"/>
			</svg>
			',

			'search_line'                         => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M12.0206 11.078L14.876 13.9327L13.9326 14.876L11.078 12.0207C10.0158 12.8722 8.69465 13.3353 7.33331 13.3333C4.02131 13.3333 1.33331 10.6453 1.33331 7.33334C1.33331 4.02134 4.02131 1.33334 7.33331 1.33334C10.6453 1.33334 13.3333 4.02134 13.3333 7.33334C13.3353 8.69468 12.8721 10.0158 12.0206 11.078ZM10.6833 10.5833C11.5292 9.71315 12.0017 8.54692 12 7.33334C12 4.75534 9.91131 2.66668 7.33331 2.66668C4.75531 2.66668 2.66665 4.75534 2.66665 7.33334C2.66665 9.91134 4.75531 12 7.33331 12C8.54689 12.0017 9.71312 11.5292 10.5833 10.6833L10.6833 10.5833Z" fill="black"/>
			</svg>
			',

			'search_light'                        => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.365 3.26001C10.945 3.26001 8.165 6.08001 8.165 9.52001C8.165 10.98 8.665 12.3 9.485 13.38L3.60501 19.32C3.26501 19.68 3.26501 20.24 3.60501 20.58C3.78501 20.76 4.00501 20.84 4.22501 20.84C4.46501 20.84 4.685 20.76 4.865 20.58L10.745 14.62C11.765 15.36 13.005 15.78 14.345 15.78C17.765 15.78 20.545 12.96 20.545 9.52001C20.565 6.06001 17.785 3.26001 14.365 3.26001ZM14.365 14.2C11.825 14.2 9.765 12.1 9.765 9.52001C9.765 6.94001 11.825 4.84001 14.365 4.84001C16.905 4.84001 18.965 6.94001 18.965 9.52001C18.965 12.1 16.905 14.2 14.365 14.2ZM17.465 9.60001C17.425 9.94001 17.125 10.2 16.785 10.2C16.745 10.2 16.725 10.2 16.685 10.2C16.305 10.14 16.045 9.80001 16.085 9.42001C16.225 8.38001 15.065 7.84001 15.005 7.82001C14.665 7.66001 14.505 7.24001 14.665 6.90001C14.825 6.56001 15.225 6.40001 15.585 6.54001C15.665 6.56001 17.745 7.52001 17.465 9.60001ZM16.005 11.12C16.145 11.26 16.245 11.48 16.245 11.68C16.245 11.9 16.165 12.1 16.005 12.24C15.865 12.38 15.645 12.48 15.445 12.48C15.245 12.48 15.025 12.4 14.885 12.24C14.745 12.1 14.645 11.88 14.645 11.68C14.645 11.48 14.725 11.26 14.885 11.12C15.025 10.98 15.245 10.88 15.445 10.88C15.645 10.88 15.845 10.96 16.005 11.12Z" fill="black"/>
			</svg>
			',

			'search_minus'                        => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.8438 9.375V10.9375C14.8438 11.2598 14.5801 11.5234 14.2578 11.5234H6.05469C5.73242 11.5234 5.46875 11.2598 5.46875 10.9375V9.375C5.46875 9.05273 5.73242 8.78906 6.05469 8.78906H14.2578C14.5801 8.78906 14.8438 9.05273 14.8438 9.375ZM24.6582 23.2764L23.2764 24.6582C22.8174 25.1172 22.0752 25.1172 21.6211 24.6582L16.748 19.79C16.5283 19.5703 16.4062 19.2725 16.4062 18.96V18.1641C14.6826 19.5117 12.5146 20.3125 10.1562 20.3125C4.5459 20.3125 0 15.7666 0 10.1562C0 4.5459 4.5459 0 10.1562 0C15.7666 0 20.3125 4.5459 20.3125 10.1562C20.3125 12.5146 19.5117 14.6826 18.1641 16.4062H18.96C19.2725 16.4062 19.5703 16.5283 19.79 16.748L24.6582 21.6162C25.1123 22.0752 25.1123 22.8174 24.6582 23.2764ZM16.7969 10.1562C16.7969 6.48438 13.8281 3.51562 10.1562 3.51562C6.48438 3.51562 3.51562 6.48438 3.51562 10.1562C3.51562 13.8281 6.48438 16.7969 10.1562 16.7969C13.8281 16.7969 16.7969 13.8281 16.7969 10.1562Z" fill="black"/>
			</svg>
			',

			'question_mark_circle'                => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.985 7.9C15.625 8.62 15.925 9.59999 15.785 10.64C15.545 12.56 14.145 13.24 12.905 13.24C12.845 13.24 12.805 13.24 12.805 13.24V13.72C12.805 14.16 12.445 14.52 12.005 14.52C11.565 14.52 11.205 14.16 11.205 13.72V13.08C11.205 12.42 11.485 11.64 12.905 11.64C13.685 11.64 14.085 11.24 14.185 10.44C14.225 10.18 14.245 9.48001 13.765 8.96001C13.385 8.54001 12.765 8.31999 11.925 8.31999C10.125 8.31999 10.065 9.49999 10.065 9.61999C10.065 10.06 9.70499 10.42 9.26499 10.42C8.82499 10.42 8.46499 10.06 8.46499 9.61999C8.46499 8.81999 9.08497 6.71999 11.925 6.71999C13.585 6.71999 14.505 7.36 14.985 7.9ZM11.945 15.2C11.685 15.2 11.425 15.3 11.245 15.5C11.065 15.68 10.945 15.94 10.945 16.2C10.945 16.46 11.045 16.72 11.245 16.9C11.425 17.08 11.685 17.2 11.945 17.2C12.205 17.2 12.465 17.1 12.645 16.9C12.825 16.72 12.945 16.46 12.945 16.2C12.945 15.94 12.845 15.68 12.645 15.5C12.485 15.32 12.225 15.2 11.945 15.2ZM21.205 12C21.205 17.08 17.085 21.2 12.005 21.2C6.92498 21.2 2.80498 17.08 2.80498 12C2.80498 6.92 6.92498 2.8 12.005 2.8C17.085 2.8 21.205 6.92 21.205 12ZM19.605 12C19.605 7.8 16.205 4.4 12.005 4.4C7.80498 4.4 4.40498 7.8 4.40498 12C4.40498 16.2 7.80498 19.6 12.005 19.6C16.205 19.6 19.605 16.2 19.605 12Z" fill="black"/>
			</svg>
			',

			'info_circle'                         => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.465 17.56C11.305 17.56 11.145 17.5 11.025 17.4C10.825 17.24 10.725 16.98 10.785 16.72L11.765 11.72L11.225 12.02C10.885 12.2 10.465 12.1 10.265 11.76C10.085 11.42 10.185 11 10.525 10.8L12.385 9.73999C12.625 9.59999 12.925 9.62 13.145 9.78C13.365 9.94 13.465 10.22 13.425 10.48L12.405 15.66L13.245 15.3C13.605 15.14 14.005 15.3 14.165 15.66C14.325 16.02 14.165 16.42 13.805 16.58L11.745 17.48C11.665 17.54 11.565 17.56 11.465 17.56ZM13.445 8C13.625 7.82 13.745 7.56 13.745 7.3C13.745 7.04 13.645 6.78 13.445 6.6C13.265 6.42 13.005 6.3 12.745 6.3C12.485 6.3 12.225 6.4 12.045 6.6C11.865 6.78 11.745 7.04 11.745 7.3C11.745 7.56 11.845 7.82 12.045 8C12.225 8.18 12.485 8.3 12.745 8.3C13.005 8.3 13.265 8.2 13.445 8ZM21.205 12C21.205 6.92 17.085 2.8 12.005 2.8C6.92498 2.8 2.80498 6.92 2.80498 12C2.80498 17.08 6.92498 21.2 12.005 21.2C17.085 21.2 21.205 17.08 21.205 12ZM19.605 12C19.605 16.2 16.205 19.6 12.005 19.6C7.80498 19.6 4.40498 16.2 4.40498 12C4.40498 7.8 7.80498 4.4 12.005 4.4C16.205 4.4 19.605 7.8 19.605 12Z" fill="black"/>
			</svg>
			',

			'plus'                                => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M20.3125 8.59375H13.2812V1.5625C13.2812 0.699707 12.5815 0 11.7188 0H10.1562C9.29346 0 8.59375 0.699707 8.59375 1.5625V8.59375H1.5625C0.699707 8.59375 0 9.29346 0 10.1562V11.7188C0 12.5815 0.699707 13.2812 1.5625 13.2812H8.59375V20.3125C8.59375 21.1753 9.29346 21.875 10.1562 21.875H11.7188C12.5815 21.875 13.2812 21.1753 13.2812 20.3125V13.2812H20.3125C21.1753 13.2812 21.875 12.5815 21.875 11.7188V10.1562C21.875 9.29346 21.1753 8.59375 20.3125 8.59375Z" fill="black"/>
            </svg>',

			'plus_light'                          => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.3051 12.1C17.3051 12.6 16.9051 13 16.4051 13H12.8051V16.4C12.8051 16.9 12.4051 17.3 11.9051 17.3C11.4051 17.3 11.0051 16.9 11.0051 16.4V13H7.60511C7.10511 13 6.70511 12.6 6.70511 12.1C6.70511 11.6 7.10511 11.2 7.60511 11.2H11.0051V7.6C11.0051 7.1 11.4051 6.7 11.9051 6.7C12.4051 6.7 12.8051 7.1 12.8051 7.6V11.2H16.4051C16.9051 11.2 17.3051 11.6 17.3051 12.1Z" fill="black"/>
			</svg>
			',

			'minus'                               => '<svg width="16" height="16" viewBox="0 0 22 5" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M20.3125 0H1.5625C0.699707 0 0 0.699707 0 1.5625V3.125C0 3.98779 0.699707 4.6875 1.5625 4.6875H20.3125C21.1753 4.6875 21.875 3.98779 21.875 3.125V1.5625C21.875 0.699707 21.1753 0 20.3125 0Z" fill="black"/>
            </svg>',

			'call'                                => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.2866 17.6656L18.8179 15.3218C18.5843 15.2223 18.3246 15.2013 18.078 15.262C17.8315 15.3228 17.6113 15.462 17.4507 15.6587L15.0288 18.6177C11.2279 16.8256 8.16904 13.7668 6.37695 9.96587L9.33594 7.54399C9.53305 7.38368 9.67256 7.16351 9.73335 6.91682C9.79414 6.67013 9.7729 6.41035 9.67285 6.1768L7.3291 0.708053C7.21929 0.4563 7.02508 0.250751 6.77996 0.126852C6.53483 0.00295173 6.25416 -0.0315334 5.98633 0.0293424L0.908203 1.20122C0.649985 1.26085 0.419602 1.40624 0.254656 1.61366C0.0897096 1.82109 -5.94829e-05 2.07829 2.95713e-08 2.34331C2.95713e-08 14.8677 10.1514 24.9996 22.6562 24.9996C22.9213 24.9997 23.1787 24.91 23.3862 24.7451C23.5937 24.5801 23.7392 24.3497 23.7988 24.0914L24.9707 19.0132C25.0312 18.7441 24.996 18.4623 24.8711 18.2163C24.7463 17.9704 24.5396 17.7756 24.2866 17.6656Z" fill="black"/>
            </svg>',

			'location'                            => '<svg width="16" height="16" viewBox="0 0 19 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M8.41152 24.4956C1.31689 14.2105 0 13.1549 0 9.375C0 4.19731 4.19731 0 9.375 0C14.5527 0 18.75 4.19731 18.75 9.375C18.75 13.1549 17.4331 14.2105 10.3385 24.4956C9.8729 25.1682 8.87705 25.1681 8.41152 24.4956ZM9.375 13.2812C11.5324 13.2812 13.2812 11.5324 13.2812 9.375C13.2812 7.21763 11.5324 5.46875 9.375 5.46875C7.21763 5.46875 5.46875 7.21763 5.46875 9.375C5.46875 11.5324 7.21763 13.2812 9.375 13.2812Z" fill="black"/>
            </svg>',

			'location_gps'                        => '<svg width="16" height="16" viewBox="0 0 18 17" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M8.25059 16.7125V15.2125C6.68809 15.0375 5.34746 14.3906 4.22871 13.2719C3.10996 12.1531 2.46309 10.8125 2.28809 9.24998H0.788086V7.74998H2.28809C2.46309 6.18748 3.10996 4.84685 4.22871 3.7281C5.34746 2.60935 6.68809 1.96248 8.25059 1.78748V0.287476H9.75059V1.78748C11.3131 1.96248 12.6537 2.60935 13.7725 3.7281C14.8912 4.84685 15.5381 6.18748 15.7131 7.74998H17.2131V9.24998H15.7131C15.5381 10.8125 14.8912 12.1531 13.7725 13.2719C12.6537 14.3906 11.3131 15.0375 9.75059 15.2125V16.7125H8.25059ZM9.00059 13.75C10.4506 13.75 11.6881 13.2375 12.7131 12.2125C13.7381 11.1875 14.2506 9.94998 14.2506 8.49998C14.2506 7.04998 13.7381 5.81248 12.7131 4.78748C11.6881 3.76248 10.4506 3.24998 9.00059 3.24998C7.55059 3.24998 6.31309 3.76248 5.28809 4.78748C4.26309 5.81248 3.75059 7.04998 3.75059 8.49998C3.75059 9.94998 4.26309 11.1875 5.28809 12.2125C6.31309 13.2375 7.55059 13.75 9.00059 13.75ZM9.00059 11.5C8.17559 11.5 7.46934 11.2062 6.88184 10.6187C6.29434 10.0312 6.00059 9.32498 6.00059 8.49998C6.00059 7.67498 6.29434 6.96873 6.88184 6.38123C7.46934 5.79373 8.17559 5.49998 9.00059 5.49998C9.82559 5.49998 10.5318 5.79373 11.1193 6.38123C11.7068 6.96873 12.0006 7.67498 12.0006 8.49998C12.0006 9.32498 11.7068 10.0312 11.1193 10.6187C10.5318 11.2062 9.82559 11.5 9.00059 11.5Z" fill="black"/>
			</svg>
			',

			'email'                               => '<svg width="16" height="16" viewBox="0 0 25 19" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.5264 6.19141C24.7168 6.04004 25 6.18164 25 6.4209V16.4062C25 17.7002 23.9502 18.75 22.6562 18.75H2.34375C1.0498 18.75 0 17.7002 0 16.4062V6.42578C0 6.18164 0.27832 6.04492 0.473633 6.19629C1.56738 7.0459 3.01758 8.125 7.99805 11.7432C9.02832 12.4951 10.7666 14.0771 12.5 14.0674C14.2432 14.082 16.0156 12.4658 17.0068 11.7432C21.9873 8.125 23.4326 7.04102 24.5264 6.19141ZM12.5 12.5C13.6328 12.5195 15.2637 11.0742 16.084 10.4785C22.5635 5.77637 23.0566 5.36621 24.5508 4.19434C24.834 3.97461 25 3.63281 25 3.27148V2.34375C25 1.0498 23.9502 0 22.6562 0H2.34375C1.0498 0 0 1.0498 0 2.34375V3.27148C0 3.63281 0.166016 3.96973 0.449219 4.19434C1.94336 5.36133 2.43652 5.77637 8.91602 10.4785C9.73633 11.0742 11.3672 12.5195 12.5 12.5Z" fill="black"/>
            </svg>',

			'email_light'                         => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M21.12 7.36C21.12 7.34 21.12 7.3 21.12 7.28C21.12 7.26 21.12 7.23999 21.12 7.21999C21.12 7.19999 21.1 7.18001 21.1 7.14001C21.1 7.12001 21.08 7.08 21.08 7.06C21.08 7.04 21.06 7.01999 21.04 6.99999C21.02 6.97999 21.02 6.93999 21 6.91999V6.89999C20.98 6.87999 20.98 6.88 20.96 6.86C20.94 6.84 20.92 6.81999 20.9 6.79999C20.88 6.77999 20.86 6.76 20.84 6.76C20.82 6.74 20.8 6.71999 20.78 6.71999C20.76 6.69999 20.74 6.7 20.72 6.68C20.7 6.66 20.68 6.66001 20.66 6.64001C20.64 6.64001 20.6 6.61999 20.58 6.61999C20.56 6.61999 20.54 6.59999 20.5 6.59999C20.48 6.59999 20.44 6.59999 20.42 6.59999C20.4 6.59999 20.38 6.59999 20.36 6.59999H3.55999C3.53999 6.59999 3.52001 6.59999 3.50001 6.59999C3.48001 6.59999 3.44 6.59999 3.42 6.59999C3.4 6.59999 3.38 6.61999 3.34 6.61999C3.32 6.61999 3.27999 6.64001 3.25999 6.64001C3.23999 6.64001 3.22001 6.66 3.20001 6.68C3.18001 6.7 3.16 6.69999 3.14 6.71999C3.12 6.73999 3.10001 6.74 3.08001 6.76C3.06001 6.78 3.04 6.79999 3.02 6.79999C3 6.81999 2.97999 6.84 2.95999 6.86C2.93999 6.88 2.94 6.87999 2.92 6.89999V6.91999C2.9 6.93999 2.88001 6.97999 2.88001 6.99999C2.86001 7.01999 2.86 7.04 2.84 7.06C2.82 7.08 2.82 7.10001 2.82 7.14001C2.82 7.16001 2.80001 7.17999 2.80001 7.21999C2.80001 7.23999 2.80001 7.26 2.80001 7.28C2.80001 7.3 2.80001 7.34 2.80001 7.36V7.38V16.58C2.80001 17.02 3.16001 17.38 3.60001 17.38H20.4C20.84 17.38 21.2 17.02 21.2 16.58L21.12 7.36C21.12 7.36 21.12 7.38 21.12 7.36ZM17.9 8.18L11.92 12.62L5.94 8.18H17.9ZM4.32 15.78V8.98L11.44 14.26C11.58 14.36 11.74 14.42 11.92 14.42C12.1 14.42 12.26 14.36 12.4 14.26L19.52 8.98V15.78H4.32Z" fill="black"/>
			</svg>
			',

			'drafts'                              => '<svg width="16" height="16" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M8.66732 0.833313L16.209 5.33331C16.459 5.48609 16.6534 5.69442 16.7923 5.95831C16.9312 6.2222 17.0007 6.49998 17.0007 6.79165V15.8333C17.0007 16.2916 16.8375 16.684 16.5111 17.0104C16.1847 17.3368 15.7923 17.5 15.334 17.5H2.00065C1.54232 17.5 1.14996 17.3368 0.823568 17.0104C0.497179 16.684 0.333984 16.2916 0.333984 15.8333V6.79165C0.333984 6.49998 0.403429 6.2222 0.542318 5.95831C0.681207 5.69442 0.875651 5.48609 1.12565 5.33331L8.66732 0.833313ZM8.66732 10.5416L15.1673 6.66665L8.66732 2.79165L2.16732 6.66665L8.66732 10.5416Z" fill="black"/>
			</svg>
			',

			'hour_glass'                          => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M18.4051 19.2H17.6051V17.1C17.6051 15.94 16.4451 14.96 15.3251 14C14.9451 13.68 14.4051 13.18 14.2051 12.96V11.02C14.4051 10.8 14.9451 10.3 15.3251 9.97998C16.4451 9.03998 17.6051 8.05998 17.6051 6.87998V4.8H18.4051C18.8451 4.8 19.2051 4.44 19.2051 4C19.2051 3.56 18.8451 3.2 18.4051 3.2H5.60511C5.16511 3.2 4.80511 3.56 4.80511 4C4.80511 4.44 5.16511 4.8 5.60511 4.8H6.40511V6.9C6.40511 8.06 7.56511 9.04 8.68511 10C9.06511 10.32 9.60511 10.82 9.80511 11.04V12.98C9.60511 13.2 9.06511 13.7 8.68511 14.02C7.56511 14.96 6.40511 15.94 6.40511 17.12V19.22H5.60511C5.16511 19.22 4.80511 19.58 4.80511 20.02C4.80511 20.46 5.16511 20.82 5.60511 20.82H18.4051C18.8451 20.82 19.2051 20.46 19.2051 20.02C19.2051 19.58 18.8451 19.2 18.4051 19.2ZM8.00511 17.1C8.00511 16.68 9.12512 15.72 9.72512 15.22C10.6851 14.4 11.4051 13.8 11.4051 13.04V10.94C11.4051 10.18 10.6851 9.58001 9.72512 8.76001C9.12512 8.26001 8.00511 7.31998 8.00511 6.87998V4.8H16.0051V6.9C16.0051 7.32 14.8851 8.27998 14.2851 8.77998C13.3251 9.59998 12.6051 10.2 12.6051 10.96V13.06C12.6051 13.82 13.3251 14.42 14.2851 15.24C14.8851 15.74 16.0051 16.68 16.0051 17.12V19.22H8.00511V17.1ZM13.8051 6.6V6.2C13.8051 5.82 14.1251 5.5 14.5051 5.5C14.8851 5.5 15.2051 5.82 15.2051 6.2V6.6C15.2051 6.98 14.8851 7.3 14.5051 7.3C14.1251 7.3 13.8051 6.98 13.8051 6.6Z" fill="black"/>
			</svg>
			',

			'bank_light'                          => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0.333344 12.3333H13.6667V13.6667H0.333344V12.3333ZM1.66668 7H3.00001V11.6667H1.66668V7ZM5.00001 7H6.33334V11.6667H5.00001V7ZM7.66668 7H9.00001V11.6667H7.66668V7ZM11 7H12.3333V11.6667H11V7ZM0.333344 3.66667L7.00001 0.333336L13.6667 3.66667V6.33334H0.333344V3.66667ZM1.66668 4.49067V5H12.3333V4.49067L7.00001 1.824L1.66668 4.49067ZM7.00001 4.33334C6.8232 4.33334 6.65363 4.2631 6.52861 4.13807C6.40358 4.01305 6.33334 3.84348 6.33334 3.66667C6.33334 3.48986 6.40358 3.32029 6.52861 3.19526C6.65363 3.07024 6.8232 3 7.00001 3C7.17682 3 7.34639 3.07024 7.47141 3.19526C7.59644 3.32029 7.66668 3.48986 7.66668 3.66667C7.66668 3.84348 7.59644 4.01305 7.47141 4.13807C7.34639 4.2631 7.17682 4.33334 7.00001 4.33334Z" fill="black"/>
			</svg>
			',

			'bank_dark'                           => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0 12H13.3333V13.3333H0V12ZM1.33333 6.66667H2.66667V11.3333H1.33333V6.66667ZM4.66667 6.66667H6V11.3333H4.66667V6.66667ZM7.33333 6.66667H8.66667V11.3333H7.33333V6.66667ZM10.6667 6.66667H12V11.3333H10.6667V6.66667ZM0 3.33333L6.66667 0L13.3333 3.33333V6H0V3.33333ZM6.66667 4C6.84348 4 7.01305 3.92976 7.13807 3.80474C7.2631 3.67971 7.33333 3.51014 7.33333 3.33333C7.33333 3.15652 7.2631 2.98695 7.13807 2.86193C7.01305 2.7369 6.84348 2.66667 6.66667 2.66667C6.48986 2.66667 6.32029 2.7369 6.19526 2.86193C6.07024 2.98695 6 3.15652 6 3.33333C6 3.51014 6.07024 3.67971 6.19526 3.80474C6.32029 3.92976 6.48986 4 6.66667 4Z" fill="black"/>
			</svg>
			',

			'check'                               => '<svg width="16" height="16" viewBox="0 0 25 19" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M8.4911 18.2766L0.366101 10.1516C-0.122034 9.66351 -0.122034 8.87206 0.366101 8.38387L2.13383 6.6161C2.62196 6.12792 3.41346 6.12792 3.9016 6.6161L9.37499 12.0894L21.0984 0.366101C21.5865 -0.122034 22.378 -0.122034 22.8662 0.366101L24.6339 2.13387C25.122 2.62201 25.122 3.41346 24.6339 3.90165L10.2589 18.2767C9.77069 18.7648 8.97924 18.7648 8.4911 18.2766Z" fill="black"/>
            </svg>',

			'check_light'                         => '<svg width="12" height="9" viewBox="0 0 12 9" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M4.66668 7.11333L10.7947 0.986L11.7373 1.92867L4.66668 8.99933L0.424011 4.75667L1.36668 3.814L4.66668 7.11333Z" fill="black"/>
			</svg>
			',

			'check_circle' => '<svg width="16" height="16" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.0822 2.52272e-05C20.2172 0.00323084 26 5.78801 26 12.9235C26 16.4893 24.5558 19.7179 22.2204 22.0561L22.2205 22.056C19.8671 24.491 16.5718 26.0028 12.9234 26.0028C5.78601 26.0028 0 20.2168 0 13.0794C0 9.43244 1.51063 6.13833 3.94031 3.78863L3.94392 3.78515C6.26963 1.447 9.48928 0 13.0469 0H13.0841H13.0822L13.0822 2.52272e-05ZM13.0822 24.1238C19.268 24.1238 24.2825 19.1092 24.2825 12.9235C24.2825 6.7377 19.268 1.72316 13.0822 1.72316C6.89644 1.72316 1.8819 6.7377 1.8819 12.9235C1.88909 19.1063 6.89932 24.1166 13.0815 24.1238H13.0822ZM10.8881 18.5305L5.89101 13.5323L7.10872 12.3146L10.8881 16.094L19.0558 7.9264L20.2734 9.14408L10.8881 18.5305Z" fill="black"/>
			</svg>
			',

			'user'                                => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M12.5 14.0625C16.3818 14.0625 19.5312 10.9131 19.5312 7.03125C19.5312 3.14941 16.3818 0 12.5 0C8.61816 0 5.46875 3.14941 5.46875 7.03125C5.46875 10.9131 8.61816 14.0625 12.5 14.0625ZM18.75 15.625H16.0596C14.9756 16.123 13.7695 16.4062 12.5 16.4062C11.2305 16.4062 10.0293 16.123 8.94043 15.625H6.25C2.79785 15.625 0 18.4229 0 21.875V22.6562C0 23.9502 1.0498 25 2.34375 25H22.6562C23.9502 25 25 23.9502 25 22.6562V21.875C25 18.4229 22.2021 15.625 18.75 15.625Z" fill="black"/>
            </svg>',

			'user_variation_two'                  => '<svg width="16" height="16" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.63053 0.333333L12.9639 3.66667V13.0053C12.9637 13.1808 12.8939 13.349 12.7697 13.473C12.6456 13.597 12.4773 13.6667 12.3019 13.6667H1.62587C1.45079 13.6654 1.28321 13.5954 1.15935 13.4717C1.03548 13.3479 0.965264 13.1804 0.963867 13.0053V0.994667C0.963867 0.629333 1.26053 0.333333 1.62587 0.333333H9.63053ZM6.96387 6.66667C7.40589 6.66667 7.82982 6.49107 8.14238 6.17851C8.45494 5.86595 8.63053 5.44203 8.63053 5C8.63053 4.55797 8.45494 4.13405 8.14238 3.82149C7.82982 3.50893 7.40589 3.33333 6.96387 3.33333C6.52184 3.33333 6.09792 3.50893 5.78536 3.82149C5.4728 4.13405 5.2972 4.55797 5.2972 5C5.2972 5.44203 5.4728 5.86595 5.78536 6.17851C6.09792 6.49107 6.52184 6.66667 6.96387 6.66667ZM3.98187 10.3333H9.94587C9.86505 9.59893 9.51608 8.92018 8.96581 8.42715C8.41555 7.93411 7.7027 7.66147 6.96387 7.66147C6.22503 7.66147 5.51218 7.93411 4.96192 8.42715C4.41166 8.92018 4.06268 9.59893 3.98187 10.3333Z" fill="black"/>
			</svg>
			',

			'user_variation_three'                => '<svg width="16" height="16" viewBox="0 0 12 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.2972 14.6667H9.96383V13.3333C9.96383 12.8029 9.75311 12.2942 9.37804 11.9191C9.00297 11.544 8.49426 11.3333 7.96383 11.3333H3.96383C3.43339 11.3333 2.92469 11.544 2.54961 11.9191C2.17454 12.2942 1.96383 12.8029 1.96383 13.3333V14.6667H0.630493V13.3333C0.630493 12.4493 0.981683 11.6014 1.6068 10.9763C2.23193 10.3512 3.07977 10 3.96383 10H7.96383C8.84788 10 9.69573 10.3512 10.3208 10.9763C10.946 11.6014 11.2972 12.4493 11.2972 13.3333V14.6667ZM5.96383 8.66667C5.43854 8.66667 4.9184 8.5632 4.43309 8.36218C3.94779 8.16117 3.50683 7.86653 3.1354 7.49509C2.76396 7.12366 2.46933 6.6827 2.26831 6.1974C2.06729 5.7121 1.96383 5.19195 1.96383 4.66667C1.96383 4.14138 2.06729 3.62124 2.26831 3.13593C2.46933 2.65063 2.76396 2.20967 3.1354 1.83824C3.50683 1.4668 3.94779 1.17217 4.43309 0.971148C4.9184 0.770129 5.43854 0.666666 5.96383 0.666666C7.02469 0.666666 8.04211 1.08809 8.79225 1.83824C9.5424 2.58838 9.96383 3.6058 9.96383 4.66667C9.96383 5.72753 9.5424 6.74495 8.79225 7.49509C8.04211 8.24524 7.02469 8.66667 5.96383 8.66667ZM5.96383 7.33333C6.67107 7.33333 7.34935 7.05238 7.84944 6.55228C8.34954 6.05219 8.63049 5.37391 8.63049 4.66667C8.63049 3.95942 8.34954 3.28115 7.84944 2.78105C7.34935 2.28095 6.67107 2 5.96383 2C5.25658 2 4.57831 2.28095 4.07821 2.78105C3.57811 3.28115 3.29716 3.95942 3.29716 4.66667C3.29716 5.37391 3.57811 6.05219 4.07821 6.55228C4.57831 7.05238 5.25658 7.33333 5.96383 7.33333Z" fill="black"/>
			</svg>
			',

			'user_variation_four'                 => '<svg width="16" height="16" viewBox="0 0 12 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.2972 14.6667H0.630493V13.3333C0.630493 12.4493 0.981683 11.6014 1.6068 10.9763C2.23193 10.3512 3.07977 10 3.96383 10H7.96383C8.84788 10 9.69573 10.3512 10.3208 10.9763C10.946 11.6014 11.2972 12.4493 11.2972 13.3333V14.6667ZM5.96383 8.66667C5.43854 8.66667 4.9184 8.5632 4.43309 8.36218C3.94779 8.16117 3.50683 7.86653 3.1354 7.49509C2.76396 7.12366 2.46933 6.6827 2.26831 6.1974C2.06729 5.7121 1.96383 5.19195 1.96383 4.66667C1.96383 4.14138 2.06729 3.62124 2.26831 3.13593C2.46933 2.65063 2.76396 2.20967 3.1354 1.83824C3.50683 1.4668 3.94779 1.17217 4.43309 0.971148C4.9184 0.770129 5.43854 0.666666 5.96383 0.666666C7.02469 0.666666 8.04211 1.08809 8.79225 1.83824C9.5424 2.58838 9.96383 3.6058 9.96383 4.66667C9.96383 5.72753 9.5424 6.74495 8.79225 7.49509C8.04211 8.24524 7.02469 8.66667 5.96383 8.66667Z" fill="black"/>
			</svg>
			',

			'user_variation_five'                 => '<svg width="16" height="16" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.89053 10.026C1.96484 9.3732 1.27102 8.44263 0.909615 7.36912C0.548206 6.2956 0.53797 5.1349 0.880391 4.05518C1.22281 2.97545 1.9001 2.03279 2.81414 1.36377C3.72817 0.694747 4.83147 0.33411 5.96419 0.33411C7.09691 0.33411 8.20021 0.694747 9.11425 1.36377C10.0283 2.03279 10.7056 2.97545 11.048 4.05518C11.3904 5.1349 11.3802 6.2956 11.0188 7.36912C10.6574 8.44263 9.96355 9.3732 9.03786 10.026L10.4265 13.1993C10.4488 13.2501 10.4581 13.3057 10.4535 13.361C10.4489 13.4163 10.4306 13.4695 10.4002 13.5159C10.3698 13.5623 10.3283 13.6004 10.2795 13.6268C10.2306 13.6531 10.176 13.6668 10.1205 13.6667H1.80719C1.7518 13.6667 1.69727 13.653 1.64851 13.6267C1.59976 13.6005 1.55832 13.5624 1.52795 13.5161C1.49757 13.4698 1.47922 13.4166 1.47455 13.3614C1.46988 13.3063 1.47904 13.2508 1.50119 13.2L2.89053 10.026ZM7.38053 9.564L8.26853 8.93667C8.96301 8.44721 9.4836 7.74932 9.75486 6.94415C10.0261 6.13898 10.0339 5.26836 9.77721 4.45844C9.52048 3.64852 9.01253 2.94139 8.32696 2.43951C7.64139 1.93764 6.81383 1.6671 5.96419 1.6671C5.11456 1.6671 4.28699 1.93764 3.60143 2.43951C2.91586 2.94139 2.4079 3.64852 2.15117 4.45844C1.89444 5.26836 1.90227 6.13898 2.17353 6.94415C2.44478 7.74932 2.96538 8.44721 3.65986 8.93667L4.54719 9.564L3.33586 12.3333H8.59186L7.38053 9.564ZM3.37653 6.31333L4.66986 5.99C4.74163 6.27891 4.90803 6.53549 5.14253 6.71887C5.37704 6.90224 5.66617 7.00187 5.96386 7.00187C6.26155 7.00187 6.55068 6.90224 6.78519 6.71887C7.01969 6.53549 7.18609 6.27891 7.25786 5.99L8.55119 6.31333C8.40616 6.88966 8.07286 7.40107 7.60415 7.76644C7.13544 8.13181 6.55815 8.33023 5.96386 8.33023C5.36956 8.33023 4.79228 8.13181 4.32357 7.76644C3.85486 7.40107 3.52156 6.88966 3.37653 6.31333Z" fill="black"/>
			</svg>
			',

			'user_variation_six'                  => '<svg width="16" height="16" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.89053 10.026C1.96484 9.3732 1.27102 8.44263 0.909615 7.36912C0.548206 6.2956 0.53797 5.1349 0.880391 4.05518C1.22281 2.97545 1.9001 2.03279 2.81414 1.36377C3.72817 0.694747 4.83147 0.33411 5.96419 0.33411C7.09691 0.33411 8.20021 0.694747 9.11425 1.36377C10.0283 2.03279 10.7056 2.97545 11.048 4.05518C11.3904 5.1349 11.3802 6.2956 11.0188 7.36912C10.6574 8.44263 9.96355 9.3732 9.03786 10.026L10.4265 13.1993C10.4488 13.2501 10.4581 13.3057 10.4535 13.361C10.4489 13.4163 10.4306 13.4695 10.4002 13.5159C10.3698 13.5623 10.3283 13.6004 10.2795 13.6268C10.2306 13.6531 10.176 13.6668 10.1205 13.6667H1.80719C1.7518 13.6667 1.69727 13.653 1.64851 13.6267C1.59976 13.6005 1.55832 13.5624 1.52795 13.5161C1.49757 13.4698 1.47922 13.4166 1.47455 13.3614C1.46988 13.3063 1.47904 13.2508 1.50119 13.2L2.89053 10.026ZM3.37653 6.31333C3.52132 6.88996 3.85456 7.40171 4.32337 7.76734C4.79217 8.13298 5.36966 8.33156 5.96419 8.33156C6.55872 8.33156 7.13622 8.13298 7.60502 7.76734C8.07382 7.40171 8.40707 6.88996 8.55186 6.31333L7.25786 5.99C7.18609 6.27891 7.01969 6.53549 6.78519 6.71887C6.55068 6.90224 6.26155 7.00187 5.96386 7.00187C5.66617 7.00187 5.37704 6.90224 5.14253 6.71887C4.90803 6.53549 4.74163 6.27891 4.66986 5.99L3.37653 6.31333Z" fill="black"/>
			</svg>
			',

			'user_emoji_variation_one'            => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667ZM6.96391 12.3333C8.3784 12.3333 9.73495 11.7714 10.7351 10.7712C11.7353 9.77104 12.2972 8.41449 12.2972 7C12.2972 5.58551 11.7353 4.22896 10.7351 3.22876C9.73495 2.22857 8.3784 1.66667 6.96391 1.66667C5.54942 1.66667 4.19287 2.22857 3.19267 3.22876C2.19248 4.22896 1.63057 5.58551 1.63057 7C1.63057 8.41449 2.19248 9.77104 3.19267 10.7712C4.19287 11.7714 5.54942 12.3333 6.96391 12.3333ZM3.63057 7H4.96391C4.96391 7.53043 5.17462 8.03914 5.54969 8.41421C5.92477 8.78929 6.43348 9 6.96391 9C7.49434 9 8.00305 8.78929 8.37812 8.41421C8.75319 8.03914 8.96391 7.53043 8.96391 7H10.2972C10.2972 7.88406 9.94605 8.7319 9.32093 9.35702C8.69581 9.98214 7.84796 10.3333 6.96391 10.3333C6.07985 10.3333 5.23201 9.98214 4.60689 9.35702C3.98176 8.7319 3.63057 7.88406 3.63057 7Z" fill="black"/>
			</svg>
			',

			'user_emoji_variation_two'            => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667ZM3.63057 7C3.63057 7.88406 3.98176 8.7319 4.60689 9.35702C5.23201 9.98214 6.07985 10.3333 6.96391 10.3333C7.84796 10.3333 8.69581 9.98214 9.32093 9.35702C9.94605 8.7319 10.2972 7.88406 10.2972 7H8.96391C8.96391 7.53043 8.75319 8.03914 8.37812 8.41421C8.00305 8.78929 7.49434 9 6.96391 9C6.43348 9 5.92477 8.78929 5.54969 8.41421C5.17462 8.03914 4.96391 7.53043 4.96391 7H3.63057Z" fill="black"/>
			</svg>
			',

			'supervised_user_cirlce'              => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M10.1875 21.8221C11.117 20.0625 12.3229 18.871 13.8053 18.2476C15.2876 17.6242 16.5609 17.3125 17.625 17.3125C18.0801 17.3125 18.5188 17.3482 18.9411 17.4195C19.3633 17.4908 19.7772 17.5849 20.1827 17.7019C20.7067 16.9503 21.1406 16.0861 21.4843 15.1094C21.8281 14.1326 22 13.0961 22 12C22 9.2083 21.0312 6.84372 19.0937 4.90622C17.1562 2.96872 14.7916 1.99997 12 1.99997C9.2083 1.99997 6.84372 2.96872 4.90622 4.90622C2.96872 6.84372 1.99997 9.2083 1.99997 12C1.99997 13.0096 2.13979 13.9675 2.41944 14.8738C2.69908 15.78 3.09452 16.6138 3.60575 17.375C4.42785 16.9343 5.2672 16.6054 6.12378 16.3882C6.98035 16.1711 7.86134 16.0625 8.76678 16.0625C9.36132 16.0625 9.93585 16.1118 10.4903 16.2103C11.0448 16.3089 11.552 16.4279 12.0119 16.5673C11.653 16.7692 11.3181 16.9928 11.0072 17.2379C10.6963 17.4831 10.3974 17.7491 10.1106 18.036C9.90863 17.9943 9.69107 17.9675 9.45791 17.9555C9.22472 17.9435 8.99434 17.9374 8.76678 17.9374C8.07582 17.9374 7.39026 18.0184 6.71009 18.1803C6.02993 18.3421 5.38776 18.5849 4.7836 18.9086C5.50637 19.6795 6.32929 20.3109 7.25238 20.8029C8.17546 21.2948 9.15384 21.6346 10.1875 21.8221ZM12.0021 23.8749C10.3596 23.8749 8.81586 23.5633 7.37069 22.9399C5.9255 22.3166 4.6684 21.4707 3.59938 20.4021C2.53033 19.3336 1.68401 18.077 1.06041 16.6325C0.436802 15.188 0.125 13.6445 0.125 12.0021C0.125 10.3596 0.436667 8.81586 1.06 7.37069C1.68333 5.9255 2.52927 4.6684 3.59781 3.59938C4.66638 2.53034 5.92293 1.68401 7.36747 1.06041C8.81199 0.436804 10.3555 0.125 11.9979 0.125C13.6403 0.125 15.1841 0.436668 16.6293 1.06C18.0744 1.68333 19.3315 2.52927 20.4006 3.59781C21.4696 4.66638 22.3159 5.92293 22.9395 7.36747C23.5631 8.81199 23.8749 10.3555 23.8749 11.9979C23.8749 13.6403 23.5633 15.1841 22.9399 16.6293C22.3166 18.0744 21.4707 19.3315 20.4021 20.4006C19.3336 21.4696 18.077 22.3159 16.6325 22.9395C15.188 23.5631 13.6445 23.8749 12.0021 23.8749ZM8.87497 13.5624C7.74676 13.5624 6.78764 13.1674 5.99759 12.3773C5.20753 11.5873 4.8125 10.6282 4.8125 9.49997C4.8125 8.37176 5.20753 7.41264 5.99759 6.6226C6.78764 5.83253 7.74676 5.4375 8.87497 5.4375C10.0032 5.4375 10.9623 5.83253 11.7523 6.6226C12.5424 7.41264 12.9374 8.37176 12.9374 9.49997C12.9374 10.6282 12.5424 11.5873 11.7523 12.3773C10.9623 13.1674 10.0032 13.5624 8.87497 13.5624ZM8.87497 11.6875C9.47593 11.6875 9.99076 11.4732 10.4195 11.0445C10.8482 10.6158 11.0625 10.1009 11.0625 9.49997C11.0625 8.89901 10.8482 8.38418 10.4195 7.95547C9.99076 7.52678 9.47593 7.31244 8.87497 7.31244C8.27401 7.31244 7.75918 7.52678 7.33047 7.95547C6.90178 8.38418 6.68744 8.89901 6.68744 9.49997C6.68744 10.1009 6.90178 10.6158 7.33047 11.0445C7.75918 11.4732 8.27401 11.6875 8.87497 11.6875ZM17.625 15.0528C16.7702 15.0528 16.0476 14.7577 15.4574 14.1675C14.8672 13.5773 14.5721 12.8548 14.5721 12C14.5721 11.1452 14.8672 10.4226 15.4574 9.83244C16.0476 9.24221 16.7702 8.9471 17.625 8.9471C18.4798 8.9471 19.2023 9.24221 19.7925 9.83244C20.3827 10.4226 20.6778 11.1452 20.6778 12C20.6778 12.8548 20.3827 13.5773 19.7925 14.1675C19.2023 14.7577 18.4798 15.0528 17.625 15.0528Z" fill="black"/>
			</svg>
			',

			'refresh'                             => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.1851 11.16L17.4251 13.96C17.2651 14.12 17.0651 14.2 16.8451 14.2C16.6251 14.2 16.4251 14.12 16.2651 13.96L13.5051 11.16C13.2051 10.84 13.2051 10.34 13.5051 10.02C13.8251 9.72 14.3251 9.72 14.6451 10.02L16.1851 11.58C15.9851 8.68 13.6051 6.38 10.7051 6.38C7.6651 6.38 5.2051 8.9 5.2051 11.98C5.2051 15.06 7.6651 17.58 10.7051 17.58C11.8251 17.58 12.9051 17.24 13.8051 16.6C14.1651 16.34 14.6651 16.44 14.9251 16.8C15.1851 17.16 15.0851 17.66 14.7251 17.92C13.5451 18.74 12.1451 19.18 10.7051 19.18C6.7851 19.18 3.6051 15.96 3.6051 11.98C3.6051 8 6.7851 4.78 10.7051 4.78C14.3851 4.78 17.4251 7.64 17.7651 11.3L19.0251 10.02C19.3451 9.7 19.8451 9.7 20.1651 10.02C20.4851 10.34 20.4851 10.84 20.1851 11.16Z" fill="black"/>
			</svg>
			',

			'medapp'                              => '<svg width="16" height="16" viewBox="0 0 16 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M5.77637 11.6406C5.94727 11.0303 6.11328 10 6.4209 10C6.82617 10.0879 6.88965 11.1426 7.3291 11.7871C7.55371 10.6396 7.58789 7.63184 8.01758 7.55371C8.45703 7.51953 8.97949 10.8008 9.0918 11.3379C9.5752 11.5381 11.4795 11.6602 11.4795 11.6602C11.5723 12.0166 10.3076 12.0312 9.52637 12.041C9.30176 12.7637 9.2627 13.3936 8.96973 13.4082C8.74023 13.418 8.56934 12.002 8.11523 10.9863L7.65625 14.1846C7.44141 14.8193 6.89941 13.0859 6.58691 12.2656C6.42578 12.2607 3.54004 12.1875 4.2627 11.8848L5.77637 11.6406ZM11.1328 21.875C12.168 21.875 12.168 20.3125 11.1328 20.3125H4.49219C3.45703 20.3125 3.45703 21.875 4.49219 21.875H11.1328ZM9.96094 25C10.9961 25 10.9961 23.4375 9.96094 23.4375H5.66406C4.62891 23.4375 4.62891 25 5.66406 25H9.96094ZM11.6309 18.0908C11.7871 17.168 11.8848 16.3135 12.2119 15.708C12.5977 14.9902 12.998 14.3359 13.3838 13.7061C14.585 11.7334 15.625 10.0342 15.625 7.57812C15.625 3.39844 12.1191 0 7.8125 0C3.50586 0 0 3.39844 0 7.57812C0 10.0293 1.04004 11.7334 2.24121 13.7061C2.62695 14.3359 3.02246 14.9902 3.41309 15.708C3.74023 16.3184 3.83789 17.1631 3.99414 18.0957C4.16504 19.1211 5.75684 18.8623 5.58594 17.8467C5.41016 16.7871 5.3125 15.8594 4.83887 14.9854C3.24707 12.0361 1.61133 10.3174 1.61133 7.57812C1.61133 4.2627 4.39453 1.5625 7.8125 1.5625C11.2305 1.5625 14.0137 4.2627 14.0137 7.57812C14.0137 10.3174 12.3779 12.0361 10.7861 14.9805C10.3125 15.8594 10.2148 16.8066 10.0391 17.8418C9.87305 18.8477 11.4551 19.1309 11.6309 18.0908Z" fill="black"/>
            </svg>',

			'map_pin'                             => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M16.505 4.38001C15.365 3.36001 13.765 2.8 12.025 2.8C10.285 2.8 8.68499 3.36001 7.54499 4.38001C6.16499 5.62001 5.42499 7.48001 5.42499 9.78001C5.42499 14.8 11.205 20.7 11.465 20.94C11.625 21.1 11.825 21.18 12.025 21.18C12.225 21.18 12.445 21.1 12.585 20.94C12.825 20.7 18.625 14.8 18.625 9.78001C18.605 7.48001 17.885 5.62001 16.505 4.38001ZM12.005 19.22C11.465 18.62 10.605 17.62 9.76501 16.42C7.96501 13.86 7.005 11.58 7.005 9.8C7.005 4.8 10.825 4.4 12.005 4.4C16.645 4.4 17.005 8.54 17.005 9.8C17.005 13.32 13.425 17.66 12.005 19.22ZM12.005 6.26C10.245 6.26 8.82499 7.72 8.82499 9.5C8.82499 11.28 10.245 12.74 12.005 12.74C13.765 12.74 15.185 11.28 15.185 9.5C15.185 7.7 13.765 6.26 12.005 6.26ZM12.005 11.32C11.025 11.32 10.225 10.5 10.225 9.48001C10.225 8.46001 11.025 7.64001 12.005 7.64001C12.985 7.64001 13.785 8.46001 13.785 9.48001C13.785 10.5 12.985 11.32 12.005 11.32Z" fill="black"/>
			</svg>
			',

			'chevron_arrow'                       => '<svg width="16" height="16" viewBox="0 0 14 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M10.8737 12.7121C10.9908 12.595 10.9908 12.405 10.8737 12.2879L1.00502 2.41924C0.887867 2.30208 0.887867 2.11213 1.00502 1.99497L1.99497 1.00502C2.11213 0.887867 2.30208 0.887867 2.41924 1.00502L13.7021 12.2879C13.8192 12.405 13.8192 12.595 13.7021 12.7121L2.41924 23.995C2.30208 24.1121 2.11213 24.1121 1.99497 23.995L1.00502 23.005C0.887867 22.8879 0.887868 22.6979 1.00503 22.5808L10.8737 12.7121Z" fill="black"/>
            </svg>',

			'chevron_arrow_right'                 => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M15.405 12C15.405 12.22 15.325 12.42 15.165 12.58L9.96501 17.58C9.80501 17.72 9.605 17.8 9.405 17.8C9.185 17.8 8.985 17.72 8.825 17.56C8.525 17.24 8.52499 16.74 8.84499 16.42L13.445 12L8.84499 7.57999C8.52499 7.27999 8.525 6.76 8.825 6.44C9.125 6.12 9.64501 6.12 9.96501 6.42L15.165 11.42C15.325 11.58 15.405 11.78 15.405 12Z" fill="black"/>
			</svg>
			',

			'chevron_arrow_circle' => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill="black" fill-rule="evenodd" clip-rule="evenodd" d="M12 0C18.627 0 24 5.373 24 12C24 18.627 18.627 24 12 24C5.373 24 0 18.627 0 12C0 5.373 5.373 0 12 0ZM12 1C5.925 1 1 5.925 1 12C1 18.075 5.925 23 12 23C18.075 23 23 18.075 23 12C23 5.925 18.075 1 12 1ZM9.47 7.47C9.76 7.18 10.24 7.18 10.53 7.47L15.06 12L10.53 16.53C10.24 16.82 9.76 16.82 9.47 16.53C9.18 16.24 9.18 15.76 9.47 15.47L13 12L9.47 8.53C9.18 8.24 9.18 7.76 9.47 7.47Z"/>
			</svg>
			',

			'long_arrow'                          => '<svg width="16" height="16" viewBox="0 0 20 10" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M15.1109 1.11091C15.5014 0.720385 16.1346 0.720385 16.5251 1.11091L19.7071 4.29289C20.0976 4.68341 20.0976 5.31658 19.7071 5.7071L16.5251 8.88908C16.1346 9.27961 15.5014 9.27961 15.1109 8.88908C14.7204 8.49856 14.7204 7.86539 15.1109 7.47487L16.5858 6H0.5V4H16.5858L15.1109 2.52512C14.7204 2.1346 14.7204 1.50143 15.1109 1.11091Z" fill="black"/>
            </svg>',

			'arrow_right'                         => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M19.3651 12.56L14.3851 17.56C14.2251 17.72 14.0251 17.8 13.8251 17.8C13.6251 17.8 13.4251 17.72 13.2651 17.56C12.9451 17.24 12.9451 16.74 13.2651 16.42L16.8851 12.78H5.20511C4.76511 12.78 4.40511 12.42 4.40511 11.98C4.40511 11.54 4.76511 11.18 5.20511 11.18H16.8851L13.2651 7.54001C12.9451 7.22001 12.9451 6.72 13.2651 6.4C13.5851 6.08 14.0851 6.08 14.4051 6.4L19.3851 11.4C19.6851 11.74 19.6851 12.26 19.3651 12.56Z" fill="black"/>
			</svg>
			',

			'arrow_right_long'                    => '<svg width="16" height="16" viewBox="0 0 44 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M43.0607 13.0607C43.6464 12.4749 43.6464 11.5251 43.0607 10.9393L33.5147 1.3934C32.9289 0.807611 31.9792 0.807611 31.3934 1.3934C30.8076 1.97919 30.8076 2.92893 31.3934 3.51472L39.8787 12L31.3934 20.4853C30.8076 21.0711 30.8076 22.0208 31.3934 22.6066C31.9792 23.1924 32.9289 23.1924 33.5147 22.6066L43.0607 13.0607ZM0 13.5H42V10.5H0V13.5Z" fill="black"/>
			</svg>
			',

			'arrow_fill'                          => '<svg width="16" height="16" viewBox="0 0 16 24" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M7.42244e-07 0.905071L15.5 12.1316L0 23.9991L7.42244e-07 0.905071Z" fill="black"/>
            </svg>',

			'reset_right'                         => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.6306 7C13.6306 10.682 10.6459 13.6667 6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7C0.297241 3.318 3.28191 0.333333 6.96391 0.333333V1.66667C5.70975 1.66676 4.49574 2.10884 3.53519 2.91522C2.57463 3.7216 1.92898 4.8407 1.71167 6.07588C1.49435 7.31107 1.71929 8.58333 2.34695 9.66913C2.97461 10.7549 3.96484 11.5848 5.14366 12.0129C6.32247 12.4411 7.61447 12.4401 8.79263 12.0102C9.9708 11.5802 10.9598 10.7488 11.5858 9.6621C12.2118 8.57534 12.4348 7.30274 12.2156 6.06788C11.9964 4.83303 11.349 3.71491 10.3872 2.91L8.96391 4.33333V0.333333H12.9639L11.3326 1.96467C12.0546 2.58986 12.6335 3.36317 13.03 4.23203C13.4266 5.10089 13.6314 6.04493 13.6306 7Z" fill="black"/>
			</svg>
			',

			'reset_left'                          => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0.297244 7C0.297244 10.682 3.28191 13.6667 6.96391 13.6667C10.6459 13.6667 13.6306 10.682 13.6306 7C13.6306 3.318 10.6459 0.333333 6.96391 0.333333V1.66667C8.21807 1.66676 9.43208 2.10884 10.3926 2.91522C11.3532 3.7216 11.9988 4.8407 12.2162 6.07588C12.4335 7.31107 12.2085 8.58333 11.5809 9.66913C10.9532 10.7549 9.96298 11.5848 8.78416 12.0129C7.60534 12.4411 6.31335 12.4401 5.13519 12.0102C3.95702 11.5802 2.96806 10.7488 2.34205 9.6621C1.71605 8.57534 1.49305 7.30274 1.71224 6.06788C1.93144 4.83303 2.57879 3.71491 3.54058 2.91L4.96391 4.33333V0.333333H0.963911L2.59458 1.96467C1.8727 2.58992 1.29389 3.36326 0.897479 4.23212C0.501069 5.10097 0.296353 6.04499 0.297244 7Z" fill="black"/>
			</svg>
			',

			'reset_loop_variation_one'            => '<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 1.66667C6.14388 1.66614 5.3348 1.85496 4.59971 2.2184C3.86462 2.58184 3.22336 3.11009 2.72591 3.762L4.29724 5.33333H0.297241V1.33333L1.77657 2.81267C2.4008 2.03782 3.19087 1.41284 4.08861 0.983759C4.98635 0.554676 5.9689 0.332412 6.96391 0.333333C10.6459 0.333333 13.6306 3.318 13.6306 7H12.2972C12.2972 5.58551 11.7353 4.22896 10.7351 3.22876C9.73495 2.22857 8.3784 1.66667 6.96391 1.66667ZM1.63057 7C1.63055 8.11533 1.98018 9.2026 2.63029 10.1089C3.28041 11.0151 4.19828 11.6948 5.25479 12.0522C6.31129 12.4096 7.45327 12.4268 8.52007 12.1014C9.58686 11.776 10.5248 11.1243 11.2019 10.238L9.63057 8.66667H13.6306V12.6667L12.1512 11.1873C11.527 11.9622 10.7369 12.5872 9.83921 13.0162C8.94147 13.4453 7.95892 13.6676 6.96391 13.6667C3.28191 13.6667 0.297241 10.682 0.297241 7H1.63057Z" fill="black"/>
			</svg>
			',

			'reset_loop_variation_two'            => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96391 1.66667C7.83373 1.66591 8.6905 1.87818 9.45936 2.28493C10.2282 2.69167 10.8858 3.28051 11.3746 4H9.63057V5.33333H13.6306V1.33333H12.2972V3C11.677 2.17126 10.8719 1.49867 9.94604 1.03574C9.02017 0.572808 7.99906 0.332296 6.96391 0.333333C3.28191 0.333333 0.297241 3.318 0.297241 7H1.63057C1.63057 5.58551 2.19248 4.22896 3.19267 3.22876C4.19287 2.22857 5.54942 1.66667 6.96391 1.66667ZM12.2972 7C12.2976 8.14068 11.9322 9.25141 11.2547 10.1691C10.5773 11.0868 9.62343 11.7632 8.53325 12.0988C7.44307 12.4345 6.274 12.4117 5.19769 12.034C4.12138 11.6562 3.19453 10.9433 2.55324 10H4.29724V8.66667H0.297241V12.6667H1.63057V11C2.25083 11.8287 3.05591 12.5013 3.98178 12.9643C4.90765 13.4272 5.92876 13.6677 6.96391 13.6667C10.6459 13.6667 13.6306 10.682 13.6306 7H12.2972Z" fill="black"/>
			</svg>
			',

			'appstore'                            => '<svg width="16" height="16" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M19.5312 0H2.34375C1.0498 0 0 1.0498 0 2.34375V19.5312C0 20.8252 1.0498 21.875 2.34375 21.875H19.5312C20.8252 21.875 21.875 20.8252 21.875 19.5312V2.34375C21.875 1.0498 20.8252 0 19.5312 0ZM6.20117 17.2119C5.93262 17.6807 5.33203 17.8369 4.86816 17.5684C4.39941 17.2998 4.24316 16.6992 4.51172 16.2354L5.20996 15.0293C5.99609 14.79 6.64062 14.9756 7.14355 15.5859L6.20117 17.2119ZM12.9834 14.5801H4.10156C3.56445 14.5801 3.125 14.1406 3.125 13.6035C3.125 13.0664 3.56445 12.627 4.10156 12.627H6.5918L9.78516 7.09961L8.78418 5.37109C8.51562 4.90234 8.67676 4.30664 9.14062 4.03809C9.60938 3.76953 10.2051 3.93066 10.4736 4.39453L10.9082 5.14648L11.3428 4.39453C11.6113 3.92578 12.2119 3.76953 12.6758 4.03809C13.1445 4.30664 13.3008 4.90723 13.0322 5.37109L8.84277 12.627H11.875C12.8613 12.627 13.4131 13.7842 12.9834 14.5801ZM17.7734 14.5801H16.3574L17.3145 16.2354C17.583 16.7041 17.4219 17.2998 16.958 17.5684C16.4893 17.8369 15.8936 17.6758 15.625 17.2119C14.0186 14.4336 12.8174 12.3438 12.0117 10.957C11.1963 9.54102 11.7773 8.125 12.3584 7.64648C12.998 8.75488 13.9551 10.415 15.2344 12.627H17.7734C18.3105 12.627 18.75 13.0664 18.75 13.6035C18.75 14.1455 18.3105 14.5801 17.7734 14.5801Z" fill="black"/>
            </svg>',

			'light'                               => '<svg width="16" height="16" viewBox="0 0 18 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M4.69043 22.1851C4.69092 22.4922 4.78174 22.793 4.95215 23.0489L5.78662 24.3033C5.92917 24.5177 6.12252 24.6936 6.34947 24.8152C6.57641 24.9369 6.82991 25.0005 7.0874 25.0005H10.1006C10.3581 25.0005 10.6116 24.9369 10.8385 24.8152C11.0655 24.6936 11.2588 24.5177 11.4014 24.3033L12.2358 23.0489C12.4062 22.793 12.4972 22.4925 12.4976 22.1851L12.4995 20.3125H4.68799L4.69043 22.1851ZM0 8.59379C0 10.7603 0.803223 12.7369 2.12695 14.2471C2.93359 15.1675 4.19531 17.0904 4.67627 18.7124C4.67822 18.7251 4.67969 18.7378 4.68164 18.7505H12.5059C12.5078 18.7378 12.5093 18.7256 12.5112 18.7124C12.9922 17.0904 14.2539 15.1675 15.0605 14.2471C16.3843 12.7369 17.1875 10.7603 17.1875 8.59379C17.1875 3.83842 13.3257 -0.0146068 8.56689 4.16298e-05C3.58594 0.0151783 0 4.05131 0 8.59379ZM8.59375 4.68754C6.43994 4.68754 4.6875 6.43998 4.6875 8.59379C4.6875 9.02543 4.33789 9.37504 3.90625 9.37504C3.47461 9.37504 3.125 9.02543 3.125 8.59379C3.125 5.57817 5.57812 3.12504 8.59375 3.12504C9.02539 3.12504 9.375 3.47465 9.375 3.90629C9.375 4.33793 9.02539 4.68754 8.59375 4.68754Z" fill="black"/>
            </svg>',

			'light_bulb'                          => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M12.0051 2.79999C8.7251 2.79999 6.0051 5.52 6.0051 8.86C6.0051 10.9 6.8051 12.54 8.4051 13.64V15.6C8.4051 15.82 8.5451 16.04 8.7051 16.18C8.8451 16.32 9.06511 16.4 9.26511 16.4C9.28511 16.4 9.32509 16.4 9.34509 16.4L14.8451 15.96C15.2651 15.92 15.6251 15.58 15.6251 15.16V13.66C17.0251 12.64 18.0251 10.88 18.0251 8.86C18.0051 5.52 15.2851 2.79999 12.0051 2.79999ZM14.4051 12.5C14.1451 12.64 14.0051 12.92 14.0051 13.2V14.42L10.0051 14.74V13.2C10.0051 12.92 9.88509 12.66 9.64509 12.5C8.26509 11.7 7.62509 10.5 7.62509 8.86C7.62509 6.4 9.6051 4.39999 12.0051 4.39999C14.4251 4.39999 16.4051 6.4 16.4051 8.86C16.3851 10.46 15.6651 11.82 14.4051 12.5ZM15.5251 17.66C15.5651 18.1 15.2251 18.48 14.7851 18.52L9.32509 18.92C9.30509 18.92 9.28511 18.92 9.26511 18.92C8.84511 18.92 8.50511 18.6 8.46511 18.18C8.42511 17.74 8.7651 17.36 9.2051 17.32L14.6651 16.92C15.1251 16.88 15.5051 17.22 15.5251 17.66ZM13.7851 20.18C13.8251 20.62 13.4851 21 13.0451 21.04L11.0651 21.2C11.0451 21.2 11.0251 21.2 11.0051 21.2C10.5851 21.2 10.2451 20.88 10.2051 20.46C10.1651 20.02 10.5051 19.64 10.9451 19.6L12.9251 19.44C13.3851 19.42 13.7651 19.74 13.7851 20.18ZM15.1851 8.86C15.1451 9.22 14.8451 9.49999 14.4851 9.49999C14.4651 9.49999 14.4451 9.49999 14.4251 9.49999C14.0451 9.45999 13.7651 9.11998 13.8051 8.73998C13.9251 7.59998 12.9251 7.17998 12.8051 7.13998C12.4451 6.99998 12.2651 6.59998 12.3851 6.23998C12.5051 5.87998 12.9051 5.68001 13.2651 5.82001C14.0051 6.06001 15.3651 7.04 15.1851 8.86Z" fill="black"/>
			</svg>
			',

			'deployment_cube'                     => '<svg width="16" height="16" viewBox="0 0 24 26" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M10.75 22.2813V13.7188L3.25 9.375V17.9375L10.75 22.2813ZM13.25 22.2813L20.75 17.9375V9.375L13.25 13.7188V22.2813ZM12 11.5625L19.4062 7.28125L12 3L4.59375 7.28125L12 11.5625ZM2 20.125C1.60417 19.8958 1.29688 19.5938 1.07813 19.2188C0.859375 18.8438 0.75 18.4271 0.75 17.9688V8.03125C0.75 7.57292 0.859375 7.15625 1.07813 6.78125C1.29688 6.40625 1.60417 6.10417 2 5.875L10.75 0.84375C11.1458 0.614583 11.5625 0.5 12 0.5C12.4375 0.5 12.8542 0.614583 13.25 0.84375L22 5.875C22.3958 6.10417 22.7031 6.40625 22.9219 6.78125C23.1406 7.15625 23.25 7.57292 23.25 8.03125V17.9688C23.25 18.4271 23.1406 18.8438 22.9219 19.2188C22.7031 19.5938 22.3958 19.8958 22 20.125L13.25 25.1562C12.8542 25.3854 12.4375 25.5 12 25.5C11.5625 25.5 11.1458 25.3854 10.75 25.1562L2 20.125Z" fill="black"/>
			</svg>
			',

			'bolt'                                => '<svg width="16" height="16" viewBox="0 0 16 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M14.4536 7.8125H8.81888L10.899 1.47461C11.0943 0.732422 10.5327 0 9.76614 0H2.73489C2.14895 0 1.65091 0.43457 1.57278 1.01562L0.0102821 12.7344C-0.0824913 13.4375 0.464384 14.0625 1.17239 14.0625H6.96829L4.71731 23.5596C4.54153 24.3018 5.10794 25 5.85501 25C6.26516 25 6.65579 24.7852 6.87063 24.4141L15.4644 9.57031C15.9185 8.79395 15.357 7.8125 14.4536 7.8125Z" fill="black"/>
            </svg>',

			'calendar_month'                      => '<svg width="16" height="16" viewBox="0 0 16 18" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M7.66699 10.6666C7.43088 10.6666 7.23296 10.5868 7.07324 10.427C6.91352 10.2673 6.83366 10.0694 6.83366 9.83329C6.83366 9.59718 6.91352 9.39927 7.07324 9.23954C7.23296 9.07982 7.43088 8.99996 7.66699 8.99996C7.9031 8.99996 8.10102 9.07982 8.26074 9.23954C8.42046 9.39927 8.50033 9.59718 8.50033 9.83329C8.50033 10.0694 8.42046 10.2673 8.26074 10.427C8.10102 10.5868 7.9031 10.6666 7.66699 10.6666ZM4.33366 10.6666C4.09755 10.6666 3.89963 10.5868 3.73991 10.427C3.58019 10.2673 3.50033 10.0694 3.50033 9.83329C3.50033 9.59718 3.58019 9.39927 3.73991 9.23954C3.89963 9.07982 4.09755 8.99996 4.33366 8.99996C4.56977 8.99996 4.76769 9.07982 4.92741 9.23954C5.08713 9.39927 5.16699 9.59718 5.16699 9.83329C5.16699 10.0694 5.08713 10.2673 4.92741 10.427C4.76769 10.5868 4.56977 10.6666 4.33366 10.6666ZM11.0003 10.6666C10.7642 10.6666 10.5663 10.5868 10.4066 10.427C10.2469 10.2673 10.167 10.0694 10.167 9.83329C10.167 9.59718 10.2469 9.39927 10.4066 9.23954C10.5663 9.07982 10.7642 8.99996 11.0003 8.99996C11.2364 8.99996 11.4344 9.07982 11.5941 9.23954C11.7538 9.39927 11.8337 9.59718 11.8337 9.83329C11.8337 10.0694 11.7538 10.2673 11.5941 10.427C11.4344 10.5868 11.2364 10.6666 11.0003 10.6666ZM7.66699 14C7.43088 14 7.23296 13.9201 7.07324 13.7604C6.91352 13.6007 6.83366 13.4027 6.83366 13.1666C6.83366 12.9305 6.91352 12.7326 7.07324 12.5729C7.23296 12.4132 7.43088 12.3333 7.66699 12.3333C7.9031 12.3333 8.10102 12.4132 8.26074 12.5729C8.42046 12.7326 8.50033 12.9305 8.50033 13.1666C8.50033 13.4027 8.42046 13.6007 8.26074 13.7604C8.10102 13.9201 7.9031 14 7.66699 14ZM4.33366 14C4.09755 14 3.89963 13.9201 3.73991 13.7604C3.58019 13.6007 3.50033 13.4027 3.50033 13.1666C3.50033 12.9305 3.58019 12.7326 3.73991 12.5729C3.89963 12.4132 4.09755 12.3333 4.33366 12.3333C4.56977 12.3333 4.76769 12.4132 4.92741 12.5729C5.08713 12.7326 5.16699 12.9305 5.16699 13.1666C5.16699 13.4027 5.08713 13.6007 4.92741 13.7604C4.76769 13.9201 4.56977 14 4.33366 14ZM11.0003 14C10.7642 14 10.5663 13.9201 10.4066 13.7604C10.2469 13.6007 10.167 13.4027 10.167 13.1666C10.167 12.9305 10.2469 12.7326 10.4066 12.5729C10.5663 12.4132 10.7642 12.3333 11.0003 12.3333C11.2364 12.3333 11.4344 12.4132 11.5941 12.5729C11.7538 12.7326 11.8337 12.9305 11.8337 13.1666C11.8337 13.4027 11.7538 13.6007 11.5941 13.7604C11.4344 13.9201 11.2364 14 11.0003 14ZM1.83366 17.3333C1.37533 17.3333 0.982964 17.1701 0.656576 16.8437C0.330187 16.5173 0.166992 16.125 0.166992 15.6666V3.99996C0.166992 3.54163 0.330187 3.14926 0.656576 2.82288C0.982964 2.49649 1.37533 2.33329 1.83366 2.33329H2.66699V0.666626H4.33366V2.33329H11.0003V0.666626H12.667V2.33329H13.5003C13.9587 2.33329 14.351 2.49649 14.6774 2.82288C15.0038 3.14926 15.167 3.54163 15.167 3.99996V15.6666C15.167 16.125 15.0038 16.5173 14.6774 16.8437C14.351 17.1701 13.9587 17.3333 13.5003 17.3333H1.83366ZM1.83366 15.6666H13.5003V7.33329H1.83366V15.6666Z" fill="black"/>
			</svg>
			',

			'calendar_today'                      => '<svg width="16" height="16" viewBox="0 0 18 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.3077 19.4998C1.80257 19.4998 1.375 19.3248 1.025 18.9748C0.675 18.6248 0.5 18.1973 0.5 17.6921V4.3076C0.5 3.80246 0.675 3.3749 1.025 3.0249C1.375 2.6749 1.80257 2.4999 2.3077 2.4999H3.69232V1.15372C3.69232 0.934505 3.76572 0.751497 3.91252 0.604697C4.05931 0.457913 4.24232 0.384521 4.46155 0.384521C4.68077 0.384521 4.86377 0.457913 5.01057 0.604697C5.15736 0.751497 5.23075 0.934505 5.23075 1.15372V2.4999H12.8076V1.1345C12.8076 0.92168 12.8794 0.74348 13.023 0.599896C13.1666 0.456313 13.3448 0.384521 13.5576 0.384521C13.7704 0.384521 13.9486 0.456313 14.0922 0.599896C14.2358 0.74348 14.3076 0.92168 14.3076 1.1345V2.4999H15.6922C16.1974 2.4999 16.625 2.6749 16.975 3.0249C17.325 3.3749 17.5 3.80246 17.5 4.3076V17.6921C17.5 18.1973 17.325 18.6248 16.975 18.9748C16.625 19.3248 16.1974 19.4998 15.6922 19.4998H2.3077ZM2.3077 17.9999H15.6922C15.7692 17.9999 15.8397 17.9678 15.9038 17.9037C15.9679 17.8396 16 17.7691 16 17.6921V8.3076H1.99997V17.6921C1.99997 17.7691 2.03202 17.8396 2.09612 17.9037C2.16024 17.9678 2.23077 17.9999 2.3077 17.9999ZM1.99997 6.80762H16V4.3076C16 4.23066 15.9679 4.16014 15.9038 4.09602C15.8397 4.03192 15.7692 3.99987 15.6922 3.99987H2.3077C2.23077 3.99987 2.16024 4.03192 2.09612 4.09602C2.03202 4.16014 1.99997 4.23066 1.99997 4.3076V6.80762Z" fill="black"/>
			</svg>
			',

			'pace'                                => '<svg width="16" height="16" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.99998 19.5C8.68581 19.5 7.45082 19.2506 6.295 18.752C5.13917 18.2533 4.13375 17.5765 3.27875 16.7217C2.42375 15.8669 1.74688 14.8616 1.24812 13.706C0.749375 12.5504 0.5 11.3156 0.5 10.0017C0.5 8.68772 0.749334 7.45268 1.248 6.29655C1.74667 5.1404 2.42342 4.13472 3.27825 3.2795C4.1331 2.42427 5.13834 1.74721 6.29398 1.24833C7.44959 0.749443 8.68437 0.5 9.9983 0.5C11.3122 0.5 12.5473 0.749376 13.7034 1.24813C14.8596 1.74688 15.8652 2.42375 16.7205 3.27875C17.5757 4.13375 18.2527 5.13917 18.7516 6.295C19.2505 7.45082 19.5 8.68581 19.5 9.99998C19.5 10.45 19.4717 10.8916 19.4153 11.325C19.3589 11.7583 19.2692 12.1833 19.1461 12.6C18.9641 12.4102 18.7589 12.2478 18.5307 12.1125C18.3025 11.9772 18.0532 11.8827 17.7827 11.8289C17.8583 11.534 17.9134 11.2349 17.9481 10.9317C17.9827 10.6285 18 10.3179 18 9.99998C18 7.76664 17.225 5.87498 15.675 4.32498C14.125 2.77498 12.2333 1.99998 9.99998 1.99998C7.76664 1.99998 5.87498 2.77498 4.32498 4.32498C2.77498 5.87498 1.99998 7.76664 1.99998 9.99998C1.99998 12.2333 2.77498 14.125 4.32498 15.675C5.87498 17.225 7.76664 18 9.99998 18C10.8756 18 11.7089 17.8682 12.4997 17.6047C13.2905 17.3412 14.0175 16.9723 14.6808 16.4981C14.8359 16.7045 15.0176 16.8903 15.2259 17.0557C15.4343 17.2211 15.6602 17.3525 15.9038 17.45C15.0923 18.0948 14.188 18.5977 13.1911 18.9586C12.1941 19.3195 11.1304 19.5 9.99998 19.5ZM17.1063 15.75C16.8264 15.75 16.5897 15.6533 16.3961 15.4601C16.2025 15.2669 16.1058 15.0304 16.1058 14.7505C16.1058 14.4707 16.2024 14.234 16.3956 14.0404C16.5888 13.8468 16.8254 13.75 17.1052 13.75C17.385 13.75 17.6217 13.8466 17.8153 14.0398C18.0089 14.2331 18.1057 14.4696 18.1057 14.7494C18.1057 15.0293 18.0091 15.266 17.8159 15.4596C17.6227 15.6532 17.3861 15.75 17.1063 15.75ZM10.75 9.69613L14 12.9462C14.1384 13.0846 14.2093 13.2586 14.2125 13.4683C14.2157 13.6779 14.1448 13.8551 14 14C13.8551 14.1448 13.6795 14.2173 13.4731 14.2173C13.2667 14.2173 13.091 14.1448 12.9462 14L9.52115 10.575C9.42755 10.4814 9.35896 10.3794 9.31538 10.269C9.27179 10.1587 9.25 10.0446 9.25 9.9269V5.74995C9.25 5.53747 9.3219 5.35935 9.4657 5.2156C9.60952 5.07185 9.78772 4.99998 10.0003 4.99998C10.2129 4.99998 10.391 5.07185 10.5346 5.2156C10.6782 5.35935 10.75 5.53747 10.75 5.74995V9.69613Z" fill="black"/>
			</svg>
			',

			'shopping_bag'                        => '<svg width="16" height="16" viewBox="0 0 12 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.00336 0.666656C6.4411 0.666656 6.87455 0.752876 7.27897 0.920391C7.68339 1.08791 8.05085 1.33344 8.36038 1.64297C8.66991 1.9525 8.91544 2.31996 9.08296 2.72438C9.25047 3.1288 9.33669 3.56225 9.33669 3.99999V5.33332H11.3367C11.5135 5.33332 11.6831 5.40356 11.8081 5.52859C11.9331 5.65361 12.0034 5.82318 12.0034 5.99999V14C12.0034 14.1768 11.9331 14.3464 11.8081 14.4714C11.6831 14.5964 11.5135 14.6667 11.3367 14.6667H0.670024C0.493213 14.6667 0.323643 14.5964 0.198619 14.4714C0.0735948 14.3464 0.00335693 14.1768 0.00335693 14V5.99999C0.00335693 5.82318 0.0735948 5.65361 0.198619 5.52859C0.323643 5.40356 0.493213 5.33332 0.670024 5.33332H2.67002V3.99999C2.67002 3.11593 3.02121 2.26809 3.64633 1.64297C4.27146 1.01785 5.1193 0.666656 6.00336 0.666656ZM9.33669 7.33332H8.00336V7.99999C8.00371 8.16985 8.0689 8.33317 8.1856 8.4566C8.30229 8.58003 8.46171 8.65426 8.63129 8.66413C8.80086 8.674 8.96781 8.61877 9.09804 8.50971C9.22827 8.40065 9.31196 8.246 9.33202 8.07732L9.33669 7.99999V7.33332ZM4.00336 7.33332H2.67002V7.99999C2.67038 8.16985 2.73556 8.33317 2.85226 8.4566C2.96896 8.58003 3.12837 8.65426 3.29795 8.66413C3.46753 8.674 3.63448 8.61877 3.76471 8.50971C3.89494 8.40065 3.97863 8.246 3.99869 8.07732L4.00336 7.99999V7.33332ZM6.00336 1.99999C5.49333 1.99995 5.00255 2.19477 4.6314 2.5446C4.26025 2.89444 4.03678 3.37285 4.00669 3.88199L4.00336 3.99999V5.33332H8.00336V3.99999C8.00339 3.48985 7.80847 2.99898 7.4585 2.62782C7.10853 2.25665 6.62995 2.03325 6.12069 2.00332L6.00336 1.99999Z" fill="black"/>
			</svg>
			',

			'shopping_bag_light'                  => '<svg width="16" height="16" viewBox="0 0 12 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.67002 5.33332V3.99999C2.67002 3.11593 3.02121 2.26809 3.64633 1.64297C4.27146 1.01785 5.1193 0.666656 6.00336 0.666656C6.88741 0.666656 7.73526 1.01785 8.36038 1.64297C8.9855 2.26809 9.33669 3.11593 9.33669 3.99999V5.33332H11.3367C11.5135 5.33332 11.6831 5.40356 11.8081 5.52859C11.9331 5.65361 12.0034 5.82318 12.0034 5.99999V14C12.0034 14.1768 11.9331 14.3464 11.8081 14.4714C11.6831 14.5964 11.5135 14.6667 11.3367 14.6667H0.670024C0.493213 14.6667 0.323643 14.5964 0.198619 14.4714C0.0735948 14.3464 0.00335693 14.1768 0.00335693 14V5.99999C0.00335693 5.82318 0.0735948 5.65361 0.198619 5.52859C0.323643 5.40356 0.493213 5.33332 0.670024 5.33332H2.67002ZM2.67002 6.66666H1.33669V13.3333H10.67V6.66666H9.33669V7.99999H8.00336V6.66666H4.00336V7.99999H2.67002V6.66666ZM4.00336 5.33332H8.00336V3.99999C8.00336 3.46956 7.79264 2.96085 7.41757 2.58578C7.0425 2.2107 6.53379 1.99999 6.00336 1.99999C5.47292 1.99999 4.96422 2.2107 4.58914 2.58578C4.21407 2.96085 4.00336 3.46956 4.00336 3.99999V5.33332Z" fill="black"/>
			</svg>
			',

			'shopping_cart_bag'                   => '<svg width="16" height="16" viewBox="0 0 12 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M4 3.99999C4 3.46956 4.21071 2.96085 4.58579 2.58578C4.96086 2.2107 5.46957 1.99999 6 1.99999C6.53043 1.99999 7.03914 2.2107 7.41421 2.58578C7.78929 2.96085 8 3.46956 8 3.99999H4ZM2.66667 3.99999H0.666667C0.489856 3.99999 0.320286 4.07023 0.195262 4.19525C0.0702379 4.32028 0 4.48985 0 4.66666V14C0 14.1768 0.0702379 14.3464 0.195262 14.4714C0.320286 14.5964 0.489856 14.6667 0.666667 14.6667H11.3333C11.5101 14.6667 11.6797 14.5964 11.8047 14.4714C11.9298 14.3464 12 14.1768 12 14V4.66666C12 4.48985 11.9298 4.32028 11.8047 4.19525C11.6797 4.07023 11.5101 3.99999 11.3333 3.99999H9.33333C9.33333 3.11593 8.98214 2.26809 8.35702 1.64297C7.7319 1.01785 6.88406 0.666656 6 0.666656C5.11595 0.666656 4.2681 1.01785 3.64298 1.64297C3.01786 2.26809 2.66667 3.11593 2.66667 3.99999ZM4 6.66666C4 7.19709 4.21071 7.7058 4.58579 8.08087C4.96086 8.45594 5.46957 8.66666 6 8.66666C6.53043 8.66666 7.03914 8.45594 7.41421 8.08087C7.78929 7.7058 8 7.19709 8 6.66666H9.33333C9.33333 7.55071 8.98214 8.39856 8.35702 9.02368C7.7319 9.6488 6.88406 9.99999 6 9.99999C5.11595 9.99999 4.2681 9.6488 3.64298 9.02368C3.01786 8.39856 2.66667 7.55071 2.66667 6.66666H4Z" fill="black"/>
			</svg>
			',

			'shopping_cart_bag_light'             => '<svg width="16" height="16" viewBox="0 0 24 27" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M3.25 26.5C2.5625 26.5 1.97396 26.2552 1.48438 25.7656C0.994792 25.276 0.75 24.6875 0.75 24V9C0.75 8.3125 0.994792 7.72396 1.48438 7.23438C1.97396 6.74479 2.5625 6.5 3.25 6.5H5.75C5.75 4.77083 6.35938 3.29688 7.57812 2.07812C8.79688 0.859375 10.2708 0.25 12 0.25C13.7292 0.25 15.2031 0.859375 16.4219 2.07812C17.6406 3.29688 18.25 4.77083 18.25 6.5H20.75C21.4375 6.5 22.026 6.74479 22.5156 7.23438C23.0052 7.72396 23.25 8.3125 23.25 9V24C23.25 24.6875 23.0052 25.276 22.5156 25.7656C22.026 26.2552 21.4375 26.5 20.75 26.5H3.25ZM3.25 24H20.75V9H3.25V24ZM12 16.5C13.7292 16.5 15.2031 15.8906 16.4219 14.6719C17.6406 13.4531 18.25 11.9792 18.25 10.25H15.75C15.75 11.2917 15.3854 12.1771 14.6562 12.9062C13.9271 13.6354 13.0417 14 12 14C10.9583 14 10.0729 13.6354 9.34375 12.9062C8.61458 12.1771 8.25 11.2917 8.25 10.25H5.75C5.75 11.9792 6.35938 13.4531 7.57812 14.6719C8.79688 15.8906 10.2708 16.5 12 16.5ZM8.25 6.5H15.75C15.75 5.45833 15.3854 4.57292 14.6562 3.84375C13.9271 3.11458 13.0417 2.75 12 2.75C10.9583 2.75 10.0729 3.11458 9.34375 3.84375C8.61458 4.57292 8.25 5.45833 8.25 6.5Z" fill="black"/>
			</svg>
			',

			'shopping_cart_bag_variant_one'       => '<svg width="16" height="16" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.5914 13.3333H0.924723C0.747912 13.3333 0.578343 13.2631 0.453319 13.1381C0.328295 13.013 0.258057 12.8435 0.258057 12.6667V0.666667C0.258057 0.489856 0.328295 0.320286 0.453319 0.195262C0.578343 0.0702379 0.747912 0 0.924723 0H11.5914C11.7682 0 11.9378 0.0702379 12.0628 0.195262C12.1878 0.320286 12.2581 0.489856 12.2581 0.666667V12.6667C12.2581 12.8435 12.1878 13.013 12.0628 13.1381C11.9378 13.2631 11.7682 13.3333 11.5914 13.3333ZM4.25806 2.66667H2.92472V4C2.92472 4.88406 3.27591 5.7319 3.90103 6.35702C4.52616 6.98214 5.374 7.33333 6.25806 7.33333C7.14211 7.33333 7.98996 6.98214 8.61508 6.35702C9.2402 5.7319 9.59139 4.88406 9.59139 4V2.66667H8.25806V4C8.25806 4.53043 8.04734 5.03914 7.67227 5.41421C7.2972 5.78929 6.78849 6 6.25806 6C5.72762 6 5.21892 5.78929 4.84384 5.41421C4.46877 5.03914 4.25806 4.53043 4.25806 4V2.66667Z" fill="black"/>
			</svg>
			',

			'shopping_cart_bag_variant_one_light' => '<svg width="16" height="16" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M11.3333 13.3333H0.666667C0.489856 13.3333 0.320286 13.2631 0.195262 13.1381C0.0702379 13.013 0 12.8435 0 12.6667V0.666667C0 0.489856 0.0702379 0.320286 0.195262 0.195262C0.320286 0.0702379 0.489856 0 0.666667 0H11.3333C11.5101 0 11.6797 0.0702379 11.8047 0.195262C11.9298 0.320286 12 0.489856 12 0.666667V12.6667C12 12.8435 11.9298 13.013 11.8047 13.1381C11.6797 13.2631 11.5101 13.3333 11.3333 13.3333ZM10.6667 12V1.33333H1.33333V12H10.6667ZM4 2.66667V4C4 4.53043 4.21071 5.03914 4.58579 5.41421C4.96086 5.78929 5.46957 6 6 6C6.53043 6 7.03914 5.78929 7.41421 5.41421C7.78929 5.03914 8 4.53043 8 4V2.66667H9.33333V4C9.33333 4.88406 8.98214 5.7319 8.35702 6.35702C7.7319 6.98214 6.88406 7.33333 6 7.33333C5.11595 7.33333 4.2681 6.98214 3.64298 6.35702C3.01786 5.7319 2.66667 4.88406 2.66667 4V2.66667H4Z" fill="black"/>
			</svg>
			',

			'shopping_cart_bag_variant_two'       => '<svg width="16" height="16" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.33669 0.333344H9.67002C9.77352 0.333344 9.8756 0.35744 9.96817 0.403725C10.0607 0.45001 10.1413 0.517213 10.2034 0.60001L12.0034 3.00001V13C12.0034 13.1768 11.9331 13.3464 11.8081 13.4714C11.6831 13.5964 11.5135 13.6667 11.3367 13.6667H0.670024C0.493213 13.6667 0.323643 13.5964 0.198619 13.4714C0.0735948 13.3464 0.00335693 13.1768 0.00335693 13V3.00001L1.80336 0.60001C1.86545 0.517213 1.94598 0.45001 2.03855 0.403725C2.13112 0.35744 2.23319 0.333344 2.33669 0.333344ZM10.3367 3.00001L9.33669 1.66668H2.67002L1.67002 3.00001H10.3367ZM4.00336 5.66668H2.67002V7.00001C2.67002 7.88407 3.02121 8.73191 3.64633 9.35703C4.27146 9.98215 5.1193 10.3333 6.00336 10.3333C6.88741 10.3333 7.73526 9.98215 8.36038 9.35703C8.9855 8.73191 9.33669 7.88407 9.33669 7.00001V5.66668H8.00336V7.00001C8.00336 7.53044 7.79264 8.03915 7.41757 8.41422C7.0425 8.7893 6.53379 9.00001 6.00336 9.00001C5.47292 9.00001 4.96422 8.7893 4.58914 8.41422C4.21407 8.03915 4.00336 7.53044 4.00336 7.00001V5.66668Z" fill="black"/>
			</svg>',

			'shopping_cart_bag_variant_two_light' => '<svg width="16" height="16" viewBox="0 0 12 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.33669 0.333344H9.67002C9.77352 0.333344 9.8756 0.35744 9.96817 0.403725C10.0607 0.45001 10.1413 0.517213 10.2034 0.60001L12.0034 3.00001V13C12.0034 13.1768 11.9331 13.3464 11.8081 13.4714C11.6831 13.5964 11.5135 13.6667 11.3367 13.6667H0.670024C0.493213 13.6667 0.323643 13.5964 0.198619 13.4714C0.0735948 13.3464 0.00335693 13.1768 0.00335693 13V3.00001L1.80336 0.60001C1.86545 0.517213 1.94598 0.45001 2.03855 0.403725C2.13112 0.35744 2.23319 0.333344 2.33669 0.333344ZM10.67 4.33334H1.33669V12.3333H10.67V4.33334ZM10.3367 3.00001L9.33669 1.66668H2.67002L1.67002 3.00001H10.3367ZM4.00336 5.66668V7.00001C4.00336 7.53044 4.21407 8.03915 4.58914 8.41422C4.96422 8.7893 5.47292 9.00001 6.00336 9.00001C6.53379 9.00001 7.0425 8.7893 7.41757 8.41422C7.79264 8.03915 8.00336 7.53044 8.00336 7.00001V5.66668H9.33669V7.00001C9.33669 7.88407 8.9855 8.73191 8.36038 9.35703C7.73526 9.98215 6.88741 10.3333 6.00336 10.3333C5.1193 10.3333 4.27146 9.98215 3.64633 9.35703C3.02121 8.73191 2.67002 7.88407 2.67002 7.00001V5.66668H4.00336Z" fill="black"/>
			</svg>
			',

			'basket'                              => '<svg width="16" height="16" viewBox="0 0 25 20" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M25 7.98623V8.68068C25 9.25598 24.5336 9.72235 23.9583 9.72235H23.6111L22.4777 17.6559C22.3311 18.6822 21.4521 19.4446 20.4154 19.4446H4.58464C3.54787 19.4446 2.66888 18.6822 2.52222 17.6559L1.38889 9.72235H1.04167C0.466363 9.72235 0 9.25598 0 8.68068V7.98623C0 7.41093 0.466363 6.94457 1.04167 6.94457H3.96445L8.599 0.572128C9.05017 -0.0481843 9.91875 -0.185381 10.5391 0.265791C11.1595 0.716963 11.2967 1.58558 10.8455 2.20594L7.39918 6.94457H17.6008L14.1545 2.2059C13.7033 1.58558 13.8405 0.71692 14.4609 0.265748C15.0812 -0.185424 15.9499 -0.0482711 16.401 0.572085L21.0355 6.94457H23.9583C24.5336 6.94457 25 7.41093 25 7.98623ZM13.5417 15.6251V10.764C13.5417 10.1887 13.0753 9.72235 12.5 9.72235C11.9247 9.72235 11.4583 10.1887 11.4583 10.764V15.6251C11.4583 16.2004 11.9247 16.6668 12.5 16.6668C13.0753 16.6668 13.5417 16.2004 13.5417 15.6251ZM18.4028 15.6251V10.764C18.4028 10.1887 17.9364 9.72235 17.3611 9.72235C16.7858 9.72235 16.3194 10.1887 16.3194 10.764V15.6251C16.3194 16.2004 16.7858 16.6668 17.3611 16.6668C17.9364 16.6668 18.4028 16.2004 18.4028 15.6251ZM8.68056 15.6251V10.764C8.68056 10.1887 8.21419 9.72235 7.63889 9.72235C7.06358 9.72235 6.59722 10.1887 6.59722 10.764V15.6251C6.59722 16.2004 7.06358 16.6668 7.63889 16.6668C8.21419 16.6668 8.68056 16.2004 8.68056 15.6251Z" fill="black"/>
            </svg>',

			'chart'                               => '<svg width="16" height="16" viewBox="0 0 25 19" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M24.4141 15.625C24.7363 15.625 25 15.8887 25 16.2109V18.1641C25 18.4863 24.7363 18.75 24.4141 18.75H0.585938C0.263672 18.75 0 18.4863 0 18.1641V0.585938C0 0.263672 0.263672 0 0.585938 0H2.53906C2.86133 0 3.125 0.263672 3.125 0.585938V15.625H24.4141ZM18.1982 4.66309L14.0625 7.42188L9.89746 1.87012C9.64844 1.53809 9.14062 1.5625 8.92578 1.91895L4.6875 8.98438V14.0625H23.4375L19.0479 4.89258C18.8916 4.5752 18.4912 4.46777 18.1982 4.66309Z" fill="black"/>
            </svg>',

			'tag_fill'                            => '<svg width="16" height="16" viewBox="0 0 25 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M19.4508 8.82582L11.1742 0.54918C10.8226 0.197548 10.3456 2.6003e-06 9.84836 0H1.875C0.839453 0 0 0.839453 0 1.875V9.84836C2.6003e-06 10.3456 0.197548 10.8226 0.54918 11.1742L8.82582 19.4508C9.55801 20.183 10.7452 20.1831 11.4775 19.4508L19.4508 11.4775C20.183 10.7452 20.183 9.55805 19.4508 8.82582ZM4.375 6.25C3.33945 6.25 2.5 5.41055 2.5 4.375C2.5 3.33945 3.33945 2.5 4.375 2.5C5.41055 2.5 6.25 3.33945 6.25 4.375C6.25 5.41055 5.41055 6.25 4.375 6.25ZM24.4508 11.4775L16.4775 19.4508C15.7452 20.183 14.558 20.183 13.8258 19.4508L13.8118 19.4368L20.6109 12.6376C21.275 11.9736 21.6406 11.0907 21.6406 10.1516C21.6406 9.21258 21.2749 8.32973 20.6109 7.6657L12.9452 0H14.8484C15.3456 2.6003e-06 15.8226 0.197548 16.1742 0.54918L24.4508 8.82582C25.183 9.55805 25.183 10.7452 24.4508 11.4775Z" fill="black"/>
			</svg>',

			'tag'                                 => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.405 6.8H8.60498C8.40498 6.8 8.22498 6.88 8.08498 7L3.08498 11.4C2.90498 11.56 2.80498 11.78 2.80498 12C2.80498 12.24 2.90498 12.44 3.08498 12.6L8.08498 17C8.22498 17.12 8.42498 17.2 8.60498 17.2H20.405C20.845 17.2 21.205 16.84 21.205 16.4V7.6C21.205 7.16 20.845 6.8 20.405 6.8ZM19.605 15.6H8.90498L4.80498 12L8.90498 8.4H19.605V15.6ZM8.24497 11.08C8.48497 10.84 8.82499 10.7 9.16499 10.7C9.50499 10.7 9.84498 10.84 10.085 11.08C10.325 11.32 10.465 11.66 10.465 12C10.465 12.34 10.325 12.68 10.085 12.92C9.84498 13.16 9.50499 13.3 9.16499 13.3C8.82499 13.3 8.48497 13.16 8.24497 12.92C8.00497 12.68 7.86499 12.34 7.86499 12C7.86499 11.66 8.00497 11.32 8.24497 11.08Z" fill="black"/>
			</svg>
			',

			'chat_box'                            => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.4199 9C13.4199 9.35362 13.2794 9.69276 13.0294 9.94281C12.7793 10.1929 12.4402 10.3333 12.0866 10.3333H4.08659L1.41992 13V2.33333C1.41992 1.97971 1.5604 1.64057 1.81045 1.39052C2.06049 1.14048 2.39963 1 2.75326 1H12.0866C12.4402 1 12.7793 1.14048 13.0294 1.39052C13.2794 1.64057 13.4199 1.97971 13.4199 2.33333V9Z" fill="black" />
			</svg>
			',

			'tags'                                => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M17.8451 13.12C17.8451 12.9 17.7651 12.7 17.6051 12.56L10.1451 5.19999C10.0051 5.05999 9.8251 4.98 9.6251 4.98L3.6651 4.59999C3.4251 4.57999 3.2051 4.67998 3.0451 4.83998C2.8851 4.99998 2.8051 5.22 2.8051 5.46L3.1851 11.32C3.2051 11.52 3.2851 11.7 3.4251 11.84L10.9051 19.18C11.0651 19.34 11.2651 19.42 11.4651 19.42C11.6651 19.42 11.8651 19.34 12.0251 19.18L17.6051 13.7C17.7651 13.54 17.8451 13.34 17.8451 13.12ZM11.4651 17.48L4.7651 10.9L4.4651 6.26L9.2251 6.56L15.9051 13.12L11.4651 17.48ZM8.0051 8.03998C8.2251 8.25998 8.3651 8.58 8.3651 8.88C8.3651 9.2 8.2451 9.49999 8.0051 9.71999C7.7851 9.93999 7.4651 10.08 7.1451 10.08C6.8251 10.08 6.5251 9.95999 6.2851 9.71999C6.0651 9.49999 5.9251 9.18 5.9251 8.88C5.9251 8.56 6.0451 8.25998 6.2851 8.03998C6.5051 7.81998 6.8251 7.68 7.1451 7.68C7.4651 7.68 7.7851 7.81998 8.0051 8.03998ZM21.2051 13.12C21.2051 13.3 21.1251 13.48 21.0051 13.62L15.4251 19.1C15.2851 19.24 15.1051 19.3 14.9251 19.3C14.7451 19.3 14.5651 19.24 14.4251 19.1C14.1451 18.82 14.1451 18.38 14.4251 18.12L19.5051 13.14L12.5451 6.29999C12.2651 6.01999 12.2651 5.57999 12.5451 5.31999C12.8251 5.03999 13.2651 5.03999 13.5451 5.31999L21.0251 12.66C21.1251 12.76 21.2051 12.94 21.2051 13.12Z" fill="black"/>
			</svg>
			',

			'times'                               => '<svg width="16" height="16" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M11.8516 8.59375L16.7378 3.70752C17.3374 3.10791 17.3374 2.13574 16.7378 1.53564L15.6519 0.449707C15.0522 -0.149902 14.0801 -0.149902 13.48 0.449707L8.59375 5.33594L3.70752 0.449707C3.10791 -0.149902 2.13574 -0.149902 1.53564 0.449707L0.449707 1.53564C-0.149902 2.13525 -0.149902 3.10742 0.449707 3.70752L5.33594 8.59375L0.449707 13.48C-0.149902 14.0796 -0.149902 15.0518 0.449707 15.6519L1.53564 16.7378C2.13525 17.3374 3.10791 17.3374 3.70752 16.7378L8.59375 11.8516L13.48 16.7378C14.0796 17.3374 15.0522 17.3374 15.6519 16.7378L16.7378 15.6519C17.3374 15.0522 17.3374 14.0801 16.7378 13.48L11.8516 8.59375Z" fill="black"/>
            </svg>',

			'times_light'                         => '<svg width="16" height="16" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M10.9449 9.66003C11.3049 10.02 11.3049 10.58 10.9449 10.94C10.7649 11.12 10.5449 11.2 10.3049 11.2C10.0649 11.2 9.84493 11.12 9.66493 10.94L6.00492 7.28004L2.34491 10.94C2.16491 11.12 1.94492 11.2 1.70492 11.2C1.46492 11.2 1.24493 11.12 1.06493 10.94C0.704932 10.58 0.704932 10.02 1.06493 9.66003L4.72492 6.00004L1.06493 2.34004C0.704932 1.98004 0.704932 1.42004 1.06493 1.06004C1.42493 0.700037 1.98491 0.700037 2.34491 1.06004L6.00492 4.72003L9.66493 1.06004C10.0249 0.700037 10.5849 0.700037 10.9449 1.06004C11.3049 1.42004 11.3049 1.98004 10.9449 2.34004L7.2849 6.00004L10.9449 9.66003Z" fill="black"/>
			</svg>
			',

			'times_circle' => '<svg width="16" height="16" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.0822 2.52272e-05C20.2172 0.00323084 26 5.78801 26 12.9235C26 16.4893 24.5558 19.7179 22.2204 22.0561L22.2205 22.056C19.8671 24.491 16.5718 26.0028 12.9234 26.0028C5.78601 26.0028 0 20.2168 0 13.0794C0 9.43244 1.51063 6.13833 3.94031 3.78864L3.94392 3.78515C6.26963 1.447 9.48928 0 13.0469 0H13.0841H13.0822L13.0822 2.52272e-05ZM13.0822 24.1238C19.268 24.1238 24.2825 19.1092 24.2825 12.9235C24.2825 6.7377 19.268 1.72316 13.0822 1.72316C6.89644 1.72316 1.8819 6.7377 1.8819 12.9235C1.88909 19.1063 6.89932 24.1166 13.0815 24.1238H13.0822ZM8.2115 19.0118L6.9938 17.7942L17.9529 6.83508L19.1706 8.05276L8.2115 19.0118ZM17.9529 19.0118L6.9938 8.05276L8.2115 6.83508L19.1706 17.7942L17.9529 19.0118Z" fill="black"/>
			</svg>
			',

			'bell'                                => '<svg width="16" height="16" viewBox="0 0 22 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M10.9375 25C12.6621 25 14.0611 23.6011 14.0611 21.875H7.814C7.814 23.6011 9.21292 25 10.9375 25ZM21.4546 17.6899C20.5113 16.6763 18.7461 15.1514 18.7461 10.1562C18.7461 6.3623 16.086 3.3252 12.4991 2.58008V1.5625C12.4991 0.699707 11.7998 0 10.9375 0C10.0752 0 9.37601 0.699707 9.37601 1.5625V2.58008C5.7891 3.3252 3.12894 6.3623 3.12894 10.1562C3.12894 15.1514 1.3638 16.6763 0.420444 17.6899C0.127475 18.0049 -0.00240765 18.3813 3.37592e-05 18.75C0.00540485 19.5508 0.633823 20.3125 1.56742 20.3125H20.3077C21.2412 20.3125 21.8702 19.5508 21.875 18.75C21.8775 18.3813 21.7476 18.0044 21.4546 17.6899Z" fill="black"/>
            </svg>',

			'globe'                               => '<svg width="16" height="16" viewBox="0 0 25 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M16.4307 7.42188C15.7227 3.06152 14.0527 0 12.1094 0C10.166 0 8.49609 3.06152 7.78809 7.42188H16.4307ZM7.42188 12.1094C7.42188 13.1934 7.48047 14.2334 7.58301 15.2344H16.6309C16.7334 14.2334 16.792 13.1934 16.792 12.1094C16.792 11.0254 16.7334 9.98535 16.6309 8.98438H7.58301C7.48047 9.98535 7.42188 11.0254 7.42188 12.1094ZM23.2764 7.42188C21.8799 4.10645 19.0527 1.54297 15.5615 0.507812C16.7529 2.1582 17.5732 4.64355 18.0029 7.42188H23.2764ZM8.65234 0.507812C5.16602 1.54297 2.33398 4.10645 0.942383 7.42188H6.21582C6.64062 4.64355 7.46094 2.1582 8.65234 0.507812ZM23.7988 8.98438H18.1982C18.3008 10.0098 18.3594 11.0596 18.3594 12.1094C18.3594 13.1592 18.3008 14.209 18.1982 15.2344H23.7939C24.0625 14.2334 24.2139 13.1934 24.2139 12.1094C24.2139 11.0254 24.0625 9.98535 23.7988 8.98438ZM5.85938 12.1094C5.85938 11.0596 5.91797 10.0098 6.02051 8.98438H0.419922C0.15625 9.98535 0 11.0254 0 12.1094C0 13.1934 0.15625 14.2334 0.419922 15.2344H6.01562C5.91797 14.209 5.85938 13.1592 5.85938 12.1094ZM7.78809 16.7969C8.49609 21.1572 10.166 24.2188 12.1094 24.2188C14.0527 24.2188 15.7227 21.1572 16.4307 16.7969H7.78809ZM15.5664 23.7109C19.0527 22.6758 21.8848 20.1123 23.2812 16.7969H18.0078C17.5781 19.5752 16.7578 22.0605 15.5664 23.7109ZM0.942383 16.7969C2.33887 20.1123 5.16602 22.6758 8.65723 23.7109C7.46582 22.0605 6.64551 19.5752 6.21582 16.7969H0.942383Z" fill="black"/>
            </svg>',

			'globe_outline'                       => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M12.0051 2.8C6.9251 2.8 2.8051 6.92 2.8051 12C2.8051 17.08 6.9251 21.2 12.0051 21.2C17.0851 21.2 21.2051 17.08 21.2051 12C21.2051 6.92 17.0851 2.8 12.0051 2.8ZM12.7451 19.56C12.7051 19.56 12.6051 19.56 12.6051 19.58V15.24C13.6051 15.22 14.5851 15.2 15.4451 15.14C14.6851 17.48 13.2851 19.04 12.7451 19.56ZM11.2651 19.56C10.7251 19.02 9.3251 17.46 8.5651 15.14C9.4051 15.2 10.4051 15.24 11.4051 15.24V19.58C11.4051 19.58 11.3251 19.56 11.2651 19.56ZM4.4051 12C4.4051 11.5 4.4651 11 4.5451 10.52C4.9851 10.44 5.8251 10.32 7.0051 10.2C6.9051 10.78 6.8451 11.38 6.8451 12.02C6.8451 12.66 6.9051 13.26 6.9851 13.82C5.8251 13.7 4.96509 13.58 4.52509 13.5C4.46509 13 4.4051 12.5 4.4051 12ZM8.0651 12C8.0651 11.32 8.1451 10.68 8.2651 10.08C9.1851 10.02 10.2051 9.96001 11.4051 9.96001V14.04C10.2051 14.02 9.1851 13.98 8.2451 13.9C8.1451 13.32 8.0651 12.68 8.0651 12ZM12.7251 4.43999C13.2651 4.97999 14.6451 6.58001 15.4251 8.86001C14.5851 8.80001 13.6051 8.76001 12.6051 8.76001V4.41999C12.6051 4.41999 12.6851 4.43999 12.7251 4.43999ZM11.4051 4.41999V8.76001C10.4051 8.78001 9.4251 8.80001 8.5851 8.86001C9.3451 6.58001 10.7451 4.97999 11.2651 4.43999C11.3251 4.43999 11.4051 4.41999 11.4051 4.41999ZM12.6051 14.04V9.96001C13.8051 9.98001 14.8251 10.02 15.7451 10.08C15.8651 10.68 15.9451 11.32 15.9451 12C15.9451 12.68 15.8851 13.32 15.7651 13.92C14.8451 13.98 13.8051 14.02 12.6051 14.04ZM16.9851 10.2C18.1651 10.32 19.0051 10.44 19.4451 10.52C19.5451 11 19.5851 11.5 19.5851 12C19.5851 12.5 19.5251 13 19.4451 13.48C19.0051 13.56 18.1651 13.68 16.9851 13.8C17.0851 13.22 17.1251 12.62 17.1251 11.98C17.1451 11.38 17.0851 10.76 16.9851 10.2ZM19.0851 9.23999C18.5251 9.15999 17.7251 9.06001 16.7051 8.96001C16.2251 7.24001 15.3851 5.86 14.6851 4.88C16.7051 5.64 18.3051 7.23999 19.0851 9.23999ZM9.32509 4.88C8.60509 5.84 7.7851 7.21999 7.3051 8.93999C6.3051 9.01999 5.50509 9.14 4.92509 9.22C5.70509 7.24 7.32509 5.64 9.32509 4.88ZM4.92509 14.76C5.48509 14.84 6.2851 14.94 7.2851 15.04C7.7651 16.76 8.5651 18.14 9.2851 19.1C7.2851 18.32 5.70509 16.74 4.92509 14.76ZM14.7251 19.1C15.4451 18.14 16.2451 16.78 16.7251 15.06C17.7251 14.98 18.5251 14.86 19.0851 14.78C18.3051 16.74 16.7251 18.32 14.7251 19.1Z" fill="black"/>
			</svg>
			',

			'tablet'                              => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.125 18.2001C13.125 18.5401 12.865 18.8001 12.525 18.8001H11.485C11.145 18.8001 10.885 18.5401 10.885 18.2001C10.885 17.8601 11.145 17.6 11.485 17.6H12.525C12.865 17.6 13.125 17.8601 13.125 18.2001ZM19.405 19.68C19.405 20.52 18.725 21.2001 17.885 21.2001H6.12498C5.28498 21.2001 4.60498 20.52 4.60498 19.68V4.32007C4.60498 3.48007 5.28498 2.80005 6.12498 2.80005H17.885C18.725 2.80005 19.405 3.48007 19.405 4.32007V19.68ZM6.20498 4.40005V15.4001H17.805V4.40005H6.20498ZM17.805 19.6V16.6H6.20498V19.6H17.805Z" fill="black"/>
			</svg>
			',

			'mobile'                              => '<svg width="16" height="16" viewBox="0 0 16 25" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M13.2812 0H2.34375C1.0498 0 0 1.0498 0 2.34375V22.6562C0 23.9502 1.0498 25 2.34375 25H13.2812C14.5752 25 15.625 23.9502 15.625 22.6562V2.34375C15.625 1.0498 14.5752 0 13.2812 0ZM7.8125 23.4375C6.94824 23.4375 6.25 22.7393 6.25 21.875C6.25 21.0107 6.94824 20.3125 7.8125 20.3125C8.67676 20.3125 9.375 21.0107 9.375 21.875C9.375 22.7393 8.67676 23.4375 7.8125 23.4375ZM13.2812 18.1641C13.2812 18.4863 13.0176 18.75 12.6953 18.75H2.92969C2.60742 18.75 2.34375 18.4863 2.34375 18.1641V2.92969C2.34375 2.60742 2.60742 2.34375 2.92969 2.34375H12.6953C13.0176 2.34375 13.2812 2.60742 13.2812 2.92969V18.1641Z" fill="black"/>
            </svg>',

			'mobile_light'                        => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.3851 18C13.3851 18.34 13.1251 18.6 12.7851 18.6H11.2451C10.9051 18.6 10.6451 18.34 10.6451 18C10.6451 17.66 10.9051 17.4 11.2451 17.4H12.7851C13.1051 17.4 13.3851 17.66 13.3851 18ZM17.2051 19.68C17.2051 20.52 16.5251 21.2 15.6851 21.2H8.3251C7.4851 21.2 6.8051 20.52 6.8051 19.68V4.32002C6.8051 3.48002 7.4851 2.8 8.3251 2.8H15.6851C16.5251 2.8 17.2051 3.48002 17.2051 4.32002V19.68ZM8.4051 4.4V15H15.6051V4.4H8.4051ZM15.6051 19.6V16.2H8.4051V19.6H15.6051Z" fill="black"/>
			</svg>
			',

			'pc_monitor'                          => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M19.6851 4.2H4.3251C3.4851 4.2 2.8051 4.88002 2.8051 5.72002V14.58C2.8051 15.42 3.4851 16.2 4.3251 16.2H9.4051V17.02L7.88511 18.24C7.62511 18.46 7.5051 18.88 7.6051 19.2C7.7251 19.52 8.02511 19.8 8.36511 19.8H15.5651C15.9051 19.8 16.2251 19.52 16.3451 19.2C16.4651 18.88 16.3651 18.48 16.1051 18.26L14.6051 17.02V16.2H19.6851C20.5251 16.2 21.2051 15.42 21.2051 14.58V5.72002C21.2051 4.88002 20.5251 4.2 19.6851 4.2ZM13.4451 17.96L13.9251 18.4H10.0051L10.5251 17.94C10.6851 17.8 10.8051 17.56 10.8051 17.34V16.18H13.2051V17.34C13.2051 17.56 13.2851 17.82 13.4451 17.96ZM19.6051 14.6H4.4051V5.8H19.6051V14.6Z" fill="black"/>
			</svg>
			',

			'debit_credit_card'                   => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M21.205 7.47998C21.205 6.65998 20.545 6 19.725 6H4.26501C3.44501 6 2.78501 6.65998 2.78501 7.47998V16.54C2.78501 17.36 3.44501 18.02 4.26501 18.02H19.725C20.545 18.02 21.205 17.36 21.205 16.54V7.47998ZM19.605 7.6V9H4.40501V7.6H19.605ZM4.40501 16.4V11.4H19.605V16.4H4.40501ZM18.105 13.8C18.105 14.24 17.745 14.6 17.305 14.6H13.505C13.065 14.6 12.705 14.24 12.705 13.8C12.705 13.36 13.065 13 13.505 13H17.305C17.745 13 18.105 13.36 18.105 13.8Z" fill="black"/>
			</svg>
			',

			'badge_variation_one'                 => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M5.36639 0.0979122C4.91404 -0.0483976 4.42435 -0.0287766 3.98515 0.153257C3.54595 0.335291 3.18596 0.66783 2.96973 1.09125L2.43239 2.14191C2.36854 2.267 2.26681 2.36873 2.14173 2.43258L1.09039 2.96991C0.666978 3.18614 0.334439 3.54613 0.152405 3.98533C-0.0296284 4.42454 -0.0492496 4.91422 0.0970603 5.36658L0.46106 6.48991C0.504272 6.62339 0.504272 6.7671 0.46106 6.90058L0.0977271 8.02391C-0.0485828 8.47627 -0.0289617 8.96596 0.153072 9.40516C0.335106 9.84436 0.667645 10.2044 1.09106 10.4206L2.14173 10.9579C2.26681 11.0218 2.36854 11.1235 2.43239 11.2486L2.96973 12.2999C3.18596 12.7233 3.54595 13.0559 3.98515 13.2379C4.42435 13.4199 4.91404 13.4396 5.36639 13.2932L6.48973 12.9292C6.62321 12.886 6.76691 12.886 6.90039 12.9292L8.02373 13.2926C8.47601 13.4389 8.96563 13.4194 9.40483 13.2375C9.84402 13.0556 10.2041 12.7232 10.4204 12.2999L10.9577 11.2486C11.0216 11.1235 11.1233 11.0218 11.2484 10.9579L12.2997 10.4212C12.7233 10.205 13.0559 9.8449 13.238 9.40555C13.42 8.9662 13.4395 8.47636 13.2931 8.02391L12.9291 6.90058C12.8858 6.7671 12.8858 6.62339 12.9291 6.48991L13.2924 5.36658C13.4388 4.9143 13.4192 4.42467 13.2373 3.98548C13.0554 3.54629 12.723 3.18625 12.2997 2.96991L11.2484 2.43258C11.1233 2.36873 11.0216 2.267 10.9577 2.14191L10.4211 1.09058C10.2048 0.667017 9.84471 0.334374 9.40536 0.15233C8.96601 -0.0297138 8.47617 -0.0492433 8.02373 0.0972455L6.90039 0.461245C6.76691 0.504458 6.62321 0.504458 6.48973 0.461245L5.36639 0.0979122ZM3.20173 6.53325L4.14439 5.59058L6.02973 7.47658L9.80106 3.70525L10.7444 4.64791L6.02973 9.36125L3.20173 6.53325Z" fill="black"/>
			</svg>
			',

			'badge_variation_two'                 => '<svg width="16" height="16" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M5.36637 0.0979122C4.91409 -0.0484494 4.42447 -0.0289265 3.98527 0.152981C3.54608 0.334888 3.18604 0.667284 2.96971 1.09058L2.43237 2.14191C2.36852 2.267 2.26679 2.36873 2.14171 2.43258L1.09037 2.96925C0.666932 3.1856 0.334432 3.54575 0.152514 3.98509C-0.029403 4.42443 -0.0488341 4.91421 0.0977063 5.36658L0.46104 6.48991C0.504252 6.62339 0.504252 6.7671 0.46104 6.90058L0.0977063 8.02391C-0.0486035 8.47627 -0.0289825 8.96596 0.153051 9.40516C0.335085 9.84436 0.667624 10.2044 1.09104 10.4206L2.14171 10.9579C2.26679 11.0218 2.36852 11.1235 2.43237 11.2486L2.96971 12.2999C3.18593 12.7233 3.54593 13.0559 3.98513 13.2379C4.42433 13.4199 4.91401 13.4396 5.36637 13.2932L6.48971 12.9292C6.62319 12.886 6.76689 12.886 6.90037 12.9292L8.02371 13.2926C8.47615 13.4391 8.96599 13.4195 9.40534 13.2375C9.84469 13.0555 10.2048 12.7228 10.421 12.2992L10.9584 11.2486C11.0221 11.1236 11.1235 11.0219 11.2484 10.9579L12.2997 10.4206C12.7231 10.2044 13.0557 9.84436 13.2377 9.40516C13.4197 8.96596 13.4393 8.47627 13.293 8.02391L12.929 6.90058C12.8858 6.7671 12.8858 6.62339 12.929 6.48991L13.293 5.36658C13.4395 4.91413 13.42 4.42429 13.238 3.98494C13.0559 3.54559 12.7233 3.18549 12.2997 2.96925L11.2484 2.43258C11.1235 2.36861 11.0221 2.2669 10.9584 2.14191L10.421 1.09058C10.2048 0.667017 9.84469 0.334374 9.40534 0.15233C8.96599 -0.0297138 8.47615 -0.0492433 8.02371 0.0972455L6.90037 0.461245C6.76689 0.504458 6.62319 0.504458 6.48971 0.461245L5.36637 0.0979122ZM4.15704 1.69725C4.22907 1.55612 4.34902 1.44526 4.49537 1.38454C4.64173 1.32382 4.80492 1.31722 4.95571 1.36591L6.07904 1.72991C6.47948 1.85955 6.9106 1.85955 7.31104 1.72991L8.43437 1.36591C8.58524 1.31704 8.7486 1.32355 8.8951 1.38428C9.0416 1.44501 9.16165 1.55597 9.23371 1.69725L9.77037 2.74858C9.96187 3.12349 10.2668 3.42841 10.6417 3.61991L11.693 4.15658C11.8343 4.22863 11.9453 4.34869 12.006 4.49519C12.0667 4.64169 12.0732 4.80504 12.0244 4.95591L11.6604 6.07925C11.5307 6.47968 11.5307 6.91081 11.6604 7.31125L12.0244 8.43458C12.0731 8.58536 12.0665 8.74856 12.0057 8.89491C11.945 9.04127 11.8342 9.16121 11.693 9.23325L10.6417 9.77058C10.2668 9.96208 9.96187 10.267 9.77037 10.6419L9.23371 11.6932C9.16154 11.8344 9.04144 11.9452 8.89495 12.0058C8.74846 12.0664 8.58517 12.0728 8.43437 12.0239L7.31104 11.6606C6.9106 11.5309 6.47948 11.5309 6.07904 11.6606L4.95571 12.0239C4.805 12.0727 4.64186 12.0662 4.49552 12.0056C4.34917 11.945 4.22918 11.8343 4.15704 11.6932L3.61971 10.6419C3.42821 10.267 3.12328 9.96208 2.74837 9.77058L1.69704 9.23325C1.55603 9.1611 1.44531 9.04111 1.38472 8.89477C1.32413 8.74842 1.31763 8.58528 1.36637 8.43458L1.72971 7.31125C1.85934 6.91081 1.85934 6.47968 1.72971 6.07925L1.36637 4.95591C1.31745 4.80512 1.32386 4.64183 1.38446 4.49533C1.44506 4.34884 1.55588 4.22874 1.69704 4.15658L2.74837 3.61991C3.12328 3.42841 3.42821 3.12349 3.61971 2.74858L4.15704 1.69725ZM3.20171 6.53325L6.03037 9.36191L10.7437 4.64791L9.80104 3.70525L6.03037 7.47658L4.14437 5.59058L3.20171 6.53325Z" fill="black"/>
			</svg>
			',

			'badge_variation_three'               => '<svg width="16" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.67838 2.98524C10.015 2.96858 10.3197 2.92524 10.579 2.87324L11.7337 4.19324C11.4737 4.73991 11.3257 5.26124 11.2704 5.77791C11.1877 6.54924 11.3297 7.20658 11.4337 7.68658L11.4384 7.70858C11.5464 8.20458 11.6177 8.53124 11.607 8.91458C11.597 9.27524 11.509 9.75191 11.169 10.4326C10.4357 11.8999 8.70572 12.2099 7.35905 12.8826C7.14172 12.9919 6.91771 13.1159 6.69505 13.2619C6.48116 13.1229 6.25946 12.9962 6.03105 12.8826C4.68438 12.2092 2.95505 11.8999 2.22105 10.4326C1.88105 9.75258 1.79305 9.27524 1.78305 8.91458C1.77238 8.53124 1.84305 8.20458 1.95171 7.70791L1.95638 7.68658C2.06038 7.20658 2.20238 6.54924 2.11971 5.77791C2.05665 5.22715 1.89995 4.69122 1.65638 4.19324L2.81105 2.87324C3.07038 2.92524 3.37505 2.96858 3.71171 2.98524C4.55505 3.02724 5.62971 2.90191 6.69505 2.30724C7.76038 2.90191 8.83505 3.02724 9.67838 2.98524ZM12.753 7.47791C12.5377 6.49191 12.3357 5.56724 13.3617 4.02858L11.0284 1.36191C11.0284 1.36191 8.69505 2.36191 6.69505 0.695244C4.69505 2.36191 2.36171 1.36191 2.36171 1.36191L0.0283813 4.02858C1.05438 5.56724 0.852381 6.49191 0.637048 7.47791C0.433048 8.41391 0.217048 9.40458 1.02838 11.0286C2.07971 13.1312 4.16705 13.3686 5.65705 14.1919C6.05705 14.4132 6.41305 14.6759 6.69505 15.0286C6.97705 14.6759 7.33371 14.4132 7.73371 14.1919C9.22305 13.3686 11.3104 13.1312 12.3617 11.0286C13.1737 9.40524 12.957 8.41391 12.753 7.47791ZM8.27971 8.21058L8.65438 10.3919L6.69438 9.36191L4.73571 10.3919L5.10971 8.20991L3.52505 6.66524L5.71505 6.34658L6.69505 4.36191L7.67505 6.34658L9.86505 6.66524L8.27971 8.21058Z" fill="black"/>
			</svg>
			',

			'badge_variation_four'                => '<svg width="16" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0.637048 7.47791C0.852381 6.49191 1.05505 5.56724 0.0283813 4.02858L2.36171 1.36191C2.36171 1.36191 4.69505 2.36191 6.69505 0.695244C8.69505 2.36191 11.0284 1.36191 11.0284 1.36191L13.3617 4.02858C12.3357 5.56724 12.5377 6.49191 12.753 7.47791C12.957 8.41391 13.173 9.40458 12.3617 11.0286C11.5904 12.5719 10.2604 13.1106 9.01838 13.6132C8.11438 13.9799 7.25705 14.3266 6.69505 15.0286C6.13371 14.3266 5.27572 13.9792 4.37172 13.6132C3.12971 13.1106 1.80038 12.5719 1.02838 11.0286C0.216381 9.40524 0.433048 8.41391 0.637048 7.47791ZM8.28038 8.21058L9.86505 6.66524L7.67438 6.34658L6.69505 4.36191L5.71505 6.34658L3.52505 6.66524L5.10971 8.21058L4.73571 10.3919L6.69505 9.36191L8.65438 10.3919L8.28038 8.21058Z" fill="black"/>
			</svg>
			',

			'badge_variation_five'                => '<svg width="16" height="16" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M7.58907 1.36191C7.3368 2.0741 7.2914 2.84317 7.45811 3.58008C7.62483 4.317 7.99684 4.99164 8.53109 5.52589C9.06534 6.06014 9.73998 6.43215 10.4769 6.59887C11.2138 6.76558 11.9829 6.72018 12.6951 6.46791V12.6952C12.6951 12.8721 12.6248 13.0416 12.4998 13.1667C12.3748 13.2917 12.2052 13.3619 12.0284 13.3619H1.36174C1.18492 13.3619 1.01535 13.2917 0.89033 13.1667C0.765306 13.0416 0.695068 12.8721 0.695068 12.6952V2.02858C0.695068 1.85177 0.765306 1.6822 0.89033 1.55718C1.01535 1.43215 1.18492 1.36191 1.36174 1.36191H7.58907ZM11.3617 5.36191C10.6545 5.36191 9.97621 5.08096 9.47612 4.58086C8.97602 4.08077 8.69507 3.40249 8.69507 2.69525C8.69507 1.988 8.97602 1.30973 9.47612 0.809628C9.97621 0.309531 10.6545 0.0285797 11.3617 0.0285797C12.069 0.0285797 12.7473 0.309531 13.2474 0.809628C13.7474 1.30973 14.0284 1.988 14.0284 2.69525C14.0284 3.40249 13.7474 4.08077 13.2474 4.58086C12.7473 5.08096 12.069 5.36191 11.3617 5.36191Z" fill="black"/>
			</svg>
			',

			'badge_variation_six'                 => '<svg width="16" height="16" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M7.58907 1.36191C7.43815 1.79023 7.36128 2.24112 7.36174 2.69525H2.0284V12.0286H11.3617V6.69525C11.8159 6.69571 12.2668 6.61883 12.6951 6.46791V12.6952C12.6951 12.8721 12.6248 13.0416 12.4998 13.1667C12.3748 13.2917 12.2052 13.3619 12.0284 13.3619H1.36174C1.18492 13.3619 1.01535 13.2917 0.89033 13.1667C0.765306 13.0416 0.695068 12.8721 0.695068 12.6952V2.02858C0.695068 1.85177 0.765306 1.6822 0.89033 1.55718C1.01535 1.43215 1.18492 1.36191 1.36174 1.36191H7.58907ZM11.3617 4.02858C11.7154 4.02858 12.0545 3.8881 12.3045 3.63806C12.5546 3.38801 12.6951 3.04887 12.6951 2.69525C12.6951 2.34162 12.5546 2.00249 12.3045 1.75244C12.0545 1.50239 11.7154 1.36191 11.3617 1.36191C11.0081 1.36191 10.669 1.50239 10.4189 1.75244C10.1689 2.00249 10.0284 2.34162 10.0284 2.69525C10.0284 3.04887 10.1689 3.38801 10.4189 3.63806C10.669 3.8881 11.0081 4.02858 11.3617 4.02858ZM11.3617 5.36191C10.6545 5.36191 9.97621 5.08096 9.47612 4.58086C8.97602 4.08077 8.69507 3.40249 8.69507 2.69525C8.69507 1.988 8.97602 1.30973 9.47612 0.809628C9.97621 0.309531 10.6545 0.0285797 11.3617 0.0285797C12.069 0.0285797 12.7473 0.309531 13.2474 0.809628C13.7474 1.30973 14.0284 1.988 14.0284 2.69525C14.0284 3.40249 13.7474 4.08077 13.2474 4.58086C12.7473 5.08096 12.069 5.36191 11.3617 5.36191Z" fill="black"/>
			</svg>
			',

			'sofa_light'                          => '<svg width="16" height="16" viewBox="0 0 16 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M5.96384 -2.38419e-07C4.90297 -2.38419e-07 3.88556 0.421427 3.13541 1.17157C2.38527 1.92172 1.96384 2.93913 1.96384 4V4.234C0.950504 4.73133 0.385838 5.944 0.808504 7.10533L1.0165 7.67867C1.20242 8.18956 1.29763 8.729 1.29784 9.27267V11C1.29784 11.2651 1.4031 11.5194 1.5905 11.7069C1.77789 11.8944 2.03207 11.9998 2.29717 12H13.6305C13.8957 12 14.1501 11.8946 14.3376 11.7071C14.5251 11.5196 14.6305 11.2652 14.6305 11V9.27333C14.6303 8.72926 14.7253 8.18935 14.9112 7.678L15.1198 7.10467C15.5418 5.944 14.9778 4.73133 13.9638 4.234V4C13.9638 2.93913 13.5424 1.92172 12.7923 1.17157C12.0421 0.421427 11.0247 -2.38419e-07 9.96384 -2.38419e-07H5.96384ZM12.6305 4.02133C11.5012 4.17467 10.6305 5.14267 10.6305 6.31467V7.33333H5.29717V6.31467C5.29749 5.75518 5.09504 5.21454 4.72731 4.79288C4.35958 4.37122 3.8515 4.09711 3.29717 4.02133V4C3.29717 3.29276 3.57812 2.61448 4.07822 2.11438C4.57832 1.61428 5.25659 1.33333 5.96384 1.33333H9.96384C10.6711 1.33333 11.3494 1.61428 11.8495 2.11438C12.3496 2.61448 12.6305 3.29276 12.6305 4V4.02133ZM10.6305 8.66667V9.33333H11.9638V6.31467C11.9636 6.17129 11.9949 6.02961 12.0553 5.8996C12.1157 5.76959 12.2039 5.6544 12.3137 5.56213C12.4234 5.46987 12.552 5.40278 12.6905 5.36557C12.829 5.32836 12.9739 5.32195 13.1151 5.34678C13.2563 5.37161 13.3904 5.42708 13.5078 5.50928C13.6253 5.59149 13.7233 5.69844 13.795 5.8226C13.8667 5.94677 13.9103 6.08513 13.9228 6.22797C13.9353 6.3708 13.9163 6.51463 13.8672 6.64933L13.6592 7.22267C13.42 7.87969 13.2975 8.57346 13.2972 9.27267V10.6667H2.6305V9.27333C2.6305 8.57394 2.50821 7.87994 2.26917 7.22267L2.0605 6.64933C2.01207 6.51483 1.99363 6.37137 2.00647 6.22899C2.01932 6.08661 2.06313 5.94876 2.13485 5.82509C2.20657 5.70143 2.30446 5.59494 2.42166 5.51309C2.53887 5.43123 2.67255 5.37599 2.81335 5.35124C2.95414 5.32648 3.09865 5.33281 3.23675 5.36977C3.37484 5.40673 3.50319 5.47344 3.61279 5.56523C3.72239 5.65701 3.8106 5.77164 3.87124 5.9011C3.93188 6.03056 3.96348 6.17171 3.96384 6.31467V9.33333H5.29717V8.66667H10.6305Z" fill="black"/>
			</svg>
			',

			'sofa_fill'                           => '<svg width="16" height="16" viewBox="0 0 16 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.96389 -2.20075e-07H5.96389C5.01622 -9.09355e-05 4.09929 0.336286 3.3765 0.949193C2.65371 1.5621 2.17201 2.41172 2.01722 3.34667C2.10922 3.33778 2.20255 3.33333 2.29722 3.33333C3.09287 3.33333 3.85593 3.6494 4.41854 4.21201C4.98115 4.77462 5.29722 5.53768 5.29722 6.33333V7.33333H10.6306V6.33333C10.6306 5.91578 10.7178 5.50283 10.8866 5.12091C11.0554 4.73899 11.302 4.39651 11.6107 4.11538C11.9195 3.83426 12.2835 3.62068 12.6795 3.48831C13.0755 3.35594 13.4948 3.3077 13.9106 3.34667C13.7558 2.41172 13.2741 1.5621 12.5513 0.949193C11.8285 0.336286 10.9116 -9.09355e-05 9.96389 -2.20075e-07ZM13.9639 4.7C13.7217 4.65057 13.4716 4.65562 13.2316 4.71479C12.9916 4.77395 12.7678 4.88576 12.5763 5.04211C12.3849 5.19845 12.2306 5.39542 12.1247 5.61875C12.0188 5.84207 11.9638 6.08616 11.9639 6.33333V9.33333H10.6306V8.66667H5.29722V9.33333H3.96389V6.33333C3.96389 5.89131 3.78829 5.46738 3.47573 5.15482C3.16317 4.84226 2.73925 4.66667 2.29722 4.66667C1.85519 4.66667 1.43127 4.84226 1.11871 5.15482C0.806149 5.46738 0.630554 5.89131 0.630554 6.33333C0.630554 6.726 0.751888 7.026 0.890554 7.37C1.07722 7.834 1.29722 8.37667 1.29722 9.33333V11.3333C1.29722 11.5101 1.36746 11.6797 1.49248 11.8047C1.61751 11.9298 1.78708 12 1.96389 12H13.9639C14.1407 12 14.3103 11.9298 14.4353 11.8047C14.5603 11.6797 14.6306 11.5101 14.6306 11.3333V9.33333C14.6306 8.37733 14.8506 7.83333 15.0372 7.37C15.1759 7.026 15.2972 6.726 15.2972 6.33333C15.2973 5.94912 15.1646 5.57667 14.9217 5.27903C14.6787 4.98139 14.3403 4.77684 13.9639 4.7Z" fill="black"/>
			</svg>
			',

			'cart'                                => '<svg width="16" height="16" viewBox="0 0 25 23" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
            <path d="M22.9219 13.0781L24.9737 4.0503C25.1218 3.39848 24.6263 2.77778 23.9579 2.77778H6.91007L6.51224 0.832899C6.41311 0.348134 5.98655 0 5.49171 0H1.04167C0.466363 0 0 0.466363 0 1.04167V1.73611C0 2.31141 0.466363 2.77778 1.04167 2.77778H4.07478L7.12374 17.6838C6.39431 18.1033 5.90278 18.8898 5.90278 19.7917C5.90278 21.134 6.99097 22.2222 8.33333 22.2222C9.67569 22.2222 10.7639 21.134 10.7639 19.7917C10.7639 19.1114 10.4841 18.4967 10.0337 18.0556H19.1329C18.6826 18.4967 18.4028 19.1114 18.4028 19.7917C18.4028 21.134 19.491 22.2222 20.8333 22.2222C22.1757 22.2222 23.2639 21.134 23.2639 19.7917C23.2639 18.8293 22.7045 17.9977 21.8933 17.6039L22.1327 16.5503C22.2809 15.8985 21.7854 15.2778 21.117 15.2778H9.46688L9.18281 13.8889H21.9061C22.3925 13.8889 22.8141 13.5523 22.9219 13.0781Z" fill="black"/>
            </svg>',

			'cart_variation_two'                  => '<svg width="16" height="16" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.63326 3.278L0.471924 1.116L1.41459 0.173333L3.57659 2.33533H13.7373C13.8412 2.33533 13.9436 2.35961 14.0365 2.40624C14.1294 2.45288 14.21 2.52058 14.2721 2.60393C14.3341 2.68728 14.3758 2.78399 14.3939 2.88632C14.4119 2.98866 14.4057 3.09379 14.3759 3.19333L12.7759 8.52667C12.7348 8.66406 12.6504 8.78451 12.5353 8.87014C12.4203 8.95577 12.2807 9.00201 12.1373 9.002H3.96659V10.3353H11.2999V11.6687H3.29992C3.12311 11.6687 2.95354 11.5984 2.82852 11.4734C2.7035 11.3484 2.63326 11.1788 2.63326 11.002V3.278ZM3.96659 3.66867V7.66867H11.6413L12.8413 3.66867H3.96659ZM3.63326 14.3353C3.36804 14.3353 3.11369 14.23 2.92615 14.0424C2.73861 13.8549 2.63326 13.6006 2.63326 13.3353C2.63326 13.0701 2.73861 12.8158 2.92615 12.6282C3.11369 12.4407 3.36804 12.3353 3.63326 12.3353C3.89847 12.3353 4.15283 12.4407 4.34036 12.6282C4.5279 12.8158 4.63326 13.0701 4.63326 13.3353C4.63326 13.6006 4.5279 13.8549 4.34036 14.0424C4.15283 14.23 3.89847 14.3353 3.63326 14.3353ZM11.6333 14.3353C11.368 14.3353 11.1137 14.23 10.9262 14.0424C10.7386 13.8549 10.6333 13.6006 10.6333 13.3353C10.6333 13.0701 10.7386 12.8158 10.9262 12.6282C11.1137 12.4407 11.368 12.3353 11.6333 12.3353C11.8985 12.3353 12.1528 12.4407 12.3404 12.6282C12.5279 12.8158 12.6333 13.0701 12.6333 13.3353C12.6333 13.6006 12.5279 13.8549 12.3404 14.0424C12.1528 14.23 11.8985 14.3353 11.6333 14.3353Z" fill="black"/>
			</svg>
			',

			'cart_variation_three'                => '<svg width="16" height="16" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M2.96726 5H12.2593L12.5926 3.66667H4.30059V2.33333H13.4473C13.5486 2.33334 13.6486 2.35644 13.7397 2.40089C13.8307 2.44534 13.9105 2.50997 13.9728 2.58986C14.0352 2.66975 14.0785 2.7628 14.0995 2.86194C14.1204 2.96108 14.1186 3.0637 14.0939 3.162L12.4273 9.82867C12.3911 9.97283 12.3079 10.1008 12.1907 10.1922C12.0736 10.2837 11.9292 10.3333 11.7806 10.3333H2.29993C2.12312 10.3333 1.95355 10.2631 1.82852 10.1381C1.7035 10.013 1.63326 9.84348 1.63326 9.66667V1.66667H0.299927V0.333333H2.29993C2.47674 0.333333 2.64631 0.403571 2.77133 0.528595C2.89636 0.65362 2.96659 0.823189 2.96659 1L2.96726 5ZM2.96726 14.3333C2.61364 14.3333 2.2745 14.1929 2.02445 13.9428C1.7744 13.6928 1.63393 13.3536 1.63393 13C1.63393 12.6464 1.7744 12.3072 2.02445 12.0572C2.2745 11.8071 2.61364 11.6667 2.96726 11.6667C3.32088 11.6667 3.66002 11.8071 3.91007 12.0572C4.16012 12.3072 4.30059 12.6464 4.30059 13C4.30059 13.3536 4.16012 13.6928 3.91007 13.9428C3.66002 14.1929 3.32088 14.3333 2.96726 14.3333ZM10.9673 14.3333C10.6136 14.3333 10.2745 14.1929 10.0245 13.9428C9.7744 13.6928 9.63393 13.3536 9.63393 13C9.63393 12.6464 9.7744 12.3072 10.0245 12.0572C10.2745 11.8071 10.6136 11.6667 10.9673 11.6667C11.3209 11.6667 11.66 11.8071 11.9101 12.0572C12.1601 12.3072 12.3006 12.6464 12.3006 13C12.3006 13.3536 12.1601 13.6928 11.9101 13.9428C11.66 14.1929 11.3209 14.3333 10.9673 14.3333Z" fill="black"/>
			</svg>
			',

			'cart_variation_four'                 => '<svg width="16" height="16" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1.63387 9.66667V1.66667H0.300537V0.333333H2.30054C2.47735 0.333333 2.64692 0.403571 2.77194 0.528595C2.89697 0.65362 2.9672 0.823189 2.9672 1V9H11.2592L12.5925 3.66667H4.30054V2.33333H13.4472C13.5485 2.33334 13.6485 2.35644 13.7396 2.40089C13.8307 2.44534 13.9104 2.50997 13.9728 2.58986C14.0351 2.66975 14.0784 2.7628 14.0994 2.86194C14.1204 2.96108 14.1185 3.0637 14.0939 3.162L12.4272 9.82867C12.3911 9.97283 12.3078 10.1008 12.1907 10.1922C12.0735 10.2837 11.9292 10.3333 11.7805 10.3333H2.29987C2.12306 10.3333 1.95349 10.2631 1.82847 10.1381C1.70344 10.013 1.63387 9.84348 1.63387 9.66667ZM2.96654 14.3333C2.61292 14.3333 2.27378 14.1929 2.02373 13.9428C1.77368 13.6928 1.6332 13.3536 1.6332 13C1.6332 12.6464 1.77368 12.3072 2.02373 12.0572C2.27378 11.8071 2.61292 11.6667 2.96654 11.6667C3.32016 11.6667 3.6593 11.8071 3.90935 12.0572C4.15939 12.3072 4.29987 12.6464 4.29987 13C4.29987 13.3536 4.15939 13.6928 3.90935 13.9428C3.6593 14.1929 3.32016 14.3333 2.96654 14.3333ZM10.9665 14.3333C10.6129 14.3333 10.2738 14.1929 10.0237 13.9428C9.77368 13.6928 9.6332 13.3536 9.6332 13C9.6332 12.6464 9.77368 12.3072 10.0237 12.0572C10.2738 11.8071 10.6129 11.6667 10.9665 11.6667C11.3202 11.6667 11.6593 11.8071 11.9093 12.0572C12.1594 12.3072 12.2999 12.6464 12.2999 13C12.2999 13.3536 12.1594 13.6928 11.9093 13.9428C11.6593 14.1929 11.3202 14.3333 10.9665 14.3333Z" fill="black"/>
			</svg>
			',

			'cart_variation_five'                 => '<svg width="16" height="16" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M3.63057 12.3333C3.89579 12.3333 4.15014 12.4387 4.33768 12.6262C4.52522 12.8138 4.63057 13.0681 4.63057 13.3333C4.63057 13.5985 4.52522 13.8529 4.33768 14.0404C4.15014 14.228 3.89579 14.3333 3.63057 14.3333C3.36536 14.3333 3.111 14.228 2.92346 14.0404C2.73593 13.8529 2.63057 13.5985 2.63057 13.3333C2.63057 13.0681 2.73593 12.8138 2.92346 12.6262C3.111 12.4387 3.36536 12.3333 3.63057 12.3333ZM12.2972 12.3333C12.5625 12.3333 12.8168 12.4387 13.0043 12.6262C13.1919 12.8138 13.2972 13.0681 13.2972 13.3333C13.2972 13.5985 13.1919 13.8529 13.0043 14.0404C12.8168 14.228 12.5625 14.3333 12.2972 14.3333C12.032 14.3333 11.7777 14.228 11.5901 14.0404C11.4026 13.8529 11.2972 13.5985 11.2972 13.3333C11.2972 13.0681 11.4026 12.8138 11.5901 12.6262C11.7777 12.4387 12.032 12.3333 12.2972 12.3333ZM1.4119 0.171333L3.96391 2.72333V10.3333H13.2972V11.6667H3.29724C3.12043 11.6667 2.95086 11.5964 2.82583 11.4714C2.70081 11.3464 2.63057 11.1768 2.63057 11V3.27533L0.469238 1.11467L1.4119 0.171333ZM10.6306 1C10.8074 1 10.977 1.07024 11.102 1.19526C11.227 1.32029 11.2972 1.48986 11.2972 1.66667V3H13.2932C13.6639 3 13.9639 3.304 13.9639 3.66333V9.00333C13.9635 9.09094 13.9458 9.1776 13.9118 9.25836C13.8779 9.33912 13.8283 9.4124 13.7661 9.474C13.7038 9.53561 13.6299 9.58433 13.5488 9.61739C13.4677 9.65045 13.3808 9.66719 13.2932 9.66667H5.30191C5.12539 9.66616 4.95614 9.59636 4.83057 9.4723C4.70501 9.34824 4.63319 9.17983 4.63057 9.00333V3.66333C4.63101 3.57567 4.64873 3.48896 4.68272 3.40815C4.71671 3.32735 4.7663 3.25404 4.82866 3.19243C4.89102 3.13081 4.96491 3.0821 5.04612 3.04908C5.12732 3.01607 5.21425 2.99939 5.30191 3H7.29724V1.66667C7.29724 1.48986 7.36748 1.32029 7.4925 1.19526C7.61752 1.07024 7.78709 1 7.9639 1H10.6306ZM6.63057 4.33333H5.9639V8.33333H6.63057V4.33333ZM10.6306 4.33333H7.9639V8.33333H10.6306V4.33333ZM12.6306 4.33333H11.9639V8.33333H12.6306V4.33333ZM9.9639 2.33333H8.63057V3H9.9639V2.33333Z" fill="black"/>
			</svg>
			',

			'coupon_dark'                         => '<svg width="16" height="16" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M8.30054 -2.38419e-07V12H0.967204C0.790393 12 0.620823 11.9298 0.495799 11.8047C0.370775 11.6797 0.300537 11.5101 0.300537 11.3333V7.66667C0.742565 7.66667 1.16649 7.49107 1.47905 7.17851C1.79161 6.86595 1.9672 6.44203 1.9672 6C1.9672 5.55797 1.79161 5.13405 1.47905 4.82149C1.16649 4.50893 0.742565 4.33333 0.300537 4.33333V0.666666C0.300537 0.489855 0.370775 0.320286 0.495799 0.195262C0.620823 0.0702376 0.790393 -2.38419e-07 0.967204 -2.38419e-07H8.30054ZM9.63387 -2.38419e-07H12.9672C13.144 -2.38419e-07 13.3136 0.0702376 13.4386 0.195262C13.5636 0.320286 13.6339 0.489855 13.6339 0.666666V4.33333C13.1918 4.33333 12.7679 4.50893 12.4554 4.82149C12.1428 5.13405 11.9672 5.55797 11.9672 6C11.9672 6.44203 12.1428 6.86595 12.4554 7.17851C12.7679 7.49107 13.1918 7.66667 13.6339 7.66667V11.3333C13.6339 11.5101 13.5636 11.6797 13.4386 11.8047C13.3136 11.9298 13.144 12 12.9672 12H9.63387V-2.38419e-07Z" fill="black"/>
			</svg>
			',

			'coupon_light'                        => '<svg width="16" height="16" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0.300537 4.33333V0.666666C0.300537 0.489855 0.370775 0.320286 0.495799 0.195262C0.620823 0.0702376 0.790393 -2.38419e-07 0.967204 -2.38419e-07H12.9672C13.144 -2.38419e-07 13.3136 0.0702376 13.4386 0.195262C13.5636 0.320286 13.6339 0.489855 13.6339 0.666666V4.33333C13.1918 4.33333 12.7679 4.50893 12.4554 4.82149C12.1428 5.13405 11.9672 5.55797 11.9672 6C11.9672 6.44203 12.1428 6.86595 12.4554 7.17851C12.7679 7.49107 13.1918 7.66667 13.6339 7.66667V11.3333C13.6339 11.5101 13.5636 11.6797 13.4386 11.8047C13.3136 11.9298 13.144 12 12.9672 12H0.967204C0.790393 12 0.620823 11.9298 0.495799 11.8047C0.370775 11.6797 0.300537 11.5101 0.300537 11.3333V7.66667C0.742565 7.66667 1.16649 7.49107 1.47905 7.17851C1.79161 6.86595 1.9672 6.44203 1.9672 6C1.9672 5.55797 1.79161 5.13405 1.47905 4.82149C1.16649 4.50893 0.742565 4.33333 0.300537 4.33333ZM8.30054 1.33333H1.63387V3.312C2.13468 3.5602 2.55619 3.94337 2.85087 4.41831C3.14556 4.89324 3.30171 5.44107 3.30171 6C3.30171 6.55893 3.14556 7.10676 2.85087 7.58169C2.55619 8.05663 2.13468 8.4398 1.63387 8.688V10.6667H8.30054V1.33333ZM9.63387 1.33333V10.6667H12.3005V8.688C11.7997 8.4398 11.3782 8.05663 11.0835 7.58169C10.7888 7.10676 10.6327 6.55893 10.6327 6C10.6327 5.44107 10.7888 4.89324 11.0835 4.41831C11.3782 3.94337 11.7997 3.5602 12.3005 3.312V1.33333H9.63387Z" fill="black"/>
			</svg>
			',

			'takeout_light'                       => '<svg width="16" height="16" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.63057 0.666666C9.80739 0.666666 9.97696 0.736904 10.102 0.861929C10.227 0.986953 10.2972 1.15652 10.2972 1.33333V1.99933L13.6306 2V6L12.2839 5.99933L14.1286 11.0633C14.2536 11.4019 14.3086 11.7624 14.2902 12.1229C14.2719 12.4833 14.1805 12.8363 14.0217 13.1605C13.8629 13.4846 13.6399 13.7731 13.3663 14.0085C13.0927 14.2439 12.7741 14.4213 12.4299 14.53C12.0858 14.6387 11.7231 14.6764 11.3639 14.6408C11.0047 14.6051 10.6565 14.497 10.3404 14.3228C10.0242 14.1487 9.7467 13.9121 9.52465 13.6276C9.30261 13.343 9.14065 13.0163 9.04857 12.6673H6.21324C6.06152 13.2524 5.71564 13.7686 5.23222 14.1315C4.74881 14.4943 4.15653 14.6822 3.55237 14.6645C2.9482 14.6467 2.36796 14.4244 1.90667 14.0338C1.44538 13.6433 1.13037 13.1076 1.01324 12.5147C0.797395 12.4019 0.61655 12.2322 0.490328 12.024C0.364106 11.8157 0.297328 11.5769 0.297241 11.3333V2.66667C0.297241 2.48986 0.367479 2.32029 0.492503 2.19526C0.617528 2.07024 0.787097 2 0.963908 2H5.63057C5.80739 2 5.97695 2.07024 6.10198 2.19526C6.227 2.32029 6.29724 2.48986 6.29724 2.66667V8C6.29726 8.16329 6.35721 8.32089 6.46572 8.44291C6.57422 8.56494 6.72374 8.6429 6.88591 8.662L6.96391 8.66667H8.29724C8.46053 8.66665 8.61813 8.6067 8.74016 8.49819C8.86218 8.38968 8.94014 8.24017 8.95924 8.078L8.96391 8V2H6.96391V0.666666H9.63057ZM3.63057 10.6667C3.27695 10.6667 2.93781 10.8071 2.68777 11.0572C2.43772 11.3072 2.29724 11.6464 2.29724 12C2.29724 12.3536 2.43772 12.6928 2.68777 12.9428C2.93781 13.1929 3.27695 13.3333 3.63057 13.3333C3.9842 13.3333 4.32333 13.1929 4.57338 12.9428C4.82343 12.6928 4.96391 12.3536 4.96391 12C4.96391 11.6464 4.82343 11.3072 4.57338 11.0572C4.32333 10.8071 3.9842 10.6667 3.63057 10.6667ZM11.6306 10.666C11.277 10.666 10.9378 10.8065 10.6878 11.0565C10.4377 11.3066 10.2972 11.6457 10.2972 11.9993C10.2972 12.353 10.4377 12.6921 10.6878 12.9421C10.9378 13.1922 11.277 13.3327 11.6306 13.3327C11.9842 13.3327 12.3233 13.1922 12.5734 12.9421C12.8234 12.6921 12.9639 12.353 12.9639 11.9993C12.9639 11.6457 12.8234 11.3066 12.5734 11.0565C12.3233 10.8065 11.9842 10.666 11.6306 10.666ZM10.8652 5.99933H10.2972V8C10.2972 8.53043 10.0865 9.03914 9.71146 9.41421C9.33638 9.78929 8.82767 10 8.29724 10H6.96391C6.55025 10.0001 6.14675 9.87189 5.80898 9.6331C5.47121 9.39431 5.21579 9.05666 5.07791 8.66667H1.63057V10.236C1.95114 9.873 2.36445 9.6041 2.82621 9.45813C3.28796 9.31216 3.78074 9.29462 4.2517 9.40739C4.72266 9.52017 5.15405 9.759 5.49961 10.0983C5.84517 10.4376 6.09186 10.8645 6.21324 11.3333H9.04791C9.21561 10.683 9.62252 10.1199 10.1873 9.75657C10.7521 9.39322 11.4332 9.25636 12.0946 9.37333L10.8652 5.99933ZM4.96391 5.33333H1.63057V7.33333H4.96391V5.33333ZM12.2972 3.33333H10.2972V4.66667H12.2972V3.33333ZM4.96391 3.33333H1.63057V4H4.96391V3.33333Z" fill="black"/>
			</svg>
			',

			'takeout_dark'                        => '<svg width="16" height="16" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.63057 0.666666C9.80739 0.666666 9.97696 0.736904 10.102 0.861929C10.227 0.986953 10.2972 1.15652 10.2972 1.33333V1.99933L13.6306 2V6L12.2839 5.99933L14.1286 11.0633C14.2536 11.4019 14.3086 11.7624 14.2902 12.1229C14.2719 12.4833 14.1805 12.8363 14.0217 13.1605C13.8629 13.4846 13.6399 13.7731 13.3663 14.0085C13.0927 14.2439 12.7741 14.4213 12.4299 14.53C12.0858 14.6387 11.7231 14.6764 11.3639 14.6408C11.0047 14.6051 10.6565 14.497 10.3404 14.3228C10.0242 14.1487 9.7467 13.9121 9.52465 13.6276C9.30261 13.343 9.14065 13.0163 9.04857 12.6673H6.21324C6.06152 13.2524 5.71564 13.7686 5.23222 14.1315C4.74881 14.4943 4.15653 14.6822 3.55237 14.6645C2.9482 14.6467 2.36796 14.4244 1.90667 14.0338C1.44538 13.6433 1.13037 13.1076 1.01324 12.5147C0.797395 12.4019 0.61655 12.2322 0.490328 12.024C0.364106 11.8157 0.297328 11.5769 0.297241 11.3333V8H6.29724C6.29726 8.16329 6.35721 8.32089 6.46572 8.44291C6.57422 8.56494 6.72374 8.6429 6.88591 8.662L6.96391 8.66667H8.29724C8.46053 8.66665 8.61813 8.6067 8.74016 8.49819C8.86218 8.38968 8.94014 8.24017 8.95924 8.078L8.96391 8V2H6.96391V0.666666H9.63057ZM3.63057 10.6667C3.27695 10.6667 2.93781 10.8071 2.68777 11.0572C2.43772 11.3072 2.29724 11.6464 2.29724 12C2.29724 12.3536 2.43772 12.6928 2.68777 12.9428C2.93781 13.1929 3.27695 13.3333 3.63057 13.3333C3.9842 13.3333 4.32333 13.1929 4.57338 12.9428C4.82343 12.6928 4.96391 12.3536 4.96391 12C4.96391 11.6464 4.82343 11.3072 4.57338 11.0572C4.32333 10.8071 3.9842 10.6667 3.63057 10.6667ZM11.6306 10.6667C11.277 10.6667 10.9378 10.8071 10.6878 11.0572C10.4377 11.3072 10.2972 11.6464 10.2972 12C10.2972 12.3536 10.4377 12.6928 10.6878 12.9428C10.9378 13.1929 11.277 13.3333 11.6306 13.3333C11.9842 13.3333 12.3233 13.1929 12.5734 12.9428C12.8234 12.6928 12.9639 12.3536 12.9639 12C12.9639 11.6464 12.8234 11.3072 12.5734 11.0572C12.3233 10.8071 11.9842 10.6667 11.6306 10.6667ZM5.63057 2C5.80739 2 5.97695 2.07024 6.10198 2.19526C6.227 2.32029 6.29724 2.48986 6.29724 2.66667V7.33333H0.297241V2.66667C0.297241 2.48986 0.367479 2.32029 0.492503 2.19526C0.617528 2.07024 0.787097 2 0.963908 2H5.63057ZM12.2972 3.33333H10.2972V4.66667H12.2972V3.33333ZM4.96391 3.33333H1.63057V4H4.96391V3.33333Z" fill="black"/>
			</svg>
			',

			'parcel_package_light'                => '<svg width="16" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1.96383 5.102V10.898L6.96383 13.7927L11.9638 10.898V5.102L6.96383 2.20733L1.96383 5.102ZM6.96383 0.666666L13.2972 4.33333V11.6667L6.96383 15.3333L0.630493 11.6667V4.33333L6.96383 0.666666ZM3.29649 6.64667L6.29716 8.38467V11.7507H7.63049V8.38467L10.6312 6.648L9.96316 5.494L6.96383 7.23L3.96449 5.49333L3.29649 6.64667Z" fill="black"/>
			</svg>
			',

			'parcel_package_dark'                 => '<svg width="16" height="16" viewBox="0 0 14 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M6.96383 0.666666L13.2972 4.33333V11.6667L6.96383 15.3333L0.630493 11.6667V4.33333L6.96383 0.666666ZM3.29649 6.64667L6.29716 8.38533V11.7507H7.63049V8.38533L10.6312 6.648L9.96316 5.494L6.96383 7.23L3.96449 5.49333L3.29649 6.64667Z" fill="black"/>
			</svg>
			',

			'eye_view'                            => '<svg width="16" height="16" viewBox="0 0 25 17" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M24.8489 7.69965C22.4952 3.1072 17.8355 0 12.5 0C7.16447 0 2.50345 3.10938 0.151018 7.70009C0.0517306 7.89649 0 8.11348 0 8.33355C0 8.55362 0.0517306 8.77061 0.151018 8.96701C2.50475 13.5595 7.16447 16.6667 12.5 16.6667C17.8355 16.6667 22.4965 13.5573 24.8489 8.96658C24.9482 8.77018 25 8.55319 25 8.33312C25 8.11304 24.9482 7.89605 24.8489 7.69965ZM12.5 14.5833C11.2638 14.5833 10.0555 14.2168 9.02766 13.53C7.99985 12.8433 7.19878 11.8671 6.72573 10.7251C6.25268 9.58307 6.12891 8.3264 6.37007 7.11402C6.61123 5.90164 7.20648 4.78799 8.08056 3.91392C8.95464 3.03984 10.0683 2.44458 11.2807 2.20343C12.493 1.96227 13.7497 2.08604 14.8917 2.55909C16.0338 3.03213 17.0099 3.83321 17.6967 4.86102C18.3834 5.88883 18.75 7.0972 18.75 8.33333C18.7504 9.15421 18.589 9.96711 18.275 10.7256C17.9611 11.484 17.5007 12.1732 16.9203 12.7536C16.3398 13.3341 15.6507 13.7944 14.8922 14.1084C14.1338 14.4223 13.3208 14.5837 12.5 14.5833ZM12.5 4.16667C12.1281 4.17186 11.7586 4.22719 11.4015 4.33116C11.6958 4.73119 11.8371 5.22347 11.7996 5.71873C11.7621 6.21398 11.5484 6.6794 11.1972 7.0306C10.846 7.38179 10.3806 7.5955 9.88537 7.63297C9.39012 7.67043 8.89784 7.52917 8.49781 7.23481C8.27001 8.07404 8.31113 8.96357 8.61538 9.77821C8.91962 10.5928 9.47167 11.2916 10.1938 11.776C10.916 12.2605 11.7719 12.5063 12.641 12.4788C13.5102 12.4514 14.3489 12.152 15.039 11.623C15.7291 11.0939 16.236 10.3617 16.4882 9.52951C16.7404 8.69729 16.7253 7.80693 16.445 6.98376C16.1647 6.16058 15.6333 5.44602 14.9256 4.94067C14.2179 4.43532 13.3696 4.16462 12.5 4.16667Z" fill="black"/>
			</svg>
			',

			'ban_block_circle'                    => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M18.505 5.49999C14.925 1.91999 9.08499 1.91999 5.48499 5.49999C1.90499 9.07999 1.90499 14.92 5.48499 18.52C7.28499 20.32 9.64499 21.22 11.985 21.22C14.345 21.22 16.705 20.32 18.485 18.52C22.105 14.92 22.105 9.07999 18.505 5.49999ZM6.62499 17.38C3.84499 14.6 3.66499 10.2 6.08499 7.21999L16.785 17.92C13.805 20.32 9.40499 20.16 6.62499 17.38ZM17.925 16.78L7.22499 6.08C8.60499 4.95999 10.305 4.39999 12.005 4.39999C13.945 4.39999 15.905 5.13999 17.385 6.61999C20.165 9.39999 20.325 13.8 17.925 16.78Z" fill="black"/>
			</svg>
			',

			'thumbs_up_like'                      => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.765 21.2C12.285 21.2 8.385 20.38 7.425 19.7C7.205 19.54 7.08501 19.3 7.08501 19.04V11.22C7.08501 10.98 7.20501 10.74 7.38501 10.6C7.44501 10.56 8.845 9.45999 10.305 8.63999C12.125 7.63999 13.385 6.24001 13.685 5.36001C14.045 4.28001 14.565 2.8 16.205 2.8C16.985 2.8 17.625 3.24 17.965 4C18.645 5.56 17.925 7.72 16.725 9.42C17.525 9.6 18.525 9.85999 19.125 10.04C20.225 10.38 20.945 11.18 21.105 12.16C21.245 13.16 20.745 14.18 19.685 14.96C18.905 17.06 17.565 20.38 16.585 20.92C16.205 21.12 15.545 21.2 14.765 21.2ZM8.68501 18.56C10.205 19.2 14.885 19.86 15.765 19.52C16.225 19.1 17.405 16.42 18.225 14.16C18.285 14 18.385 13.86 18.525 13.76C19.185 13.32 19.525 12.8 19.465 12.36C19.405 12 19.085 11.7 18.605 11.54C17.605 11.22 15.125 10.68 15.085 10.68C14.805 10.62 14.585 10.42 14.485 10.14C14.385 9.85999 14.465 9.56001 14.665 9.36001C16.465 7.42001 16.785 5.43999 16.445 4.63999C16.345 4.39999 16.225 4.4 16.165 4.4C15.765 4.4 15.585 4.68001 15.165 5.88001C14.685 7.28001 13.025 8.95999 11.045 10.04C10.085 10.56 9.125 11.26 8.645 11.62V18.56H8.68501ZM5.525 19.12V11.14C5.525 10.42 4.945 9.83999 4.225 9.83999C3.505 9.83999 2.925 10.42 2.925 11.14V19.12C2.925 19.84 3.505 20.42 4.225 20.42C4.925 20.42 5.525 19.82 5.525 19.12Z" fill="black"/>
			</svg>
			',

			'alert_triangle_warning'              => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.405 20.2H3.605C3.325 20.2 3.065 20.04 2.905 19.8C2.765 19.56 2.765 19.26 2.905 19L11.305 4.2C11.445 3.94 11.705 3.8 12.005 3.8C12.305 3.8 12.565 3.96 12.705 4.2L21.105 19C21.245 19.24 21.245 19.56 21.105 19.8C20.945 20.04 20.685 20.2 20.405 20.2ZM4.985 18.6H19.045L12.025 6.21999L4.985 18.6ZM12.805 13.82V10.1C12.805 9.66 12.445 9.3 12.005 9.3C11.565 9.3 11.205 9.66 11.205 10.1V13.82C11.205 14.26 11.565 14.62 12.005 14.62C12.445 14.62 12.805 14.26 12.805 13.82ZM12.705 17.14C12.885 16.96 13.005 16.7 13.005 16.44C13.005 16.18 12.905 15.92 12.705 15.74C12.525 15.56 12.265 15.44 12.005 15.44C11.745 15.44 11.485 15.54 11.305 15.74C11.125 15.92 11.005 16.18 11.005 16.44C11.005 16.7 11.105 16.96 11.305 17.14C11.485 17.32 11.745 17.44 12.005 17.44C12.265 17.44 12.525 17.32 12.705 17.14Z" fill="black"/>
			</svg>
			',

			'phone'                               => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M20.5052 5.29998C20.4852 5.27998 20.4852 5.27999 20.4652 5.25999L18.3252 3.37996C18.0252 3.09996 17.6052 2.95998 17.1652 2.99998C16.7652 3.03998 16.4052 3.19996 16.1252 3.47996C16.1052 3.49996 16.0852 3.51997 16.0652 3.53997L13.9452 6.19998C13.3852 6.79998 13.4052 7.71998 13.9852 8.29998C14.0252 8.33998 14.0652 8.37998 14.1052 8.39998L15.1852 9.12C15.1052 9.5 14.5452 10.58 12.5652 12.56C10.5852 14.54 9.50521 15.1 9.12521 15.18L8.40521 14.1C8.38521 14.06 8.34521 14.02 8.30521 13.98C7.72521 13.4 6.80521 13.4 6.20521 13.94L3.54522 16.06C3.52522 16.08 3.50522 16.1 3.48522 16.12C2.88522 16.72 2.84522 17.72 3.38522 18.3L5.26521 20.44C5.28521 20.46 5.28521 20.46 5.30521 20.48C5.66521 20.84 6.22522 20.98 6.84522 20.98C7.94522 20.98 9.20521 20.54 9.86521 20.28C11.1452 19.78 13.6452 18.56 16.1252 16.08C17.9652 14.24 19.4452 12.02 20.3252 9.82C20.7052 8.82 21.5452 6.33998 20.5052 5.29998ZM14.9852 14.98C11.2852 18.68 7.12521 19.7 6.42521 19.34L4.60521 17.26L7.20521 15.2L7.90521 16.26C7.92521 16.28 7.92522 16.3 7.94522 16.32C8.18522 16.62 8.52521 16.78 8.92521 16.8C9.30521 16.82 10.4852 16.88 13.6652 13.7C14.4452 12.92 16.8452 10.52 16.7652 8.95999C16.7452 8.55999 16.5652 8.21996 16.2852 7.97996C16.2652 7.95996 16.2452 7.93997 16.2252 7.93997L15.1652 7.23997L17.2252 4.63997L19.3052 6.45999C19.7052 7.11999 18.6852 11.28 14.9852 14.98Z" fill="black"/>
			</svg>
			',

			'phone_call'                          => '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M14.292 15.5C12.5559 15.5 10.8406 15.1215 9.14616 14.3646C7.45171 13.6076 5.91005 12.5347 4.52116 11.1458C3.13227 9.75694 2.05935 8.21528 1.30241 6.52083C0.545464 4.82639 0.166992 3.11111 0.166992 1.375C0.166992 1.125 0.250326 0.916667 0.416992 0.75C0.583659 0.583333 0.791992 0.5 1.04199 0.5H4.41699C4.61144 0.5 4.78505 0.565972 4.93783 0.697917C5.0906 0.829861 5.18088 0.986111 5.20866 1.16667L5.75033 4.08333C5.7781 4.30556 5.77116 4.49306 5.72949 4.64583C5.68783 4.79861 5.61144 4.93056 5.50033 5.04167L3.47949 7.08333C3.75727 7.59722 4.08713 8.09375 4.46908 8.57292C4.85102 9.05208 5.27116 9.51389 5.72949 9.95833C6.16005 10.3889 6.61144 10.7882 7.08366 11.1562C7.55588 11.5243 8.05588 11.8611 8.58366 12.1667L10.542 10.2083C10.667 10.0833 10.8302 9.98958 11.0316 9.92708C11.233 9.86458 11.4309 9.84722 11.6253 9.875L14.5003 10.4583C14.6948 10.5139 14.8545 10.6146 14.9795 10.7604C15.1045 10.9062 15.167 11.0694 15.167 11.25V14.625C15.167 14.875 15.0837 15.0833 14.917 15.25C14.7503 15.4167 14.542 15.5 14.292 15.5Z" fill="black"/>
			</svg>
			',

			'phone_vibration'                     => '<svg width="16" height="16" viewBox="0 0 30 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1.85197 7.5625C2.1177 7.5625 2.3403 7.65233 2.51978 7.832C2.69926 8.01169 2.789 8.23434 2.789 8.49997V13.5C2.789 13.7656 2.69912 13.9882 2.51937 14.1679C2.3396 14.3476 2.11685 14.4374 1.85113 14.4374C1.58538 14.4374 1.36277 14.3476 1.18331 14.1679C1.00381 13.9882 0.914062 13.7656 0.914062 13.5V8.49997C0.914062 8.23434 1.00395 8.01169 1.18372 7.832C1.36347 7.65233 1.58622 7.5625 1.85197 7.5625ZM5.45772 5.0625C5.72345 5.0625 5.94606 5.15233 6.12556 5.332C6.30504 5.51169 6.39478 5.73434 6.39478 5.99997V16C6.39478 16.2656 6.3049 16.4882 6.12512 16.6679C5.94535 16.8476 5.7226 16.9374 5.45687 16.9374C5.19115 16.9374 4.96853 16.8476 4.78903 16.6679C4.60955 16.4882 4.51981 16.2656 4.51981 16V5.99997C4.51981 5.73434 4.6097 5.51169 4.78947 5.332C4.96924 5.15233 5.19199 5.0625 5.45772 5.0625ZM28.1499 7.5625C28.4157 7.5625 28.6383 7.65233 28.8178 7.832C28.9973 8.01169 29.087 8.23434 29.087 8.49997V13.5C29.087 13.7656 28.9971 13.9882 28.8173 14.1679C28.6376 14.3476 28.4148 14.4374 28.1491 14.4374C27.8834 14.4374 27.6608 14.3476 27.4813 14.1679C27.3018 13.9882 27.2121 13.7656 27.2121 13.5V8.49997C27.2121 8.23434 27.3019 8.01169 27.4817 7.832C27.6615 7.65233 27.8842 7.5625 28.1499 7.5625ZM24.5442 5.0625C24.8099 5.0625 25.0325 5.15233 25.212 5.332C25.3915 5.51169 25.4813 5.73434 25.4813 5.99997V16C25.4813 16.2656 25.3914 16.4882 25.2116 16.6679C25.0318 16.8476 24.8091 16.9374 24.5433 16.9374C24.2776 16.9374 24.055 16.8476 23.8755 16.6679C23.696 16.4882 23.6063 16.2656 23.6063 16V5.99997C23.6063 5.73434 23.6962 5.51169 23.8759 5.332C24.0557 5.15233 24.2785 5.0625 24.5442 5.0625ZM10.3852 21.6249C9.76379 21.6249 9.23184 21.4037 8.78934 20.9612C8.34682 20.5187 8.12556 19.9867 8.12556 19.3653V2.63463C8.12556 2.01323 8.34682 1.48128 8.78934 1.03878C9.23184 0.596261 9.76379 0.375 10.3852 0.375H19.6159C20.2373 0.375 20.7692 0.596261 21.2117 1.03878C21.6542 1.48128 21.8755 2.01323 21.8755 2.63463V19.3653C21.8755 19.9867 21.6542 20.5187 21.2117 20.9612C20.7692 21.4037 20.2373 21.6249 19.6159 21.6249H10.3852ZM10.3852 19.75H19.6159C19.7281 19.75 19.8202 19.7139 19.8923 19.6418C19.9645 19.5697 20.0005 19.4775 20.0005 19.3653V2.63463C20.0005 2.52244 19.9645 2.43028 19.8923 2.35816C19.8202 2.28603 19.7281 2.24997 19.6159 2.24997H10.3852C10.273 2.24997 10.1808 2.28603 10.1087 2.35816C10.0366 2.43028 10.0005 2.52244 10.0005 2.63463V19.3653C10.0005 19.4775 10.0366 19.5697 10.1087 19.6418C10.1808 19.7139 10.273 19.75 10.3852 19.75Z" fill="black"/>
			</svg>
			',

			'space_rocket'                        => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M21.1649 3.58001C21.1249 3.18001 20.8249 2.88007 20.4249 2.84007C15.3649 2.44007 11.7449 4.90001 9.4849 7.98001C8.2449 7.58001 6.9049 7.72003 5.6849 8.40003C4.5049 9.06003 3.5249 10.1801 2.8849 11.5401C2.7449 11.8601 2.8049 12.22 3.0649 12.46C3.3049 12.7 3.6849 12.74 3.9849 12.58C5.2649 11.9 6.7049 12.04 7.5649 12.9L11.0849 16.42L11.1049 16.4401C11.9649 17.3001 12.1049 18.74 11.4249 20.02C11.2649 20.32 11.3249 20.7001 11.5449 20.9401C11.7049 21.1001 11.9049 21.18 12.1249 21.18C12.2449 21.18 12.3649 21.16 12.4649 21.1C13.8249 20.46 14.9449 19.46 15.6049 18.3C16.3049 17.08 16.4449 15.74 16.0249 14.48C16.9249 13.82 17.7449 13.1 18.4249 12.3C20.5249 9.88003 21.4449 6.94001 21.1649 3.58001ZM5.4849 10.56C6.3449 9.71999 7.4249 9.20003 8.5649 9.40003C8.2449 9.96003 7.9849 10.52 7.7449 11.08C7.0649 10.7 6.2849 10.52 5.4849 10.56ZM13.4649 18.52C13.4849 17.7 13.3049 16.9201 12.9449 16.2401C13.5249 16.0001 14.0849 15.72 14.6249 15.42C14.8249 16.56 14.3249 17.66 13.4649 18.52ZM11.8649 14.9401L9.0449 12.12C10.4649 8.34005 13.9649 4.28003 19.5849 4.40003C19.7849 11.1 14.2649 14.0001 11.8649 14.9401ZM17.0449 6.95999C17.2849 7.19999 17.4249 7.54001 17.4249 7.88001C17.4249 8.22001 17.2849 8.56003 17.0449 8.80003C16.8049 9.04003 16.4649 9.18001 16.1249 9.18001C15.7849 9.18001 15.4449 9.04003 15.2049 8.80003C14.9649 8.56003 14.8249 8.22001 14.8249 7.88001C14.8249 7.54001 14.9649 7.19999 15.2049 6.95999C15.4449 6.71999 15.7849 6.58001 16.1249 6.58001C16.4649 6.58001 16.8049 6.71999 17.0449 6.95999ZM5.7849 15.28C4.8649 16.2 4.8249 18.04 4.8249 18.4C4.8249 18.84 5.1849 19.2 5.6249 19.2H5.6449C6.0649 19.2 7.8249 19.1401 8.7249 18.2401C9.2849 17.6801 9.4049 17.1 9.4049 16.72C9.4049 16.18 9.1849 15.6601 8.7649 15.2401C7.7649 14.2201 6.5049 14.54 5.7849 15.28ZM7.6049 17.1C7.4049 17.3 6.9649 17.44 6.5049 17.5C6.5849 17.04 6.7249 16.6 6.9049 16.42C7.0449 16.28 7.1649 16.2 7.3049 16.2C7.4049 16.2 7.5249 16.26 7.6449 16.38C7.7649 16.5 7.8249 16.62 7.8249 16.72C7.8049 16.84 7.7049 17 7.6049 17.1Z" fill="black"/>
			</svg>
			',

			'bed_variation_one'                   => '<svg width="16" height="16" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.6667 5.33333V11.3333H12.3333V9.33333H1.66668V11.3333H0.333344V0.666664H1.66668V7.33333H7.00001V2.66666H11C11.7073 2.66666 12.3855 2.94762 12.8856 3.44771C13.3857 3.94781 13.6667 4.62609 13.6667 5.33333ZM4.33334 6.66666C3.80291 6.66666 3.2942 6.45595 2.91913 6.08088C2.54406 5.70581 2.33334 5.1971 2.33334 4.66666C2.33334 4.13623 2.54406 3.62752 2.91913 3.25245C3.2942 2.87738 3.80291 2.66666 4.33334 2.66666C4.86378 2.66666 5.37248 2.87738 5.74756 3.25245C6.12263 3.62752 6.33334 4.13623 6.33334 4.66666C6.33334 5.1971 6.12263 5.70581 5.74756 6.08088C5.37248 6.45595 4.86378 6.66666 4.33334 6.66666Z" fill="black"/>
			</svg>
			',

			'bed_variation_two'                   => '<svg width="16" height="16" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M13.6667 5.33333V11.3333H12.3333V9.33333H1.66668V11.3333H0.333344V0.666664H1.66668V7.33333H7.00001V2.66666H11C11.7073 2.66666 12.3855 2.94762 12.8856 3.44771C13.3857 3.94781 13.6667 4.62609 13.6667 5.33333ZM12.3333 7.33333V5.33333C12.3333 4.97971 12.1929 4.64057 11.9428 4.39052C11.6928 4.14047 11.3536 4 11 4H8.33334V7.33333H12.3333ZM4.33334 5.33333C4.51015 5.33333 4.67972 5.26309 4.80475 5.13807C4.92977 5.01304 5.00001 4.84348 5.00001 4.66666C5.00001 4.48985 4.92977 4.32028 4.80475 4.19526C4.67972 4.07024 4.51015 4 4.33334 4C4.15653 4 3.98696 4.07024 3.86194 4.19526C3.73691 4.32028 3.66668 4.48985 3.66668 4.66666C3.66668 4.84348 3.73691 5.01304 3.86194 5.13807C3.98696 5.26309 4.15653 5.33333 4.33334 5.33333ZM4.33334 6.66666C3.80291 6.66666 3.2942 6.45595 2.91913 6.08088C2.54406 5.70581 2.33334 5.1971 2.33334 4.66666C2.33334 4.13623 2.54406 3.62752 2.91913 3.25245C3.2942 2.87738 3.80291 2.66666 4.33334 2.66666C4.86378 2.66666 5.37248 2.87738 5.74756 3.25245C6.12263 3.62752 6.33334 4.13623 6.33334 4.66666C6.33334 5.1971 6.12263 5.70581 5.74756 6.08088C5.37248 6.45595 4.86378 6.66666 4.33334 6.66666Z" fill="black"/>
			</svg>
			',

			'media_gif_light'                     => '<svg width="16" height="16" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.63053 0.333333L12.9639 3.66667V12.9953C12.9645 13.0829 12.9478 13.1697 12.9149 13.2508C12.882 13.3319 12.8334 13.4058 12.7719 13.4681C12.7104 13.5304 12.6373 13.5801 12.5566 13.6141C12.476 13.6482 12.3894 13.6661 12.3019 13.6667H1.62587C1.45079 13.6654 1.28321 13.5954 1.15935 13.4717C1.03548 13.3479 0.965264 13.1804 0.963867 13.0053V0.994667C0.963867 0.629333 1.26187 0.333333 1.62987 0.333333H9.63053ZM8.96387 1.66667H2.2972V12.3333H11.6305V4.33333H8.96387V1.66667ZM7.63053 5.66667V9H6.96387V5.66667H7.63053ZM6.2972 5.66667V6.33333H4.96387C4.78706 6.33333 4.61749 6.40357 4.49246 6.5286C4.36744 6.65362 4.2972 6.82319 4.2972 7V7.66667C4.2972 7.84348 4.36744 8.01305 4.49246 8.13807C4.61749 8.2631 4.78706 8.33333 4.96387 8.33333H5.63053V7.66667H4.96387V7H6.2972V8.33333C6.2972 8.51014 6.22696 8.67971 6.10194 8.80474C5.97691 8.92976 5.80734 9 5.63053 9H4.96387C4.61025 9 4.27111 8.85952 4.02106 8.60948C3.77101 8.35943 3.63053 8.02029 3.63053 7.66667V7C3.63053 6.64638 3.77101 6.30724 4.02106 6.05719C4.27111 5.80714 4.61025 5.66667 4.96387 5.66667H6.2972ZM10.2972 5.66667V6.33333H8.96387V7H10.2972V7.66667H8.96387V9H8.2972V5.66667H10.2972Z" fill="black"/>
			</svg>
			',

			'media_gif_dark'                      => '<svg width="16" height="16" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.63053 0.333333L12.9639 3.66667V12.9953C12.9645 13.0829 12.9478 13.1697 12.9149 13.2508C12.882 13.3319 12.8334 13.4058 12.7719 13.4681C12.7104 13.5304 12.6373 13.5801 12.5566 13.6141C12.476 13.6482 12.3894 13.6661 12.3019 13.6667H1.62587C1.45079 13.6654 1.28321 13.5954 1.15935 13.4717C1.03548 13.3479 0.965264 13.1804 0.963867 13.0053V0.994667C0.963867 0.629333 1.26187 0.333333 1.62987 0.333333H9.63053ZM7.63053 5.66667H6.96387V9H7.63053V5.66667ZM6.2972 5.66667H4.96387C4.61025 5.66667 4.27111 5.80714 4.02106 6.05719C3.77101 6.30724 3.63053 6.64638 3.63053 7V7.66667C3.63053 8.02029 3.77101 8.35943 4.02106 8.60948C4.27111 8.85952 4.61025 9 4.96387 9H5.63053C5.80734 9 5.97691 8.92976 6.10194 8.80474C6.22696 8.67971 6.2972 8.51014 6.2972 8.33333V7H4.96387V7.66667H5.63053V8.33333H4.96387C4.78706 8.33333 4.61749 8.2631 4.49246 8.13807C4.36744 8.01305 4.2972 7.84348 4.2972 7.66667V7C4.2972 6.82319 4.36744 6.65362 4.49246 6.5286C4.61749 6.40357 4.78706 6.33333 4.96387 6.33333H6.2972V5.66667ZM10.2972 5.66667H8.2972V9H8.96387V7.66667H10.2972V7H8.96387V6.33333H10.2972V5.66667Z" fill="black"/>
			</svg>
			',

			'media_video_variation_one'           => '<svg width="16" height="16" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M0.297241 0.662C0.298461 0.486919 0.368508 0.319345 0.49225 0.195478C0.615992 0.0716117 0.783495 0.00139619 0.958575 -2.38419e-07H12.9692C13.3346 -2.38419e-07 13.6306 0.296666 13.6306 0.662V11.338C13.6294 11.5131 13.5593 11.6807 13.4356 11.8045C13.3118 11.9284 13.1443 11.9986 12.9692 12H0.958575C0.783117 11.9998 0.614906 11.93 0.490901 11.8059C0.366896 11.6817 0.297241 11.5135 0.297241 11.338V0.662ZM1.63057 1.33333V10.6667H12.2972V1.33333H1.63057ZM6.04524 3.61L9.29791 5.778C9.33449 5.80234 9.36448 5.83535 9.38523 5.87408C9.40598 5.91281 9.41683 5.95606 9.41683 6C9.41683 6.04394 9.40598 6.08719 9.38523 6.12592C9.36448 6.16465 9.33449 6.19766 9.29791 6.222L6.04457 8.39C6.00446 8.41659 5.9579 8.43183 5.90982 8.4341C5.86175 8.43637 5.81396 8.42559 5.77151 8.4029C5.72907 8.38021 5.69356 8.34645 5.66875 8.30522C5.64393 8.26398 5.63074 8.21679 5.63057 8.16867V3.83133C5.63066 3.7831 5.64383 3.73579 5.66868 3.69445C5.69353 3.65311 5.72912 3.61929 5.77167 3.59657C5.81422 3.57386 5.86214 3.56312 5.91031 3.56548C5.95849 3.56784 6.00512 3.58323 6.04524 3.61Z" fill="black"/>
			</svg>
			',

			'media_video_variation_two'           => '<svg width="16" height="16" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M8.96387 1.66667V4.33333H11.6305V12.3333H2.2972V1.66667H8.96387ZM1.62987 0.333333C1.5427 0.332982 1.45632 0.349815 1.37566 0.382868C1.29501 0.415922 1.22165 0.464548 1.1598 0.525967C1.09795 0.587387 1.04881 0.660394 1.01519 0.740817C0.981569 0.82124 0.964129 0.9075 0.963867 0.994667V13.0053C0.965264 13.1804 1.03548 13.3479 1.15935 13.4717C1.28321 13.5954 1.45079 13.6654 1.62587 13.6667H12.3019C12.3895 13.6661 12.4761 13.6482 12.5568 13.6141C12.6375 13.58 12.7107 13.5303 12.7721 13.4679C12.8336 13.4055 12.8822 13.3315 12.9151 13.2504C12.948 13.1692 12.9646 13.0823 12.9639 12.9947V3.66667L9.63053 0.333333H1.62987ZM8.96387 6.778L5.71053 4.60933C5.67037 4.58271 5.62375 4.56747 5.57562 4.56523C5.52748 4.56298 5.47964 4.57382 5.43718 4.59659C5.39472 4.61936 5.35922 4.65321 5.33445 4.69455C5.30969 4.73588 5.29658 4.78315 5.29653 4.83133V9.168C5.2965 9.21629 5.30958 9.26368 5.33438 9.30512C5.35918 9.34655 5.39477 9.38048 5.43734 9.40327C5.47991 9.42606 5.52787 9.43686 5.57611 9.43453C5.62434 9.43219 5.67103 9.4168 5.7112 9.39L8.96387 7.222C9.00045 7.19766 9.03044 7.16465 9.05119 7.12592C9.07194 7.08719 9.08279 7.04394 9.08279 7C9.08279 6.95606 9.07194 6.91281 9.05119 6.87408C9.03044 6.83535 9.00045 6.80234 8.96387 6.778Z" fill="black"/>
			</svg>
			',

			'media_video_variation_three'         => '<svg width="16" height="16" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M12.9639 1.33333H7.23991L5.90657 -2.38419e-07H0.963908C0.787097 -2.38419e-07 0.617528 0.0702376 0.492503 0.195262C0.367479 0.320286 0.297241 0.489855 0.297241 0.666666V11.3333C0.297241 11.5101 0.367479 11.6797 0.492503 11.8047C0.617528 11.9298 0.787097 12 0.963908 12H12.9639C13.1407 12 13.3103 11.9298 13.4353 11.8047C13.5603 11.6797 13.6306 11.5101 13.6306 11.3333V2C13.6306 1.82319 13.5603 1.65362 13.4353 1.5286C13.3103 1.40357 13.1407 1.33333 12.9639 1.33333ZM8.96391 6.44467C9.00049 6.46901 9.03048 6.50201 9.05123 6.54074C9.07198 6.57947 9.08283 6.62273 9.08283 6.66667C9.08283 6.7106 9.07198 6.75386 9.05123 6.79259C9.03048 6.83132 9.00049 6.86432 8.96391 6.88867L5.71191 9.05667C5.67174 9.08347 5.62505 9.09886 5.57681 9.10119C5.52858 9.10353 5.48062 9.09273 5.43805 9.06993C5.39547 9.04714 5.35989 9.01322 5.33509 8.97178C5.31029 8.93035 5.29721 8.88296 5.29724 8.83467V4.498C5.29721 4.44971 5.31029 4.40232 5.33509 4.36088C5.35989 4.31945 5.39547 4.28552 5.43805 4.26273C5.48062 4.23994 5.52858 4.22914 5.57681 4.23147C5.62505 4.23381 5.67174 4.2492 5.71191 4.276L8.96391 6.44467Z" fill="black"/>
			</svg>
			',

			'media_video_variation_four'          => '<svg width="16" height="16" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9.63053 0.333333L12.9639 3.66667V13.0053C12.9637 13.1808 12.8939 13.349 12.7697 13.473C12.6456 13.597 12.4773 13.6667 12.3019 13.6667H1.62587C1.45079 13.6654 1.28321 13.5954 1.15935 13.4717C1.03548 13.3479 0.965264 13.1804 0.963867 13.0053V0.994667C0.963867 0.629333 1.26053 0.333333 1.62587 0.333333H9.63053ZM8.96387 6.778L5.71187 4.60933C5.6717 4.58253 5.625 4.56714 5.57677 4.56481C5.52854 4.56247 5.48058 4.57327 5.438 4.59606C5.39543 4.61886 5.35985 4.65278 5.33505 4.69422C5.31025 4.73565 5.29717 4.78304 5.2972 4.83133V9.168C5.29717 9.21629 5.31025 9.26368 5.33505 9.30512C5.35985 9.34655 5.39543 9.38048 5.438 9.40327C5.48058 9.42606 5.52854 9.43686 5.57677 9.43453C5.625 9.43219 5.6717 9.4168 5.71187 9.39L8.96387 7.222C9.00045 7.19766 9.03044 7.16465 9.05119 7.12592C9.07194 7.08719 9.08279 7.04394 9.08279 7C9.08279 6.95606 9.07194 6.91281 9.05119 6.87408C9.03044 6.83535 9.00045 6.80234 8.96387 6.778Z" fill="black"/>
			</svg>
			',

			'media_video_variation_five'          => '<svg width="16" height="16" viewBox="0 0 14 12" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1.63057 10.6667V1.33333H5.35457L6.68791 2.66667H12.2972V10.6667H1.63057ZM12.9639 1.33333H7.23991L5.90657 -2.38419e-07H0.963908C0.787097 -2.38419e-07 0.617528 0.0702376 0.492503 0.195262C0.367479 0.320286 0.297241 0.489855 0.297241 0.666666V11.3333C0.297241 11.5101 0.367479 11.6797 0.492503 11.8047C0.617528 11.9298 0.787097 12 0.963908 12H12.9639C13.1407 12 13.3103 11.9298 13.4353 11.8047C13.5603 11.6797 13.6306 11.5101 13.6306 11.3333V2C13.6306 1.82319 13.5603 1.65362 13.4353 1.5286C13.3103 1.40357 13.1407 1.33333 12.9639 1.33333ZM8.96391 6.44467L5.71191 4.276C5.67174 4.2492 5.62505 4.23381 5.57681 4.23147C5.52858 4.22914 5.48062 4.23994 5.43805 4.26273C5.39547 4.28552 5.35989 4.31945 5.33509 4.36088C5.31029 4.40232 5.29721 4.44971 5.29724 4.498V8.83467C5.29721 8.88296 5.31029 8.93035 5.33509 8.97178C5.35989 9.01322 5.39547 9.04714 5.43805 9.06993C5.48062 9.09273 5.52858 9.10353 5.57681 9.10119C5.62505 9.09886 5.67174 9.08347 5.71191 9.05667L8.96391 6.88867C9.00049 6.86432 9.03048 6.83132 9.05123 6.79259C9.07198 6.75386 9.08283 6.7106 9.08283 6.66667C9.08283 6.62273 9.07198 6.57947 9.05123 6.54074C9.03048 6.50201 9.00049 6.46901 8.96391 6.44467Z" fill="black"/>
			</svg>
			',
		);

		return $icons_stub;
	}

	public static function get_cozy_social_icon_collection() {
		$social_media = array(
			'email',
			'facebook',
			'linkedin',
			'pinterest',
			'reddit',
			'instagram',
			'telegram',
			'tumblr',
			'twitter',
			'whatsapp',
			'youtube',
			'snapchat',
			'stumbleupon',
			'medium',
			'behance',
			'blogger',
			'wallet',
			'vk',
			'dribble',
			'wordpress',
			'google',
			'rss',
			'lastfm',
			'yelp',
			'twitch',
			'vimeo',
			'spotify',
			'github',
			'angellist',
			'amazon',
			'viber',
			'android',
			'quora',
		);

		$default_colors = array(
			'email'       => '',
			'facebook'    => '#1877f2',
			'linkedin'    => '#0a66c2',
			'pinterest'   => '#e60023',
			'reddit'      => '#ff5700',
			'instagram'   => 'linear-gradient(180deg, #DA5353 -38.62%, #595FF4 61.38%)',
			'telegram'    => '#0088cc',
			'tumblr'      => '#35465c',
			'twitter'     => '#000',
			'whatsapp'    => '#25d366',
			'youtube'     => '#ff0000',
			'snapchat'    => '#fffc00',
			'stumbleupon' => '#eb4924',
			'medium'      => '#02b875',
			'behance'     => '#053eff',
			'blogger'     => '#f57d00',
			'wallet'      => '',
			'vk'          => '#4c75a3',
			'dribble'     => '#ea4c89',
			'wordpress'   => '#21759b',
			'google'      => '#4285f4',
			'rss'         => '#ff6600',
			'lastfm'      => '#d51007',
			'yelp'        => '#af0606',
			'twitch'      => '#6441a5',
			'vimeo'       => '#1ab7ea',
			'spotify'     => '#1ed760',
			'github'      => '#181717',
			'angellist'   => '#000',
			'amazon'      => '#ff9900',
			'viber'       => '#665cac',
			'android'     => '#a4c639',
			'quora'       => '#b92b27',
		);

		$keys_to_keep = array_flip( $social_media ); // Flip the values to keys

		$icons = self::get_cozy_icon_collection();

		$result = array_intersect_key( $icons, $keys_to_keep );

		foreach ( $result as $key => $value ) {
			if ( is_string( $result[ $key ] ) ) {
				$result[ $key ] = array_merge( array( 'logo' => $value ), array( 'defaultColor' => $default_colors[ $key ] ) );

			}
		}

		return $result;
	}

	public static function get_cozy_shape_divider_collection() {
		$shape_divider_stub = array(
			'single_layout_1'  => '<svg viewBox="0 0 519 134" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M0 134H519V0L0 134Z" width="519"/>
		  	</svg>',

			'single_layout_2'  => '<svg viewBox="0 0 519 86" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M519 85.6532C415.699 -27.7409 112.284 -29.4747 0 86L519 85.6532Z"/>
		  	</svg>',

			'single_layout_3'  => '<svg viewBox="0 0 519 109" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M519 0C369 137.5 122.5 134.5 0 0V109H519V0Z"/>
		  	</svg>',

			'single_layout_4'  => '<svg viewBox="0 0 519 155" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M83.9192 0L0 71.7685V155H519L83.9192 0Z"/>
		  	</svg>',

			'single_layout_5'  => '<svg viewBox="0 0 519 74" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M169.098 27.8138C51.2243 -15.9419 -3.33485 24.3353 0.157424 74L519 74V0C443.169 94.8591 313.592 81.4516 169.098 27.8138Z"/>
		  	</svg>',

			'single_layout_6'  => '<svg viewBox="0 0 519 100" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M259.5 0L0 100H519L259.5 0Z"/>
		  	</svg>',

			'single_layout_7'  => '<svg viewBox="0 0 519 76" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M259 0L0 76H518.993V0H259Z"/>
		  	</svg>',

			'single_layout_8'  => '<svg viewBox="0 0 519 120" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M519 1.59363C274.097 -12.856 70.957 74.5106 0 120H519V1.59363Z"/>
		  	</svg>',

			'single_layout_9'  => '<svg viewBox="0 0 519 112" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M108.569 98.5L0 0V112H519V0L108.569 98.5Z"/>
		  	</svg>',

			'single_layout_10' => '<svg viewBox="0 0 519 115" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M259.5 95L0 0V115H519V0L259.5 95Z"/>
		  	</svg>',

			'single_layout_11' => '<svg viewBox="0 0 519 202" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M0 201.5V170.5C90 215.5 426.5 146.5 519 0V201.5H0Z" />
			</svg>
			',

			'single_layout_12' => '<svg viewBox="0 0 519 105" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M45.8583 30.8609C20.8182 37.2887 4.85273 19.5391 0 9.86087V105H519V8.03478C498.327 21.6209 476.296 8.33913 467.864 0C444.571 31.1165 417.76 21.6087 407.266 12.9652C402.753 25.2365 395.559 31.5913 392.526 33.2348C382.044 39.5165 370.446 33.6609 365.957 29.9478C354.893 39.7357 341.329 38.287 335.931 36.3391C328.943 61.4661 309.604 61.6609 300.809 58.6174C303.575 66.7983 299.05 73.4696 296.441 75.7826C290.036 83.6713 278.608 80.5304 273.694 77.9739C261.757 93.6052 249.188 95.4435 244.396 94.4087C234.496 93.3861 225.47 83.0261 222.195 77.9739C203.123 93.167 184.161 82.7217 177.064 75.6C170.367 92.8383 154.014 96.7826 146.674 96.6C129.204 95.2852 122.532 76.3304 121.379 67.0174C109.914 73.5913 81.162 78.887 65.5119 67.0174C52.9919 57.5217 47.1928 38.9565 45.8583 30.8609Z" />
			</svg>
			',

			'single_layout_13' => '<svg viewBox="0 0 519 15" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M5.04759 2.99588C2.5959 0.194241 0.660993 -0.0146543 0 0.231104V15H519V4.83908C516.981 4.83908 514.914 2.62726 514.133 1.52135C510.96 -0.985384 507.162 1.70567 505.66 3.36453C502.92 6.16617 499.711 4.04037 498.449 2.62726C495.132 -1.05911 491.659 0.722634 490.337 2.0743C486.155 6.49795 482.465 4.28613 481.143 2.62726C478.115 -1.05911 475.314 0.108239 474.293 1.15271C469.966 6.16617 466.241 4.71628 464.919 3.36465C460.592 -1.64873 457.347 0.538391 456.266 2.25862C452.228 6.09245 448.935 4.5934 447.793 3.36465C443.611 -1.50127 440.162 0.59983 438.96 2.25862C435.787 6.38736 432.35 4.71628 431.028 3.36465C426.845 -1.79627 423.757 0.108351 422.735 1.70578C418.986 6.57179 414.683 4.47056 413.001 2.81169C409.684 -1.31705 406.571 0.35411 405.429 1.70578C401.68 5.98197 398.098 4.59344 396.776 3.36465C392.45 -1.50136 388.965 0.599867 387.763 2.25873C384.157 6.53492 380.612 4.40912 379.29 2.81169C375.54 -1.61195 372.8 0.737274 370.817 2.62737C366.311 6.08251 363.306 4.2248 361.984 2.62737C358.811 -1.059 355.494 0.599867 354.232 1.8901C350.194 6.75611 346.781 4.77775 345.579 3.18033C341.974 -1.09586 338.789 0.29267 337.647 1.52146C333.754 6.68238 330.016 4.77775 328.634 3.18033C325.461 -1.09586 322.024 0.29267 320.702 1.52146C316.664 6.53492 312.65 4.47056 311.148 2.81169C307.831 -1.16959 304.237 0.661307 302.855 2.07442C299.106 6.64551 295.644 4.47056 294.382 2.81169C291.065 -1.4645 287.352 0.538428 285.91 2.07442C282.16 5.90824 279.059 4.532 277.978 3.36465C274.084 -1.20645 270.707 0.35411 269.505 1.70578C265.034 6.8667 260.672 3.85616 259.049 1.70578C256.021 -1.24332 252.62 1.09138 251.298 2.62737C248.125 6.4612 244.808 4.59344 243.546 3.18033C239.796 -1.09586 236.455 0.415549 235.254 1.70578C231.504 6.27688 227.923 4.59344 226.601 3.18033C223.139 -1.09586 219.39 0.415549 217.948 1.70578C213.909 6.57179 210.496 4.47056 209.295 2.81169C204.968 -1.61195 201.242 0.968505 199.92 2.81169C196.315 6.35061 192.77 3.9176 191.448 2.25873C187.41 -1.57509 184.597 1.02994 183.696 2.81169C180.523 6.49806 177.086 4.83919 175.764 3.54896C171.87 -1.16959 168.613 0.23123 167.472 1.52146C162.713 6.82983 158.879 4.34768 157.557 2.44305C153.807 -1.24332 150.226 1.2757 148.904 2.99601C145.587 6.68238 141.633 4.16336 140.071 2.44305C136.754 -1.39077 133.28 1.21426 131.958 2.99601C128.641 6.38747 125.288 4.40912 124.026 2.99601C120.133 -1.57509 116.876 0.722747 115.734 2.44305C112.129 6.12942 108.583 4.34768 107.261 2.99601C103.512 -1.28018 99.6898 0.845626 98.2477 2.44305C95.0749 6.27688 91.8781 4.40912 90.6763 2.99601C88.3328 0.968505 84.9076 -1.42764 80.5811 2.99601C77.1199 6.53492 74.3317 4.47056 73.3703 2.99601C69.6206 -1.13273 66.2796 0.415549 65.0778 1.70578C61.6166 6.12942 57.9871 4.77775 56.6051 3.54896C53.1439 -0.874681 49.6346 0.476989 48.3126 1.70578C44.1303 6.57179 40.8013 4.96207 39.6596 3.54896C36.3426 -1.02214 32.7492 0.415549 31.3671 1.70578C27.4733 5.83451 24.0962 4.65488 22.8944 3.54896C18.1353 -2.05432 13.7006 1.33703 12.0782 3.54896C10.0952 5.76067 6.1893 4.10184 5.04759 2.99588Z" />
			</svg>
			',

			'multi_layout_1'   => '<svg viewBox="0 0 519 71" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M519 39.899C451.001 23.6195 399.965 16.128 291.015 49.2635C348.281 68.1721 414.372 73.3002 455.431 62.5894C474.88 57.516 500.812 43.6808 519 39.899Z" fill-opacity="0.56"/>
			<path d="M287 48.5014C130.706 -5.22093 21.4299 1.00007 0 1V18C118.14 5.43654 237.206 32.7792 287 48.5014Z" fill-opacity="0.15"/>
			<path d="M130.74 20.8097C78.5163 17.848 33.1353 21.8574 0 30.5V38.5C85.5396 16.7099 212.738 33.8371 266.163 43.1414C237.71 34.1373 158.968 22.4105 130.74 20.8097Z" fill-opacity="0.7"/>
			<path d="M266.883 43.141C181 16.5012 72.1398 10.4329 0 18.001V30.5011C110.14 3.9674 219.5 34.0016 266.883 43.141Z" fill-opacity="0.35"/>
			<path d="M306.322 53.7654C161.102 10.1132 40.5187 27.876 0 38.5009V71H519V39.899C507.835 39.899 467.646 60.8588 445.526 64.2103C382.497 73.7602 329.192 59.168 306.322 53.7654Z"/>
			</svg>
			',

			'multi_layout_2'   => '<svg viewBox="0 0 519 103" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M259.75 0L0 102.5H519L259.75 0Z"/>
			<path d="M0 102.5V74L259.75 0L0 102.5Z" fill-opacity="0.5"/>
			<path d="M519 102.5V74L259.25 0L519 102.5Z" fill-opacity="0.5"/>
			<path d="M259.75 0L0 46.5V74L259.75 0Z" fill-opacity="0.3"/>
			<path d="M259.25 0L519 46.5V74L259.25 0Z" fill-opacity="0.3"/>
			</svg>
			',

			'multi_layout_3'   => '<svg viewBox="0 0 519 134" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M519 0.000198364L0 113.5V134L519 0.000198364Z" fill-opacity="0.5"/>
			<path d="M518.501 0.501022L0 92.5005V113.5L518.501 0.501022Z" fill-opacity="0.25"/>
			<path d="M0 134H519V0.000488281L0 134Z"/>
			</svg>
			',

			'multi_layout_4'   => '<svg viewBox="0 0 519 122" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M519 3.52723C274.097 -10.9224 70.957 76.4441 0 121.934H519V3.52723Z"/>
			<path d="M0 121.934V99.9346C41 78.5 232 2.43359 443.5 1.93457C232 5.93359 53 86.4341 0 121.934Z" fill-opacity="0.5"/>
			<path d="M0 99.9215V76.931C80.9347 50.5177 255.598 4.28317 426.905 1.10027C464.794 -0.577102 496.505 0.423931 518.5 3.93125C488.454 1.34897 457.734 0.527457 426.905 1.10027C308.895 6.32461 130.955 37.5316 0 99.9215Z" fill-opacity="0.25"/>
			</svg>
			',

			'multi_layout_6'   => '<svg viewBox="0 0 519 125" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M109.748 55.9436C70.2053 57.2896 20.1065 19.2087 0 0V120.72H518.987V38.5C494.189 50.2776 466.779 78.6575 455.748 91.2764C387.889 139.649 278.559 62.6737 238.346 51.3167C198.133 39.9597 159.177 54.2611 109.748 55.9436Z" fill-opacity="0.5"/>
			<path d="M111.424 70.2449C72.216 77.648 20.5254 57.7961 0 47V124.085H519V92.9589C501.128 87.0701 452.397 84.1257 410.927 105.157C352.87 134.601 281.492 102.633 246.724 84.5463C211.956 66.4593 160.433 60.9911 111.424 70.2449Z"/>
			<path d="M153.731 64.7764C63.9221 14.3009 13.6837 24.5024 6.10352e-05 35.9996V117.174L519 119.458V64.7764C512.369 109.5 434.692 85.9999 399.339 73.9999C329.971 54.8193 282.748 77.9563 251.751 89.173C212.878 95.9031 170.207 75.7128 153.731 64.7764Z" fill-opacity="0.5"/>
			</svg>
			',

			'multi_layout_7'   => '<svg viewBox="0 0 519 200" fill="none" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
			<path d="M519 0.100669C429.327 -3.17623 374.135 74.4349 341.061 104.239C404.756 95.6131 487.364 102.594 519 112.272V0.100669Z" fill-opacity="0.5"/>
			<path d="M203.774 146.104C156.066 163.944 93.7241 172.892 68.7705 174.926C96.431 187.759 137.033 203.117 194.131 191.756C241.222 182.387 308.833 136.426 341.061 104.238C332.687 104.238 263.409 123.804 203.774 146.104Z" fill-opacity="0.5"/>
			<path d="M0 170.929V134.323C18.0174 150.732 46.6929 165.249 68.7705 174.926C41.7698 178.629 11.6732 174.014 0 170.929Z" fill-opacity="0.5"/>
			<path d="M68.7705 174.927C40.5518 178.461 11.0811 173.874 0 170.929V199.33L519 200V112.272C473.576 96.7044 432.417 96.0341 403.995 96.0342C367.177 97.5292 341.061 104.239 341.061 104.239C335.732 108.446 331.672 112.023 322.029 119.176L291.069 142.739L257.572 164.408C170.023 215.109 108.612 190.916 68.7705 174.927Z"/>
			</svg>
			',
		);

		return $shape_divider_stub;
	}
}
