<?php
$features = array(
	'General Blocks'     => array(
		array(
			'label' => 'Accordion',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Advanced Gallery',
			'free'  => 'Basic',
			'pro'   => 'Advanced with AJAX loader',
		),
		array(
			'label' => 'Advanced Mega Menu',
			'free'  => 'Basic',
			'pro'   => 'Advanced with Mega Menu',
		),
		array(
			'label' => 'Advanced Tabs',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Back to Top',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Breadcrumb',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Cozy Button',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Contact Form 7 Styler',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Cozy Container',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Call To Action',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Date & Time',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Featured Content Box',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Icon List',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Before/After Image',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Popup Builder',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Pricing Table',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Progress Bar',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Sidebar Panel',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Slider',
			'free'  => 'Basic',
			'pro'   => 'Advanced',
		),
		array(
			'label' => 'Social Icons',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Teams',
			'free'  => 'Basic',
			'pro'   => 'Advanced',
		),
		array(
			'label' => 'Testimonials',
			'free'  => 'Basic',
			'pro'   => 'Advanced',
		),
		array(
			'label' => 'Toggle Content',
			'free'  => false,
			'pro'   => true,
		),
	),
	'Post Blocks'        => array(
		array(
			'label' => 'Advertisement',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Advanced Categories',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Categorized Post Tabs',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Featured Post',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Featured Post Tabs',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Magazine Grid (with AJAX loader)',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Magazine List (with AJAX loader)',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'News Ticker',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Popular Post',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Post Grid/Carousel',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Post Comments',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Post Slider',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Post Views',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Related Post',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Trending Post',
			'free'  => false,
			'pro'   => true,
		),
	),
	'WooCommerce Blocks' => array(
		array(
			'label' => 'Add to Cart',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Featured Product',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Featured Product Tabs',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Product Category',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Product Grid/Carousel',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'All Product Reviews',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Product Slider',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Product Showcase Tabs',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Quick View',
			'free'  => false,
			'pro'   => true,
		),
		array(
			'label' => 'Wishlist',
			'free'  => false,
			'pro'   => true,
		),
	),
	'Utility Functions'  => array(
		array(
			'label' => 'Cozy Animation',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Cozy Hover Styles',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Cozy Responsive Visibility',
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => "Core Button block's Hover Styles",
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => "Core Navigation block's Hover Styles",
			'free'  => true,
			'pro'   => true,
		),
		array(
			'label' => 'Google Fonts in Core WordPress blocks',
			'free'  => true,
			'pro'   => true,
		),
	),
);
?>

<div class="features__list">
	<div class="table-wrap" role="region">
		<table class="feature-table" aria-describedby="legend">
			<thead>
				<tr>
					<th scope="col" class="col-feature">Particulars</th>
					<th scope="col" class="col-free">Free</th>
					<th scope="col" class="col-pro">Pro</th>
				</tr>
			</thead>
			<tbody>
				<!-- General section -->
				<?php
				foreach ( $features as $key => $section ) {
					?>
					<tr class="section">
						<td colspan="3"><?php echo esc_html( $key ); ?></td>
					</tr>

					<?php
					foreach ( $section as $feature ) {
						?>
						<tr class="section__item">
							<td><?php echo esc_html( $feature['label'] ); ?></td>
							<td class="<?php echo is_bool( $feature['free'] ) ? ( $feature['free'] ? 'chip__yes' : 'chip__no' ) : ''; ?>">
								<span>
								<?php
								echo is_bool( $feature['free'] )
								? ( $feature['free'] ? '✔' : '✖' )
								: esc_html( $feature['free'] );
								?>
								</span>
							</td>
							<td class="<?php echo is_bool( $feature['pro'] ) ? ( $feature['pro'] ? 'chip__yes' : 'chip__no' ) : ''; ?>">
								<span>
								<?php
								echo is_bool( $feature['pro'] )
								? ( $feature['pro'] ? '✔' : '✖' )
								: esc_html( $feature['pro'] );
								?>
								</span>
							</td>
						</tr>
						<?php
					}
				}
				?>
			</tbody>
		</table>
	</div>

	<?php if ( ! cozy_addons_premium_access() ) : ?>
	<div class="ct-plugin-link right__align">
		<a class="ca__primary-btn btn-large" href="<?php echo ! cozy_addons_premium_access() ? 'https://cozythemes.com/cozy-addons/' : '#'; ?>" target="<?php echo ! cozy_addons_premium_access() ? '_blank' : ''; ?>">
			<img src="<?php echo esc_url( COZY_ADDONS_PLUGIN_URL . 'admin/assets/img/crown.png' ); ?>" />
			<?php esc_html_e( 'Upgrade to Pro', 'cozy-addons' ); ?></a>

	</div>
	<?php endif; ?>

</div>